/*
 * Decompiled with CFR 0.152.
 */
package io.churchkey.asn1;

public enum Asn1Class {
    UNIVERSAL(0),
    APPLICATION(1),
    CONTEXT(2),
    PRIVATE(3);


    private Asn1Class(int constant) {
        if (this.ordinal() != constant) {
            throw new IllegalStateException("The enum order was improperly changed in source code");
        }
    }

    public byte getConstant() {
        return (byte)this.ordinal();
    }

    public static Asn1Class fromConstant(int value) {
        if (value < 0 || value >= Asn1Class.values().length) {
            return null;
        }
        return Asn1Class.values()[value];
    }
}

