/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.apache.naming.EjbRef;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.assembler.classic.JndiBuilder;
import org.apache.openejb.core.ivm.EjbObjectInputStream;
import org.apache.openejb.core.ivm.IntraVmCopyMonitor;
import org.apache.tomee.common.AbstractObjectFactory;
import org.apache.tomee.common.NamingUtil;

public class EjbFactory
extends AbstractObjectFactory {
    @Override
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable environment) throws Exception {
        if (!(object instanceof EjbRef)) {
            return null;
        }
        Object value = super.getObjectInstance(object, name, context, environment);
        if (NamingUtil.isPropertyTrue((Reference)object, "external")) {
            value = EjbFactory.copy(value);
        }
        return value;
    }

    @Override
    protected String buildJndiName(Reference reference) throws NamingException {
        String deploymentId = NamingUtil.getProperty(reference, "deploymentid");
        if (deploymentId == null) {
            throw new NamingException("ejb-ref deploymentId is null");
        }
        InterfaceType type = InterfaceType.BUSINESS_REMOTE;
        String interfaceType = NamingUtil.getProperty(reference, "remote");
        if (interfaceType == null) {
            type = InterfaceType.LOCALBEAN;
            interfaceType = NamingUtil.getProperty(reference, "localbean");
        }
        if (interfaceType == null) {
            type = InterfaceType.BUSINESS_LOCAL;
            interfaceType = NamingUtil.getProperty(reference, "local");
        }
        if (interfaceType == null) {
            throw new NamingException("ejb-ref interface type is null");
        }
        String jndiName = "java:openejb/Deployment/" + JndiBuilder.format((String)deploymentId, (String)interfaceType, (InterfaceType)type);
        return jndiName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object copy(Object source) throws Exception {
        IntraVmCopyMonitor.preCrossClassLoaderOperation();
        try {
            Object copy;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
            ObjectOutputStream out = new ObjectOutputStream(baos);
            out.writeObject(source);
            out.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            EjbObjectInputStream in = new EjbObjectInputStream((InputStream)bais);
            Object object = copy = in.readObject();
            return object;
        }
        finally {
            IntraVmCopyMonitor.postCrossClassLoaderOperation();
        }
    }
}

