/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.impl.controller;

import java.util.concurrent.BlockingQueue;
import org.apache.batchee.container.impl.StepContextImpl;
import org.apache.batchee.container.impl.controller.BaseStepController;
import org.apache.batchee.container.impl.controller.DecisionController;
import org.apache.batchee.container.impl.controller.FlowController;
import org.apache.batchee.container.impl.controller.PartitionedStepController;
import org.apache.batchee.container.impl.controller.SplitController;
import org.apache.batchee.container.impl.controller.batchlet.BatchletStepController;
import org.apache.batchee.container.impl.controller.chunk.ChunkStepController;
import org.apache.batchee.container.impl.jobinstance.RuntimeJobExecution;
import org.apache.batchee.container.services.BatchKernelService;
import org.apache.batchee.container.services.ServicesManager;
import org.apache.batchee.container.util.PartitionDataWrapper;
import org.apache.batchee.jaxb.Batchlet;
import org.apache.batchee.jaxb.Chunk;
import org.apache.batchee.jaxb.Decision;
import org.apache.batchee.jaxb.Flow;
import org.apache.batchee.jaxb.Partition;
import org.apache.batchee.jaxb.Split;
import org.apache.batchee.jaxb.Step;

public class ExecutionElementControllerFactory {
    public static BaseStepController getStepController(RuntimeJobExecution jobExecutionImpl, Step step, StepContextImpl stepContext, long rootJobExecutionId, BlockingQueue<PartitionDataWrapper> analyzerQueue, ServicesManager servicesManager) {
        Batchlet batchlet;
        Partition partition = step.getPartition();
        if (partition != null) {
            if (partition.getMapper() != null) {
                return new PartitionedStepController(jobExecutionImpl, step, stepContext, rootJobExecutionId, servicesManager);
            }
            if (partition.getPlan() != null && partition.getPlan().getPartitions() != null) {
                return new PartitionedStepController(jobExecutionImpl, step, stepContext, rootJobExecutionId, servicesManager);
            }
        }
        if ((batchlet = step.getBatchlet()) != null) {
            if (step.getChunk() != null) {
                throw new IllegalArgumentException("Step contains both a batchlet and a chunk.  Aborting.");
            }
            return new BatchletStepController(jobExecutionImpl, step, stepContext, rootJobExecutionId, analyzerQueue, servicesManager);
        }
        Chunk chunk = step.getChunk();
        if (chunk == null) {
            throw new IllegalArgumentException("Step does not contain either a batchlet or a chunk.  Aborting.");
        }
        return new ChunkStepController(jobExecutionImpl, step, stepContext, rootJobExecutionId, analyzerQueue, servicesManager);
    }

    public static DecisionController getDecisionController(ServicesManager servicesManager, RuntimeJobExecution jobExecutionImpl, Decision decision) {
        return new DecisionController(jobExecutionImpl, decision, servicesManager);
    }

    public static FlowController getFlowController(ServicesManager servicesManager, RuntimeJobExecution jobExecutionImpl, Flow flow, long rootJobExecutionId) {
        return new FlowController(jobExecutionImpl, flow, rootJobExecutionId, servicesManager);
    }

    public static SplitController getSplitController(BatchKernelService kernel, RuntimeJobExecution jobExecutionImpl, Split split, long rootJobExecutionId) {
        return new SplitController(jobExecutionImpl, split, rootJobExecutionId, kernel);
    }

    private ExecutionElementControllerFactory() {
    }
}

