/*
 * Decompiled with CFR 0.152.
 */
package io.churchkey.ssh;

import io.churchkey.Key;
import io.churchkey.ssh.OpenSSHPrivateKey;
import io.churchkey.ssh.OpenSSHPublicKey;
import io.churchkey.util.Utils;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class OpenSSHParser
implements Key.Format.Parser {
    @Override
    public byte[] encode(Key key) {
        switch (key.getType()) {
            case PUBLIC: {
                return new OpenSSHPublicKey().encode(key);
            }
            case PRIVATE: {
                return OpenSSHPrivateKey.encode(key);
            }
            case SECRET: {
                throw new UnsupportedOperationException("Secret keys cannot be exported to PEM format.");
            }
        }
        throw new UnsupportedOperationException("Unsupported key type: " + (Object)((Object)key.getType()));
    }

    @Override
    public Key decode(byte[] bytes) {
        if (Utils.startsWith("ssh-", bytes) || Utils.startsWith("ecdsa-", bytes)) {
            return new OpenSSHPublicKey().decode(bytes);
        }
        if (Utils.startsWith("-----BEGIN OPENSSH PRIVATE KEY-----", bytes)) {
            return OpenSSHPrivateKey.decode(bytes);
        }
        return null;
    }

    @Override
    public List<Key> decodeSet(byte[] bytes) {
        if (Utils.startsWith("ssh-", bytes) || Utils.startsWith("ecdsa-", bytes)) {
            return new OpenSSHPublicKey().decodeSet(bytes);
        }
        if (Utils.startsWith("-----BEGIN OPENSSH PRIVATE KEY-----", bytes)) {
            return Collections.singletonList(OpenSSHPrivateKey.decode(bytes));
        }
        return null;
    }

    @Override
    public byte[] encodeSet(List<Key> keys) {
        if (keys.size() == 0) {
            throw new IllegalArgumentException("No keys to encode");
        }
        if (keys.size() == 1) {
            return this.encode(keys.get(0));
        }
        List publicKeys = keys.stream().filter(key -> key.getType().equals((Object)Key.Type.PUBLIC)).collect(Collectors.toList());
        if (keys.size() != publicKeys.size()) {
            String message = String.format("Encoding of multiple keys in OpenSSH is only supported for public keys.  Found %s private keys", keys.size() - publicKeys.size());
            throw new UnsupportedOperationException(message);
        }
        return new OpenSSHPublicKey().encodeSet(keys);
    }

    public static String base64(byte[] src) {
        return Base64.getEncoder().encodeToString(src);
    }
}

