/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.beans.Introspector;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.openejb.util.URLs;

public class IntrospectionSupport {
    public static boolean getProperties(Object target, Map<String, String> props, String optionPrefix) {
        Method[] methods;
        boolean rc = false;
        if (target == null) {
            throw new IllegalArgumentException("target was null.");
        }
        if (props == null) {
            throw new IllegalArgumentException("props was null.");
        }
        if (optionPrefix == null) {
            optionPrefix = "";
        }
        Class<?> clazz = target.getClass();
        for (Method method : methods = clazz.getMethods()) {
            Object name = method.getName();
            Class<?> type = method.getReturnType();
            Class<?>[] params = method.getParameterTypes();
            if (!((String)name).startsWith("get") || params.length != 0 || type == null || !IntrospectionSupport.isSettableType(type)) continue;
            try {
                String strValue;
                Object value = method.invoke(target, new Object[0]);
                if (value == null || (strValue = IntrospectionSupport.convertToString(value, type)) == null) continue;
                name = ((String)name).substring(3, 4).toLowerCase() + ((String)name).substring(4);
                props.put(optionPrefix + (String)name, strValue);
                rc = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return rc;
    }

    public static boolean setProperties(Object target, Map props, String optionPrefix) {
        boolean rc = false;
        if (target == null) {
            throw new IllegalArgumentException("target was null.");
        }
        if (props == null) {
            throw new IllegalArgumentException("props was null.");
        }
        Iterator iter = props.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (!name.startsWith(optionPrefix)) continue;
            Object value = props.get(name);
            if (!IntrospectionSupport.setProperty(target, name = name.substring(optionPrefix.length()), value)) continue;
            iter.remove();
            rc = true;
        }
        return rc;
    }

    public static Map extractProperties(Map props, String optionPrefix) {
        if (props == null) {
            throw new IllegalArgumentException("props was null.");
        }
        HashMap rc = new HashMap(props.size());
        Iterator iter = props.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (!name.startsWith(optionPrefix)) continue;
            Object value = props.get(name);
            name = name.substring(optionPrefix.length());
            rc.put(name, value);
            iter.remove();
        }
        return rc;
    }

    public static boolean setProperties(Object target, Map props) {
        boolean rc = false;
        if (target == null) {
            throw new IllegalArgumentException("target was null.");
        }
        if (props == null) {
            throw new IllegalArgumentException("props was null.");
        }
        Iterator iter = props.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!IntrospectionSupport.setProperty(target, (String)entry.getKey(), entry.getValue())) continue;
            iter.remove();
            rc = true;
        }
        return rc;
    }

    private static boolean setProperty(Object target, String name, Object value) {
        try {
            Class<?> clazz = target.getClass();
            Method setter = IntrospectionSupport.findSetterMethod(clazz, name);
            if (setter == null) {
                return false;
            }
            if (value == null || value.getClass() == setter.getParameterTypes()[0]) {
                setter.invoke(target, value);
            } else {
                setter.invoke(target, IntrospectionSupport.convert(value, setter.getParameterTypes()[0]));
            }
            return true;
        }
        catch (Throwable ignore) {
            return false;
        }
    }

    private static Object convert(Object value, Class type) throws URISyntaxException {
        PropertyEditor editor = PropertyEditorManager.findEditor(type);
        if (editor != null) {
            editor.setAsText(value.toString());
            return editor.getValue();
        }
        if (type == URI.class) {
            return URLs.uri(value.toString());
        }
        return null;
    }

    private static String convertToString(Object value, Class type) throws URISyntaxException {
        PropertyEditor editor = PropertyEditorManager.findEditor(type);
        if (editor != null) {
            editor.setValue(value);
            return editor.getAsText();
        }
        if (type == URI.class) {
            return ((URI)value).toString();
        }
        return null;
    }

    private static Method findSetterMethod(Class clazz, String name) {
        Method[] methods;
        name = "set" + ((String)name).substring(0, 1).toUpperCase() + ((String)name).substring(1);
        for (Method method : methods = clazz.getMethods()) {
            Class<?>[] params = method.getParameterTypes();
            if (!method.getName().equals(name) || params.length != 1 || !IntrospectionSupport.isSettableType(params[0])) continue;
            return method;
        }
        return null;
    }

    private static boolean isSettableType(Class clazz) {
        if (PropertyEditorManager.findEditor(clazz) != null) {
            return true;
        }
        if (clazz == URI.class) {
            return true;
        }
        return clazz == Boolean.class;
    }

    public static String toString(Object target) {
        return IntrospectionSupport.toString(target, Object.class);
    }

    public static String toString(Object target, Class stopClass) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        IntrospectionSupport.addFields(target, target.getClass(), stopClass, map);
        StringBuilder buffer = new StringBuilder(IntrospectionSupport.simpleName(target.getClass()));
        buffer.append(" {");
        Set<Map.Entry<String, Object>> entrySet = map.entrySet();
        boolean first = true;
        Iterator<Map.Entry<String, Object>> iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> o;
            Map.Entry<String, Object> entry = o = iterator.next();
            if (first) {
                first = false;
            } else {
                buffer.append(", ");
            }
            buffer.append((Object)entry.getKey());
            buffer.append(" = ");
            IntrospectionSupport.appendToString(buffer, entry.getValue());
        }
        buffer.append("}");
        return buffer.toString();
    }

    protected static void appendToString(StringBuilder buffer, Object value) {
        buffer.append(value);
    }

    public static String simpleName(Class clazz) {
        String name = clazz.getName();
        int p = name.lastIndexOf(46);
        if (p >= 0) {
            name = name.substring(p + 1);
        }
        return name;
    }

    private static void addFields(Object target, Class startClass, Class stopClass, LinkedHashMap<String, Object> map) {
        Field[] fields;
        if (startClass != stopClass) {
            IntrospectionSupport.addFields(target, startClass.getSuperclass(), stopClass, map);
        }
        for (Field field : fields = startClass.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers()) || Modifier.isPrivate(field.getModifiers())) continue;
            try {
                field.setAccessible(true);
                List<Object> o = field.get(target);
                if (o != null && o.getClass().isArray()) {
                    try {
                        o = Arrays.asList((Object[])o);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                map.put(field.getName(), o);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static Class getPropertyType(Class clazz, String propertyName) throws NoSuchFieldException {
        while (true) {
            try {
                return clazz.getDeclaredField(propertyName).getType();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                for (Method method : clazz.getDeclaredMethods()) {
                    String type;
                    String methodName;
                    if (method.getReturnType() != Void.TYPE || method.getParameterTypes().length != 1 || !(methodName = method.getName()).startsWith("set") || !propertyName.equals(type = Introspector.decapitalize(methodName.substring(3)))) continue;
                    return method.getParameterTypes()[0];
                }
                if ((clazz = clazz.getSuperclass()) != null) continue;
                throw new NoSuchFieldException(propertyName);
            }
            break;
        }
    }
}

