/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Function;
import org.apache.tinkerpop.gremlin.process.computer.GraphFilter;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.Attachable;

public interface GraphReader {
    public void readGraph(InputStream var1, Graph var2) throws IOException;

    default public Optional<Vertex> readVertex(InputStream inputStream, GraphFilter graphFilter) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getCanonicalName() + " currently does not support " + GraphFilter.class.getSimpleName() + " deserialization filtering");
    }

    public Vertex readVertex(InputStream var1, Function<Attachable<Vertex>, Vertex> var2) throws IOException;

    public Vertex readVertex(InputStream var1, Function<Attachable<Vertex>, Vertex> var2, Function<Attachable<Edge>, Edge> var3, Direction var4) throws IOException;

    public Iterator<Vertex> readVertices(InputStream var1, Function<Attachable<Vertex>, Vertex> var2, Function<Attachable<Edge>, Edge> var3, Direction var4) throws IOException;

    public Edge readEdge(InputStream var1, Function<Attachable<Edge>, Edge> var2) throws IOException;

    public VertexProperty readVertexProperty(InputStream var1, Function<Attachable<VertexProperty>, VertexProperty> var2) throws IOException;

    public Property readProperty(InputStream var1, Function<Attachable<Property>, Property> var2) throws IOException;

    public <C> C readObject(InputStream var1, Class<? extends C> var2) throws IOException;

    public static interface ReaderBuilder<T extends GraphReader> {
        public T create();
    }
}

