/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.language.grammar;

import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinAntlrToJava;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinErrorListener;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinLexer;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinParser;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinParserException;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GremlinQueryParser {
    private static final Logger log = LoggerFactory.getLogger(GremlinQueryParser.class);
    private static final GremlinErrorListener errorListener = new GremlinErrorListener();

    public static Object parse(String query) {
        return GremlinQueryParser.parse(query, new GremlinAntlrToJava());
    }

    public static Object parse(String query, GremlinVisitor<Object> visitor) {
        GremlinParser.QueryListContext queryContext;
        CodePointCharStream in = CharStreams.fromString((String)query);
        GremlinLexer lexer = new GremlinLexer((CharStream)in);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)errorListener);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        GremlinParser parser = new GremlinParser((TokenStream)tokens);
        ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)errorListener);
        try {
            queryContext = parser.queryList();
        }
        catch (Exception ex) {
            try {
                tokens.seek(0);
                lexer.reset();
                parser.reset();
                ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL);
                log.debug("Query parsed with using LL prediction mode: {}", (Object)query);
                queryContext = parser.queryList();
            }
            catch (Exception e) {
                log.debug("Query parsing failed in retry with exception" + e);
                throw new GremlinParserException("Failed to interpret Gremlin query: " + e.getMessage());
            }
        }
        try {
            return visitor.visit((ParseTree)queryContext);
        }
        catch (ClassCastException ex) {
            log.debug("Converting a java.lang.ClassCastException to GremlinParserException, assuming that it indicates a semantic parse error.", (Throwable)ex);
            throw new GremlinParserException("Failed to interpret Gremlin query: " + ex.getMessage(), ex);
        }
    }
}

