/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.MessageLite;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.history.SummaryEvent;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.dag.recovery.records.RecoveryProtos;

public class VertexGroupCommitFinishedEvent
implements HistoryEvent,
SummaryEvent {
    private TezDAGID dagID;
    private String vertexGroupName;
    private Collection<TezVertexID> vertexIds;
    private long commitFinishTime;

    public VertexGroupCommitFinishedEvent() {
    }

    public VertexGroupCommitFinishedEvent(TezDAGID dagID, String vertexGroupName, Collection<TezVertexID> vertexIds, long commitFinishTime) {
        this.dagID = dagID;
        this.vertexGroupName = vertexGroupName;
        this.vertexIds = vertexIds;
        this.commitFinishTime = commitFinishTime;
    }

    @Override
    public HistoryEventType getEventType() {
        return HistoryEventType.VERTEX_GROUP_COMMIT_FINISHED;
    }

    @Override
    public boolean isRecoveryEvent() {
        return true;
    }

    @Override
    public boolean isHistoryEvent() {
        return false;
    }

    public RecoveryProtos.VertexGroupCommitFinishedProto toProto() {
        Collection vertexIdsStr = Collections2.transform(this.vertexIds, (Function)new Function<TezVertexID, String>(){

            public String apply(TezVertexID vertexId) {
                return vertexId.toString();
            }
        });
        return RecoveryProtos.VertexGroupCommitFinishedProto.newBuilder().setDagId(this.dagID.toString()).setVertexGroupName(this.vertexGroupName).addAllVertexIds(vertexIdsStr).build();
    }

    public void fromProto(RecoveryProtos.VertexGroupCommitFinishedProto proto) {
        this.dagID = TezDAGID.fromString((String)proto.getDagId());
        this.vertexGroupName = proto.getVertexGroupName();
        this.vertexIds = Collections2.transform((Collection)proto.getVertexIdsList(), (Function)new Function<String, TezVertexID>(){

            public TezVertexID apply(String input) {
                return TezVertexID.fromString((String)input);
            }
        });
    }

    @Override
    public void toProtoStream(CodedOutputStream outputStream) throws IOException {
        outputStream.writeMessageNoTag((MessageLite)this.toProto());
    }

    @Override
    public void fromProtoStream(CodedInputStream inputStream) throws IOException {
        RecoveryProtos.VertexGroupCommitFinishedProto proto = (RecoveryProtos.VertexGroupCommitFinishedProto)inputStream.readMessage(RecoveryProtos.VertexGroupCommitFinishedProto.PARSER, (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
        if (proto == null) {
            throw new IOException("No data found in stream");
        }
        this.fromProto(proto);
    }

    public String toString() {
        return "dagId=" + this.dagID + ", vertexGroup=" + this.vertexGroupName;
    }

    public String getVertexGroupName() {
        return this.vertexGroupName;
    }

    @Override
    public void toSummaryProtoStream(OutputStream outputStream) throws IOException {
        RecoveryProtos.SummaryEventProto.Builder builder = RecoveryProtos.SummaryEventProto.newBuilder().setDagId(this.dagID.toString()).setTimestamp(this.commitFinishTime).setEventType(this.getEventType().ordinal()).setEventPayload(this.toProto().toByteString());
        builder.build().writeDelimitedTo(outputStream);
    }

    @Override
    public void fromSummaryProtoStream(RecoveryProtos.SummaryEventProto proto) throws IOException {
        RecoveryProtos.VertexGroupCommitFinishedProto vertexGroupCommitFinishedProto = RecoveryProtos.VertexGroupCommitFinishedProto.parseFrom(proto.getEventPayload());
        this.fromProto(vertexGroupCommitFinishedProto);
        this.commitFinishTime = proto.getTimestamp();
    }

    @Override
    public boolean writeToRecoveryImmediately() {
        return false;
    }

    public TezDAGID getDagID() {
        return this.dagID;
    }

    public Collection<TezVertexID> getVertexIds() {
        return this.vertexIds;
    }
}

