/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.tapestry5.ioc.AnnotationProvider;
import org.apache.tapestry5.ioc.Invokable;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.ServiceBuilderResources;
import org.apache.tapestry5.ioc.def.ServiceDef3;
import org.apache.tapestry5.ioc.internal.ConstructorServiceCreator;
import org.apache.tapestry5.ioc.internal.IOCMessages;
import org.apache.tapestry5.ioc.internal.InternalRegistry;
import org.apache.tapestry5.ioc.internal.Module;
import org.apache.tapestry5.ioc.internal.ObjectLocatorImpl;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.PlasticProxyFactory;
import org.slf4j.Logger;

public class ServiceResourcesImpl
extends ObjectLocatorImpl
implements ServiceBuilderResources {
    private final InternalRegistry registry;
    private final Module module;
    private final ServiceDef3 serviceDef;
    private final Logger logger;
    private final PlasticProxyFactory proxyFactory;

    public ServiceResourcesImpl(InternalRegistry registry, Module module, ServiceDef3 serviceDef, PlasticProxyFactory proxyFactory, Logger logger) {
        super(registry, module);
        this.registry = registry;
        this.module = module;
        this.serviceDef = serviceDef;
        this.proxyFactory = proxyFactory;
        this.logger = logger;
    }

    @Override
    public String getServiceId() {
        return this.serviceDef.getServiceId();
    }

    @Override
    public Class getServiceInterface() {
        return this.serviceDef.getServiceInterface();
    }

    @Override
    public Class getServiceImplementation() {
        return this.serviceDef.getServiceImplementation();
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public <T> Collection<T> getUnorderedConfiguration(final Class<T> valueType) {
        Collection result = (Collection)this.registry.invoke("Collecting unordered configuration for service " + this.serviceDef.getServiceId(), new Invokable<Collection<T>>(){

            @Override
            public Collection<T> invoke() {
                return ServiceResourcesImpl.this.registry.getUnorderedConfiguration(ServiceResourcesImpl.this.serviceDef, valueType);
            }
        });
        this.logConfiguration(result);
        return result;
    }

    private void logConfiguration(Collection configuration) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(IOCMessages.constructedConfiguration(configuration));
        }
    }

    @Override
    public <T> List<T> getOrderedConfiguration(final Class<T> valueType) {
        List result = (List)this.registry.invoke("Collecting ordered configuration for service " + this.serviceDef.getServiceId(), new Invokable<List<T>>(){

            @Override
            public List<T> invoke() {
                return ServiceResourcesImpl.this.registry.getOrderedConfiguration(ServiceResourcesImpl.this.serviceDef, valueType);
            }
        });
        this.logConfiguration(result);
        return result;
    }

    @Override
    public <K, V> Map<K, V> getMappedConfiguration(final Class<K> keyType, final Class<V> valueType) {
        Map result = (Map)this.registry.invoke("Collecting mapped configuration for service " + this.serviceDef.getServiceId(), new Invokable<Map<K, V>>(){

            @Override
            public Map<K, V> invoke() {
                return ServiceResourcesImpl.this.registry.getMappedConfiguration(ServiceResourcesImpl.this.serviceDef, keyType, valueType);
            }
        });
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(IOCMessages.constructedConfiguration(result));
        }
        return result;
    }

    @Override
    public Object getModuleBuilder() {
        return this.module.getModuleBuilder();
    }

    @Override
    public <T> T autobuild(String description, final Class<T> clazz) {
        assert (clazz != null);
        return (T)this.registry.invoke(description, new Invokable<T>(){

            @Override
            public T invoke() {
                Constructor constructor = InternalUtils.findAutobuildConstructor(clazz);
                if (constructor == null) {
                    throw new RuntimeException(IOCMessages.noAutobuildConstructor(clazz));
                }
                String description = ServiceResourcesImpl.this.proxyFactory.getConstructorLocation(constructor).toString();
                ConstructorServiceCreator creator = new ConstructorServiceCreator(ServiceResourcesImpl.this, description, constructor);
                return clazz.cast(creator.createObject());
            }
        });
    }

    @Override
    public <T> T autobuild(Class<T> clazz) {
        assert (clazz != null);
        return this.autobuild("Autobuilding instance of class " + clazz.getName(), clazz);
    }

    @Override
    public OperationTracker getTracker() {
        return this.registry;
    }

    public Class getImplementationClass() {
        return null;
    }

    @Override
    public AnnotationProvider getClassAnnotationProvider() {
        return this.serviceDef.getClassAnnotationProvider();
    }

    @Override
    public AnnotationProvider getMethodAnnotationProvider(String methodName, Class ... parameterTypes) {
        return this.serviceDef.getMethodAnnotationProvider(methodName, parameterTypes);
    }
}

