/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services.dashboard;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.tapestry5.Block;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.runtime.Component;
import org.apache.tapestry5.services.ComponentSource;
import org.apache.tapestry5.services.dashboard.DashboardManager;
import org.apache.tapestry5.services.dashboard.DashboardTab;

public class DashboardManagerImpl
implements DashboardManager {
    private final ComponentSource componentSource;
    private final List<String> tabNames;
    private final Map<String, String> tab2PageName = CollectionFactory.newCaseInsensitiveMap();

    public DashboardManagerImpl(ComponentSource componentSource, List<DashboardTab> tabs) {
        this.componentSource = componentSource;
        List tabNames = CollectionFactory.newList();
        for (DashboardTab tab : tabs) {
            tabNames.add(tab.tabName);
            this.tab2PageName.put(tab.tabName, tab.pageName);
        }
        this.tabNames = Collections.unmodifiableList(tabNames);
    }

    @Override
    public List<String> getTabNames() {
        return this.tabNames;
    }

    @Override
    public Block getTabContent(String tabName) {
        Component page = this.componentSource.getPage(this.tab2PageName.get(tabName));
        return page.getComponentResources().getBlock("content");
    }
}

