/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.tapestry5.internal.services.ClusteredSessionImpl;
import org.apache.tapestry5.internal.services.SessionImpl;
import org.apache.tapestry5.internal.services.SessionLock;
import org.apache.tapestry5.internal.services.TapestrySessionFactory;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.services.PerthreadManager;
import org.apache.tapestry5.services.Session;
import org.apache.tapestry5.services.SessionPersistedObjectAnalyzer;

public class TapestrySessionFactoryImpl
implements TapestrySessionFactory {
    private boolean clustered;
    private final SessionPersistedObjectAnalyzer analyzer;
    private final HttpServletRequest request;
    private final PerthreadManager perthreadManager;
    private final boolean sessionLockingEnabled;
    private final Lock mapLock = new ReentrantLock();
    private final Map<HttpSession, SessionLock> sessionToLock = new WeakHashMap<HttpSession, SessionLock>();
    private final SessionLock NO_OP_LOCK = new SessionLock(){

        @Override
        public void acquireReadLock() {
        }

        @Override
        public void acquireWriteLock() {
        }
    };

    public TapestrySessionFactoryImpl(@Symbol(value="tapestry.clustered-sessions") boolean clustered, SessionPersistedObjectAnalyzer analyzer, HttpServletRequest request, PerthreadManager perthreadManager, @Symbol(value="tapestry.session-locking-enabled") boolean sessionLockingEnabled) {
        this.clustered = clustered;
        this.analyzer = analyzer;
        this.request = request;
        this.perthreadManager = perthreadManager;
        this.sessionLockingEnabled = sessionLockingEnabled;
    }

    @Override
    public Session getSession(boolean create) {
        HttpSession httpSession = this.request.getSession(create);
        if (httpSession == null) {
            return null;
        }
        SessionLock lock = this.lockForSession(httpSession);
        if (this.clustered) {
            return new ClusteredSessionImpl(this.request, httpSession, lock, this.analyzer);
        }
        return new SessionImpl(this.request, httpSession, lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SessionLock lockForSession(HttpSession session) {
        if (!this.sessionLockingEnabled) {
            return this.NO_OP_LOCK;
        }
        this.mapLock.lock();
        try {
            SessionLock result = this.sessionToLock.get(session);
            if (result == null) {
                result = new SessionLockImpl();
                this.sessionToLock.put(session, result);
            }
            SessionLock sessionLock = result;
            return sessionLock;
        }
        finally {
            this.mapLock.unlock();
        }
    }

    private class SessionLockImpl
    implements SessionLock {
        private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

        private SessionLockImpl() {
        }

        private boolean isReadLocked() {
            return this.lock.getReadHoldCount() != 0;
        }

        private boolean isWriteLocked() {
            return this.lock.isWriteLockedByCurrentThread();
        }

        @Override
        public void acquireReadLock() {
            if (this.isReadLocked() || this.isWriteLocked()) {
                return;
            }
            this.lock.readLock().lock();
            TapestrySessionFactoryImpl.this.perthreadManager.addThreadCleanupCallback(new Runnable(){

                @Override
                public void run() {
                    if (SessionLockImpl.this.isReadLocked()) {
                        SessionLockImpl.this.lock.readLock().unlock();
                    }
                }
            });
        }

        @Override
        public void acquireWriteLock() {
            if (this.isWriteLocked()) {
                return;
            }
            if (this.isReadLocked()) {
                this.lock.readLock().unlock();
            }
            this.lock.writeLock().lock();
            TapestrySessionFactoryImpl.this.perthreadManager.addThreadCleanupCallback(new Runnable(){

                @Override
                public void run() {
                    SessionLockImpl.this.lock.writeLock().unlock();
                }
            });
        }
    }
}

