/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.resource.cost;

import org.apache.sysds.common.Types;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.resource.CloudInstance;
import org.apache.sysds.resource.cost.RDDStats;
import org.apache.sysds.resource.cost.VarStats;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.utils.stats.InfrastructureAnalyzer;

public class IOCostUtils {
    private static final double COMPUTE_EFFICIENCY = 0.5;
    private static final double READ_DENSE_FACTOR = 0.5;
    private static final double WRITE_DENSE_FACTOR = 0.3;
    private static final double SPARSE_FACTOR = 0.5;
    private static final double TEXT_FACTOR = 0.5;
    private static final double S3_COMPUTE_BOUND = 1.2E9;
    private static final double SERIALIZATION_FACTOR = 0.5;
    private static final double DESERIALIZATION_FACTOR = 0.8;
    public static final long DEFAULT_FLOPS = 0x80000000L;
    protected static final String S3_SOURCE_IDENTIFIER = "s3";
    protected static final String HDFS_SOURCE_IDENTIFIER = "hdfs";

    public static double getMemReadTime(VarStats stats, IOMetrics metrics) {
        if (stats.isScalar()) {
            return 0.0;
        }
        if (stats.allocatedMemory < 0L) {
            throw new RuntimeException("VarStats.allocatedMemory should carry the estimated size before getting read time");
        }
        double sizeMB = (double)stats.allocatedMemory / 1048576.0;
        return sizeMB / metrics.memReadBandwidth;
    }

    public static double getMemReadTime(RDDStats stats, IOMetrics metrics) {
        double size = stats.distributedSize;
        if (size < 0.0) {
            throw new RuntimeException("RDDStats.distributedMemory should carry the estimated size before getting read time");
        }
        double minExecutionMemory = SparkExecutionContext.getDataMemoryBudget(true, false);
        double spillOverFraction = minExecutionMemory >= size ? 0.0 : (size - minExecutionMemory) / size;
        double mixedBandwidthPerCore = (spillOverFraction * metrics.localDiskReadBandwidth + (1.0 - spillOverFraction) * metrics.memReadBandwidth) / (double)metrics.cpuCores;
        double numWaves = Math.ceil((double)stats.numPartitions / (double)SparkExecutionContext.getDefaultParallelism(false));
        double sizeMB = size / 1048576.0;
        double partitionSizeMB = sizeMB / (double)stats.numPartitions;
        return numWaves * (partitionSizeMB / mixedBandwidthPerCore);
    }

    public static double getMemWriteTime(VarStats stats, IOMetrics metrics) {
        if (stats == null) {
            return 0.0;
        }
        if (stats.allocatedMemory < 0L) {
            throw new DMLRuntimeException("VarStats.allocatedMemory should carry the estimated size before getting write time");
        }
        double sizeMB = (double)stats.allocatedMemory / 1048576.0;
        return sizeMB / metrics.memWriteBandwidth;
    }

    public static double getMemWriteTime(RDDStats stats, IOMetrics metrics) {
        if (stats.distributedSize < 0L) {
            throw new RuntimeException("RDDStats.distributedMemory should carry the estimated size before getting write time");
        }
        double numWaves = Math.ceil((double)stats.numPartitions / (double)SparkExecutionContext.getDefaultParallelism(false));
        double sizeMB = (double)stats.distributedSize / 1048576.0;
        double partitionSizeMB = sizeMB / (double)stats.numPartitions;
        return numWaves * partitionSizeMB / (metrics.memWriteBandwidth / (double)metrics.cpuCores);
    }

    public static double getFileSystemReadTime(VarStats stats, IOMetrics metrics) {
        String sourceType = (String)stats.fileInfo[0];
        Types.FileFormat format = (Types.FileFormat)((Object)stats.fileInfo[1]);
        double sizeMB = IOCostUtils.getFileSizeInMB(stats);
        boolean isSparse = MatrixBlock.evalSparseFormatOnDisk(stats.getM(), stats.getN(), stats.getNNZ());
        return IOCostUtils.getStorageReadTime(sizeMB, isSparse, sourceType, format, metrics);
    }

    public static double getHadoopReadTime(VarStats stats, IOMetrics metrics) {
        String sourceType = (String)stats.fileInfo[0];
        Types.FileFormat format = (Types.FileFormat)((Object)stats.fileInfo[1]);
        long size = IOCostUtils.getPartitionedFileSize(stats);
        long hdfsBlockSize = InfrastructureAnalyzer.getHDFSBlockSize();
        double numPartitions = Math.ceil((double)size / (double)hdfsBlockSize);
        double sizePerExecutorMB = size < hdfsBlockSize ? (double)((long)metrics.cpuCores * size) / 1048576.0 : (double)((long)metrics.cpuCores * hdfsBlockSize) / 1048576.0;
        boolean isSparse = MatrixBlock.evalSparseFormatOnDisk(stats.getM(), stats.getN(), stats.getNNZ());
        double timePerCore = IOCostUtils.getStorageReadTime(sizePerExecutorMB, isSparse, sourceType, format, metrics);
        double numWaves = Math.ceil(numPartitions / (double)SparkExecutionContext.getDefaultParallelism(false));
        return numWaves * timePerCore;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static double getStorageReadTime(double sizeMB, boolean isSparse, String source, Types.FileFormat format, IOMetrics metrics) {
        if (format == null || format.isTextFormat()) {
            if (source.equals(S3_SOURCE_IDENTIFIER)) {
                if (!isSparse) return metrics.s3BandwidthEfficiency * sizeMB;
                return 0.5 * metrics.s3BandwidthEfficiency * sizeMB;
            }
            if (!isSparse) return sizeMB / metrics.hdfsReadTextDenseBandwidth;
            return sizeMB / metrics.hdfsReadTextSparseBandwidth;
        }
        if (format != Types.FileFormat.BINARY) throw new RuntimeException("Format " + format + " is not supported for estimation yet.");
        if (!source.equals(HDFS_SOURCE_IDENTIFIER)) throw new RuntimeException("Reading binary files from S3 is not supported");
        if (!isSparse) return sizeMB / metrics.hdfsReadBinaryDenseBandwidth;
        return sizeMB / metrics.hdfsReadBinarySparseBandwidth;
    }

    public static double getFileSystemWriteTime(VarStats stats, IOMetrics metrics) {
        String sourceType = (String)stats.fileInfo[0];
        Types.FileFormat format = (Types.FileFormat)((Object)stats.fileInfo[1]);
        double sizeMB = IOCostUtils.getFileSizeInMB(stats);
        boolean isSparse = MatrixBlock.evalSparseFormatOnDisk(stats.getM(), stats.getN(), stats.getNNZ());
        return IOCostUtils.getStorageWriteTime(sizeMB, isSparse, sourceType, format, metrics);
    }

    public static double getHadoopWriteTime(VarStats stats, IOMetrics metrics) {
        if (stats.rddStats == null) {
            throw new RuntimeException("Estimation for hadoop write time required VarStats object with assigned 'rddStats' member");
        }
        String sourceType = (String)stats.fileInfo[0];
        Types.FileFormat format = (Types.FileFormat)((Object)stats.fileInfo[1]);
        long size = IOCostUtils.getPartitionedFileSize(stats);
        double sizePerPartitionMB = (double)size / (double)stats.rddStats.numPartitions / 1048576.0;
        double sizePerExecutor = sizePerPartitionMB * (double)metrics.cpuCores;
        boolean isSparse = MatrixBlock.evalSparseFormatOnDisk(stats.getM(), stats.getN(), stats.getNNZ());
        double timePerCore = IOCostUtils.getStorageWriteTime(sizePerExecutor, isSparse, sourceType, format, metrics);
        double numWaves = Math.ceil((double)stats.rddStats.numPartitions / (double)(SparkExecutionContext.getNumExecutors() * metrics.cpuCores));
        return numWaves * timePerCore;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static double getStorageWriteTime(double sizeMB, boolean isSparse, String source, Types.FileFormat format, IOMetrics metrics) {
        if (format == null) throw new RuntimeException("Estimation not possible without source identifier and file format");
        if (IOCostUtils.isInvalidDataSource(source)) {
            throw new RuntimeException("Estimation not possible without source identifier and file format");
        }
        if (format.isTextFormat()) {
            if (source.equals(S3_SOURCE_IDENTIFIER)) {
                if (!isSparse) return metrics.s3BandwidthEfficiency * sizeMB;
                return 0.5 * metrics.s3BandwidthEfficiency * sizeMB;
            }
            if (!isSparse) return sizeMB / metrics.hdfsWriteTextDenseBandwidth;
            return sizeMB / metrics.hdfsWriteTextSparseBandwidth;
        }
        if (format != Types.FileFormat.BINARY) throw new RuntimeException("Format " + format + " is not supported for estimation yet.");
        if (!source.equals(HDFS_SOURCE_IDENTIFIER)) throw new RuntimeException("Writing binary files from S3 is not supported");
        if (!isSparse) return sizeMB / metrics.hdfsWriteBinaryDenseBandwidth;
        return sizeMB / metrics.hdfsWriteBinarySparseBandwidth;
    }

    public static double getSparkParallelizeTime(RDDStats output, IOMetrics driverMetrics, IOMetrics executorMetrics) {
        double sizeMB = (double)output.distributedSize / 1048576.0;
        double serializationTime = sizeMB / driverMetrics.serializationBandwidth;
        double effectiveBandwidth = Math.min(driverMetrics.networkingBandwidth, (double)SparkExecutionContext.getNumExecutors() * executorMetrics.networkingBandwidth);
        double transferTime = sizeMB / effectiveBandwidth;
        return serializationTime + transferTime;
    }

    public static double getSparkCollectTime(RDDStats output, IOMetrics driverMetrics, IOMetrics executorMetrics) {
        double sizeMB = (double)output.distributedSize / 1048576.0;
        double numWaves = Math.ceil((double)output.numPartitions / (double)SparkExecutionContext.getDefaultParallelism(false));
        int currentParallelism = Math.min(output.numPartitions, SparkExecutionContext.getDefaultParallelism(false));
        double bandwidthPerCore = executorMetrics.networkingBandwidth / (double)executorMetrics.cpuCores;
        double effectiveBandwidth = Math.min(numWaves * driverMetrics.networkingBandwidth, (double)currentParallelism * bandwidthPerCore);
        return sizeMB / effectiveBandwidth;
    }

    public static double getSparkShuffleReadTime(RDDStats input, IOMetrics metrics) {
        double sizeMB = (double)input.distributedSize / 1048576.0;
        if (SparkExecutionContext.getNumExecutors() < 2) {
            double diskBandwidthPerCore = metrics.localDiskWriteBandwidth / (double)metrics.cpuCores;
            return sizeMB / diskBandwidthPerCore;
        }
        int currentParallelism = Math.min(input.numPartitions, SparkExecutionContext.getDefaultParallelism(false));
        double networkBandwidthPerCore = metrics.networkingBandwidth / (double)metrics.cpuCores;
        return sizeMB / ((double)currentParallelism * networkBandwidthPerCore);
    }

    public static double getSparkShuffleReadStaticTime(RDDStats input, IOMetrics metrics) {
        double sizeMB = (double)input.distributedSize / 1048576.0;
        int currentParallelism = Math.min(input.numPartitions, SparkExecutionContext.getDefaultParallelism(false));
        double readBandwidthPerCore = metrics.memReadBandwidth / (double)metrics.cpuCores;
        return sizeMB / ((double)currentParallelism * readBandwidthPerCore);
    }

    public static double getSparkShuffleWriteTime(RDDStats output, IOMetrics metrics) {
        double sizeMB = (double)output.distributedSize / 1048576.0;
        int currentParallelism = Math.min(output.numPartitions, SparkExecutionContext.getDefaultParallelism(false));
        double bandwidthPerCore = metrics.localDiskWriteBandwidth / (double)metrics.cpuCores;
        return sizeMB / ((double)currentParallelism * bandwidthPerCore);
    }

    public static double getSparkShuffleTime(RDDStats output, IOMetrics metrics, boolean withDistribution) {
        double totalTime = IOCostUtils.getSparkShuffleWriteTime(output, metrics);
        totalTime = withDistribution ? (totalTime += IOCostUtils.getSparkShuffleReadTime(output, metrics)) : (totalTime += IOCostUtils.getSparkShuffleReadStaticTime(output, metrics));
        return totalTime;
    }

    protected static double getSparkBroadcastTime(VarStats stats, IOMetrics driverMetrics, IOMetrics executorMetrics) {
        double sizeMB = (double)OptimizerUtils.estimatePartitionedSizeExactSparsity(stats.characteristics) / 1048576.0;
        double serializationTime = sizeMB / driverMetrics.serializationBandwidth;
        double effectiveBandwidth = Math.min(driverMetrics.networkingBandwidth, executorMetrics.networkingBandwidth);
        double transferTime = sizeMB / effectiveBandwidth;
        return serializationTime + transferTime;
    }

    public static String getDataSource(String fileName) {
        String[] fileParts = fileName.split("://");
        if (fileParts.length > 1) {
            String filesystem = fileParts[0].toLowerCase();
            if (filesystem.matches("\\b(s3|s3a)\\b")) {
                return S3_SOURCE_IDENTIFIER;
            }
            return filesystem;
        }
        return HDFS_SOURCE_IDENTIFIER;
    }

    private static double getFileSizeInMB(VarStats fileStats) {
        double sizeMB;
        Types.FileFormat format = (Types.FileFormat)((Object)fileStats.fileInfo[1]);
        if (format == Types.FileFormat.BINARY) {
            sizeMB = (double)MatrixBlock.estimateSizeOnDisk(fileStats.getM(), fileStats.getM(), fileStats.getNNZ()) / 1048576.0;
        } else if (format.isTextFormat()) {
            sizeMB = (double)OptimizerUtils.estimateSizeTextOutput(fileStats.getM(), fileStats.getM(), fileStats.getNNZ(), format) / 1048576.0;
        } else {
            throw new RuntimeException("Format " + format + " is not supported for estimation yet.");
        }
        return sizeMB;
    }

    private static long getPartitionedFileSize(VarStats fileStats) {
        long size;
        Types.FileFormat format = (Types.FileFormat)((Object)fileStats.fileInfo[1]);
        if (format == Types.FileFormat.BINARY) {
            size = MatrixBlock.estimateSizeOnDisk(fileStats.getM(), fileStats.getN(), fileStats.getNNZ());
        } else if (format.isTextFormat()) {
            size = OptimizerUtils.estimateSizeTextOutput(fileStats.getM(), fileStats.getN(), fileStats.getNNZ(), format);
        } else {
            throw new RuntimeException("Format " + format + " is not supported for estimation yet.");
        }
        return size;
    }

    public static boolean isInvalidDataSource(String identifier) {
        return !identifier.equals(HDFS_SOURCE_IDENTIFIER) && !identifier.equals(S3_SOURCE_IDENTIFIER);
    }

    public static class IOMetrics {
        long cpuFLOPS;
        int cpuCores;
        double localDiskReadBandwidth;
        double localDiskWriteBandwidth;
        double hdfsReadBinaryDenseBandwidth;
        double hdfsReadBinarySparseBandwidth;
        double hdfsWriteBinaryDenseBandwidth;
        double hdfsWriteBinarySparseBandwidth;
        double hdfsReadTextDenseBandwidth;
        double hdfsReadTextSparseBandwidth;
        double hdfsWriteTextDenseBandwidth;
        double hdfsWriteTextSparseBandwidth;
        double s3BandwidthEfficiency;
        double memReadBandwidth;
        double memWriteBandwidth;
        double networkingBandwidth;
        double serializationBandwidth;
        double deserializationBandwidth;
        public static final int DEFAULT_NUM_CPU_CORES = 8;
        public static final double DEFAULT_MBS_MEMORY_BANDWIDTH = 21328.0;
        public static final double DEFAULT_MBS_DISK_BANDWIDTH = 600.0;
        public static final double DEFAULT_MBS_NETWORK_BANDWIDTH = 640.0;
        public static final double DEFAULT_MBS_HDFS_READ_BINARY_DENSE = 150.0;
        public static final double DEFAULT_MBS_HDFS_READ_BINARY_SPARSE = 75.0;
        public static final double DEFAULT_MBS_HDFS_READ_TEXT_DENSE = 75.0;
        public static final double DEFAULT_MBS_HDFS_READ_TEXT_SPARSE = 50.0;
        public static final double DEFAULT_MBS_HDFS_WRITE_BINARY_DENSE = 120.0;
        public static final double DEFAULT_MBS_HDFS_WRITE_BINARY_SPARSE = 60.0;
        public static final double DEFAULT_MBS_HDFS_WRITE_TEXT_DENSE = 40.0;
        public static final double DEFAULT_MBS_HDFS_WRITE_TEXT_SPARSE = 30.0;

        public IOMetrics(CloudInstance instance) {
            this(instance.getFLOPS(), instance.getVCPUs(), instance.getMemoryBandwidth(), instance.getDiskReadBandwidth(), instance.getDiskWriteBandwidth(), instance.getNetworkBandwidth());
        }

        public IOMetrics(long flops, int cores, double memoryBandwidth, double diskReadBandwidth, double diskWriteBandwidth, double networkBandwidth) {
            this.cpuFLOPS = (long)((double)flops * 0.5);
            this.cpuCores = cores;
            this.memReadBandwidth = memoryBandwidth;
            this.memWriteBandwidth = memoryBandwidth;
            this.networkingBandwidth = networkBandwidth;
            this.localDiskReadBandwidth = diskReadBandwidth;
            this.localDiskWriteBandwidth = diskReadBandwidth;
            this.hdfsReadBinaryDenseBandwidth = diskReadBandwidth * 0.5;
            this.hdfsReadBinarySparseBandwidth = this.hdfsReadBinaryDenseBandwidth * 0.5;
            this.hdfsWriteBinaryDenseBandwidth = diskWriteBandwidth * 0.3;
            this.hdfsWriteBinarySparseBandwidth = this.hdfsWriteBinaryDenseBandwidth * 0.5;
            this.hdfsReadTextDenseBandwidth = this.hdfsReadBinaryDenseBandwidth * 0.5;
            this.hdfsReadTextSparseBandwidth = this.hdfsReadBinarySparseBandwidth * 0.5;
            this.hdfsWriteTextDenseBandwidth = this.hdfsWriteBinaryDenseBandwidth * 0.5;
            this.hdfsWriteTextSparseBandwidth = this.hdfsWriteBinarySparseBandwidth * 0.5;
            this.s3BandwidthEfficiency = 1.2E9 / (double)this.cpuFLOPS;
            double currentFlopsFactor = 2.147483648E9 / (double)this.cpuFLOPS;
            this.serializationBandwidth = this.memReadBandwidth * 0.5 * currentFlopsFactor;
            this.deserializationBandwidth = this.memWriteBandwidth * 0.8 * currentFlopsFactor;
        }

        public IOMetrics() {
            this.cpuFLOPS = 0x80000000L;
            this.cpuCores = 8;
            this.localDiskReadBandwidth = 600.0;
            this.localDiskWriteBandwidth = 600.0;
            this.hdfsReadBinaryDenseBandwidth = 150.0;
            this.hdfsReadBinarySparseBandwidth = 75.0;
            this.hdfsWriteBinaryDenseBandwidth = 120.0;
            this.hdfsWriteBinarySparseBandwidth = 60.0;
            this.hdfsReadTextDenseBandwidth = 75.0;
            this.hdfsReadTextSparseBandwidth = 50.0;
            this.hdfsWriteTextDenseBandwidth = 40.0;
            this.hdfsWriteTextSparseBandwidth = 30.0;
            this.s3BandwidthEfficiency = 1.2E9 / (double)this.cpuFLOPS;
            this.memReadBandwidth = 21328.0;
            this.memWriteBandwidth = 21328.0;
            this.networkingBandwidth = 640.0;
            double currentFlopsFactor = 2.147483648E9 / (double)this.cpuFLOPS;
            this.serializationBandwidth = this.memReadBandwidth * 0.5 * currentFlopsFactor;
            this.deserializationBandwidth = this.memWriteBandwidth * 0.8 * currentFlopsFactor;
        }
    }
}

