/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import javax.xml.namespace.QName;
import org.apache.woden.WSDLException;
import org.apache.woden.XMLElement;
import org.apache.woden.internal.BaseWSDLWriter;
import org.apache.woden.internal.WSDLContext;
import org.apache.woden.internal.util.dom.DOM2Writer;
import org.apache.woden.internal.util.dom.DOMUtils;
import org.apache.woden.internal.wsdl20.Constants;
import org.apache.woden.schema.ImportedSchema;
import org.apache.woden.schema.InlinedSchema;
import org.apache.woden.types.NCName;
import org.apache.woden.types.NamespaceDeclaration;
import org.apache.woden.types.QNameTokenUnion;
import org.apache.woden.wsdl20.enumeration.Direction;
import org.apache.woden.wsdl20.extensions.ExtensionElement;
import org.apache.woden.wsdl20.extensions.ExtensionRegistry;
import org.apache.woden.wsdl20.extensions.ExtensionSerializer;
import org.apache.woden.wsdl20.xml.BindingElement;
import org.apache.woden.wsdl20.xml.BindingFaultElement;
import org.apache.woden.wsdl20.xml.BindingOperationElement;
import org.apache.woden.wsdl20.xml.DescriptionElement;
import org.apache.woden.wsdl20.xml.DocumentationElement;
import org.apache.woden.wsdl20.xml.EndpointElement;
import org.apache.woden.wsdl20.xml.ImportElement;
import org.apache.woden.wsdl20.xml.IncludeElement;
import org.apache.woden.wsdl20.xml.InterfaceElement;
import org.apache.woden.wsdl20.xml.InterfaceFaultElement;
import org.apache.woden.wsdl20.xml.InterfaceFaultReferenceElement;
import org.apache.woden.wsdl20.xml.InterfaceMessageReferenceElement;
import org.apache.woden.wsdl20.xml.InterfaceOperationElement;
import org.apache.woden.wsdl20.xml.ServiceElement;
import org.apache.woden.wsdl20.xml.TypesElement;
import org.apache.woden.wsdl20.xml.WSDLElement;
import org.apache.woden.xml.XMLAttr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMWSDLWriter
extends BaseWSDLWriter {
    public DOMWSDLWriter(WSDLContext wsdlContext) {
        super(wsdlContext);
    }

    public void writeWSDL(DescriptionElement wsdlDes, Writer sink) throws WSDLException {
        PrintWriter pw = new PrintWriter(sink);
        String javaEncoding = sink instanceof OutputStreamWriter ? ((OutputStreamWriter)sink).getEncoding() : null;
        String xmlEncoding = DOM2Writer.java2XMLEncoding(javaEncoding);
        if (xmlEncoding == null) {
            throw new WSDLException("CONFIGURATION_ERROR", "Unsupported Java encoding for writing wsdl file: '" + javaEncoding + "'.");
        }
        pw.println("<?xml version=\"1.0\" encoding=\"" + xmlEncoding + "\"?>");
        this.printDescription(wsdlDes, pw);
    }

    public void writeWSDL(DescriptionElement wsdlDes, OutputStream sink) throws WSDLException {
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter(sink, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            writer = new OutputStreamWriter(sink);
        }
        this.writeWSDL(wsdlDes, writer);
    }

    protected void printDescription(DescriptionElement desEle, PrintWriter pw) throws WSDLException {
        if (desEle == null) {
            return;
        }
        if (desEle.getNamespacePrefix(Constants.NS_URI_WSDL20) == null) {
            String prefix = "wsdl";
            int subscript = 0;
            while (desEle.getNamespaceURI(prefix) != null) {
                prefix = "wsdl" + subscript++;
            }
            desEle.addNamespace(prefix, Constants.NS_URI_WSDL20);
        }
        String tagName = DOMUtils.getQualifiedValue(Constants.NS_URI_WSDL20, "description", (WSDLElement)desEle);
        pw.print('<' + tagName);
        URI targetNamespace = desEle.getTargetNamespace();
        if (targetNamespace != null) {
            String targetNamespaceStr = targetNamespace.toString();
            DOMUtils.printAttribute("targetNamespace", targetNamespaceStr, pw);
        }
        NamespaceDeclaration[] namespaces = desEle.getDeclaredNamespaces();
        this.printExtensibilityAttributes(desEle.getExtensionAttributes(), desEle, pw);
        this.printNamespaceDeclarations(namespaces, pw);
        pw.println('>');
        this.printDocumentation(desEle.getDocumentationElements(), desEle, pw);
        this.printImports(desEle.getImportElements(), desEle, pw);
        this.printIncludes(desEle.getIncludeElements(), desEle, pw);
        this.printTypes(desEle.getTypesElement(), desEle, pw);
        this.printInterfaces(desEle.getInterfaceElements(), desEle, pw);
        this.printBindings(desEle.getBindingElements(), desEle, pw);
        this.printServices(desEle.getServiceElements(), desEle, pw);
        this.printExtensibilityElements(desEle.getClass(), desEle.getExtensionElements(), desEle, pw);
        pw.println("</" + tagName + '>');
        pw.flush();
    }

    protected void printNamespaceDeclarations(NamespaceDeclaration[] namespaces, PrintWriter pw) throws WSDLException {
        if (namespaces != null) {
            int len = namespaces.length;
            for (int i = 0; i < len; ++i) {
                String prefix = namespaces[i].getPrefix();
                if (prefix == null) {
                    prefix = "";
                }
                DOMUtils.printAttribute("xmlns" + (!prefix.equals("") ? ":" + prefix : ""), namespaces[i].getNamespaceURI().toString(), pw);
            }
        }
    }

    protected void printImports(ImportElement[] imports, DescriptionElement des, PrintWriter pw) throws WSDLException {
        if (imports != null) {
            String tagName = DOMUtils.getQualifiedValue(Constants.NS_URI_WSDL20, "import", (WSDLElement)des);
            for (int ind = 0; ind < imports.length; ++ind) {
                String location;
                ImportElement importEle = imports[ind];
                if (importEle == null) continue;
                pw.print("  <" + tagName);
                String namespace = importEle.getNamespace().toString();
                if (namespace != null) {
                    DOMUtils.printAttribute("namespace", namespace, pw);
                }
                if ((location = importEle.getLocation().toString()) != null) {
                    DOMUtils.printAttribute("location", location, pw);
                }
                this.printExtensibilityAttributes(importEle.getExtensionAttributes(), importEle, pw);
                pw.println('>');
                this.printDocumentation(importEle.getDocumentationElements(), des, pw);
                this.printExtensibilityElements(importEle.getClass(), importEle.getExtensionElements(), des, pw);
                pw.println("  </" + tagName + '>');
            }
        }
    }

    protected void printIncludes(IncludeElement[] includes, DescriptionElement des, PrintWriter pw) throws WSDLException {
        if (includes != null) {
            String tagName = DOMUtils.getQualifiedValue(Constants.NS_URI_WSDL20, "include", (WSDLElement)des);
            for (int ind = 0; ind < includes.length; ++ind) {
                IncludeElement includeEle = includes[ind];
                if (includeEle == null) continue;
                pw.print("  <" + tagName);
                String location = includeEle.getLocation().toString();
                if (location != null) {
                    DOMUtils.printAttribute("location", location, pw);
                }
                this.printExtensibilityAttributes(includeEle.getExtensionAttributes(), includeEle, pw);
                pw.println('>');
                this.printDocumentation(includeEle.getDocumentationElements(), des, pw);
                this.printExtensibilityElements(includeEle.getClass(), includeEle.getExtensionElements(), des, pw);
                pw.println("  </" + tagName + '>');
            }
        }
    }

    protected void printInterfaces(InterfaceElement[] intrfaces, DescriptionElement des, PrintWriter pw) throws WSDLException {
        if (intrfaces != null) {
            String tagName = DOMUtils.getQualifiedValue(Constants.NS_URI_WSDL20, "interface", (WSDLElement)des);
            for (int ind = 0; ind < intrfaces.length; ++ind) {
                InterfaceElement intrface = intrfaces[ind];
                if (intrface == null) continue;
                pw.print("  <" + tagName);
                QName name = intrface.getName();
                if (name != null) {
                    DOMUtils.printAttribute("name", name.getLocalPart(), pw);
                }
                QName[] extendedInterfaces = intrface.getExtendedInterfaceNames();
                String attrExtendedInterfaces = "";
                for (int i = 0; i < extendedInterfaces.length; ++i) {
                    if (extendedInterfaces[i] == null) continue;
                    attrExtendedInterfaces = attrExtendedInterfaces + DOMUtils.getQualifiedValue(extendedInterfaces[i].getNamespaceURI(), extendedInterfaces[i].getLocalPart(), (WSDLElement)des);
                    if (i == extendedInterfaces.length - 1) continue;
                    attrExtendedInterfaces = attrExtendedInterfaces + " ";
                }
                if (extendedInterfaces.length > 0) {
                    DOMUtils.printAttribute("extends", attrExtendedInterfaces, pw);
                }
                URI[] styleDefaults = intrface.getStyleDefault();
                for (int i = 0; i < styleDefaults.length; ++i) {
                    URI styleDefault = styleDefaults[i];
                    if (styleDefault == null) continue;
                    DOMUtils.printAttribute("styleDefault", styleDefault.toString(), pw);
                }
                this.printExtensibilityAttributes(intrface.getExtensionAttributes(), intrface, pw);
                pw.println('>');
                this.printDocumentation(intrface.getDocumentationElements(), des, pw);
                this.printOperations(intrface.getInterfaceOperationElements(), des, pw);
                this.printFaults(intrface.getInterfaceFaultElements(), des, pw);
                this.printExtensibilityElements(intrface.getClass(), intrface.getExtensionElements(), des, pw);
                pw.println("  </" + tagName + '>');
            }
        }
    }

    protected void printOperations(InterfaceOperationElement[] operations, DescriptionElement des, PrintWriter pw) throws WSDLException {
        if (operations != null) {
            String tagName = DOMUtils.getQualifiedValue(Constants.NS_URI_WSDL20, "operation", (WSDLElement)des);
            for (int ind = 0; ind < operations.length; ++ind) {
                URI[] styles;
                URI pattern;
                InterfaceOperationElement operation = operations[ind];
                if (operation == null) continue;
                pw.print("    <" + tagName);
                QName name = operation.getName();
                if (name != null) {
                    DOMUtils.printAttribute("name", name.getLocalPart(), pw);
                }
                if ((pattern = operation.getPattern()) != null) {
                    DOMUtils.printAttribute("pattern", pattern.toString(), pw);
                }
                if ((styles = operation.getStyle()) != null && styles.length > 0) {
                    String styleStr = this.getStyleStr(styles);
                    DOMUtils.printAttribute("style", styleStr, pw);
                }
                this.printExtensibilityAttributes(operation.getExtensionAttributes(), operation, pw);
                pw.println('>');
                this.printDocumentation(operation.getDocumentationElements(), des, pw);
                this.printInterfaceMessageReferences(operation.getInterfaceMessageReferenceElements(), des, pw);
                this.printInterfaceFaultReferences(operation.getInterfaceFaultReferenceElements(), des, pw);
                this.printExtensibilityElements(operation.getClass(), operation.getExtensionElements(), des, pw);
                pw.println("    </" + tagName + '>');
            }
        }
    }

    protected void printInterfaceMessageReferences(InterfaceMessageReferenceElement[] msgrefs, DescriptionElement des, PrintWriter pw) throws WSDLException {
        for (int ind = 0; ind < msgrefs.length; ++ind) {
            InterfaceMessageReferenceElement msgRef = msgrefs[ind];
            if (msgRef == null) continue;
            String tagName = null;
            Direction msgDirection = msgRef.getDirection();
            if (msgDirection == Direction.IN) {
                tagName = DOMUtils.getQualifiedValue(Constants.NS_URI_WSDL20, "input", (WSDLElement)msgRef);
            } else if (msgDirection == Direction.OUT) {
                tagName = DOMUtils.getQualifiedValue(Constants.NS_URI_WSDL20, "output", (WSDLElement)msgRef);
            }
            pw.print("      <" + tagName);
            String msglable = msgRef.getMessageLabel().toString();
            DOMUtils.printAttribute("messageLabel", msglable, pw);
            QNameTokenUnion qtu = msgRef.getElement();
            if (qtu != null) {
                if (qtu.isQName()) {
                    QName element = qtu.getQName();
                    URI ns = msgRef.getNamespaceURI(element.getPrefix());
                    String attrName = ns != null ? DOMUtils.getQualifiedValue(msgRef.getNamespaceURI(element.getPrefix()).toString(), element.getLocalPart(), (WSDLElement)msgRef) : element.getLocalPart();
                    DOMUtils.printAttribute("element", attrName, pw);
                } else {
                    DOMUtils.printAttribute("element", qtu.getToken(), pw);
                }
            }
            this.printExtensibilityAttributes(msgRef.getExtensionAttributes(), msgRef, pw);
            pw.println('>');
            this.printDocumentation(msgRef.getDocumentationElements(), des, pw);
            this.printExtensibilityElements(msgRef.getClass(), msgRef.getExtensionElements(), des, pw);
            pw.println("    </" + tagName + '>');
        }
    }

    protected void printInterfaceFaultReferences(InterfaceFaultReferenceElement[] faulRefs, DescriptionElement des, PrintWriter pw) throws WSDLException {
        for (int ind = 0; ind < faulRefs.length; ++ind) {
            InterfaceFaultReferenceElement faulRef = faulRefs[ind];
            if (faulRef == null) continue;
            String tagName = null;
            Direction msgDirection = faulRef.getDirection();
            if (msgDirection == Direction.IN) {
                tagName = DOMUtils.getQualifiedValue(Constants.NS_URI_WSDL20, "infault", (WSDLElement)faulRef);
            } else if (msgDirection == Direction.OUT) {
                tagName = DOMUtils.getQualifiedValue(Constants.NS_URI_WSDL20, "outfault", (WSDLElement)faulRef);
            }
            pw.print("      <" + tagName);
            String msglable = faulRef.getMessageLabel().toString();
            DOMUtils.printAttribute("messageLabel", msglable, pw);
            QName attrQName = faulRef.getRef();
            String attrName = DOMUtils.getQualifiedValue(faulRef.getNamespaceURI(attrQName.getPrefix()).toString(), attrQName.getLocalPart(), (WSDLElement)faulRef);
            DOMUtils.printAttribute("ref", attrName, pw);
            this.printExtensibilityAttributes(faulRef.getExtensionAttributes(), faulRef, pw);
            pw.println('>');
            this.printDocumentation(faulRef.getDocumentationElements(), des, pw);
            this.printExtensibilityElements(faulRef.getClass(), faulRef.getExtensionElements(), des, pw);
            pw.println("    </" + tagName + '>');
        }
    }

    protected void printFaults(InterfaceFaultElement[] faulEles, DescriptionElement des, PrintWriter pw) throws WSDLException {
        for (int ind = 0; ind < faulEles.length; ++ind) {
            InterfaceFaultElement faulEle = faulEles[ind];
            if (faulEle == null) continue;
            String tagName = null;
            tagName = DOMUtils.getQualifiedValue(Constants.NS_URI_WSDL20, "fault", (WSDLElement)faulEle);
            pw.print("      <" + tagName);
            String attrName = faulEle.getName().getLocalPart();
            DOMUtils.printAttribute("name", attrName, pw);
            QName attrElement = faulEle.getElement().getQName();
            String attrEle = DOMUtils.getQualifiedValue(faulEle.getNamespaceURI(attrElement.getPrefix()).toString(), attrElement.getLocalPart(), (WSDLElement)faulEle);
            DOMUtils.printAttribute("element", attrEle, pw);
            this.printExtensibilityAttributes(faulEle.getExtensionAttributes(), faulEle, pw);
            pw.println('>');
            this.printDocumentation(faulEle.getDocumentationElements(), des, pw);
            this.printExtensibilityElements(faulEle.getClass(), faulEle.getExtensionElements(), des, pw);
            pw.println("    </" + tagName + '>');
        }
    }

    protected void printBindings(BindingElement[] bindings, DescriptionElement des, PrintWriter pw) throws WSDLException {
        String tagName = DOMUtils.getQualifiedValue(Constants.NS_URI_WSDL20, "binding", (WSDLElement)des);
        for (int ind = 0; ind < bindings.length; ++ind) {
            InterfaceElement intrface;
            BindingElement binding = bindings[ind];
            if (bindings == null) continue;
            pw.print("  <" + tagName);
            QName name = binding.getName();
            if (name != null) {
                DOMUtils.printAttribute("name", name.getLocalPart(), pw);
            }
            if ((intrface = binding.getInterfaceElement()) != null) {
                QName interfaceName = intrface.getName();
                if (interfaceName != null) {
                    DOMUtils.printQualifiedAttribute("interface", interfaceName, des, pw);
                }
                DOMUtils.printAttribute("type", binding.getType().toString(), pw);
                this.printExtensibilityAttributes(binding.getExtensionAttributes(), binding, pw);
            }
            pw.println('>');
            this.printDocumentation(binding.getDocumentationElements(), des, pw);
            this.printExtensibilityElements(binding.getClass(), binding.getExtensionElements(), des, pw);
            this.printBindingOperations(binding.getBindingOperationElements(), des, pw);
            this.printBindingFaults(binding.getBindingFaultElements(), des, pw);
            pw.println("  </" + tagName + '>');
        }
    }

    protected void printBindingFaults(BindingFaultElement[] faults, DescriptionElement des, PrintWriter pw) throws WSDLException {
        if (faults != null) {
            String tagName = DOMUtils.getQualifiedValue(Constants.NS_URI_WSDL20, "fault", (WSDLElement)des);
            for (int ind = 0; ind < faults.length; ++ind) {
                BindingFaultElement fault = faults[ind];
                if (fault == null) continue;
                pw.print("    <" + tagName);
                DOMUtils.printQualifiedAttribute("ref", fault.getRef(), des, pw);
                this.printExtensibilityAttributes(fault.getExtensionAttributes(), fault, pw);
                pw.println("/>");
            }
        }
    }

    protected void printBindingOperations(BindingOperationElement[] operations, DescriptionElement des, PrintWriter pw) throws WSDLException {
        if (operations != null) {
            String tagName = DOMUtils.getQualifiedValue(Constants.NS_URI_WSDL20, "operation", (WSDLElement)des);
            for (int ind = 0; ind < operations.length; ++ind) {
                BindingOperationElement operation = operations[ind];
                if (operation == null) continue;
                pw.print("    <" + tagName);
                DOMUtils.printQualifiedAttribute("ref", operation.getRef(), des, pw);
                this.printExtensibilityAttributes(operation.getExtensionAttributes(), operation, pw);
                pw.println("/>");
            }
        }
    }

    protected void printServices(ServiceElement[] services, DescriptionElement des, PrintWriter pw) throws WSDLException {
        String tagName = DOMUtils.getQualifiedValue(Constants.NS_URI_WSDL20, "service", (WSDLElement)des);
        for (int ind = 0; ind < services.length; ++ind) {
            ServiceElement service = services[ind];
            if (service == null) continue;
            pw.print("  <" + tagName);
            QName name = service.getName();
            if (name != null) {
                DOMUtils.printAttribute("name", name.getLocalPart(), pw);
            }
            QName interfaceName = service.getInterfaceName();
            if (name != null) {
                DOMUtils.printQualifiedAttribute("interface", interfaceName, des, pw);
            }
            this.printExtensibilityAttributes(service.getExtensionAttributes(), service, pw);
            pw.println('>');
            this.printEndpoints(service.getEndpointElements(), des, pw);
            this.printDocumentation(service.getDocumentationElements(), des, pw);
            this.printExtensibilityElements(service.getClass(), service.getExtensionElements(), des, pw);
            pw.println("    </" + tagName + '>');
        }
    }

    protected void printEndpoints(EndpointElement[] endpoints, DescriptionElement des, PrintWriter pw) throws WSDLException {
        String tagName = DOMUtils.getQualifiedValue(Constants.NS_URI_WSDL20, "endpoint", (WSDLElement)des);
        for (int ind = 0; ind < endpoints.length; ++ind) {
            URI address;
            BindingElement binding;
            EndpointElement endPoint = endpoints[ind];
            if (endPoint == null) continue;
            pw.print("    <" + tagName);
            NCName ncName = endPoint.getName();
            if (ncName != null) {
                String name = ncName.toString();
                DOMUtils.printAttribute("name", name, pw);
            }
            if ((binding = endPoint.getBindingElement()) != null) {
                DOMUtils.printQualifiedAttribute("binding", binding.getName(), des, pw);
            }
            if ((address = endPoint.getAddress()) != null) {
                DOMUtils.printAttribute("address", address.toString(), pw);
            }
            this.printExtensibilityAttributes(endPoint.getExtensionAttributes(), endPoint, pw);
            pw.println('>');
            this.printDocumentation(endPoint.getDocumentationElements(), des, pw);
            this.printExtensibilityElements(endPoint.getClass(), endPoint.getExtensionElements(), des, pw);
            pw.println("    </" + tagName + '>');
        }
    }

    protected void printTypes(TypesElement types, DescriptionElement des, PrintWriter pw) throws WSDLException {
        if (types != null) {
            String tagName = DOMUtils.getQualifiedValue(Constants.NS_URI_WSDL20, "types", (WSDLElement)des);
            pw.print("<" + tagName);
            this.printExtensibilityAttributes(types.getExtensionAttributes(), types, pw);
            pw.println('>');
            ExtensionElement[] extElements = types.getExtensionElements();
            this.printExtensibilityElements(types.getClass(), extElements, des, pw);
            this.printImportedSchemas(types.getImportedSchemas(), des, pw);
            this.printInlinedSchemas(types.getInlinedSchemas(), des, pw);
            pw.println("</" + tagName + '>');
        }
    }

    protected void printInlinedSchemas(InlinedSchema[] inlinedSchema, DescriptionElement des, PrintWriter pw) throws WSDLException {
        for (int i = 0; i < inlinedSchema.length; ++i) {
            InlinedSchema schema = inlinedSchema[i];
            XMLElement ele = schema.getXMLElement();
            DOM2Writer.serializeAsXML((Node)ele.getSource(), pw);
        }
    }

    protected void printImportedSchemas(ImportedSchema[] importedSchema, DescriptionElement des, PrintWriter pw) throws WSDLException {
        String tagname = DOMUtils.getQualifiedValue("http://www.w3.org/2001/XMLSchema", "import", (WSDLElement)des);
        for (int i = 0; i < importedSchema.length; ++i) {
            ImportedSchema schema = importedSchema[i];
            String ns = schema.getNamespace().toString();
            if ("http://www.w3.org/2001/XMLSchema".equals(ns)) continue;
            pw.println("<" + tagname);
            DOMUtils.printAttribute("namespace", importedSchema[i].getNamespace().toString(), pw);
            DOMUtils.printAttribute("location", importedSchema[i].getSchemaLocation().toString(), pw);
            pw.print(" />");
        }
    }

    protected void printExtensibilityElements(Class parentType, ExtensionElement[] extensibilityElements, DescriptionElement def, PrintWriter pw) throws WSDLException {
        if (extensibilityElements != null) {
            for (int ind = 0; ind < extensibilityElements.length; ++ind) {
                ExtensionElement ext = extensibilityElements[ind];
                QName elementType = ext.getExtensionType();
                ExtensionRegistry extReg = this.fWsdlContext.extensionRegistry;
                if (extReg == null) {
                    throw new WSDLException("CONFIGURATION_ERROR", "No ExtensionRegistry set for this Description, so unable to serialize a '" + elementType + "' element in the context of a '" + parentType.getName() + "'.");
                }
                ExtensionSerializer extSer = extReg.querySerializer(parentType, elementType);
                extSer.marshall(parentType, elementType, ext, pw, def, extReg);
            }
        }
    }

    protected void printExtensibilityAttributes(XMLAttr[] attrExts, WSDLElement ownerElem, PrintWriter pw) throws WSDLException {
        if (attrExts != null) {
            for (int index = 0; index < attrExts.length; ++index) {
                String attrName;
                XMLAttr attrExt = attrExts[index];
                if (attrExt == null) continue;
                QName ns = attrExt.getAttributeType();
                String attrLocalName = ns.getLocalPart();
                String attrValue = attrExt.toExternalForm();
                if (ns != null) {
                    String attrPrefix = ns.getPrefix();
                    attrName = DOMUtils.getQualifiedValue(ownerElem.getNamespaceURI(attrPrefix).toString(), attrLocalName, ownerElem);
                } else {
                    attrName = attrLocalName;
                }
                DOMUtils.printAttribute(attrName, attrValue, pw);
            }
        }
    }

    protected void printDocumentation(DocumentationElement[] docEles, DescriptionElement def, PrintWriter pw) throws WSDLException {
        if (docEles != null) {
            String tagName = DOMUtils.getQualifiedValue(Constants.NS_URI_WSDL20, "documentation", (WSDLElement)def);
            for (int ind = 0; ind < docEles.length; ++ind) {
                DocumentationElement docEle = docEles[ind];
                if (docEle == null) continue;
                pw.print("    <" + tagName);
                pw.println('>');
                Object o = docEle.getContent().getSource();
                Element domEl = (Element)o;
                DOM2Writer.serializeAsXML(domEl.getFirstChild(), pw);
                pw.println("    </" + tagName + '>');
            }
        }
    }

    private String getStyleStr(URI[] styles) {
        String styleStr = "";
        if (styles != null) {
            for (URI uri : styles) {
                styleStr = styleStr + uri.toString() + " ";
            }
            styleStr = styleStr.trim();
        }
        return styleStr;
    }
}

