/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.system.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.streampark.console.base.domain.RestRequest;
import org.apache.streampark.console.base.domain.RestResponse;
import org.apache.streampark.console.core.enums.AccessTokenState;
import org.apache.streampark.console.core.service.ServiceHelper;
import org.apache.streampark.console.system.entity.AccessToken;
import org.apache.streampark.console.system.service.AccessTokenService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"token"})
public class AccessTokenController {
    @Autowired
    private AccessTokenService accessTokenService;
    @Autowired
    private ServiceHelper serviceHelper;

    @PostMapping(value={"create"})
    @RequiresPermissions(value={"token:add"})
    public RestResponse createToken(@NotBlank(message="{required}") @NotBlank(message="{required}") Long userId, @RequestParam(required=false) String description) throws Exception {
        return this.accessTokenService.create(userId, description);
    }

    @PostMapping(value={"check"})
    public RestResponse verifyToken() {
        Long userId = this.serviceHelper.getUserId();
        RestResponse restResponse = RestResponse.success();
        AccessToken accessToken = this.accessTokenService.getByUserId(userId);
        if (accessToken == null) {
            restResponse.data(AccessTokenState.NULL.get());
        } else if (AccessToken.STATUS_DISABLE.equals(accessToken.getStatus())) {
            restResponse.data(AccessTokenState.INVALID_TOKEN.get());
        } else if ("0".equals(accessToken.getUserStatus())) {
            restResponse.data(AccessTokenState.LOCKED_USER.get());
        }
        return restResponse;
    }

    @PostMapping(value={"list"})
    @RequiresPermissions(value={"token:view"})
    public RestResponse tokensList(RestRequest restRequest, AccessToken accessToken) {
        IPage<AccessToken> accessTokens = this.accessTokenService.page(accessToken, restRequest);
        return RestResponse.success(accessTokens);
    }

    @PostMapping(value={"toggle"})
    @RequiresPermissions(value={"token:add"})
    public RestResponse toggleToken(@NotNull(message="{required}") @NotNull(message="{required}") Long tokenId) {
        return this.accessTokenService.toggle(tokenId);
    }

    @DeleteMapping(value={"delete"})
    @RequiresPermissions(value={"token:delete"})
    public RestResponse deleteToken(@NotBlank(message="{required}") @NotBlank(message="{required}") Long tokenId) {
        boolean res = this.accessTokenService.delete(tokenId);
        return RestResponse.success(res);
    }
}

