/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.runner;

import java.util.HashMap;
import java.util.Map;
import org.apache.streampark.common.enums.ClusterState;
import org.apache.streampark.common.enums.ExecutionMode;
import org.apache.streampark.common.util.PropertiesUtils;
import org.apache.streampark.console.core.entity.Application;
import org.apache.streampark.console.core.entity.FlinkCluster;
import org.apache.streampark.console.core.entity.FlinkEnv;
import org.apache.streampark.console.core.entity.FlinkSql;
import org.apache.streampark.console.core.service.ApplicationService;
import org.apache.streampark.console.core.service.FlinkClusterService;
import org.apache.streampark.console.core.service.FlinkEnvService;
import org.apache.streampark.console.core.service.FlinkSqlService;
import org.apache.streampark.console.system.service.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order
@Component
public class QuickStartRunner
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(QuickStartRunner.class);
    @Autowired
    private FlinkEnvService flinkEnvService;
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private FlinkClusterService flinkClusterService;
    @Autowired
    private FlinkSqlService flinkSqlService;
    @Autowired
    private UserService userService;
    private static Long defaultId = 100000L;

    public void run(ApplicationArguments args) throws Exception {
        HashMap map = PropertiesUtils.extractMultipleArgumentsAsJava((String[])args.getSourceArgs());
        Map quickstart = (Map)map.get("quickstart");
        if (quickstart != null && quickstart.size() == 3) {
            this.userService.setLastTeam(defaultId, defaultId);
            FlinkEnv flinkEnv = new FlinkEnv();
            flinkEnv.setFlinkName((String)quickstart.get("flink_name"));
            flinkEnv.setFlinkHome((String)quickstart.get("flink_home"));
            this.flinkEnvService.create(flinkEnv);
            FlinkCluster flinkCluster = new FlinkCluster();
            flinkCluster.setClusterName("quickstart");
            flinkCluster.setVersionId(flinkEnv.getId());
            flinkCluster.setClusterState(ClusterState.STARTED.getValue());
            flinkCluster.setExecutionMode(ExecutionMode.REMOTE.getMode());
            flinkCluster.setAddress("http://localhost:" + (String)quickstart.get("flink_port"));
            this.flinkClusterService.create(flinkCluster, defaultId);
            Application app = new Application();
            app.setId(defaultId);
            Application application = this.applicationService.getApp(app);
            application.setFlinkClusterId(flinkCluster.getId());
            application.setVersionId(flinkEnv.getId());
            application.setExecutionMode(ExecutionMode.REMOTE.getMode());
            FlinkSql flinkSql = this.flinkSqlService.getEffective(application.getId(), true);
            application.setFlinkSql(flinkSql.getSql());
            boolean success = this.applicationService.update(application);
            if (success) {
                this.applicationService.buildApplication(defaultId, false);
            }
        }
    }
}

