/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.kubeclient.resources;

import io.fabric8.kubernetes.client.NamespacedKubernetesClient;
import io.fabric8.kubernetes.client.extended.leaderelection.LeaderCallbacks;
import io.fabric8.kubernetes.client.extended.leaderelection.LeaderElectionConfig;
import io.fabric8.kubernetes.client.extended.leaderelection.LeaderElectionConfigBuilder;
import io.fabric8.kubernetes.client.extended.leaderelection.LeaderElector;
import io.fabric8.kubernetes.client.extended.leaderelection.resourcelock.ConfigMapLock;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.kubernetes.configuration.KubernetesLeaderElectionConfiguration;
import org.apache.flink.kubernetes.kubeclient.resources.KubernetesConfigMap;
import org.apache.flink.util.concurrent.ExecutorThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesLeaderElector {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesLeaderElector.class);
    @VisibleForTesting
    public static final String LEADER_ANNOTATION_KEY = "control-plane.alpha.kubernetes.io/leader";
    private final Object lock = new Object();
    private final ExecutorService executorService = Executors.newSingleThreadExecutor((ThreadFactory)new ExecutorThreadFactory("KubernetesLeaderElector-ExecutorService"));
    private final LeaderElector<NamespacedKubernetesClient> internalLeaderElector;

    public KubernetesLeaderElector(NamespacedKubernetesClient kubernetesClient, KubernetesLeaderElectionConfiguration leaderConfig, LeaderCallbackHandler leaderCallbackHandler) {
        LeaderElectionConfig leaderElectionConfig = ((LeaderElectionConfigBuilder)((LeaderElectionConfigBuilder)((LeaderElectionConfigBuilder)((LeaderElectionConfigBuilder)((LeaderElectionConfigBuilder)((LeaderElectionConfigBuilder)new LeaderElectionConfigBuilder().withName(leaderConfig.getConfigMapName())).withLeaseDuration(leaderConfig.getLeaseDuration())).withLock(new ConfigMapLock(kubernetesClient.getNamespace(), leaderConfig.getConfigMapName(), leaderConfig.getLockIdentity()))).withRenewDeadline(leaderConfig.getRenewDeadline())).withRetryPeriod(leaderConfig.getRetryPeriod())).withLeaderCallbacks(new LeaderCallbacks(leaderCallbackHandler::isLeader, leaderCallbackHandler::notLeader, newLeader -> LOG.info("New leader elected {} for {}.", newLeader, (Object)leaderConfig.getConfigMapName())))).build();
        this.internalLeaderElector = new LeaderElector<NamespacedKubernetesClient>(kubernetesClient, leaderElectionConfig);
        LOG.info("Create KubernetesLeaderElector {} with lock identity {}.", (Object)leaderConfig.getConfigMapName(), (Object)leaderConfig.getLockIdentity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object = this.lock;
        synchronized (object) {
            if (this.executorService.isShutdown()) {
                LOG.debug("Ignoring KubernetesLeaderElector.run call because the leader elector has already been shut down.");
            } else {
                this.executorService.execute(this.internalLeaderElector::run);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            this.executorService.shutdownNow();
        }
    }

    public static boolean hasLeadership(KubernetesConfigMap configMap, String lockIdentity) {
        String leader = configMap.getAnnotations().get(LEADER_ANNOTATION_KEY);
        return leader != null && leader.contains(lockIdentity);
    }

    public static abstract class LeaderCallbackHandler {
        public abstract void isLeader();

        public abstract void notLeader();
    }
}

