/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.xbill.DNS;

public final class Serial {
    private static final long MAX32 = 0xFFFFFFFFL;

    private Serial() {
    }

    public static int compare(long serial1, long serial2) {
        if (serial1 < 0L || serial1 > 0xFFFFFFFFL) {
            throw new IllegalArgumentException(serial1 + " out of range");
        }
        if (serial2 < 0L || serial2 > 0xFFFFFFFFL) {
            throw new IllegalArgumentException(serial2 + " out of range");
        }
        long diff = serial1 - serial2;
        if (diff >= 0xFFFFFFFFL) {
            diff -= 0x100000000L;
        } else if (diff < -4294967295L) {
            diff += 0x100000000L;
        }
        return (int)diff;
    }

    public static long increment(long serial) {
        if (serial < 0L || serial > 0xFFFFFFFFL) {
            throw new IllegalArgumentException(serial + " out of range");
        }
        if (serial == 0xFFFFFFFFL) {
            return 0L;
        }
        return serial + 1L;
    }
}

