/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.channel;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.CancellationException;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriteRequest;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriteRequestDispatcher;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriteRequestExecutor;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.function.RunnableWithException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
class ChannelStateWriteRequestExecutorImpl
implements ChannelStateWriteRequestExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(ChannelStateWriteRequestExecutorImpl.class);
    private final ChannelStateWriteRequestDispatcher dispatcher;
    private final BlockingDeque<ChannelStateWriteRequest> deque;
    private final Thread thread;
    private volatile Exception thrown = null;
    private volatile boolean wasClosed = false;
    private final String taskName;

    ChannelStateWriteRequestExecutorImpl(String taskName, ChannelStateWriteRequestDispatcher dispatcher) {
        this(taskName, dispatcher, new LinkedBlockingDeque<ChannelStateWriteRequest>());
    }

    ChannelStateWriteRequestExecutorImpl(String taskName, ChannelStateWriteRequestDispatcher dispatcher, BlockingDeque<ChannelStateWriteRequest> deque) {
        this.taskName = taskName;
        this.dispatcher = dispatcher;
        this.deque = deque;
        this.thread = new Thread(this::run, "Channel state writer " + taskName);
        this.thread.setDaemon(true);
    }

    /*
     * Loose catch block
     */
    @VisibleForTesting
    void run() {
        block10: {
            this.loop();
            try {
                IOUtils.closeAll((AutoCloseable[])new AutoCloseable[]{this::cleanupRequests, () -> this.dispatcher.fail(this.thrown == null ? new CancellationException() : this.thrown)});
            }
            catch (Exception e) {
                this.thrown = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)this.thrown);
            }
            break block10;
            catch (Exception ex) {
                try {
                    this.thrown = ex;
                }
                catch (Throwable throwable) {
                    try {
                        IOUtils.closeAll((AutoCloseable[])new AutoCloseable[]{this::cleanupRequests, () -> this.dispatcher.fail(this.thrown == null ? new CancellationException() : this.thrown)});
                    }
                    catch (Exception e) {
                        this.thrown = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)this.thrown);
                    }
                    throw throwable;
                }
                try {
                    IOUtils.closeAll((AutoCloseable[])new AutoCloseable[]{this::cleanupRequests, () -> this.dispatcher.fail(this.thrown == null ? new CancellationException() : this.thrown)});
                }
                catch (Exception e) {
                    this.thrown = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)this.thrown);
                }
            }
        }
        LOG.debug("{} loop terminated", (Object)this.taskName);
    }

    private void loop() throws Exception {
        while (!this.wasClosed) {
            try {
                this.dispatcher.dispatch(this.deque.take());
            }
            catch (InterruptedException e) {
                if (!this.wasClosed) {
                    LOG.debug(this.taskName + " interrupted while waiting for a request (continue waiting)", (Throwable)e);
                    continue;
                }
                Thread.currentThread().interrupt();
            }
        }
    }

    private void cleanupRequests() throws Exception {
        Exception cause = this.thrown == null ? new CancellationException() : this.thrown;
        ArrayList drained = new ArrayList();
        this.deque.drainTo(drained);
        LOG.info("{} discarding {} drained requests", (Object)this.taskName, (Object)drained.size());
        IOUtils.closeAll((Iterable)drained.stream().map(request -> () -> request.cancel(cause)).collect(Collectors.toList()));
    }

    @Override
    public void start() throws IllegalStateException {
        this.thread.start();
    }

    @Override
    public void submit(ChannelStateWriteRequest request) throws Exception {
        this.submitInternal(request, () -> this.deque.add(request));
    }

    @Override
    public void submitPriority(ChannelStateWriteRequest request) throws Exception {
        this.submitInternal(request, () -> this.deque.addFirst(request));
    }

    private void submitInternal(ChannelStateWriteRequest request, RunnableWithException action) throws Exception {
        try {
            action.run();
        }
        catch (Exception ex) {
            request.cancel(ex);
            throw ex;
        }
        this.ensureRunning();
    }

    private void ensureRunning() throws Exception {
        if (this.wasClosed || !this.thread.isAlive()) {
            this.cleanupRequests();
            IllegalStateException exception = new IllegalStateException("not running");
            if (this.thrown != null) {
                exception.addSuppressed(this.thrown);
            }
            throw exception;
        }
    }

    @Override
    public void close() throws IOException {
        this.wasClosed = true;
        while (this.thread.isAlive()) {
            this.thread.interrupt();
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                if (!this.thread.isAlive()) {
                    Thread.currentThread().interrupt();
                }
                LOG.debug(this.taskName + " interrupted while waiting for the writer thread to die", (Throwable)e);
            }
        }
        if (this.thrown != null) {
            throw new IOException(this.thrown);
        }
    }

    @VisibleForTesting
    Thread getThread() {
        return this.thread;
    }
}

