/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.source;

import java.util.Iterator;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.source.RichParallelSourceFunction;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.util.SplittableIterator;

@PublicEvolving
public class FromSplittableIteratorFunction<T>
extends RichParallelSourceFunction<T> {
    private static final long serialVersionUID = 1L;
    private SplittableIterator<T> fullIterator;
    private transient Iterator<T> iterator;
    private volatile boolean isRunning = true;

    public FromSplittableIteratorFunction(SplittableIterator<T> iterator) {
        this.fullIterator = iterator;
    }

    public void open(Configuration parameters) throws Exception {
        int numberOfSubTasks = this.getRuntimeContext().getNumberOfParallelSubtasks();
        int indexofThisSubTask = this.getRuntimeContext().getIndexOfThisSubtask();
        this.iterator = this.fullIterator.split(numberOfSubTasks)[indexofThisSubTask];
        this.isRunning = true;
    }

    @Override
    public void run(SourceFunction.SourceContext<T> ctx) throws Exception {
        while (this.isRunning && this.iterator.hasNext()) {
            ctx.collect(this.iterator.next());
        }
    }

    @Override
    public void cancel() {
        this.isRunning = false;
    }
}

