/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.query;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.util.Preconditions;

@Internal
abstract class AbstractQueryableStateOperator<S extends State, IN>
extends AbstractStreamOperator<IN>
implements OneInputStreamOperator<IN, IN> {
    private static final long serialVersionUID = 7842489558298787382L;
    protected final StateDescriptor<? extends S, ?> stateDescriptor;
    protected final String registrationName;
    protected transient S state;

    public AbstractQueryableStateOperator(String registrationName, StateDescriptor<? extends S, ?> stateDescriptor) {
        this.registrationName = (String)Preconditions.checkNotNull((Object)registrationName, (String)"Registration name");
        this.stateDescriptor = (StateDescriptor)Preconditions.checkNotNull(stateDescriptor, (String)"State descriptor");
        if (stateDescriptor.isQueryable()) {
            String name = stateDescriptor.getQueryableStateName();
            if (!name.equals(registrationName)) {
                throw new IllegalArgumentException("StateDescriptor already marked as queryable with name '" + name + "', but created operator with name '" + registrationName + "'.");
            }
        } else {
            stateDescriptor.setQueryable(registrationName);
        }
    }

    @Override
    public void open() throws Exception {
        super.open();
        this.state = this.getPartitionedState(this.stateDescriptor);
    }
}

