/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.serialization;

import com.esotericsoftware.kryo.io.Output;
import java.io.IOException;
import java.util.Map;
import org.apache.storm.serialization.ITupleSerializer;
import org.apache.storm.serialization.KryoValuesSerializer;
import org.apache.storm.serialization.SerializationFactory;
import org.apache.storm.task.GeneralTopologyContext;
import org.apache.storm.tuple.Tuple;

public class KryoTupleSerializer
implements ITupleSerializer {
    private KryoValuesSerializer kryo;
    private SerializationFactory.IdDictionary ids;
    private Output kryoOut;

    public KryoTupleSerializer(Map<String, Object> conf, GeneralTopologyContext context) {
        this.kryo = new KryoValuesSerializer(conf);
        this.kryoOut = new Output(2000, 2000000000);
        this.ids = new SerializationFactory.IdDictionary(context.getRawTopology());
    }

    @Override
    public byte[] serialize(Tuple tuple) {
        try {
            this.kryoOut.reset();
            this.kryoOut.writeInt(tuple.getSourceTask(), true);
            this.kryoOut.writeInt(this.ids.getStreamId(tuple.getSourceComponent(), tuple.getSourceStreamId()), true);
            tuple.getMessageId().serialize(this.kryoOut);
            this.kryo.serializeInto(tuple.getValues(), this.kryoOut);
            return this.kryoOut.toBytes();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

