/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.drpc;

import java.util.HashMap;
import java.util.Map;
import org.apache.storm.coordination.CoordinatedBolt;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.BasicBoltExecutor;
import org.apache.storm.topology.IBasicBolt;
import org.apache.storm.topology.IRichBolt;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.utils.KeyedRoundRobinQueue;

public class KeyedFairBolt
implements IRichBolt,
CoordinatedBolt.FinishedCallback {
    IRichBolt delegate;
    KeyedRoundRobinQueue<Tuple> rrQueue;
    Thread executor;
    CoordinatedBolt.FinishedCallback callback;

    public KeyedFairBolt(IRichBolt delegate) {
        this.delegate = delegate;
    }

    public KeyedFairBolt(IBasicBolt delegate) {
        this(new BasicBoltExecutor(delegate));
    }

    @Override
    public void prepare(Map<String, Object> topoConf, TopologyContext context, OutputCollector collector) {
        if (this.delegate instanceof CoordinatedBolt.FinishedCallback) {
            this.callback = (CoordinatedBolt.FinishedCallback)((Object)this.delegate);
        }
        this.delegate.prepare(topoConf, context, collector);
        this.rrQueue = new KeyedRoundRobinQueue();
        this.executor = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        KeyedFairBolt.this.delegate.execute(KeyedFairBolt.this.rrQueue.take());
                    }
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        });
        this.executor.setDaemon(true);
        this.executor.start();
    }

    @Override
    public void execute(Tuple input) {
        Object key = input.getValue(0);
        this.rrQueue.add(key, input);
    }

    @Override
    public void cleanup() {
        this.executor.interrupt();
        this.delegate.cleanup();
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        this.delegate.declareOutputFields(declarer);
    }

    @Override
    public void finishedId(Object id) {
        if (this.callback != null) {
            this.callback.finishedId(id);
        }
    }

    @Override
    public Map<String, Object> getComponentConfiguration() {
        return new HashMap<String, Object>();
    }
}

