/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.worker;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.apache.storm.Constants;
import org.apache.storm.StormTimer;
import org.apache.storm.cluster.IStateStorage;
import org.apache.storm.cluster.IStormClusterState;
import org.apache.storm.cluster.VersionedData;
import org.apache.storm.daemon.StormCommon;
import org.apache.storm.daemon.supervisor.AdvancedFSOps;
import org.apache.storm.daemon.worker.BackPressureTracker;
import org.apache.storm.daemon.worker.WorkerTransfer;
import org.apache.storm.executor.IRunningExecutor;
import org.apache.storm.generated.Assignment;
import org.apache.storm.generated.Credentials;
import org.apache.storm.generated.DebugOptions;
import org.apache.storm.generated.Grouping;
import org.apache.storm.generated.InvalidTopologyException;
import org.apache.storm.generated.NodeInfo;
import org.apache.storm.generated.StormBase;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.generated.StreamInfo;
import org.apache.storm.generated.TopologyStatus;
import org.apache.storm.grouping.Load;
import org.apache.storm.grouping.LoadMapping;
import org.apache.storm.hooks.IWorkerHook;
import org.apache.storm.messaging.ConnectionWithStatus;
import org.apache.storm.messaging.DeserializingConnectionCallback;
import org.apache.storm.messaging.IConnection;
import org.apache.storm.messaging.IContext;
import org.apache.storm.messaging.TransportFactory;
import org.apache.storm.messaging.netty.BackPressureStatus;
import org.apache.storm.metrics2.StormMetricRegistry;
import org.apache.storm.policy.IWaitStrategy;
import org.apache.storm.security.auth.IAutoCredentials;
import org.apache.storm.serialization.ITupleSerializer;
import org.apache.storm.serialization.KryoTupleSerializer;
import org.apache.storm.shade.com.google.common.collect.ImmutableMap;
import org.apache.storm.shade.com.google.common.collect.Sets;
import org.apache.storm.task.WorkerTopologyContext;
import org.apache.storm.task.WorkerUserContext;
import org.apache.storm.tuple.AddressedTuple;
import org.apache.storm.tuple.Fields;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.JCQueue;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.SupervisorIfaceFactory;
import org.apache.storm.utils.ThriftTopologyUtils;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerState {
    private static final Logger LOG = LoggerFactory.getLogger(WorkerState.class);
    private static final long LOAD_REFRESH_INTERVAL_MS = 5000L;
    private static final int RESEND_BACKPRESSURE_SIZE = 10000;
    private static long dropCount = 0L;
    final Map<String, Object> conf;
    final IContext mqContext;
    final IConnection receiver;
    final String topologyId;
    final String assignmentId;
    private final Supplier<SupervisorIfaceFactory> supervisorIfaceSupplier;
    final int port;
    final String workerId;
    final IStateStorage stateStorage;
    final IStormClusterState stormClusterState;
    final CountDownLatch isWorkerActive;
    final AtomicBoolean isTopologyActive;
    final AtomicReference<Map<String, DebugOptions>> stormComponentToDebug;
    final Set<List<Long>> localExecutors;
    final ArrayList<Integer> localTaskIds;
    final Map<Integer, JCQueue> localReceiveQueues = new HashMap<Integer, JCQueue>();
    final Map<String, Object> topologyConf;
    final StormTopology topology;
    final StormTopology systemTopology;
    final Map<Integer, String> taskToComponent;
    final Map<String, Map<String, Fields>> componentToStreamToFields;
    final Map<String, List<Integer>> componentToSortedTasks;
    final ConcurrentMap<String, Long> blobToLastKnownVersion;
    final ReentrantReadWriteLock endpointSocketLock;
    final AtomicReference<Map<Integer, NodeInfo>> cachedTaskToNodePort;
    final AtomicReference<Map<String, String>> cachedNodeToHost;
    final AtomicReference<Map<NodeInfo, IConnection>> cachedNodeToPortSocket;
    final Map<List<Long>, JCQueue> executorReceiveQueueMap;
    final Map<Integer, JCQueue> taskToExecutorQueue;
    final Runnable suicideCallback;
    final Utils.UptimeComputer uptime;
    final Map<String, Object> defaultSharedResources;
    final Map<String, Object> userSharedResources;
    final LoadMapping loadMapping;
    final AtomicReference<Map<String, VersionedData<Assignment>>> assignmentVersions;
    final StormTimer heartbeatTimer = this.mkHaltingTimer("heartbeat-timer");
    final StormTimer refreshLoadTimer = this.mkHaltingTimer("refresh-load-timer");
    final StormTimer refreshConnectionsTimer = this.mkHaltingTimer("refresh-connections-timer");
    final StormTimer refreshCredentialsTimer = this.mkHaltingTimer("refresh-credentials-timer");
    final StormTimer checkForUpdatedBlobsTimer = this.mkHaltingTimer("check-for-updated-blobs-timer");
    final StormTimer resetLogLevelsTimer = this.mkHaltingTimer("reset-log-levels-timer");
    final StormTimer refreshActiveTimer = this.mkHaltingTimer("refresh-active-timer");
    final StormTimer executorHeartbeatTimer = this.mkHaltingTimer("executor-heartbeat-timer");
    final StormTimer flushTupleTimer = this.mkHaltingTimer("flush-tuple-timer");
    final StormTimer userTimer = this.mkHaltingTimer("user-timer");
    final StormTimer backPressureCheckTimer = this.mkHaltingTimer("backpressure-check-timer");
    private final WorkerTransfer workerTransfer;
    private final BackPressureTracker bpTracker;
    private final List<IWorkerHook> deserializedWorkerHooks;
    private final Set<Integer> outboundTasks;
    private final AtomicLong nextLoadUpdate = new AtomicLong(0L);
    private final boolean trySerializeLocal;
    private final Collection<IAutoCredentials> autoCredentials;
    private final AtomicReference<Credentials> credentialsAtom;
    private final StormMetricRegistry metricRegistry;

    public WorkerState(Map<String, Object> conf, IContext mqContext, String topologyId, String assignmentId, Supplier<SupervisorIfaceFactory> supervisorIfaceSupplier, int port, String workerId, Map<String, Object> topologyConf, IStateStorage stateStorage, IStormClusterState stormClusterState, Collection<IAutoCredentials> autoCredentials, StormMetricRegistry metricRegistry, Credentials initialCredentials) throws IOException, InvalidTopologyException {
        this.metricRegistry = metricRegistry;
        this.autoCredentials = autoCredentials;
        this.credentialsAtom = new AtomicReference<Credentials>(initialCredentials);
        this.conf = conf;
        this.supervisorIfaceSupplier = supervisorIfaceSupplier;
        this.mqContext = null != mqContext ? mqContext : TransportFactory.makeContext(topologyConf, metricRegistry);
        this.topologyId = topologyId;
        this.assignmentId = assignmentId;
        this.port = port;
        this.workerId = workerId;
        this.stateStorage = stateStorage;
        this.stormClusterState = stormClusterState;
        this.localExecutors = new HashSet<List<Long>>(this.readWorkerExecutors(assignmentId, port, this.getLocalAssignment(this.stormClusterState, topologyId)));
        this.isWorkerActive = new CountDownLatch(1);
        this.isTopologyActive = new AtomicBoolean(false);
        this.stormComponentToDebug = new AtomicReference();
        this.topology = ConfigUtils.readSupervisorTopology(conf, topologyId, AdvancedFSOps.make(conf));
        this.taskToComponent = StormCommon.stormTaskInfo(this.topology, topologyConf);
        this.executorReceiveQueueMap = this.mkReceiveQueueMap(topologyConf, this.localExecutors, this.taskToComponent);
        this.localTaskIds = new ArrayList();
        this.taskToExecutorQueue = new HashMap<Integer, JCQueue>();
        this.blobToLastKnownVersion = new ConcurrentHashMap<String, Long>();
        for (Map.Entry<List<Long>, JCQueue> entry : this.executorReceiveQueueMap.entrySet()) {
            List<Integer> taskIds = StormCommon.executorIdToTasks(entry.getKey());
            for (Integer n : taskIds) {
                this.taskToExecutorQueue.put(n, entry.getValue());
            }
            this.localTaskIds.addAll(taskIds);
        }
        Collections.sort(this.localTaskIds);
        this.topologyConf = topologyConf;
        this.systemTopology = StormCommon.systemTopology(topologyConf, this.topology);
        this.componentToStreamToFields = new HashMap<String, Map<String, Fields>>();
        for (String c : ThriftTopologyUtils.getComponentIds(this.systemTopology)) {
            HashMap<String, Fields> streamToFields = new HashMap<String, Fields>();
            for (Map.Entry entry : ThriftTopologyUtils.getComponentCommon(this.systemTopology, c).get_streams().entrySet()) {
                streamToFields.put((String)entry.getKey(), new Fields(((StreamInfo)entry.getValue()).get_output_fields()));
            }
            this.componentToStreamToFields.put(c, streamToFields);
        }
        this.componentToSortedTasks = Utils.reverseMap(this.taskToComponent);
        this.componentToSortedTasks.values().forEach(Collections::sort);
        this.endpointSocketLock = new ReentrantReadWriteLock();
        this.cachedNodeToPortSocket = new AtomicReference(new HashMap());
        this.cachedTaskToNodePort = new AtomicReference(new HashMap());
        this.cachedNodeToHost = new AtomicReference(new HashMap());
        this.suicideCallback = Utils.mkSuicideFn();
        this.uptime = Utils.makeUptimeComputer();
        this.defaultSharedResources = this.makeDefaultResources();
        this.userSharedResources = this.makeUserResources();
        this.loadMapping = new LoadMapping();
        this.assignmentVersions = new AtomicReference(new HashMap());
        this.outboundTasks = this.workerOutboundTasks();
        boolean bl = this.trySerializeLocal = topologyConf.containsKey("topology.testing.always.try.serialize") && (Boolean)topologyConf.get("topology.testing.always.try.serialize") != false;
        if (this.trySerializeLocal) {
            LOG.warn("WILL TRY TO SERIALIZE ALL TUPLES (Turn off {} for production", (Object)"topology.testing.always.try.serialize");
        }
        int maxTaskId = WorkerState.getMaxTaskId(this.componentToSortedTasks);
        this.workerTransfer = new WorkerTransfer(this, topologyConf, maxTaskId);
        this.bpTracker = new BackPressureTracker(workerId, this.taskToExecutorQueue, metricRegistry, this.taskToComponent);
        this.deserializedWorkerHooks = this.deserializeWorkerHooks();
        LOG.info("Registering IConnectionCallbacks for {}:{}", (Object)assignmentId, (Object)port);
        DeserializingConnectionCallback cb = new DeserializingConnectionCallback(topologyConf, this.getWorkerTopologyContext(), this::transferLocalBatch);
        Supplier<Object> newConnectionResponse = () -> {
            BackPressureStatus bpStatus = this.bpTracker.getCurrStatus();
            LOG.info("Sending BackPressure status to new client. BPStatus: {}", (Object)bpStatus);
            return bpStatus;
        };
        this.receiver = this.mqContext.bind(topologyId, port, cb, newConnectionResponse);
    }

    public static boolean isConnectionReady(IConnection connection) {
        return !(connection instanceof ConnectionWithStatus) || ((ConnectionWithStatus)connection).status() == ConnectionWithStatus.Status.Ready;
    }

    private static int getMaxTaskId(Map<String, List<Integer>> componentToSortedTasks) {
        int maxTaskId = -1;
        for (List<Integer> integers : componentToSortedTasks.values()) {
            int tempMax;
            if (integers.isEmpty() || (tempMax = ((Integer)integers.stream().max(Integer::compareTo).get()).intValue()) <= maxTaskId) continue;
            maxTaskId = tempMax;
        }
        return maxTaskId;
    }

    public List<IWorkerHook> getDeserializedWorkerHooks() {
        return this.deserializedWorkerHooks;
    }

    public Map<String, Object> getConf() {
        return this.conf;
    }

    public IConnection getReceiver() {
        return this.receiver;
    }

    public String getTopologyId() {
        return this.topologyId;
    }

    public int getPort() {
        return this.port;
    }

    public String getWorkerId() {
        return this.workerId;
    }

    public IStateStorage getStateStorage() {
        return this.stateStorage;
    }

    public CountDownLatch getIsWorkerActive() {
        return this.isWorkerActive;
    }

    public AtomicBoolean getIsTopologyActive() {
        return this.isTopologyActive;
    }

    public AtomicReference<Map<String, DebugOptions>> getStormComponentToDebug() {
        return this.stormComponentToDebug;
    }

    public Set<List<Long>> getLocalExecutors() {
        return this.localExecutors;
    }

    public List<Integer> getLocalTaskIds() {
        return this.localTaskIds;
    }

    public Map<Integer, JCQueue> getLocalReceiveQueues() {
        return this.localReceiveQueues;
    }

    public Map<String, Object> getTopologyConf() {
        return this.topologyConf;
    }

    public StormTopology getTopology() {
        return this.topology;
    }

    public StormTopology getSystemTopology() {
        return this.systemTopology;
    }

    public Map<Integer, String> getTaskToComponent() {
        return this.taskToComponent;
    }

    public Map<String, Map<String, Fields>> getComponentToStreamToFields() {
        return this.componentToStreamToFields;
    }

    public Map<String, List<Integer>> getComponentToSortedTasks() {
        return this.componentToSortedTasks;
    }

    public Map<String, Long> getBlobToLastKnownVersion() {
        return this.blobToLastKnownVersion;
    }

    public AtomicReference<Map<NodeInfo, IConnection>> getCachedNodeToPortSocket() {
        return this.cachedNodeToPortSocket;
    }

    public Map<List<Long>, JCQueue> getExecutorReceiveQueueMap() {
        return this.executorReceiveQueueMap;
    }

    public Runnable getSuicideCallback() {
        return this.suicideCallback;
    }

    public Utils.UptimeComputer getUptime() {
        return this.uptime;
    }

    public Map<String, Object> getDefaultSharedResources() {
        return this.defaultSharedResources;
    }

    public Map<String, Object> getUserSharedResources() {
        return this.userSharedResources;
    }

    public LoadMapping getLoadMapping() {
        return this.loadMapping;
    }

    public AtomicReference<Map<String, VersionedData<Assignment>>> getAssignmentVersions() {
        return this.assignmentVersions;
    }

    public StormTimer getUserTimer() {
        return this.userTimer;
    }

    public Utils.SmartThread makeTransferThread() {
        return this.workerTransfer.makeTransferThread();
    }

    public void suicideIfLocalAssignmentsChanged(Assignment assignment) {
        boolean shouldHalt = false;
        if (assignment != null) {
            HashSet<List<Long>> assignedExecutors = new HashSet<List<Long>>(this.readWorkerExecutors(this.assignmentId, this.port, assignment));
            if (!this.localExecutors.equals(assignedExecutors)) {
                LOG.info("Found conflicting assignments. We shouldn't be alive! Assigned: " + String.valueOf(assignedExecutors) + ", Current: " + String.valueOf(this.localExecutors));
                shouldHalt = true;
            }
        } else {
            LOG.info("Assigment is null. We should not be alive!");
            shouldHalt = true;
        }
        if (shouldHalt) {
            if (!ConfigUtils.isLocalMode(this.conf)) {
                this.suicideCallback.run();
            } else {
                LOG.info("Local worker tried to commit suicide!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshConnections() {
        Assignment assignment = null;
        try {
            assignment = this.getLocalAssignment(this.stormClusterState, this.topologyId);
        }
        catch (Exception e) {
            LOG.warn("Failed to read assignment. This should only happen when topology is shutting down.", (Throwable)e);
        }
        this.suicideIfLocalAssignmentsChanged(assignment);
        HashSet<NodeInfo> neededConnections = new HashSet<NodeInfo>();
        HashMap<Integer, NodeInfo> newTaskToNodePort = new HashMap<Integer, NodeInfo>();
        if (null != assignment) {
            Map<Integer, NodeInfo> taskToNodePort = StormCommon.taskToNodeport(assignment.get_executor_node_port());
            for (Map.Entry<Integer, NodeInfo> taskToNodePortEntry : taskToNodePort.entrySet()) {
                Integer task = taskToNodePortEntry.getKey();
                if (!this.outboundTasks.contains(task)) continue;
                newTaskToNodePort.put(task, taskToNodePortEntry.getValue());
                if (this.localTaskIds.contains(task)) continue;
                neededConnections.add(taskToNodePortEntry.getValue());
            }
        }
        Set<NodeInfo> currentConnections = this.cachedNodeToPortSocket.get().keySet();
        Sets.SetView newConnections = Sets.difference(neededConnections, currentConnections);
        Sets.SetView removeConnections = Sets.difference(currentConnections, neededConnections);
        Map<String, String> nodeHost = assignment != null ? assignment.get_node_host() : null;
        this.cachedNodeToPortSocket.getAndUpdate(arg_0 -> this.lambda$refreshConnections$1((Set)newConnections, nodeHost, arg_0));
        try {
            this.endpointSocketLock.writeLock().lock();
            this.cachedTaskToNodePort.set(newTaskToNodePort);
        }
        finally {
            this.endpointSocketLock.writeLock().unlock();
        }
        if (nodeHost != null) {
            this.cachedNodeToHost.set(nodeHost);
        } else {
            this.cachedNodeToHost.set(new HashMap());
        }
        for (NodeInfo nodeInfo : removeConnections) {
            this.cachedNodeToPortSocket.get().get(nodeInfo).close();
        }
        this.cachedNodeToPortSocket.getAndUpdate(arg_0 -> WorkerState.lambda$refreshConnections$2((Set)removeConnections, arg_0));
    }

    public void refreshStormActive() {
        this.refreshStormActive(() -> this.refreshActiveTimer.schedule(0, this::refreshStormActive));
    }

    public void refreshStormActive(Runnable callback) {
        StormBase base = this.stormClusterState.stormBase(this.topologyId, callback);
        this.isTopologyActive.set(null != base && base.get_status() == TopologyStatus.ACTIVE);
        if (null != base) {
            HashMap<String, DebugOptions> debugOptionsMap = new HashMap<String, DebugOptions>(base.get_component_debug());
            for (DebugOptions debugOptions : debugOptionsMap.values()) {
                if (!debugOptions.is_set_samplingpct()) {
                    debugOptions.set_samplingpct(10.0);
                }
                if (debugOptions.is_set_enable()) continue;
                debugOptions.set_enable(false);
            }
            this.stormComponentToDebug.set(debugOptionsMap);
            LOG.debug("Events debug options {}", this.stormComponentToDebug.get());
        }
    }

    public void refreshLoad(List<IRunningExecutor> execs) {
        Sets.SetView remoteTasks = Sets.difference(new HashSet<Integer>(this.outboundTasks), new HashSet<Integer>(this.localTaskIds));
        HashMap<Integer, Double> localLoad = new HashMap<Integer, Double>();
        for (IRunningExecutor exec : execs) {
            double receiveLoad = exec.getReceiveQueue().getQueueLoad();
            localLoad.put(exec.getExecutorId().get(0).intValue(), receiveLoad);
        }
        HashMap<Integer, Load> remoteLoad = new HashMap<Integer, Load>();
        this.cachedNodeToPortSocket.get().values().stream().forEach(arg_0 -> WorkerState.lambda$refreshLoad$4(remoteLoad, (Set)remoteTasks, arg_0));
        this.loadMapping.setLocal(localLoad);
        this.loadMapping.setRemote(remoteLoad);
        Long now = System.currentTimeMillis();
        if (now > this.nextLoadUpdate.get()) {
            this.receiver.sendLoadMetrics(localLoad);
            this.nextLoadUpdate.set(now + 5000L);
        }
    }

    public void refreshBackPressureStatus() {
        LOG.debug("Checking for change in Backpressure status on worker's tasks");
        boolean bpSituationChanged = this.bpTracker.refreshBpTaskList();
        if (bpSituationChanged) {
            BackPressureStatus bpStatus = this.bpTracker.getCurrStatus();
            this.receiver.sendBackPressureStatus(bpStatus);
        }
    }

    public void activateWorkerWhenAllConnectionsReady() {
        int delaySecs = 0;
        int recurSecs = 1;
        this.refreshActiveTimer.schedule(delaySecs, () -> {
            if (this.areAllConnectionsReady()) {
                LOG.info("All connections are ready for worker {}:{} with id {}", new Object[]{this.assignmentId, this.port, this.workerId});
                this.isWorkerActive.countDown();
            } else {
                this.refreshActiveTimer.schedule(recurSecs, () -> this.activateWorkerWhenAllConnectionsReady(), false, 0);
            }
        });
    }

    public boolean tryTransferRemote(AddressedTuple tuple, Queue<AddressedTuple> pendingEmits, ITupleSerializer serializer) {
        return this.workerTransfer.tryTransferRemote(tuple, pendingEmits, serializer);
    }

    public void flushRemotes() throws InterruptedException {
        this.workerTransfer.flushRemotes();
    }

    public boolean tryFlushRemotes() {
        return this.workerTransfer.tryFlushRemotes();
    }

    private void transferLocalBatch(ArrayList<AddressedTuple> tupleBatch) {
        for (int i = 0; i < tupleBatch.size(); ++i) {
            AddressedTuple tuple = tupleBatch.get(i);
            JCQueue queue = this.taskToExecutorQueue.get(tuple.dest);
            if (queue.isEmptyOverflow() && queue.tryPublish(tuple)) continue;
            int currOverflowCount = queue.getOverflowCount();
            BackPressureTracker.BackpressureState bpState = this.bpTracker.getBackpressureState(tuple.dest);
            if (this.bpTracker.recordBackPressure(bpState)) {
                this.receiver.sendBackPressureStatus(this.bpTracker.getCurrStatus());
                this.bpTracker.setLastOverflowCount(bpState, currOverflowCount);
            } else if (currOverflowCount - this.bpTracker.getLastOverflowCount(bpState) > 10000) {
                BackPressureStatus bpStatus = this.bpTracker.getCurrStatus();
                this.receiver.sendBackPressureStatus(bpStatus);
                this.bpTracker.setLastOverflowCount(bpState, currOverflowCount);
                LOG.debug("Re-sent BackPressure Status. OverflowCount = {}, BP Status ID = {}. ", (Object)currOverflowCount, (Object)bpStatus.id);
            }
            if (queue.tryPublishToOverflow(tuple)) continue;
            this.dropMessage(tuple, queue);
        }
    }

    private void dropMessage(AddressedTuple tuple, JCQueue queue) {
        queue.recordMsgDrop();
        LOG.warn("Dropping message as overflow threshold has reached for Q = {}. OverflowCount = {}. Total Drop Count= {}, Dropped Message : {}", new Object[]{queue.getQueueName(), queue.getOverflowCount(), ++dropCount, tuple});
    }

    public void checkSerialize(KryoTupleSerializer serializer, AddressedTuple tuple) {
        if (this.trySerializeLocal) {
            serializer.serialize(tuple.getTuple());
        }
    }

    public final WorkerTopologyContext getWorkerTopologyContext() {
        try {
            String codeDir = ConfigUtils.supervisorStormResourcesPath(ConfigUtils.supervisorStormDistRoot(this.conf, this.topologyId));
            String pidDir = ConfigUtils.workerPidsRoot(this.conf, this.topologyId);
            return new WorkerTopologyContext(this.systemTopology, this.topologyConf, this.taskToComponent, this.componentToSortedTasks, this.componentToStreamToFields, this.topologyId, codeDir, pidDir, this.port, this.localTaskIds, this.defaultSharedResources, this.userSharedResources, this.cachedTaskToNodePort, this.assignmentId, this.cachedNodeToHost);
        }
        catch (IOException e) {
            throw Utils.wrapInRuntime(e);
        }
    }

    public final WorkerUserContext getWorkerUserContext() {
        try {
            String codeDir = ConfigUtils.supervisorStormResourcesPath(ConfigUtils.supervisorStormDistRoot(this.conf, this.topologyId));
            String pidDir = ConfigUtils.workerPidsRoot(this.conf, this.topologyId);
            return new WorkerUserContext(this.systemTopology, this.topologyConf, this.taskToComponent, this.componentToSortedTasks, this.componentToStreamToFields, this.topologyId, codeDir, pidDir, this.port, this.localTaskIds, this.defaultSharedResources, this.userSharedResources, this.cachedTaskToNodePort, this.assignmentId, this.cachedNodeToHost);
        }
        catch (IOException e) {
            throw Utils.wrapInRuntime(e);
        }
    }

    private List<IWorkerHook> deserializeWorkerHooks() {
        ArrayList<IWorkerHook> myHookList = new ArrayList<IWorkerHook>();
        if (this.topology.is_set_worker_hooks()) {
            for (ByteBuffer hook : this.topology.get_worker_hooks()) {
                byte[] hookBytes = Utils.toByteArray(hook);
                IWorkerHook hookObject = Utils.javaDeserialize(hookBytes, IWorkerHook.class);
                myHookList.add(hookObject);
            }
        }
        return myHookList;
    }

    public void runWorkerStartHooks() {
        WorkerUserContext workerUserContext = this.getWorkerUserContext();
        for (IWorkerHook hook : this.getDeserializedWorkerHooks()) {
            hook.start(this.topologyConf, workerUserContext);
        }
    }

    public void runWorkerShutdownHooks() {
        for (IWorkerHook hook : this.getDeserializedWorkerHooks()) {
            hook.shutdown();
        }
    }

    public void closeResources() {
        LOG.info("Shutting down default resources");
        ((ExecutorService)this.defaultSharedResources.get("executor")).shutdownNow();
        LOG.info("Shut down default resources");
    }

    public boolean areAllConnectionsReady() {
        return this.cachedNodeToPortSocket.get().values().stream().map(WorkerState::isConnectionReady).reduce((left, right) -> left != false && right != false).orElse(true);
    }

    public Collection<IAutoCredentials> getAutoCredentials() {
        return this.autoCredentials;
    }

    public Credentials getCredentials() {
        return this.credentialsAtom.get();
    }

    public void setCredentials(Credentials credentials) {
        this.credentialsAtom.set(credentials);
    }

    private List<List<Long>> readWorkerExecutors(String assignmentId, int port, Assignment assignment) {
        ArrayList<List<Long>> executorsAssignedToThisWorker = new ArrayList<List<Long>>();
        executorsAssignedToThisWorker.add(Constants.SYSTEM_EXECUTOR_ID);
        Map<List<Long>, NodeInfo> executorToNodePort = assignment.get_executor_node_port();
        for (Map.Entry<List<Long>, NodeInfo> entry : executorToNodePort.entrySet()) {
            NodeInfo nodeInfo = entry.getValue();
            if (!nodeInfo.get_node().equals(assignmentId) || nodeInfo.get_port().iterator().next() != (long)port) continue;
            executorsAssignedToThisWorker.add(entry.getKey());
        }
        return executorsAssignedToThisWorker;
    }

    private Assignment getLocalAssignment(IStormClusterState stormClusterState, String topologyId) {
        SupervisorIfaceFactory fac = this.supervisorIfaceSupplier.get();
        try {
            Assignment assignment = fac.getIface().getLocalAssignmentForStorm(topologyId);
            if (fac != null) {
                fac.close();
            }
            return assignment;
        }
        catch (Throwable throwable) {
            try {
                if (fac != null) {
                    try {
                        fac.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                Assignment assignment = stormClusterState.remoteAssignmentInfo(topologyId, null);
                if (assignment == null) {
                    throw new RuntimeException("Failed to read worker assignment. Supervisor client threw exception, and assignment in Zookeeper was null", e);
                }
                return assignment;
            }
        }
    }

    private Map<List<Long>, JCQueue> mkReceiveQueueMap(Map<String, Object> topologyConf, Set<List<Long>> executors, Map<Integer, String> taskToComponent) {
        Integer recvQueueSize = ObjectReader.getInt(topologyConf.get("topology.executor.receive.buffer.size"));
        Integer recvBatchSize = ObjectReader.getInt(topologyConf.get("topology.producer.batch.size"));
        Integer overflowLimit = ObjectReader.getInt(topologyConf.get("topology.executor.overflow.limit"));
        if (recvBatchSize > recvQueueSize / 2) {
            throw new IllegalArgumentException("topology.producer.batch.size:" + recvBatchSize + " is greater than half of topology.executor.receive.buffer.size:" + recvQueueSize);
        }
        IWaitStrategy backPressureWaitStrategy = IWaitStrategy.createBackPressureWaitStrategy(topologyConf);
        HashMap<List<Long>, JCQueue> receiveQueueMap = new HashMap<List<Long>, JCQueue>();
        for (List<Long> executor : executors) {
            List<Integer> taskIds = StormCommon.executorIdToTasks(executor);
            int taskId = taskIds.get(0);
            String compId = (long)taskId == -1L ? "__system" : taskToComponent.get(taskId);
            receiveQueueMap.put(executor, new JCQueue("receive-queue" + executor.toString(), "receive-queue", recvQueueSize, overflowLimit, recvBatchSize, backPressureWaitStrategy, this.getTopologyId(), compId, taskIds, this.getPort(), this.metricRegistry));
        }
        return receiveQueueMap;
    }

    private Map<String, Object> makeDefaultResources() {
        int threadPoolSize = ObjectReader.getInt(this.conf.get("topology.worker.shared.thread.pool.size"));
        return ImmutableMap.of((Object)"executor", (Object)Executors.newFixedThreadPool(threadPoolSize));
    }

    private Map<String, Object> makeUserResources() {
        return new HashMap<String, Object>();
    }

    private StormTimer mkHaltingTimer(String name) {
        return new StormTimer(name, (thread, exception) -> {
            LOG.error("Error when processing event", exception);
            Utils.exitProcess(20, "Error when processing an event");
        });
    }

    private Set<Integer> workerOutboundTasks() {
        WorkerTopologyContext context = this.getWorkerTopologyContext();
        HashSet<String> components = new HashSet<String>();
        for (Integer taskId : this.localTaskIds) {
            for (Map<String, Grouping> value : context.getTargets(context.getComponentId(taskId)).values()) {
                components.addAll(value.keySet());
            }
        }
        HashSet<Integer> outboundTasks = new HashSet<Integer>();
        for (Map.Entry<String, List<Integer>> entry : Utils.reverseMap(this.taskToComponent).entrySet()) {
            if (!components.contains(entry.getKey())) continue;
            outboundTasks.addAll((Collection<Integer>)entry.getValue());
        }
        return outboundTasks;
    }

    public Set<Integer> getOutboundTasks() {
        return this.outboundTasks;
    }

    public boolean hasRemoteOutboundTasks() {
        Sets.SetView remoteTasks = Sets.difference(new HashSet<Integer>(this.outboundTasks), new HashSet<Integer>(this.localTaskIds));
        return !remoteTasks.isEmpty();
    }

    public boolean isSingleWorker() {
        Sets.SetView nonLocalTasks = Sets.difference(this.getTaskToComponent().keySet(), new HashSet<Integer>(this.localTaskIds));
        return nonLocalTasks.isEmpty();
    }

    public void haltWorkerTransfer() {
        this.workerTransfer.haltTransferThd();
    }

    public JCQueue getTransferQueue() {
        return this.workerTransfer.getTransferQueue();
    }

    public StormMetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    private static /* synthetic */ void lambda$refreshLoad$4(Map remoteLoad, Set remoteTasks, IConnection conn) {
        remoteLoad.putAll(conn.getLoad(remoteTasks));
    }

    private static /* synthetic */ Map lambda$refreshConnections$2(Set removeConnections, Map prev) {
        HashMap next = new HashMap(prev);
        removeConnections.forEach(next::remove);
        return next;
    }

    private /* synthetic */ Map lambda$refreshConnections$1(Set newConnections, Map nodeHost, Map prev) {
        HashMap<NodeInfo, IConnection> next = new HashMap<NodeInfo, IConnection>(prev);
        for (NodeInfo nodeInfo : newConnections) {
            next.put(nodeInfo, this.mqContext.connect(this.topologyId, (String)nodeHost.get(nodeInfo.get_node()), nodeInfo.get_port().iterator().next().intValue(), this.workerTransfer.getRemoteBackPressureStatus()));
        }
        return next;
    }

    public static interface ILocalTransferCallback {
        public void transfer(ArrayList<AddressedTuple> var1);
    }
}

