/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.topology;

import java.util.List;
import java.util.Map;
import org.apache.storm.spout.CheckPointState;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.BaseStatefulBoltExecutor;
import org.apache.storm.topology.IRichBolt;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.tuple.Values;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckpointTupleForwarder
extends BaseStatefulBoltExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(CheckpointTupleForwarder.class);
    private final IRichBolt bolt;

    public CheckpointTupleForwarder(IRichBolt bolt) {
        this.bolt = bolt;
    }

    @Override
    public void prepare(Map<String, Object> topoConf, TopologyContext context, OutputCollector outputCollector) {
        this.init(context, new BaseStatefulBoltExecutor.AnchoringOutputCollector(outputCollector));
        this.bolt.prepare(topoConf, context, this.collector);
    }

    @Override
    public void cleanup() {
        this.bolt.cleanup();
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        this.bolt.declareOutputFields(declarer);
        this.declareCheckpointStream(declarer);
    }

    @Override
    public Map<String, Object> getComponentConfiguration() {
        return this.bolt.getComponentConfiguration();
    }

    @Override
    protected void handleCheckpoint(Tuple checkpointTuple, CheckPointState.Action action, long txid) {
        this.collector.emit("$checkpoint", checkpointTuple, (List<Object>)new Values(new Object[]{txid, action}));
        this.collector.ack(checkpointTuple);
    }

    @Override
    protected void handleTuple(Tuple input) {
        this.bolt.execute(input);
    }
}

