/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.internal;

import java.io.Serializable;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.OptionalConfigEntry;
import org.apache.spark.sql.connector.catalog.CatalogManager$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.util.Utils$;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class StaticSQLConf$ {
    public static final StaticSQLConf$ MODULE$ = new StaticSQLConf$();
    private static final ConfigEntry<String> WAREHOUSE_PATH = SQLConf$.MODULE$.buildStaticConf("spark.sql.warehouse.dir").doc("The default location for managed databases and tables.").version("2.0.0").stringConf().createWithDefault((Object)Utils$.MODULE$.resolveURI("spark-warehouse").toString());
    private static final ConfigEntry<String> CATALOG_DEFAULT_DATABASE = SQLConf$.MODULE$.buildStaticConf("spark.sql.catalog." + CatalogManager$.MODULE$.SESSION_CATALOG_NAME() + ".defaultDatabase").doc("The default database for session catalog.").version("3.4.0").stringConf().createWithDefault((Object)"default");
    private static final ConfigEntry<String> CATALOG_IMPLEMENTATION = SQLConf$.MODULE$.buildStaticConf("spark.sql.catalogImplementation").internal().version("2.0.0").stringConf().checkValues((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hive", "in-memory"}))).createWithDefault((Object)"in-memory");
    private static final ConfigEntry<String> GLOBAL_TEMP_DATABASE = SQLConf$.MODULE$.buildStaticConf("spark.sql.globalTempDatabase").internal().version("2.1.0").stringConf().transform((Function1 & Serializable)x$1 -> x$1.toLowerCase(Locale.ROOT)).createWithDefault((Object)"global_temp");
    private static final ConfigEntry<Object> SCHEMA_STRING_LENGTH_THRESHOLD = SQLConf$.MODULE$.buildStaticConf("spark.sql.sources.schemaStringLengthThreshold").internal().doc("The maximum length allowed in a single cell when storing additional schema information in Hive's metastore.").version("1.3.1").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)4000));
    private static final ConfigEntry<Object> FILESOURCE_TABLE_RELATION_CACHE_SIZE = SQLConf$.MODULE$.buildStaticConf("spark.sql.filesourceTableRelationCacheSize").internal().doc("The maximum size of the cache that maps qualified table names to table relation plans.").version("2.2.0").intConf().checkValue((Function1)(JFunction1.mcZI.sp & Serializable)cacheSize -> cacheSize >= 0, "The maximum size of the cache must not be negative").createWithDefault((Object)BoxesRunTime.boxToInteger((int)1000));
    private static final ConfigEntry<Object> CODEGEN_CACHE_MAX_ENTRIES = SQLConf$.MODULE$.buildStaticConf("spark.sql.codegen.cache.maxEntries").internal().doc("When nonzero, enable caching of generated classes for operators and expressions. All jobs share the cache that can use up to the specified number for generated classes.").version("2.4.0").intConf().checkValue((Function1)(JFunction1.mcZI.sp & Serializable)maxEntries -> maxEntries >= 0, "The maximum must not be negative").createWithDefault((Object)BoxesRunTime.boxToInteger((int)100));
    private static final ConfigEntry<Object> CODEGEN_COMMENTS = SQLConf$.MODULE$.buildStaticConf("spark.sql.codegen.comments").internal().doc("When true, put comment in the generated code. Since computing huge comments can be extremely expensive in certain cases, such as deeply-nested expressions which operate over inputs with wide schemas, default is false.").version("2.0.0").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
    private static final ConfigEntry<Object> DEBUG_MODE = SQLConf$.MODULE$.buildStaticConf("spark.sql.debug").internal().doc("Only used for internal debugging. Not all functions are supported when it is enabled.").version("2.1.0").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
    private static final ConfigEntry<Object> HIVE_THRIFT_SERVER_SINGLESESSION = SQLConf$.MODULE$.buildStaticConf("spark.sql.hive.thriftServer.singleSession").doc("When set to true, Hive Thrift server is running in a single session mode. All the JDBC/ODBC connections share the temporary views, function registries, SQL configuration and the current database.").version("1.6.0").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
    private static final OptionalConfigEntry<Seq<String>> SPARK_SESSION_EXTENSIONS = SQLConf$.MODULE$.buildStaticConf("spark.sql.extensions").doc("A comma-separated list of classes that implement Function1[SparkSessionExtensions, Unit] used to configure Spark Session extensions. The classes must have a no-args constructor. If multiple extensions are specified, they are applied in the specified order. For the case of rules and planner strategies, they are applied in the specified order. For the case of parsers, the last parser is used and each parser can delegate to its predecessor. For the case of function name conflicts, the last registered function name is used.").version("2.2.0").stringConf().toSequence().createOptional();
    private static final ConfigEntry<Object> LOAD_SESSION_EXTENSIONS_FROM_CLASSPATH = SQLConf$.MODULE$.buildStaticConf("spark.sql.extensions.test.loadFromCp").doc("Flag that determines if we should load extensions from the classpath using the SparkSessionExtensionsProvider mechanism. This is a test only flag.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
    private static final ConfigEntry<String> SPARK_CACHE_SERIALIZER = SQLConf$.MODULE$.buildStaticConf("spark.sql.cache.serializer").doc("The name of a class that implements org.apache.spark.sql.columnar.CachedBatchSerializer. It will be used to translate SQL data into a format that can more efficiently be cached. The underlying API is subject to change so use with caution. Multiple classes cannot be specified. The class must have a no-arg constructor.").version("3.1.0").stringConf().createWithDefault((Object)"org.apache.spark.sql.execution.columnar.DefaultCachedBatchSerializer");
    private static final OptionalConfigEntry<Seq<String>> QUERY_EXECUTION_LISTENERS = SQLConf$.MODULE$.buildStaticConf("spark.sql.queryExecutionListeners").doc("List of class names implementing QueryExecutionListener that will be automatically added to newly created sessions. The classes should have either a no-arg constructor, or a constructor that expects a SparkConf argument.").version("2.3.0").stringConf().toSequence().createOptional();
    private static final OptionalConfigEntry<Seq<String>> STREAMING_QUERY_LISTENERS = SQLConf$.MODULE$.buildStaticConf("spark.sql.streaming.streamingQueryListeners").doc("List of class names implementing StreamingQueryListener that will be automatically added to newly created sessions. The classes should have either a no-arg constructor, or a constructor that expects a SparkConf argument.").version("2.4.0").stringConf().toSequence().createOptional();
    private static final ConfigEntry<Object> UI_RETAINED_EXECUTIONS = SQLConf$.MODULE$.buildStaticConf("spark.sql.ui.retainedExecutions").doc("Number of executions to retain in the Spark UI.").version("1.5.0").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)1000));
    private static final ConfigEntry<Object> SHUFFLE_EXCHANGE_MAX_THREAD_THRESHOLD = SQLConf$.MODULE$.buildStaticConf("spark.sql.shuffleExchange.maxThreadThreshold").internal().doc("The maximum degree of parallelism for doing preparation of shuffle exchange, which includes subquery execution, file listing, etc.").version("4.0.0").intConf().checkValue((Function1)(JFunction1.mcZI.sp & Serializable)thres -> thres > 0 && thres <= 1024, "The threshold must be in (0,1024].").createWithDefault((Object)BoxesRunTime.boxToInteger((int)1024));
    private static final ConfigEntry<Object> BROADCAST_EXCHANGE_MAX_THREAD_THRESHOLD = SQLConf$.MODULE$.buildStaticConf("spark.sql.broadcastExchange.maxThreadThreshold").internal().doc("The maximum degree of parallelism to fetch and broadcast the table. If we encounter memory issue like frequently full GC or OOM when broadcast table we can decrease this number in order to reduce memory usage. Notice the number should be carefully chosen since decreasing parallelism might cause longer waiting for other broadcasting. Also, increasing parallelism may cause memory problem.").version("3.0.0").intConf().checkValue((Function1)(JFunction1.mcZI.sp & Serializable)thres -> thres > 0 && thres <= 128, "The threshold must be in (0,128].").createWithDefault((Object)BoxesRunTime.boxToInteger((int)128));
    private static final ConfigEntry<Object> SUBQUERY_MAX_THREAD_THRESHOLD = SQLConf$.MODULE$.buildStaticConf("spark.sql.subquery.maxThreadThreshold").internal().doc("The maximum degree of parallelism to execute the subquery.").version("2.4.6").intConf().checkValue((Function1)(JFunction1.mcZI.sp & Serializable)thres -> thres > 0 && thres <= 128, "The threshold must be in (0,128].").createWithDefault((Object)BoxesRunTime.boxToInteger((int)16));
    private static final ConfigEntry<Object> RESULT_QUERY_STAGE_MAX_THREAD_THRESHOLD = SQLConf$.MODULE$.buildStaticConf("spark.sql.resultQueryStage.maxThreadThreshold").internal().doc("The maximum degree of parallelism to execute ResultQueryStageExec in AQE").version("4.0.0").intConf().checkValue((Function1)(JFunction1.mcZI.sp & Serializable)thres -> thres > 0 && thres <= 1024, "The threshold must be in (0,1024].").createWithDefault((Object)BoxesRunTime.boxToInteger((int)1024));
    private static final ConfigEntry<Object> SQL_EVENT_TRUNCATE_LENGTH = SQLConf$.MODULE$.buildStaticConf("spark.sql.event.truncate.length").doc("Threshold of SQL length beyond which it will be truncated before adding to event. Defaults to no truncation. If set to 0, callsite will be logged instead.").version("3.0.0").intConf().checkValue((Function1)(JFunction1.mcZI.sp & Serializable)x$2 -> x$2 >= 0, "Must be set greater or equal to zero").createWithDefault((Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE));
    private static final ConfigEntry<Object> SQL_LEGACY_SESSION_INIT_WITH_DEFAULTS = SQLConf$.MODULE$.buildStaticConf("spark.sql.legacy.sessionInitWithConfigDefaults").internal().doc("Flag to revert to legacy behavior where a cloned SparkSession receives SparkConf defaults, dropping any overrides in its parent SparkSession.").version("3.0.0").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
    private static final ConfigEntry<Object> DEFAULT_URL_STREAM_HANDLER_FACTORY_ENABLED = SQLConf$.MODULE$.buildStaticConf("spark.sql.defaultUrlStreamHandlerFactory.enabled").internal().doc("When true, register Hadoop's FsUrlStreamHandlerFactory to support ADD JAR against HDFS locations. It should be disabled when a different stream protocol handler should be registered to support a particular protocol type, or if Hadoop's FsUrlStreamHandlerFactory conflicts with other protocol types such as `http` or `https`. See also SPARK-25694 and HADOOP-14598.").version("3.0.0").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
    private static final ConfigEntry<Object> STREAMING_UI_ENABLED = SQLConf$.MODULE$.buildStaticConf("spark.sql.streaming.ui.enabled").doc("Whether to run the Structured Streaming Web UI for the Spark application when the Spark Web UI is enabled.").version("3.0.0").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
    private static final ConfigEntry<Object> STREAMING_UI_RETAINED_PROGRESS_UPDATES = SQLConf$.MODULE$.buildStaticConf("spark.sql.streaming.ui.retainedProgressUpdates").doc("The number of progress updates to retain for a streaming query for Structured Streaming UI.").version("3.0.0").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)100));
    private static final ConfigEntry<Object> STREAMING_UI_RETAINED_QUERIES = SQLConf$.MODULE$.buildStaticConf("spark.sql.streaming.ui.retainedQueries").doc("The number of inactive queries to retain for Structured Streaming UI.").version("3.0.0").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)100));
    private static final ConfigEntry<Object> METADATA_CACHE_TTL_SECONDS = SQLConf$.MODULE$.buildStaticConf("spark.sql.metadataCacheTTLSeconds").doc("Time-to-live (TTL) value for the metadata caches: partition file metadata cache and session catalog cache. This configuration only has an effect when this value having a positive value (> 0). It also requires setting '" + MODULE$.CATALOG_IMPLEMENTATION().key() + "' to `hive`, setting '" + SQLConf$.MODULE$.HIVE_FILESOURCE_PARTITION_FILE_CACHE_SIZE().key() + "' > 0 and setting '" + SQLConf$.MODULE$.HIVE_MANAGE_FILESOURCE_PARTITIONS().key() + "' to `true` to be applied to the partition file metadata cache.").version("3.1.0").timeConf(TimeUnit.SECONDS).createWithDefault((Object)BoxesRunTime.boxToLong((long)-1L));
    private static final ConfigEntry<Seq<String>> ENABLED_STREAMING_UI_CUSTOM_METRIC_LIST = SQLConf$.MODULE$.buildStaticConf("spark.sql.streaming.ui.enabledCustomMetricList").internal().doc("Configures a list of custom metrics on Structured Streaming UI, which are enabled. The list contains the name of the custom metrics separated by comma. In aggregation only sum used. The list of supported custom metrics is state store provider specific and it can be found out for example from query progress log entry.").version("3.1.0").stringConf().toSequence().createWithDefault((Object)Nil$.MODULE$);
    private static final ConfigEntry<String> DISABLED_JDBC_CONN_PROVIDER_LIST = SQLConf$.MODULE$.buildStaticConf("spark.sql.sources.disabledJdbcConnProviderList").doc("Configures a list of JDBC connection providers, which are disabled. The list contains the name of the JDBC connection providers separated by comma.").version("3.1.0").stringConf().createWithDefault((Object)"");
    private static final ConfigEntry<Object> DATA_FRAME_DEBUGGING_ENABLED = SQLConf$.MODULE$.buildStaticConf("spark.python.sql.dataFrameDebugging.enabled").internal().doc("Enable the DataFrame debugging. This feature is enabled by default, but has a non-trivial performance overhead because of the stack trace collection.").version("4.0.0").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));

    public ConfigEntry<String> WAREHOUSE_PATH() {
        return WAREHOUSE_PATH;
    }

    public ConfigEntry<String> CATALOG_DEFAULT_DATABASE() {
        return CATALOG_DEFAULT_DATABASE;
    }

    public ConfigEntry<String> CATALOG_IMPLEMENTATION() {
        return CATALOG_IMPLEMENTATION;
    }

    public ConfigEntry<String> GLOBAL_TEMP_DATABASE() {
        return GLOBAL_TEMP_DATABASE;
    }

    public ConfigEntry<Object> SCHEMA_STRING_LENGTH_THRESHOLD() {
        return SCHEMA_STRING_LENGTH_THRESHOLD;
    }

    public ConfigEntry<Object> FILESOURCE_TABLE_RELATION_CACHE_SIZE() {
        return FILESOURCE_TABLE_RELATION_CACHE_SIZE;
    }

    public ConfigEntry<Object> CODEGEN_CACHE_MAX_ENTRIES() {
        return CODEGEN_CACHE_MAX_ENTRIES;
    }

    public ConfigEntry<Object> CODEGEN_COMMENTS() {
        return CODEGEN_COMMENTS;
    }

    public ConfigEntry<Object> DEBUG_MODE() {
        return DEBUG_MODE;
    }

    public ConfigEntry<Object> HIVE_THRIFT_SERVER_SINGLESESSION() {
        return HIVE_THRIFT_SERVER_SINGLESESSION;
    }

    public OptionalConfigEntry<Seq<String>> SPARK_SESSION_EXTENSIONS() {
        return SPARK_SESSION_EXTENSIONS;
    }

    public ConfigEntry<Object> LOAD_SESSION_EXTENSIONS_FROM_CLASSPATH() {
        return LOAD_SESSION_EXTENSIONS_FROM_CLASSPATH;
    }

    public ConfigEntry<String> SPARK_CACHE_SERIALIZER() {
        return SPARK_CACHE_SERIALIZER;
    }

    public OptionalConfigEntry<Seq<String>> QUERY_EXECUTION_LISTENERS() {
        return QUERY_EXECUTION_LISTENERS;
    }

    public OptionalConfigEntry<Seq<String>> STREAMING_QUERY_LISTENERS() {
        return STREAMING_QUERY_LISTENERS;
    }

    public ConfigEntry<Object> UI_RETAINED_EXECUTIONS() {
        return UI_RETAINED_EXECUTIONS;
    }

    public ConfigEntry<Object> SHUFFLE_EXCHANGE_MAX_THREAD_THRESHOLD() {
        return SHUFFLE_EXCHANGE_MAX_THREAD_THRESHOLD;
    }

    public ConfigEntry<Object> BROADCAST_EXCHANGE_MAX_THREAD_THRESHOLD() {
        return BROADCAST_EXCHANGE_MAX_THREAD_THRESHOLD;
    }

    public ConfigEntry<Object> SUBQUERY_MAX_THREAD_THRESHOLD() {
        return SUBQUERY_MAX_THREAD_THRESHOLD;
    }

    public ConfigEntry<Object> RESULT_QUERY_STAGE_MAX_THREAD_THRESHOLD() {
        return RESULT_QUERY_STAGE_MAX_THREAD_THRESHOLD;
    }

    public ConfigEntry<Object> SQL_EVENT_TRUNCATE_LENGTH() {
        return SQL_EVENT_TRUNCATE_LENGTH;
    }

    public ConfigEntry<Object> SQL_LEGACY_SESSION_INIT_WITH_DEFAULTS() {
        return SQL_LEGACY_SESSION_INIT_WITH_DEFAULTS;
    }

    public ConfigEntry<Object> DEFAULT_URL_STREAM_HANDLER_FACTORY_ENABLED() {
        return DEFAULT_URL_STREAM_HANDLER_FACTORY_ENABLED;
    }

    public ConfigEntry<Object> STREAMING_UI_ENABLED() {
        return STREAMING_UI_ENABLED;
    }

    public ConfigEntry<Object> STREAMING_UI_RETAINED_PROGRESS_UPDATES() {
        return STREAMING_UI_RETAINED_PROGRESS_UPDATES;
    }

    public ConfigEntry<Object> STREAMING_UI_RETAINED_QUERIES() {
        return STREAMING_UI_RETAINED_QUERIES;
    }

    public ConfigEntry<Object> METADATA_CACHE_TTL_SECONDS() {
        return METADATA_CACHE_TTL_SECONDS;
    }

    public ConfigEntry<Seq<String>> ENABLED_STREAMING_UI_CUSTOM_METRIC_LIST() {
        return ENABLED_STREAMING_UI_CUSTOM_METRIC_LIST;
    }

    public ConfigEntry<String> DISABLED_JDBC_CONN_PROVIDER_LIST() {
        return DISABLED_JDBC_CONN_PROVIDER_LIST;
    }

    public ConfigEntry<Object> DATA_FRAME_DEBUGGING_ENABLED() {
        return DATA_FRAME_DEBUGGING_ENABLED;
    }

    private StaticSQLConf$() {
    }
}

