/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.printer.lexicalpreservation;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.observer.AstObserver;
import com.github.javaparser.ast.observer.AstObserverAdapter;
import com.github.javaparser.ast.type.UnknownType;
import java.util.IdentityHashMap;

class PhantomNodeLogic {
    private static final int LEVELS_TO_EXPLORE = 3;
    private static IdentityHashMap<Node, Boolean> isPhantomNodeCache = new IdentityHashMap();
    private static AstObserver cacheCleaner = new AstObserverAdapter(){

        @Override
        public void parentChange(Node observedNode, Node previousParent, Node newParent) {
            isPhantomNodeCache.remove(observedNode);
        }
    };

    PhantomNodeLogic() {
    }

    static boolean isPhantomNode(Node node) {
        boolean res;
        if (isPhantomNodeCache.containsKey(node)) {
            res = isPhantomNodeCache.get(node);
        } else {
            if (node instanceof UnknownType) {
                return true;
            }
            res = node.getParentNode().isPresent() && !node.getParentNode().get().getRange().get().contains(node.getRange().get()) || PhantomNodeLogic.inPhantomNode(node, 3);
            isPhantomNodeCache.put(node, res);
            node.register(cacheCleaner);
        }
        return res;
    }

    private static boolean inPhantomNode(Node node, int levels) {
        return node.getParentNode().isPresent() && (PhantomNodeLogic.isPhantomNode(node.getParentNode().get()) || PhantomNodeLogic.inPhantomNode(node.getParentNode().get(), levels - 1));
    }
}

