/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jpmml.model.filters;

import org.sparkproject.dmg.pmml.PMMLObject;
import org.sparkproject.jpmml.model.filters.ElementFilter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class CountFilter
extends ElementFilter {
    private int count = 0;
    private int limit = 0;

    public CountFilter(String localName, int limit) {
        super(localName);
        this.setLimit(limit);
    }

    public CountFilter(String namespaceURI, String localName, int limit) {
        super(namespaceURI, localName);
        this.setLimit(limit);
    }

    public CountFilter(Class<? extends PMMLObject> clazz, int limit) {
        super(clazz);
        this.setLimit(limit);
    }

    public CountFilter(XMLReader reader, String localName, int limit) {
        super(reader, localName);
        this.setLimit(limit);
    }

    public CountFilter(XMLReader reader, String namespaceURI, String localName, int limit) {
        super(reader, namespaceURI, localName);
        this.setLimit(limit);
    }

    public CountFilter(XMLReader reader, Class<? extends PMMLObject> clazz, int limit) {
        super(reader, clazz);
        this.setLimit(limit);
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        if (this.matches(namespaceURI, localName)) {
            int limit = this.getLimit();
            ++this.count;
            if (this.count > limit) {
                throw new SAXException("Too many " + this.getQualifiedName() + " elements");
            }
        }
        super.startElement(namespaceURI, localName, qualifiedName, attributes);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qualifiedName) throws SAXException {
        super.endElement(namespaceURI, localName, qualifiedName);
    }

    public int getLimit() {
        return this.limit;
    }

    private void setLimit(int limit) {
        if (limit < 0) {
            throw new IllegalArgumentException();
        }
        this.limit = limit;
    }
}

