/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Reverse$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(array) - Returns a reversed string or an array with reverse order of elements.", examples="\n    Examples:\n      > SELECT _FUNC_('Spark SQL');\n       LQS krapS\n      > SELECT _FUNC_(array(2, 1, 4, 3));\n       [3,4,1,2]\n  ", group="collection_funcs", since="1.5.0", note="\n    Reverse logic for arrays is available since 2.4.0.\n  ")
@ScalaSignature(bytes="\u0006\u0005\t\u001da\u0001B\u0010!\u00016B\u0001b\u0012\u0001\u0003\u0016\u0004%\t\u0001\u0013\u0005\t\u0019\u0002\u0011\t\u0012)A\u0005\u0013\")Q\n\u0001C\u0001\u001d\")\u0011\u000b\u0001C!%\")a\u000b\u0001C!/\")\u0011\r\u0001C!E\")a\r\u0001C\u0005%\")q\r\u0001C!Q\"Aa\u000e\u0001EC\u0002\u0013%q\u000eC\u0003x\u0001\u0011\u0005\u0003\u0010C\u0004\u0002\u000e\u0001!I!a\u0004\t\u000f\u0005\u001d\u0002\u0001\"\u0003\u0002*!9\u0011\u0011\u0007\u0001\u0005B\u0005M\u0002bBA\u001b\u0001\u0011E\u0013q\u0007\u0005\n\u0003{\u0001\u0011\u0011!C\u0001\u0003\u007fA\u0011\"a\u0011\u0001#\u0003%\t!!\u0012\t\u0013\u0005m\u0003!!A\u0005B\u0005u\u0003\"CA7\u0001\u0005\u0005I\u0011AA8\u0011%\t9\bAA\u0001\n\u0003\tI\bC\u0005\u0002\u0000\u0001\t\t\u0011\"\u0011\u0002\u0002\"I\u0011q\u0012\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u0013\u0005\n\u0003+\u0003\u0011\u0011!C!\u0003/C\u0011\"a'\u0001\u0003\u0003%\t%!(\b\u0013\u0005\u001d\u0007%!A\t\u0002\u0005%g\u0001C\u0010!\u0003\u0003E\t!a3\t\r5KB\u0011AAr\u0011%\t)/GA\u0001\n\u000b\n9\u000fC\u0005\u0002jf\t\t\u0011\"!\u0002l\"I\u0011q^\r\u0002\u0002\u0013\u0005\u0015\u0011\u001f\u0005\n\u0003{L\u0012\u0011!C\u0005\u0003\u007f\u0014qAU3wKJ\u001cXM\u0003\u0002\"E\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t\u0019C%\u0001\u0005dCR\fG._:u\u0015\t)c%A\u0002tc2T!a\n\u0015\u0002\u000bM\u0004\u0018M]6\u000b\u0005%R\u0013AB1qC\u000eDWMC\u0001,\u0003\ry'oZ\u0002\u0001'\u0015\u0001aFM\u001b<!\ty\u0003'D\u0001!\u0013\t\t\u0004EA\bV]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\ty3'\u0003\u00025A\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u00027s5\tqGC\u00019\u0003\u0015\u00198-\u00197b\u0013\tQtGA\u0004Qe>$Wo\u0019;\u0011\u0005q\"eBA\u001fC\u001d\tq\u0014)D\u0001@\u0015\t\u0001E&\u0001\u0004=e>|GOP\u0005\u0002q%\u00111iN\u0001\ba\u0006\u001c7.Y4f\u0013\t)eI\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002Do\u0005)1\r[5mIV\t\u0011\n\u0005\u00020\u0015&\u00111\n\t\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017AB2iS2$\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0003\u001fB\u0003\"a\f\u0001\t\u000b\u001d\u001b\u0001\u0019A%\u0002\u001d9,H\u000e\\%oi>dWM]1oiV\t1\u000b\u0005\u00027)&\u0011Qk\u000e\u0002\b\u0005>|G.Z1o\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u00021B\u0019A(W.\n\u0005i3%aA*fcB\u0011AlX\u0007\u0002;*\u0011a\fJ\u0001\u0006if\u0004Xm]\u0005\u0003Av\u0013\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012a\u0019\t\u00039\u0012L!!Z/\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f!D]3tk2$\u0018I\u001d:bs\u0016cW-\\3oi:+H\u000e\\1cY\u0016\fAB\\;mYN\u000bg-Z#wC2$\"!\u001b7\u0011\u0005YR\u0017BA68\u0005\r\te.\u001f\u0005\u0006[\"\u0001\r![\u0001\u0006S:\u0004X\u000f^\u0001\nI>\u0014VM^3sg\u0016,\u0012\u0001\u001d\t\u0005mEL\u0017.\u0003\u0002so\tIa)\u001e8di&|g.\r\u0015\u0003\u0013Q\u0004\"AN;\n\u0005Y<$!\u0003;sC:\u001c\u0018.\u001a8u\u0003%!wnR3o\u0007>$W\r\u0006\u0003z\u007f\u0006%\u0001C\u0001>~\u001b\u0005Y(B\u0001?!\u0003\u001d\u0019w\u000eZ3hK:L!A`>\u0003\u0011\u0015C\bO]\"pI\u0016Dq!!\u0001\u000b\u0001\u0004\t\u0019!A\u0002dib\u00042A_A\u0003\u0013\r\t9a\u001f\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u0019\tYA\u0003a\u0001s\u0006\u0011QM^\u0001\u000egR\u0014\u0018N\\4D_\u0012,w)\u001a8\u0015\r\u0005E\u0011\u0011EA\u0012!\u0011\t\u0019\"a\u0007\u000f\t\u0005U\u0011q\u0003\t\u0003}]J1!!\u00078\u0003\u0019\u0001&/\u001a3fM&!\u0011QDA\u0010\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011D\u001c\t\r\u0005-1\u00021\u0001z\u0011\u001d\t)c\u0003a\u0001\u0003#\t\u0011b\u00195jY\u0012t\u0015-\\3\u0002\u0019\u0005\u0014(/Y=D_\u0012,w)\u001a8\u0015\u0011\u0005E\u00111FA\u0017\u0003_Aq!!\u0001\r\u0001\u0004\t\u0019\u0001\u0003\u0004\u0002\f1\u0001\r!\u001f\u0005\b\u0003Ka\u0001\u0019AA\t\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0003\u0003#\tAc^5uQ:+wo\u00115jY\u0012Le\u000e^3s]\u0006dGcA(\u0002:!1\u00111\b\bA\u0002%\u000b\u0001B\\3x\u0007\"LG\u000eZ\u0001\u0005G>\u0004\u0018\u0010F\u0002P\u0003\u0003BqaR\b\u0011\u0002\u0003\u0007\u0011*\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u001d#fA%\u0002J-\u0012\u00111\n\t\u0005\u0003\u001b\n9&\u0004\u0002\u0002P)!\u0011\u0011KA*\u0003%)hn\u00195fG.,GMC\u0002\u0002V]\n!\"\u00198o_R\fG/[8o\u0013\u0011\tI&a\u0014\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003?\u0002B!!\u0019\u0002l5\u0011\u00111\r\u0006\u0005\u0003K\n9'\u0001\u0003mC:<'BAA5\u0003\u0011Q\u0017M^1\n\t\u0005u\u00111M\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003c\u00022ANA:\u0013\r\t)h\u000e\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004S\u0006m\u0004\"CA?'\u0005\u0005\t\u0019AA9\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u00111\u0011\t\u0006\u0003\u000b\u000bY)[\u0007\u0003\u0003\u000fS1!!#8\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u001b\u000b9I\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGcA*\u0002\u0014\"A\u0011QP\u000b\u0002\u0002\u0003\u0007\u0011.\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA0\u00033C\u0011\"! \u0017\u0003\u0003\u0005\r!!\u001d\u0002\r\u0015\fX/\u00197t)\r\u0019\u0016q\u0014\u0005\t\u0003{:\u0012\u0011!a\u0001S\":\u0002!a)\u0002*\u0006-\u0016qVAY\u0003k\u000b9,a/\u0002>\u0006\u0005\u00171\u0019\t\u0004_\u0005\u0015\u0016bAATA\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAW\u0003U{f)\u0016(D?\"\n'O]1zS\u0001j\u0003EU3ukJt7\u000fI1!e\u00164XM]:fI\u0002\u001aHO]5oO\u0002z'\u000fI1oA\u0005\u0014(/Y=!o&$\b\u000e\t:fm\u0016\u00148/\u001a\u0011pe\u0012,'\u000fI8gA\u0015dW-\\3oiNt\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005M\u0016!a\u0001\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\u001a\u0006/\u0019:lAM\u000bFjJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A1\u000b6\u000bI6sCB\u001c&\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK1se\u0006L\bF\r\u0017!c1\u0002C\u0007\f\u00114S%Z$\u0002\t\u0011!A\u0001\u0002\u0003eW\u001a-i1\nDFM/\u000bA\u0001\nQa\u001a:pkB\f#!!/\u0002!\r|G\u000e\\3di&|gn\u00184v]\u000e\u001c\u0018!B:j]\u000e,\u0017EAA`\u0003\u0015\td&\u000e\u00181\u0003\u0011qw\u000e^3\"\u0005\u0005\u0015\u0017A\u000f\u0006!A\u0001\u0002#+\u001a<feN,\u0007\u0005\\8hS\u000e\u0004cm\u001c:!CJ\u0014\u0018-_:!SN\u0004\u0013M^1jY\u0006\u0014G.\u001a\u0011tS:\u001cW\r\t\u001a/i9\u0002dF\u0003\u0011!\u0003\u001d\u0011VM^3sg\u0016\u0004\"aL\r\u0014\u000be\ti-!7\u0011\r\u0005=\u0017Q[%P\u001b\t\t\tNC\u0002\u0002T^\nqA];oi&lW-\u0003\u0003\u0002X\u0006E'!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocA!\u00111\\Aq\u001b\t\tiN\u0003\u0003\u0002`\u0006\u001d\u0014AA5p\u0013\r)\u0015Q\u001c\u000b\u0003\u0003\u0013\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003?\nQ!\u00199qYf$2aTAw\u0011\u00159E\u00041\u0001J\u0003\u001d)h.\u00199qYf$B!a=\u0002zB!a'!>J\u0013\r\t9p\u000e\u0002\u0007\u001fB$\u0018n\u001c8\t\u0011\u0005mX$!AA\u0002=\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011\t\u0001\u0005\u0003\u0002b\t\r\u0011\u0002\u0002B\u0003\u0003G\u0012aa\u00142kK\u000e$\b")
public class Reverse
extends UnaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private transient Function1<Object, Object> doReverse;
    private final Expression child;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Expression> unapply(Reverse x$0) {
        return Reverse$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Expression, A> andThen(Function1<Reverse, A> g) {
        return Reverse$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, Reverse> compose(Function1<A$, Expression> g) {
        return Reverse$.MODULE$.compose(g);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), ArrayType$.MODULE$})), (List)Nil$.MODULE$);
    }

    @Override
    public DataType dataType() {
        return this.child().dataType();
    }

    private boolean resultArrayElementNullable() {
        return ((ArrayType)this.dataType()).containsNull();
    }

    @Override
    public Object nullSafeEval(Object input) {
        return this.doReverse().apply(input);
    }

    private Function1<Object, Object> doReverse$lzycompute() {
        Reverse reverse = this;
        synchronized (reverse) {
            if (!this.bitmap$trans$0) {
                Function1 & Serializable intersect;
                DataType dataType = this.dataType();
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    DataType elementType = arrayType.elementType();
                    intersect = (Function1 & Serializable)input -> {
                        ArrayData arrayData = (ArrayData)input;
                        return new GenericArrayData(ArrayOps$.MODULE$.reverse$extension(Predef$.MODULE$.refArrayOps(arrayData.toObjectArray(elementType))));
                    };
                } else if (dataType instanceof StringType) {
                    intersect = (Function1 & Serializable)x$22 -> ((UTF8String)x$22).reverse();
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.doReverse = intersect;
                this.bitmap$trans$0 = true;
            }
        }
        return this.doReverse;
    }

    private Function1<Object, Object> doReverse() {
        if (!this.bitmap$trans$0) {
            return this.doReverse$lzycompute();
        }
        return this.doReverse;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> {
            DataType dataType = this.dataType();
            if (dataType instanceof StringType) {
                return this.stringCodeGen(ev, (String)c);
            }
            if (dataType instanceof ArrayType) {
                return this.arrayCodeGen(ctx, ev, (String)c);
            }
            throw new MatchError((Object)dataType);
        });
    }

    private String stringCodeGen(ExprCode ev, String childName) {
        return ev.value() + " = (" + childName + ").reverse();";
    }

    private String arrayCodeGen(CodegenContext ctx, ExprCode ev, String childName) {
        String numElements = ctx.freshName("numElements");
        String arrayData = ctx.freshName("arrayData");
        String i = ctx.freshName("i");
        String j = ctx.freshName("j");
        DataType elementType = ((ArrayType)this.dataType()).elementType();
        String initialization = CodeGenerator$.MODULE$.createArrayData(arrayData, elementType, numElements, " " + this.prettyName() + " failed.");
        String assignment = CodeGenerator$.MODULE$.createArrayAssignment(arrayData, elementType, childName, i, j, this.resultArrayElementNullable());
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       |final int " + numElements + " = " + childName + ".numElements();\n       |" + initialization + "\n       |for (int " + i + " = 0; " + i + " < " + numElements + "; " + i + "++) {\n       |  int " + j + " = " + numElements + " - " + i + " - 1;\n       |  " + assignment + "\n       |}\n       |" + ev.value() + " = " + arrayData + ";\n     "));
    }

    @Override
    public String prettyName() {
        return "reverse";
    }

    @Override
    public Reverse withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public Reverse copy(Expression child) {
        return new Reverse(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "Reverse";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Reverse;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Reverse)) return false;
        boolean bl = true;
        if (!bl) return false;
        Reverse reverse = (Reverse)x$1;
        Expression expression = this.child();
        Expression expression2 = reverse.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!reverse.canEqual(this)) return false;
        return true;
    }

    public Reverse(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
    }
}

