/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Levenshtein$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(str1, str2[, threshold]) - Returns the Levenshtein distance between the two given strings. If threshold is set and distance more than it, return -1.", examples="\n    Examples:\n      > SELECT _FUNC_('kitten', 'sitting');\n       3\n      > SELECT _FUNC_('kitten', 'sitting', 2);\n       -1\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\t-c\u0001\u0002\u0016,\u0001bB\u0001B\u0015\u0001\u0003\u0016\u0004%\ta\u0015\u0005\t)\u0002\u0011\t\u0012)A\u0005s!AQ\u000b\u0001BK\u0002\u0013\u00051\u000b\u0003\u0005W\u0001\tE\t\u0015!\u0003:\u0011!9\u0006A!f\u0001\n\u0003A\u0006\u0002\u0003/\u0001\u0005#\u0005\u000b\u0011B-\t\u000bu\u0003A\u0011\u00010\t\u000bu\u0003A\u0011A2\t\u000bu\u0003A\u0011A4\t\u000b)\u0004A\u0011I6\t\u000bI\u0004A\u0011I:\t\u000bu\u0004A\u0011\t@\t\u000f\u0005\u0005\u0001\u0001\"\u0011\u0002\u0004!9\u00111\u0002\u0001\u0005R\u00055\u0001bBA\r\u0001\u0011\u0005\u00131\u0004\u0005\b\u0003G\u0001A\u0011IA\u000e\u0011\u001d\t)\u0003\u0001C!\u00037Aq!a\n\u0001\t\u0003\nI\u0003C\u0004\u0002>\u0001!\t%a\u0010\t\u000f\u0005m\u0003\u0001\"\u0003\u0002^!9\u0011q\r\u0001\u0005\n\u0005%\u0004\"CA8\u0001\u0005\u0005I\u0011AA9\u0011%\tI\bAI\u0001\n\u0003\tY\bC\u0005\u0002\u0012\u0002\t\n\u0011\"\u0001\u0002|!I\u00111\u0013\u0001\u0012\u0002\u0013\u0005\u0011Q\u0013\u0005\n\u00033\u0003\u0011\u0011!C!\u00037C\u0011\"!,\u0001\u0003\u0003%\t!a,\t\u0013\u0005]\u0006!!A\u0005\u0002\u0005e\u0006\"CA`\u0001\u0005\u0005I\u0011IAa\u0011%\ty\rAA\u0001\n\u0003\t\t\u000eC\u0005\u0002V\u0002\t\t\u0011\"\u0011\u0002X\"I\u00111\u001c\u0001\u0002\u0002\u0013\u0005\u0013Q\\\u0004\n\u0005\u0003Y\u0013\u0011!E\u0001\u0005\u00071\u0001BK\u0016\u0002\u0002#\u0005!Q\u0001\u0005\u0007;\n\"\tA!\b\t\u0013\t}!%!A\u0005F\t\u0005\u0002\"\u0003B\u0012E\u0005\u0005I\u0011\u0011B\u0013\u0011%\u0011iCII\u0001\n\u0003\t)\nC\u0005\u00030\t\n\t\u0011\"!\u00032!I!q\b\u0012\u0012\u0002\u0013\u0005\u0011Q\u0013\u0005\n\u0005\u0003\u0012\u0013\u0011!C\u0005\u0005\u0007\u00121\u0002T3wK:\u001c\b\u000e^3j]*\u0011A&L\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002/_\u0005A1-\u0019;bYf\u001cHO\u0003\u00021c\u0005\u00191/\u001d7\u000b\u0005I\u001a\u0014!B:qCJ\\'B\u0001\u001b6\u0003\u0019\t\u0007/Y2iK*\ta'A\u0002pe\u001e\u001c\u0001aE\u0003\u0001su\u0002e\t\u0005\u0002;w5\t1&\u0003\u0002=W\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005ir\u0014BA ,\u0005YIU\u000e\u001d7jG&$8)Y:u\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bCA!E\u001b\u0005\u0011%\"A\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0013%a\u0002)s_\u0012,8\r\u001e\t\u0003\u000f>s!\u0001S'\u000f\u0005%cU\"\u0001&\u000b\u0005-;\u0014A\u0002\u001fs_>$h(C\u0001D\u0013\tq%)A\u0004qC\u000e\\\u0017mZ3\n\u0005A\u000b&\u0001D*fe&\fG.\u001b>bE2,'B\u0001(C\u0003\u0011aWM\u001a;\u0016\u0003e\nQ\u0001\\3gi\u0002\nQA]5hQR\faA]5hQR\u0004\u0013!\u0003;ie\u0016\u001c\bn\u001c7e+\u0005I\u0006cA![s%\u00111L\u0011\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u0015QD'/Z:i_2$\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0005?\u0002\f'\r\u0005\u0002;\u0001!)!k\u0002a\u0001s!)Qk\u0002a\u0001s!9qk\u0002I\u0001\u0002\u0004IF\u0003B0eK\u001aDQA\u0015\u0005A\u0002eBQ!\u0016\u0005A\u0002eBQa\u0016\u0005A\u0002e\"2a\u00185j\u0011\u0015\u0011\u0016\u00021\u0001:\u0011\u0015)\u0016\u00021\u0001:\u0003M\u0019\u0007.Z2l\u0013:\u0004X\u000f\u001e#bi\u0006$\u0016\u0010]3t)\u0005a\u0007CA7q\u001b\u0005q'BA8.\u0003!\tg.\u00197zg&\u001c\u0018BA9o\u0005=!\u0016\u0010]3DQ\u0016\u001c7NU3tk2$\u0018AC5oaV$H+\u001f9fgV\tA\u000fE\u0002Hk^L!A^)\u0003\u0007M+\u0017\u000f\u0005\u0002yw6\t\u0011P\u0003\u0002{_\u0005)A/\u001f9fg&\u0011A0\u001f\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\f\u0001b\u00195jY\u0012\u0014XM\\\u000b\u0002\u007fB\u0019q)^\u001d\u0002\u0011\u0011\fG/\u0019+za\u0016,\"!!\u0002\u0011\u0007a\f9!C\u0002\u0002\ne\u0014\u0001\u0002R1uCRK\b/Z\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$2!OA\b\u0011\u001d\t\tB\u0004a\u0001\u0003'\t1B\\3x\u0007\"LG\u000e\u001a:f]B!q)!\u0006:\u0013\r\t9\"\u0015\u0002\u000b\u0013:$W\r_3e'\u0016\f\u0018\u0001\u00038vY2\f'\r\\3\u0016\u0005\u0005u\u0001cA!\u0002 %\u0019\u0011\u0011\u0005\"\u0003\u000f\t{w\u000e\\3b]\u0006qa.\u001e7m\u0013:$x\u000e\\3sC:$\u0018\u0001\u00034pY\u0012\f'\r\\3\u0002\t\u00154\u0018\r\u001c\u000b\u0005\u0003W\t\t\u0004E\u0002B\u0003[I1!a\fC\u0005\r\te.\u001f\u0005\n\u0003g\u0011\u0002\u0013!a\u0001\u0003k\tQ!\u001b8qkR\u0004B!a\u000e\u0002:5\tQ&C\u0002\u0002<5\u00121\"\u00138uKJt\u0017\r\u001c*po\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0007\u0003\u0003\ni%a\u0016\u0011\t\u0005\r\u0013\u0011J\u0007\u0003\u0003\u000bR1!a\u0012,\u0003\u001d\u0019w\u000eZ3hK:LA!a\u0013\u0002F\tAQ\t\u001f9s\u0007>$W\rC\u0004\u0002PM\u0001\r!!\u0015\u0002\u0007\r$\b\u0010\u0005\u0003\u0002D\u0005M\u0013\u0002BA+\u0003\u000b\u0012abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0004\u0002ZM\u0001\r!!\u0011\u0002\u0005\u00154\u0018\u0001F4f]\u000e{G-Z,ji\"$\u0006N]3tQ>dG\r\u0006\u0005\u0002B\u0005}\u0013\u0011MA2\u0011\u001d\ty\u0005\u0006a\u0001\u0003#Bq!!\u0017\u0015\u0001\u0004\t\t\u0005\u0003\u0004\u0002fQ\u0001\r!O\u0001\u000ei\"\u0014Xm\u001d5pY\u0012,\u0005\u0010\u001d:\u0002/\u001d,gnQ8eK^KG\u000f[8viRC'/Z:i_2$GCBA!\u0003W\ni\u0007C\u0004\u0002PU\u0001\r!!\u0015\t\u000f\u0005eS\u00031\u0001\u0002B\u0005!1m\u001c9z)\u001dy\u00161OA;\u0003oBqA\u0015\f\u0011\u0002\u0003\u0007\u0011\bC\u0004V-A\u0005\t\u0019A\u001d\t\u000f]3\u0002\u0013!a\u00013\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA?U\rI\u0014qP\u0016\u0003\u0003\u0003\u0003B!a!\u0002\u000e6\u0011\u0011Q\u0011\u0006\u0005\u0003\u000f\u000bI)A\u0005v]\u000eDWmY6fI*\u0019\u00111\u0012\"\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0010\u0006\u0015%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003/S3!WA@\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\u0014\t\u0005\u0003?\u000bI+\u0004\u0002\u0002\"*!\u00111UAS\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u001d\u0016\u0001\u00026bm\u0006LA!a+\u0002\"\n11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!-\u0011\u0007\u0005\u000b\u0019,C\u0002\u00026\n\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a\u000b\u0002<\"I\u0011Q\u0018\u000f\u0002\u0002\u0003\u0007\u0011\u0011W\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\r\u0007CBAc\u0003\u0017\fY#\u0004\u0002\u0002H*\u0019\u0011\u0011\u001a\"\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002N\u0006\u001d'\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!\b\u0002T\"I\u0011Q\u0018\u0010\u0002\u0002\u0003\u0007\u00111F\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002\u001e\u0006e\u0007\"CA_?\u0005\u0005\t\u0019AAY\u0003\u0019)\u0017/^1mgR!\u0011QDAp\u0011%\ti\fIA\u0001\u0002\u0004\tY\u0003K\n\u0001\u0003G\fI/a;\u0002p\u0006E\u0018Q_A|\u0003w\fi\u0010E\u0002;\u0003KL1!a:,\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!<\u0002\u0003\u0003R\u0001\u0005\t\u0011!?\u001a+fjQ0)gR\u0014\u0018\u0007\f\u0011tiJ\u00144\f\f\u0011uQJ,7\u000f[8mIvK\u0003%\f\u0011SKR,(O\\:!i\",\u0007\u0005T3wK:\u001c\b\u000e^3j]\u0002\"\u0017n\u001d;b]\u000e,\u0007EY3uo\u0016,g\u000e\t;iK\u0002\"xo\u001c\u0011hSZ,g\u000eI:ue&twm\u001d\u0018!\u0013\u001a\u0004C\u000f\u001b:fg\"|G\u000e\u001a\u0011jg\u0002\u001aX\r\u001e\u0011b]\u0012\u0004C-[:uC:\u001cW\rI7pe\u0016\u0004C\u000f[1oA%$H\u0006\t:fiV\u0014h\u000eI\u00172]\u0005AQ\r_1na2,7/\t\u0002\u0002t\u0006y(\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014lSR$XM\\\u0014-A\u001d\u001a\u0018\u000e\u001e;j]\u001e<\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00114\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":3.\u001b;uK:<C\u0006I\u0014tSR$\u0018N\\4(Y\u0001\u0012\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011.c)\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002z\u0006)\u0011GL\u001b/a\u0005)qM]8va\u0006\u0012\u0011q`\u0001\rgR\u0014\u0018N\\4`MVt7m]\u0001\f\u0019\u00164XM\\:ii\u0016Lg\u000e\u0005\u0002;EM)!Ea\u0002\u0003\u0014AA!\u0011\u0002B\bseJv,\u0004\u0002\u0003\f)\u0019!Q\u0002\"\u0002\u000fI,h\u000e^5nK&!!\u0011\u0003B\u0006\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\t\u0005\u0005+\u0011Y\"\u0004\u0002\u0003\u0018)!!\u0011DAS\u0003\tIw.C\u0002Q\u0005/!\"Aa\u0001\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!(\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000f}\u00139C!\u000b\u0003,!)!+\na\u0001s!)Q+\na\u0001s!9q+\nI\u0001\u0002\u0004I\u0016aD1qa2LH\u0005Z3gCVdG\u000fJ\u001a\u0002\u000fUt\u0017\r\u001d9msR!!1\u0007B\u001e!\u0011\t%L!\u000e\u0011\r\u0005\u00139$O\u001dZ\u0013\r\u0011ID\u0011\u0002\u0007)V\u0004H.Z\u001a\t\u0011\tur%!AA\u0002}\u000b1\u0001\u001f\u00131\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!Q\t\t\u0005\u0003?\u00139%\u0003\u0003\u0003J\u0005\u0005&AB(cU\u0016\u001cG\u000f")
public class Levenshtein
extends Expression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression left;
    private final Expression right;
    private final Option<Expression> threshold;

    public static Option<Expression> $lessinit$greater$default$3() {
        return Levenshtein$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Option<Expression>>> unapply(Levenshtein x$0) {
        return Levenshtein$.MODULE$.unapply(x$0);
    }

    public static Option<Expression> apply$default$3() {
        return Levenshtein$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Expression, Option<Expression>>, Levenshtein> tupled() {
        return Levenshtein$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<Expression>, Levenshtein>>> curried() {
        return Levenshtein$.MODULE$.curried();
    }

    public Expression left() {
        return this.left;
    }

    public Expression right() {
        return this.right;
    }

    public Option<Expression> threshold() {
        return this.threshold;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        if (this.children().length() > 3 || this.children().length() < 2) {
            throw QueryCompilationErrors$.MODULE$.wrongNumArgsError(Cast$.MODULE$.toSQLId(this.prettyName()), (Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3}))), this.children().length(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$4(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$5(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$6());
        }
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        Option<Expression> option = this.threshold();
        if (option instanceof Some) {
            return new .colon.colon((Object)StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), (List)new .colon.colon((Object)StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$)));
        }
        return new .colon.colon((Object)StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), (List)new .colon.colon((Object)StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), (List)Nil$.MODULE$));
    }

    @Override
    public Seq<Expression> children() {
        Option<Expression> option = this.threshold();
        if (option instanceof Some) {
            Some some = (Some)option;
            Expression value = (Expression)some.value();
            return new .colon.colon((Object)this.left(), (List)new .colon.colon((Object)this.right(), (List)new .colon.colon((Object)value, (List)Nil$.MODULE$)));
        }
        return new .colon.colon((Object)this.left(), (List)new .colon.colon((Object)this.right(), (List)Nil$.MODULE$));
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public Expression withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        Option<Expression> option = this.threshold();
        if (option instanceof Some) {
            return this.copy((Expression)newChildren.apply(0), (Expression)newChildren.apply(1), (Option<Expression>)new Some(newChildren.apply(2)));
        }
        return this.copy((Expression)newChildren.apply(0), (Expression)newChildren.apply(1), this.copy$default$3());
    }

    @Override
    public boolean nullable() {
        return this.children().exists((Function1 & Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)x$23.nullable()));
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public boolean foldable() {
        return this.children().forall((Function1 & Serializable)x$24 -> BoxesRunTime.boxToBoolean((boolean)x$24.foldable()));
    }

    @Override
    public Object eval(InternalRow input) {
        Object leftEval = this.left().eval(input);
        if (leftEval == null) {
            return null;
        }
        Object rightEval = this.right().eval(input);
        if (rightEval == null) {
            return null;
        }
        Option thresholdEval = this.threshold().map((Function1 & Serializable)x$25 -> x$25.eval(input));
        Option option = thresholdEval;
        if (option instanceof Some) {
            Some some = (Some)option;
            Object v = some.value();
            return BoxesRunTime.boxToInteger((int)((UTF8String)leftEval).levenshteinDistance((UTF8String)rightEval, BoxesRunTime.unboxToInt((Object)v)));
        }
        return BoxesRunTime.boxToInteger((int)((UTF8String)leftEval).levenshteinDistance((UTF8String)rightEval));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        Option<Expression> option = this.threshold();
        if (option instanceof Some) {
            return this.genCodeWithThreshold(ctx, ev, (Expression)this.children().apply(2));
        }
        return this.genCodeWithoutThreshold(ctx, ev);
    }

    private ExprCode genCodeWithThreshold(CodegenContext ctx, ExprCode ev, Expression thresholdExpr) {
        ExprCode leftGen = ((Expression)this.children().head()).genCode(ctx);
        ExprCode rightGen = ((Expression)this.children().apply(1)).genCode(ctx);
        ExprCode thresholdGen = thresholdExpr.genCode(ctx);
        String resultCode = ev.value() + " = " + leftGen.value() + ".levenshteinDistance(" + rightGen.value() + ", " + thresholdGen.value() + ");";
        if (this.nullable()) {
            String nullSafeEval = leftGen.code().toString() + ctx.nullSafeExec(((Expression)this.children().head()).nullable(), ExprValue$.MODULE$.exprValueToString(leftGen.isNull()), rightGen.code().toString() + ctx.nullSafeExec(((Expression)this.children().apply(1)).nullable(), ExprValue$.MODULE$.exprValueToString(rightGen.isNull()), thresholdGen.code().toString() + ctx.nullSafeExec(thresholdExpr.nullable(), ExprValue$.MODULE$.exprValueToString(thresholdGen.isNull()), "\n                  " + ev.isNull() + " = false;\n                  " + resultCode + "\n                 ")));
            return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = true;\n        ", " ", " = ", ";\n        ", ""}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), nullSafeEval})), ev.copy$default$2(), ev.copy$default$3());
        }
        Block eval = leftGen.code().$plus(rightGen.code()).$plus(thresholdGen.code());
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n        ", "\n        ", " ", " = ", ";\n        ", ""}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{eval, CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), resultCode})), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    private ExprCode genCodeWithoutThreshold(CodegenContext ctx, ExprCode ev) {
        ExprCode leftGen = ((Expression)this.children().head()).genCode(ctx);
        ExprCode rightGen = ((Expression)this.children().apply(1)).genCode(ctx);
        String resultCode = ev.value() + " = " + leftGen.value() + ".levenshteinDistance(" + rightGen.value() + ");";
        if (this.nullable()) {
            String nullSafeEval = leftGen.code().toString() + ctx.nullSafeExec(((Expression)this.children().head()).nullable(), ExprValue$.MODULE$.exprValueToString(leftGen.isNull()), rightGen.code().toString() + ctx.nullSafeExec(((Expression)this.children().apply(1)).nullable(), ExprValue$.MODULE$.exprValueToString(rightGen.isNull()), "\n              " + ev.isNull() + " = false;\n              " + resultCode + "\n             "));
            return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = true;\n        ", " ", " = ", ";\n        ", ""}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), nullSafeEval})), ev.copy$default$2(), ev.copy$default$3());
        }
        Block eval = leftGen.code().$plus(rightGen.code());
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n        ", "\n        ", " ", " = ", ";\n        ", ""}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{eval, CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), resultCode})), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    public Levenshtein copy(Expression left, Expression right, Option<Expression> threshold) {
        return new Levenshtein(left, right, threshold);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public Option<Expression> copy$default$3() {
        return this.threshold();
    }

    @Override
    public String productPrefix() {
        return "Levenshtein";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
            case 2: {
                return this.threshold();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Levenshtein;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
            case 2: {
                return "threshold";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Levenshtein)) return false;
        boolean bl = true;
        if (!bl) return false;
        Levenshtein levenshtein = (Levenshtein)x$1;
        Expression expression = this.left();
        Expression expression2 = levenshtein.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = levenshtein.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<Expression> option = this.threshold();
        Option<Expression> option2 = levenshtein.threshold();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!levenshtein.canEqual(this)) return false;
        return true;
    }

    public Levenshtein(Expression left, Expression right, Option<Expression> threshold) {
        this.left = left;
        this.right = right;
        this.threshold = threshold;
        ExpectsInputTypes.$init$(this);
    }

    public Levenshtein(Expression left, Expression right, Expression threshold) {
        this(left, right, (Option<Expression>)Option$.MODULE$.apply((Object)threshold));
    }

    public Levenshtein(Expression left, Expression right) {
        this(left, right, (Option<Expression>)None$.MODULE$);
    }
}

