/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.Abs$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.MathUtils$;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnsiIntervalType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerExactNumeric$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongExactNumeric$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the absolute value of the numeric or interval value.", examples="\n    Examples:\n      > SELECT _FUNC_(-1);\n       1\n      > SELECT _FUNC_(INTERVAL -'1-1' YEAR TO MONTH);\n       1-1\n  ", since="1.2.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005uh\u0001\u0002\u0012$\u0001BB\u0001B\u0013\u0001\u0003\u0016\u0004%\ta\u0013\u0005\t\u001f\u0002\u0011\t\u0012)A\u0005\u0019\"A\u0001\u000b\u0001BK\u0002\u0013\u0005\u0011\u000b\u0003\u0005V\u0001\tE\t\u0015!\u0003S\u0011\u00151\u0006\u0001\"\u0001X\u0011\u0015Y\u0006\u0001\"\u0011R\u0011\u00151\u0006\u0001\"\u0001]\u0011\u0015q\u0006\u0001\"\u0011`\u0011\u0015I\u0007\u0001\"\u0011k\u0011!q\u0007\u0001#b\u0001\n\u0013y\u0007\"\u0002<\u0001\t\u0003:\bbBA\u0006\u0001\u0011E\u0013Q\u0002\u0005\b\u0003'\u0001A\u0011IA\u000b\u0011\u001d\ti\u0002\u0001C)\u0003?A\u0011\"!\n\u0001\u0003\u0003%\t!a\n\t\u0013\u00055\u0002!%A\u0005\u0002\u0005=\u0002\"CA#\u0001E\u0005I\u0011AA$\u0011%\tY\u0005AA\u0001\n\u0003\ni\u0005C\u0005\u0002`\u0001\t\t\u0011\"\u0001\u0002b!I\u0011\u0011\u000e\u0001\u0002\u0002\u0013\u0005\u00111\u000e\u0005\n\u0003c\u0002\u0011\u0011!C!\u0003gB\u0011\"a \u0001\u0003\u0003%\t!!!\t\u0013\u0005\u0015\u0005!!A\u0005B\u0005\u001d\u0005\"CAF\u0001\u0005\u0005I\u0011IAG\u000f%\t\tlIA\u0001\u0012\u0003\t\u0019L\u0002\u0005#G\u0005\u0005\t\u0012AA[\u0011\u00191&\u0004\"\u0001\u0002N\"I\u0011q\u001a\u000e\u0002\u0002\u0013\u0015\u0013\u0011\u001b\u0005\n\u0003'T\u0012\u0011!CA\u0003+D\u0011\"a7\u001b#\u0003%\t!a\u0012\t\u0013\u0005u'$!A\u0005\u0002\u0006}\u0007\"CAy5E\u0005I\u0011AA$\u0011%\t\u0019PGA\u0001\n\u0013\t)PA\u0002BENT!\u0001J\u0013\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003M\u001d\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003Q%\n1a]9m\u0015\tQ3&A\u0003ta\u0006\u00148N\u0003\u0002-[\u00051\u0011\r]1dQ\u0016T\u0011AL\u0001\u0004_J<7\u0001A\n\u0006\u0001E*\u0004H\u0010\t\u0003eMj\u0011aI\u0005\u0003i\r\u0012q\"\u00168bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003eYJ!aN\u0012\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"!\u000f\u001f\u000e\u0003iR\u0011aO\u0001\u0006g\u000e\fG.Y\u0005\u0003{i\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002@\u000f:\u0011\u0001)\u0012\b\u0003\u0003\u0012k\u0011A\u0011\u0006\u0003\u0007>\na\u0001\u0010:p_Rt\u0014\"A\u001e\n\u0005\u0019S\u0014a\u00029bG.\fw-Z\u0005\u0003\u0011&\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!A\u0012\u001e\u0002\u000b\rD\u0017\u000e\u001c3\u0016\u00031\u0003\"AM'\n\u00059\u001b#AC#yaJ,7o]5p]\u000611\r[5mI\u0002\n1BZ1jY>sWI\u001d:peV\t!\u000b\u0005\u0002:'&\u0011AK\u000f\u0002\b\u0005>|G.Z1o\u000311\u0017-\u001b7P]\u0016\u0013(o\u001c:!\u0003\u0019a\u0014N\\5u}Q\u0019\u0001,\u0017.\u0011\u0005I\u0002\u0001\"\u0002&\u0006\u0001\u0004a\u0005b\u0002)\u0006!\u0003\u0005\rAU\u0001\u000f]VdG.\u00138u_2,'/\u00198u)\tAV\fC\u0003K\u000f\u0001\u0007A*\u0001\u0006j]B,H\u000fV=qKN,\u0012\u0001\u0019\t\u0004\u007f\u0005\u001c\u0017B\u00012J\u0005\r\u0019V-\u001d\t\u0003I\u001el\u0011!\u001a\u0006\u0003M\u001e\nQ\u0001^=qKNL!\u0001[3\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003-\u0004\"\u0001\u001a7\n\u00055,'\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u000f9,X.\u001a:jGV\t\u0001\u000fE\u0002@cNL!A]%\u0003\u000f9+X.\u001a:jGB\u0011\u0011\b^\u0005\u0003kj\u00121!\u00118z\u0003%!wnR3o\u0007>$W\r\u0006\u0003y}\u0006\u001d\u0001CA=}\u001b\u0005Q(BA>$\u0003\u001d\u0019w\u000eZ3hK:L!! >\u0003\u0011\u0015C\bO]\"pI\u0016Daa`\u0006A\u0002\u0005\u0005\u0011aA2uqB\u0019\u00110a\u0001\n\u0007\u0005\u0015!P\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\r\u0005%1\u00021\u0001y\u0003\t)g/\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000eF\u0002t\u0003\u001fAa!!\u0005\r\u0001\u0004\u0019\u0018!B5oaV$\u0018!\u00044mCR\f%oZ;nK:$8/\u0006\u0002\u0002\u0018A!q(!\u0007t\u0013\r\tY\"\u0013\u0002\t\u0013R,'/\u0019;pe\u0006!r/\u001b;i\u001d\u0016<8\t[5mI&sG/\u001a:oC2$2\u0001WA\u0011\u0011\u0019\t\u0019C\u0004a\u0001\u0019\u0006Aa.Z<DQ&dG-\u0001\u0003d_BLH#\u0002-\u0002*\u0005-\u0002b\u0002&\u0010!\u0003\u0005\r\u0001\u0014\u0005\b!>\u0001\n\u00111\u0001S\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\r+\u00071\u000b\u0019d\u000b\u0002\u00026A!\u0011qGA!\u001b\t\tID\u0003\u0003\u0002<\u0005u\u0012!C;oG\",7m[3e\u0015\r\tyDO\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\"\u0003s\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!!\u0013+\u0007I\u000b\u0019$A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u001f\u0002B!!\u0015\u0002\\5\u0011\u00111\u000b\u0006\u0005\u0003+\n9&\u0001\u0003mC:<'BAA-\u0003\u0011Q\u0017M^1\n\t\u0005u\u00131\u000b\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005\r\u0004cA\u001d\u0002f%\u0019\u0011q\r\u001e\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007M\fi\u0007C\u0005\u0002pQ\t\t\u00111\u0001\u0002d\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\u001e\u0011\u000b\u0005]\u0014QP:\u000e\u0005\u0005e$bAA>u\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005m\u0011\u0011P\u0001\tG\u0006tW)];bYR\u0019!+a!\t\u0011\u0005=d#!AA\u0002M\f!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011qJAE\u0011%\tygFA\u0001\u0002\u0004\t\u0019'\u0001\u0004fcV\fGn\u001d\u000b\u0004%\u0006=\u0005\u0002CA81\u0005\u0005\t\u0019A:)'\u0001\t\u0019*!'\u0002\u001c\u0006}\u0015\u0011UAS\u0003O\u000bY+!,\u0011\u0007I\n)*C\u0002\u0002\u0018\u000e\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002\u001e\u0006YuLR+O\u0007~CS\r\u001f9sS\u0001j\u0003EU3ukJt7\u000f\t;iK\u0002\n'm]8mkR,\u0007E^1mk\u0016\u0004sN\u001a\u0011uQ\u0016\u0004c.^7fe&\u001c\u0007e\u001c:!S:$XM\u001d<bY\u00022\u0018\r\\;f]\u0005AQ\r_1na2,7/\t\u0002\u0002$\u00061(\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u00172SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0013G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015J\u001dR+%KV!MA5:\u0013'L\u0019(Ae+\u0015I\u0015\u0011U\u001f\u0002juJ\u0014+ISmR\u0001\u0005\t\u0011!A\u0001\u0002\u0013'L\u0019\u000bA\u0001\nQa]5oG\u0016\f#!!+\u0002\u000bEr#G\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005=\u0016AC7bi\"|f-\u001e8dg\u0006\u0019\u0011IY:\u0011\u0005IR2#\u0002\u000e\u00028\u0006\r\u0007cBA]\u0003\u007fc%\u000bW\u0007\u0003\u0003wS1!!0;\u0003\u001d\u0011XO\u001c;j[\u0016LA!!1\u0002<\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0011\t\u0005\u0015\u00171Z\u0007\u0003\u0003\u000fTA!!3\u0002X\u0005\u0011\u0011n\\\u0005\u0004\u0011\u0006\u001dGCAAZ\u0003!!xn\u0015;sS:<GCAA(\u0003\u0015\t\u0007\u000f\u001d7z)\u0015A\u0016q[Am\u0011\u0015QU\u00041\u0001M\u0011\u001d\u0001V\u0004%AA\u0002I\u000bq\"\u00199qYf$C-\u001a4bk2$HEM\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t\t/!<\u0011\u000be\n\u0019/a:\n\u0007\u0005\u0015(H\u0001\u0004PaRLwN\u001c\t\u0006s\u0005%HJU\u0005\u0004\u0003WT$A\u0002+va2,'\u0007\u0003\u0005\u0002p~\t\t\u00111\u0001Y\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u0005]\b\u0003BA)\u0003sLA!a?\u0002T\t1qJ\u00196fGR\u0004")
public class Abs
extends UnaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private Numeric<Object> numeric;
    private final Expression child;
    private final boolean failOnError;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$2() {
        return Abs$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Object>> unapply(Abs x$0) {
        return Abs$.MODULE$.unapply(x$0);
    }

    public static boolean apply$default$2() {
        return Abs$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple2<Expression, Object>, Abs> tupled() {
        return Abs$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Object, Abs>> curried() {
        return Abs$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)TypeCollection$.MODULE$.NumericAndAnsiInterval(), (List)Nil$.MODULE$);
    }

    @Override
    public DataType dataType() {
        return this.child().dataType();
    }

    private Numeric<Object> numeric$lzycompute() {
        Abs abs = this;
        synchronized (abs) {
            if (!this.bitmap$0) {
                DataType dataType = this.dataType();
                this.numeric = dataType instanceof DayTimeIntervalType ? LongExactNumeric$.MODULE$ : (dataType instanceof YearMonthIntervalType ? IntegerExactNumeric$.MODULE$ : TypeUtils$.MODULE$.getNumeric(this.dataType(), this.failOnError()));
                this.bitmap$0 = true;
            }
        }
        return this.numeric;
    }

    private Numeric<Object> numeric() {
        if (!this.bitmap$0) {
            return this.numeric$lzycompute();
        }
        return this.numeric;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        DataType dataType = this.dataType();
        if (dataType instanceof DecimalType) {
            return this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> c + ".abs()");
        }
        if ((ByteType$.MODULE$.equals(dataType) ? true : (ShortType$.MODULE$.equals(dataType) ? true : (IntegerType$.MODULE$.equals(dataType) ? true : LongType$.MODULE$.equals(dataType)))) && this.failOnError()) {
            String mathUtils = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(MathUtils$.MODULE$.getClass().getCanonicalName()), "$");
            return this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> c + " < 0 ? " + mathUtils + ".negateExact(" + c + ") : " + c);
        }
        if (dataType instanceof AnsiIntervalType) {
            String mathUtils = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(MathUtils$.MODULE$.getClass().getCanonicalName()), "$");
            return this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> c + " < 0 ? " + mathUtils + ".negateExact(" + c + ") : " + c);
        }
        if (dataType instanceof NumericType) {
            NumericType numericType = (NumericType)dataType;
            return this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> "(" + CodeGenerator$.MODULE$.javaType((DataType)numericType) + ")(java.lang.Math.abs(" + c + "))");
        }
        throw new MatchError((Object)dataType);
    }

    @Override
    public Object nullSafeEval(Object input) {
        return this.numeric().abs(input);
    }

    @Override
    public Iterator<Object> flatArguments() {
        return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.child()}));
    }

    @Override
    public Abs withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2());
    }

    public Abs copy(Expression child, boolean failOnError) {
        return new Abs(child, failOnError);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public boolean copy$default$2() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "Abs";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return BoxesRunTime.boxToBoolean((boolean)this.failOnError());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Abs;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
            case 1: {
                return "failOnError";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Abs)) return false;
        boolean bl = true;
        if (!bl) return false;
        Abs abs = (Abs)x$1;
        if (this.failOnError() != abs.failOnError()) return false;
        Expression expression = this.child();
        Expression expression2 = abs.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!abs.canEqual(this)) return false;
        return true;
    }

    public Abs(Expression child, boolean failOnError) {
        this.child = child;
        this.failOnError = failOnError;
        ExpectsInputTypes.$init$(this);
    }

    public Abs(Expression child) {
        this(child, SQLConf$.MODULE$.get().ansiEnabled());
    }
}

