/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.catalog;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.module.scala.ClassTagExtensions;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import com.fasterxml.jackson.module.scala.JavaTypeable;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import org.apache.spark.SparkException$;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogFunction;
import org.apache.spark.sql.catalyst.catalog.FileResource$;
import org.apache.spark.sql.catalyst.catalog.FunctionResource;
import org.apache.spark.sql.catalyst.catalog.SQLFunction$;
import org.apache.spark.sql.catalyst.catalog.UserDefinedFunction;
import org.apache.spark.sql.catalyst.catalog.UserDefinedFunctionErrors$;
import org.apache.spark.sql.catalyst.parser.ParserInterface;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class UserDefinedFunction$ {
    public static final UserDefinedFunction$ MODULE$ = new UserDefinedFunction$();
    private static final String SQL_CONFIG_PREFIX = "sqlConfig.";
    private static final int INDEX_LENGTH = 3;
    private static final int HIVE_FUNCTION_RESOURCE_URI_LENGTH_THRESHOLD = 4000;
    private static final ObjectMapper _mapper = MODULE$.getObjectMapper();

    public String SQL_CONFIG_PREFIX() {
        return SQL_CONFIG_PREFIX;
    }

    public int INDEX_LENGTH() {
        return INDEX_LENGTH;
    }

    private int HIVE_FUNCTION_RESOURCE_URI_LENGTH_THRESHOLD() {
        return HIVE_FUNCTION_RESOURCE_URI_LENGTH_THRESHOLD;
    }

    public StructType parseRoutineParam(String text, ParserInterface parser) {
        StructType parsed = parser.parseRoutineParam(text);
        return (StructType)CharVarcharUtils$.MODULE$.failIfHasCharVarchar((DataType)parsed);
    }

    public StructType parseTableSchema(String text, ParserInterface parser) {
        StructType parsed = parser.parseTableSchema(text);
        return (StructType)CharVarcharUtils$.MODULE$.failIfHasCharVarchar((DataType)parsed);
    }

    public DataType parseDataType(String text, ParserInterface parser) {
        DataType dataType = parser.parseDataType(text);
        return CharVarcharUtils$.MODULE$.failIfHasCharVarchar(dataType);
    }

    private ObjectMapper _mapper() {
        return _mapper;
    }

    public ObjectMapper mapper() {
        return this._mapper();
    }

    public Seq<FunctionResource> propertiesToFunctionResources(Map<String, String> props, FunctionIdentifier name) {
        String blob = this.mapper().writeValueAsString(props);
        int threshold = this.HIVE_FUNCTION_RESOURCE_URI_LENGTH_THRESHOLD() - this.INDEX_LENGTH();
        return StringOps$.MODULE$.grouped$extension(Predef$.MODULE$.augmentString(blob), threshold).zipWithIndex().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String part = (String)tuple2._1();
                int i = tuple2._2$mcI$sp();
                String index = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%0" + MODULE$.INDEX_LENGTH() + "d"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}));
                if (index.length() > MODULE$.INDEX_LENGTH()) {
                    throw UserDefinedFunctionErrors$.MODULE$.routinePropertyTooLarge(name.funcName());
                }
                return new FunctionResource(FileResource$.MODULE$, index + part);
            }
            throw new MatchError((Object)tuple2);
        }).toSeq();
    }

    private ObjectMapper getObjectMapper() {
        ClassTagExtensions mapper = new ClassTagExtensions(){

            public final <Target, MixinSource> ObjectMapper addMixin(ClassTag<Target> evidence$1, ClassTag<MixinSource> evidence$2) {
                return ClassTagExtensions.addMixin$((ClassTagExtensions)this, evidence$1, evidence$2);
            }

            public final <T> Class<?> findMixInClassFor(ClassTag<T> evidence$3) {
                return ClassTagExtensions.findMixInClassFor$((ClassTagExtensions)this, evidence$3);
            }

            public <T> JavaType constructType(JavaTypeable<T> evidence$4) {
                return ClassTagExtensions.constructType$((ClassTagExtensions)this, evidence$4);
            }

            public <T> T readValue(JsonParser jp, JavaTypeable<T> evidence$5) {
                return (T)ClassTagExtensions.readValue$((ClassTagExtensions)this, (JsonParser)jp, evidence$5);
            }

            public <T> MappingIterator<T> readValues(JsonParser jp, JavaTypeable<T> evidence$6) {
                return ClassTagExtensions.readValues$((ClassTagExtensions)this, (JsonParser)jp, evidence$6);
            }

            public <T> T treeToValue(TreeNode n, JavaTypeable<T> evidence$7) {
                return (T)ClassTagExtensions.treeToValue$((ClassTagExtensions)this, (TreeNode)n, evidence$7);
            }

            public <T> T readValue(File src, JavaTypeable<T> evidence$8) {
                return (T)ClassTagExtensions.readValue$((ClassTagExtensions)this, (File)src, evidence$8);
            }

            public <T> T readValue(URL src, JavaTypeable<T> evidence$9) {
                return (T)ClassTagExtensions.readValue$((ClassTagExtensions)this, (URL)src, evidence$9);
            }

            public <T> T readValue(String content, JavaTypeable<T> evidence$10) {
                return (T)ClassTagExtensions.readValue$((ClassTagExtensions)this, (String)content, evidence$10);
            }

            public <T> T readValue(Reader src, JavaTypeable<T> evidence$11) {
                return (T)ClassTagExtensions.readValue$((ClassTagExtensions)this, (Reader)src, evidence$11);
            }

            public <T> T readValue(InputStream src, JavaTypeable<T> evidence$12) {
                return (T)ClassTagExtensions.readValue$((ClassTagExtensions)this, (InputStream)src, evidence$12);
            }

            public <T> T readValue(byte[] src, JavaTypeable<T> evidence$13) {
                return (T)ClassTagExtensions.readValue$((ClassTagExtensions)this, (byte[])src, evidence$13);
            }

            public <T> T readValue(byte[] src, int offset, int len, JavaTypeable<T> evidence$14) {
                return (T)ClassTagExtensions.readValue$((ClassTagExtensions)this, (byte[])src, (int)offset, (int)len, evidence$14);
            }

            public <T> T updateValue(T valueToUpdate, File src, JavaTypeable<T> evidence$15) {
                return (T)ClassTagExtensions.updateValue$((ClassTagExtensions)this, valueToUpdate, (File)src, evidence$15);
            }

            public <T> T updateValue(T valueToUpdate, URL src, JavaTypeable<T> evidence$16) {
                return (T)ClassTagExtensions.updateValue$((ClassTagExtensions)this, valueToUpdate, (URL)src, evidence$16);
            }

            public <T> T updateValue(T valueToUpdate, String content, JavaTypeable<T> evidence$17) {
                return (T)ClassTagExtensions.updateValue$((ClassTagExtensions)this, valueToUpdate, (String)content, evidence$17);
            }

            public <T> T updateValue(T valueToUpdate, Reader src, JavaTypeable<T> evidence$18) {
                return (T)ClassTagExtensions.updateValue$((ClassTagExtensions)this, valueToUpdate, (Reader)src, evidence$18);
            }

            public <T> T updateValue(T valueToUpdate, InputStream src, JavaTypeable<T> evidence$19) {
                return (T)ClassTagExtensions.updateValue$((ClassTagExtensions)this, valueToUpdate, (InputStream)src, evidence$19);
            }

            public <T> T updateValue(T valueToUpdate, byte[] src, JavaTypeable<T> evidence$20) {
                return (T)ClassTagExtensions.updateValue$((ClassTagExtensions)this, valueToUpdate, (byte[])src, evidence$20);
            }

            public <T> T updateValue(T valueToUpdate, byte[] src, int offset, int len, JavaTypeable<T> evidence$21) {
                return (T)ClassTagExtensions.updateValue$((ClassTagExtensions)this, valueToUpdate, (byte[])src, (int)offset, (int)len, evidence$21);
            }

            public <T> ObjectWriter writerWithView(ClassTag<T> evidence$23) {
                return ClassTagExtensions.writerWithView$((ClassTagExtensions)this, evidence$23);
            }

            public <T> ObjectWriter writerFor(JavaTypeable<T> evidence$24) {
                return ClassTagExtensions.writerFor$((ClassTagExtensions)this, evidence$24);
            }

            public <T> ObjectReader readerFor(JavaTypeable<T> evidence$25) {
                return ClassTagExtensions.readerFor$((ClassTagExtensions)this, evidence$25);
            }

            public <T> ObjectReader readerWithView(ClassTag<T> evidence$26) {
                return ClassTagExtensions.readerWithView$((ClassTagExtensions)this, evidence$26);
            }

            public <T> T convertValue(Object fromValue, JavaTypeable<T> evidence$27) {
                return (T)ClassTagExtensions.convertValue$((ClassTagExtensions)this, (Object)fromValue, evidence$27);
            }
            {
                ClassTagExtensions.$init$((ClassTagExtensions)this);
            }
        };
        mapper.setSerializationInclusion(JsonInclude.Include.NON_ABSENT);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.registerModule((Module)DefaultScalaModule$.MODULE$);
        return mapper;
    }

    public UserDefinedFunction fromCatalogFunction(CatalogFunction function, ParserInterface parser) {
        String className = function.className();
        if (SQLFunction$.MODULE$.isSQLFunction(className)) {
            return SQLFunction$.MODULE$.fromCatalogFunction(function, parser);
        }
        throw SparkException$.MODULE$.internalError("Unsupported function type " + className);
    }

    public boolean isUserDefinedFunction(String className) {
        return SQLFunction$.MODULE$.isSQLFunction(className);
    }

    public Map<String, String> propertiesToSQLConfigs(Map<String, String> properties) {
        Map map;
        try {
            map = (Map)properties.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)UserDefinedFunction$.$anonfun$propertiesToSQLConfigs$1(check$ifrefutable$1))).withFilter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)UserDefinedFunction$.$anonfun$propertiesToSQLConfigs$2(x$1))).map((Function1 & Serializable)x$2 -> {
                Tuple2 tuple2 = x$2;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    return new Tuple2((Object)key.substring(MODULE$.SQL_CONFIG_PREFIX().length()), (Object)value);
                }
                throw new MatchError((Object)tuple2);
            });
        }
        catch (Exception e) {
            throw SparkException$.MODULE$.internalError("Corrupted user defined function SQL configs in catalog", (Throwable)e);
        }
        return map;
    }

    public static final /* synthetic */ boolean $anonfun$propertiesToSQLConfigs$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$propertiesToSQLConfigs$2(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            return key.startsWith(MODULE$.SQL_CONFIG_PREFIX());
        }
        throw new MatchError((Object)tuple2);
    }

    private UserDefinedFunction$() {
    }
}

