/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.builder;

import io.fabric8.kubernetes.api.builder.VisitableMap;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.builder.VisitorListener;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public interface Visitable<T> {
    default public <V> T accept(final Class<V> type, final Visitor<V> visitor) {
        return this.accept(Collections.emptyList(), new Visitor<V>(){

            @Override
            public Class<V> getType() {
                return type;
            }

            @Override
            public void visit(List<Map.Entry<String, Object>> path, V element) {
                visitor.visit(path, element);
            }

            @Override
            public void visit(V element) {
                visitor.visit(element);
            }
        });
    }

    default public T accept(Visitor ... visitors) {
        return this.accept(Collections.emptyList(), visitors);
    }

    default public T accept(List<Map.Entry<String, Object>> path, Visitor ... visitors) {
        return this.accept(path, "", visitors);
    }

    default public T accept(List<Map.Entry<String, Object>> path, String currentKey, Visitor ... visitors) {
        ArrayList sortedVisitor = new ArrayList();
        for (Visitor visitor : visitors) {
            Visitor visitor2 = VisitorListener.wrap(visitor);
            if (!visitor2.canVisit(path, this).booleanValue()) continue;
            sortedVisitor.add(visitor2);
        }
        sortedVisitor.sort((l, r) -> r.order() - l.order());
        for (Visitor visitor : sortedVisitor) {
            visitor.visit(path, this);
        }
        ArrayList<Map.Entry<String, Object>> copyOfPath = path != null ? new ArrayList<Map.Entry<String, Object>>(path) : new ArrayList();
        copyOfPath.add(new AbstractMap.SimpleEntry<String, Visitable>(currentKey, this));
        this.getVisitableMap().ifPresent(vm -> {
            for (Map.Entry entry : vm.entrySet()) {
                List<Map.Entry<String, Object>> newPath = Collections.unmodifiableList(copyOfPath);
                for (Visitable visitable : new ArrayList((List)entry.getValue())) {
                    for (Visitor visitor : visitors) {
                        if (visitor.getType() == null || !visitor.getType().isAssignableFrom(visitable.getClass())) continue;
                        visitable.accept(newPath, (String)entry.getKey(), visitor);
                    }
                    for (Visitor visitor : visitors) {
                        if (visitor.getType() != null && visitor.getType().isAssignableFrom(visitable.getClass())) continue;
                        visitable.accept(newPath, (String)entry.getKey(), visitor);
                    }
                }
            }
        });
        return (T)this;
    }

    default public T getTarget(Visitable<T> visitable) {
        return (T)visitable;
    }

    default public Optional<VisitableMap> getVisitableMap() {
        return Optional.empty();
    }
}

