/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.fs.Path;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.state.RecordType$;
import org.apache.spark.sql.execution.streaming.state.StateStoreChangelogReader;
import org.sparkproject.guava.io.ByteStreams;
import scala.Enumeration;
import scala.Predef$;
import scala.Tuple3;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005y3A\u0001C\u0005\u00011!AQ\u0004\u0001B\u0001B\u0003%a\u0004\u0003\u0005#\u0001\t\u0005\t\u0015!\u0003$\u0011!Y\u0003A!A!\u0002\u0013a\u0003\"\u0002\u001a\u0001\t\u0003\u0019\u0004\"\u0002\u001d\u0001\t\u0013I\u0004\"\u0002'\u0001\t\u0003j\u0005\"B)\u0001\t\u0003\u0012&aG*uCR,7\u000b^8sK\u000eC\u0017M\\4fY><'+Z1eKJ4&G\u0003\u0002\u000b\u0017\u0005)1\u000f^1uK*\u0011A\"D\u0001\ngR\u0014X-Y7j]\u001eT!AD\b\u0002\u0013\u0015DXmY;uS>t'B\u0001\t\u0012\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003%M\tQa\u001d9be.T!\u0001F\u000b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0012aA8sO\u000e\u00011C\u0001\u0001\u001a!\tQ2$D\u0001\n\u0013\ta\u0012BA\rTi\u0006$Xm\u0015;pe\u0016\u001c\u0005.\u00198hK2|wMU3bI\u0016\u0014\u0018A\u00014n!\ty\u0002%D\u0001\f\u0013\t\t3BA\u000bDQ\u0016\u001c7\u000e]8j]R4\u0015\u000e\\3NC:\fw-\u001a:\u0002\u0015\u0019LG.\u001a+p%\u0016\fG\r\u0005\u0002%S5\tQE\u0003\u0002'O\u0005\u0011am\u001d\u0006\u0003QM\ta\u0001[1e_>\u0004\u0018B\u0001\u0016&\u0005\u0011\u0001\u0016\r\u001e5\u0002!\r|W\u000e\u001d:fgNLwN\\\"pI\u0016\u001c\u0007CA\u00171\u001b\u0005q#BA\u0018\u0012\u0003\tIw.\u0003\u00022]\t\u00012i\\7qe\u0016\u001c8/[8o\u0007>$WmY\u0001\u0007y%t\u0017\u000e\u001e \u0015\tQ*dg\u000e\t\u00035\u0001AQ!\b\u0003A\u0002yAQA\t\u0003A\u0002\rBQa\u000b\u0003A\u00021\n1\u0002]1sg\u0016\u0014UO\u001a4feR\u0011!h\u0011\t\u0004wy\u0002U\"\u0001\u001f\u000b\u0003u\nQa]2bY\u0006L!a\u0010\u001f\u0003\u000b\u0005\u0013(/Y=\u0011\u0005m\n\u0015B\u0001\"=\u0005\u0011\u0011\u0015\u0010^3\t\u000b\u0011+\u0001\u0019A#\u0002\u000b%t\u0007/\u001e;\u0011\u0005\u0019SU\"A$\u000b\u0005=B%\"A%\u0002\t)\fg/Y\u0005\u0003\u0017\u001e\u0013q\u0002R1uC&s\u0007/\u001e;TiJ,\u0017-\\\u0001\bm\u0016\u00148/[8o+\u0005q\u0005CA\u001eP\u0013\t\u0001FHA\u0003TQ>\u0014H/A\u0004hKRtU\r\u001f;\u0015\u0003M\u0003Ra\u000f+WuiJ!!\u0016\u001f\u0003\rQ+\b\u000f\\34!\t9&L\u0004\u0002\u001b1&\u0011\u0011,C\u0001\u000b%\u0016\u001cwN\u001d3UsB,\u0017BA.]\u0005\u00151\u0016\r\\;f\u0013\tiFHA\u0006F]VlWM]1uS>t\u0007")
public class StateStoreChangelogReaderV2
extends StateStoreChangelogReader {
    private byte[] parseBuffer(DataInputStream input) {
        int blockSize = input.readInt();
        byte[] blockBuffer = new byte[blockSize];
        ByteStreams.readFully((InputStream)input, (byte[])blockBuffer, (int)0, (int)blockSize);
        return blockBuffer;
    }

    @Override
    public short version() {
        return 2;
    }

    @Override
    public Tuple3<Enumeration.Value, byte[], byte[]> getNext() {
        Enumeration.Value recordType;
        Enumeration.Value value = recordType = RecordType$.MODULE$.getRecordTypeFromByte(this.input().readByte());
        Enumeration.Value value2 = RecordType$.MODULE$.EOF_RECORD();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            this.finished_$eq(true);
            return null;
        }
        Enumeration.Value value3 = recordType;
        Enumeration.Value value4 = RecordType$.MODULE$.PUT_RECORD();
        Enumeration.Value value5 = value3;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            byte[] keyBuffer = this.parseBuffer(this.input());
            byte[] valueBuffer = this.parseBuffer(this.input());
            return new Tuple3((Object)RecordType$.MODULE$.PUT_RECORD(), (Object)keyBuffer, (Object)valueBuffer);
        }
        Enumeration.Value value6 = RecordType$.MODULE$.DELETE_RECORD();
        Enumeration.Value value7 = value3;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            byte[] keyBuffer = this.parseBuffer(this.input());
            int valueSize = this.input().readInt();
            Predef$.MODULE$.assert(valueSize == -1);
            return new Tuple3((Object)RecordType$.MODULE$.DELETE_RECORD(), (Object)keyBuffer, null);
        }
        Enumeration.Value value8 = RecordType$.MODULE$.MERGE_RECORD();
        Enumeration.Value value9 = value3;
        if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
            byte[] keyBuffer = this.parseBuffer(this.input());
            byte[] valueBuffer = this.parseBuffer(this.input());
            return new Tuple3((Object)RecordType$.MODULE$.MERGE_RECORD(), (Object)keyBuffer, (Object)valueBuffer);
        }
        throw new IOException("Failed to process unknown record type");
    }

    public StateStoreChangelogReaderV2(CheckpointFileManager fm, Path fileToRead, CompressionCodec compressionCodec) {
        super(fm, fileToRead, compressionCodec);
        this.verifyVersion();
    }
}

