/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.URL;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSDataOutputStreamBuilder;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.SparkHadoopUtil;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SparkHadoopUtil$
implements Logging {
    public static final SparkHadoopUtil$ MODULE$ = new SparkHadoopUtil$();
    private static SparkHadoopUtil instance;
    private static Seq<Map.Entry<String, String>> hiveConfKeys;
    private static final int UPDATE_INPUT_METRICS_INTERVAL_RECORDS;
    private static final String SPARK_HADOOP_CONF_FILE;
    private static final String SOURCE_HIVE_SITE;
    private static final String SOURCE_SPARK;
    private static final String SOURCE_SPARK_HADOOP;
    private static final String ENV_VAR_AWS_ENDPOINT_URL;
    private static final String ENV_VAR_AWS_ACCESS_KEY;
    private static final String ENV_VAR_AWS_SECRET_KEY;
    private static final String ENV_VAR_AWS_SESSION_TOKEN;
    private static final String SOURCE_SPARK_HIVE;
    private static final String SET_TO_DEFAULT_VALUES;
    private static transient Logger org$apache$spark$internal$Logging$$log_;
    private static volatile byte bitmap$0;

    static {
        Logging.$init$((Logging)MODULE$);
        UPDATE_INPUT_METRICS_INTERVAL_RECORDS = 1000;
        SPARK_HADOOP_CONF_FILE = "__spark_hadoop_conf__.xml";
        SOURCE_HIVE_SITE = "Set by Spark from hive-site.xml";
        SOURCE_SPARK = "Set by Spark";
        SOURCE_SPARK_HADOOP = "Set by Spark from keys starting with 'spark.hadoop'";
        ENV_VAR_AWS_ENDPOINT_URL = "AWS_ENDPOINT_URL";
        ENV_VAR_AWS_ACCESS_KEY = "AWS_ACCESS_KEY_ID";
        ENV_VAR_AWS_SECRET_KEY = "AWS_SECRET_ACCESS_KEY";
        ENV_VAR_AWS_SESSION_TOKEN = "AWS_SESSION_TOKEN";
        SOURCE_SPARK_HIVE = "Set by Spark from keys starting with 'spark.hive'";
        SET_TO_DEFAULT_VALUES = "Set by Spark to default values";
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SparkHadoopUtil instance$lzycompute() {
        SparkHadoopUtil$ sparkHadoopUtil$ = this;
        synchronized (sparkHadoopUtil$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                instance = new SparkHadoopUtil();
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return instance;
    }

    private SparkHadoopUtil instance() {
        if ((byte)(bitmap$0 & 1) == 0) {
            return this.instance$lzycompute();
        }
        return instance;
    }

    public int UPDATE_INPUT_METRICS_INTERVAL_RECORDS() {
        return UPDATE_INPUT_METRICS_INTERVAL_RECORDS;
    }

    public String SPARK_HADOOP_CONF_FILE() {
        return SPARK_HADOOP_CONF_FILE;
    }

    public String SOURCE_HIVE_SITE() {
        return SOURCE_HIVE_SITE;
    }

    public String SOURCE_SPARK() {
        return SOURCE_SPARK;
    }

    public String SOURCE_SPARK_HADOOP() {
        return SOURCE_SPARK_HADOOP;
    }

    public String ENV_VAR_AWS_ENDPOINT_URL() {
        return ENV_VAR_AWS_ENDPOINT_URL;
    }

    public String ENV_VAR_AWS_ACCESS_KEY() {
        return ENV_VAR_AWS_ACCESS_KEY;
    }

    public String ENV_VAR_AWS_SECRET_KEY() {
        return ENV_VAR_AWS_SECRET_KEY;
    }

    public String ENV_VAR_AWS_SESSION_TOKEN() {
        return ENV_VAR_AWS_SESSION_TOKEN;
    }

    public String SOURCE_SPARK_HIVE() {
        return SOURCE_SPARK_HIVE;
    }

    public String SET_TO_DEFAULT_VALUES() {
        return SET_TO_DEFAULT_VALUES;
    }

    public SparkHadoopUtil get() {
        return this.instance();
    }

    public Configuration newConfiguration(SparkConf conf) {
        Configuration hadoopConf = new Configuration();
        this.org$apache$spark$deploy$SparkHadoopUtil$$appendS3AndSparkHadoopHiveConfigurations(conf, hadoopConf);
        return hadoopConf;
    }

    public void org$apache$spark$deploy$SparkHadoopUtil$$appendS3AndSparkHadoopHiveConfigurations(SparkConf conf, Configuration hadoopConf) {
        if (conf != null) {
            this.appendS3CredentialsFromEnvironment(hadoopConf, System.getenv(this.ENV_VAR_AWS_ENDPOINT_URL()), System.getenv(this.ENV_VAR_AWS_ACCESS_KEY()), System.getenv(this.ENV_VAR_AWS_SECRET_KEY()), System.getenv(this.ENV_VAR_AWS_SESSION_TOKEN()));
            this.appendHiveConfigs(hadoopConf);
            this.org$apache$spark$deploy$SparkHadoopUtil$$appendSparkHadoopConfigs(conf, hadoopConf);
            this.appendSparkHiveConfigs(conf, hadoopConf);
            String bufferSize = conf.get(package$.MODULE$.BUFFER_SIZE()).toString();
            hadoopConf.set("io.file.buffer.size", bufferSize, package$.MODULE$.BUFFER_SIZE().key());
            return;
        }
    }

    public void appendS3CredentialsFromEnvironment(Configuration hadoopConf, String endpointUrl, String keyId, String accessKey, String sessionToken) {
        if (keyId != null && accessKey != null) {
            String source = this.SOURCE_SPARK() + " on " + InetAddress.getLocalHost().toString() + " from ";
            hadoopConf.set("fs.s3.awsAccessKeyId", keyId, source + this.ENV_VAR_AWS_ACCESS_KEY());
            hadoopConf.set("fs.s3n.awsAccessKeyId", keyId, source + this.ENV_VAR_AWS_ACCESS_KEY());
            hadoopConf.set("fs.s3a.access.key", keyId, source + this.ENV_VAR_AWS_ACCESS_KEY());
            hadoopConf.set("fs.s3.awsSecretAccessKey", accessKey, source + this.ENV_VAR_AWS_SECRET_KEY());
            hadoopConf.set("fs.s3n.awsSecretAccessKey", accessKey, source + this.ENV_VAR_AWS_SECRET_KEY());
            hadoopConf.set("fs.s3a.secret.key", accessKey, source + this.ENV_VAR_AWS_SECRET_KEY());
            if (endpointUrl != null) {
                hadoopConf.set("fs.s3a.endpoint", endpointUrl, source + this.ENV_VAR_AWS_ENDPOINT_URL());
            }
            if (sessionToken != null) {
                hadoopConf.set("fs.s3a.session.token", sessionToken, source + this.ENV_VAR_AWS_SESSION_TOKEN());
                return;
            }
            return;
        }
    }

    private Seq<Map.Entry<String, String>> hiveConfKeys$lzycompute() {
        SparkHadoopUtil$ sparkHadoopUtil$ = this;
        synchronized (sparkHadoopUtil$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                Nil$ nil$;
                URL configFile = Utils$.MODULE$.getContextOrSparkClassLoader().getResource("hive-site.xml");
                if (configFile != null) {
                    Configuration conf = new Configuration(false);
                    conf.addResource(configFile);
                    nil$ = CollectionConverters$.MODULE$.IteratorHasAsScala(conf.iterator()).asScala().toSeq();
                } else {
                    nil$ = Nil$.MODULE$;
                }
                hiveConfKeys = nil$;
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return hiveConfKeys;
    }

    private Seq<Map.Entry<String, String>> hiveConfKeys() {
        if ((byte)(bitmap$0 & 2) == 0) {
            return this.hiveConfKeys$lzycompute();
        }
        return hiveConfKeys;
    }

    private void appendHiveConfigs(Configuration hadoopConf) {
        this.hiveConfKeys().foreach((Function1 & Serializable)kv -> {
            hadoopConf.set((String)kv.getKey(), (String)kv.getValue(), SparkHadoopUtil$.MODULE$.SOURCE_HIVE_SITE());
            return BoxedUnit.UNIT;
        });
    }

    public void org$apache$spark$deploy$SparkHadoopUtil$$appendSparkHadoopConfigs(SparkConf conf, Configuration hadoopConf) {
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])conf.getAll()), (Function1 & Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)SparkHadoopUtil$.$anonfun$appendSparkHadoopConfigs$4(check$ifrefutable$3))).withFilter((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)SparkHadoopUtil$.$anonfun$appendSparkHadoopConfigs$5(x$11))).foreach((Function1 & Serializable)x$12 -> {
            SparkHadoopUtil$.$anonfun$appendSparkHadoopConfigs$6(hadoopConf, x$12);
            return BoxedUnit.UNIT;
        });
        String setBySpark = this.SET_TO_DEFAULT_VALUES();
        if (conf.getOption("spark.hadoop.mapreduce.fileoutputcommitter.algorithm.version").isEmpty()) {
            hadoopConf.set("mapreduce.fileoutputcommitter.algorithm.version", "1", setBySpark);
        }
        if (conf.getOption("spark.hadoop.fs.s3a.downgrade.syncable.exceptions").isEmpty()) {
            hadoopConf.set("fs.s3a.downgrade.syncable.exceptions", "true", setBySpark);
            return;
        }
    }

    private void appendSparkHiveConfigs(SparkConf conf, Configuration hadoopConf) {
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])conf.getAll()), (Function1 & Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)SparkHadoopUtil$.$anonfun$appendSparkHiveConfigs$4(check$ifrefutable$4))).withFilter((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)SparkHadoopUtil$.$anonfun$appendSparkHiveConfigs$5(x$13))).foreach((Function1 & Serializable)x$14 -> {
            SparkHadoopUtil$.$anonfun$appendSparkHiveConfigs$6(hadoopConf, x$14);
            return BoxedUnit.UNIT;
        });
    }

    public String propertySources(Configuration hadoopConf, String key) {
        String[] sources = hadoopConf.getPropertySources(key);
        if (sources != null && ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])sources))) {
            return Predef$.MODULE$.wrapRefArray((Object[])sources).mkString(",");
        }
        return "";
    }

    public FSDataOutputStream createFile(FileSystem fs, Path path, boolean allowEC) {
        if (allowEC) {
            return fs.create(path);
        }
        if (!fs.mkdirs(path.getParent())) {
            throw new IOException("Failed to create parents of " + path);
        }
        Path qualifiedPath = fs.makeQualified(path);
        FSDataOutputStreamBuilder builder = fs.createFile(qualifiedPath);
        FSDataOutputStreamBuilder fSDataOutputStreamBuilder = builder;
        if (fSDataOutputStreamBuilder instanceof DistributedFileSystem.HdfsDataOutputStreamBuilder) {
            DistributedFileSystem.HdfsDataOutputStreamBuilder hdfsDataOutputStreamBuilder = (DistributedFileSystem.HdfsDataOutputStreamBuilder)fSDataOutputStreamBuilder;
            return hdfsDataOutputStreamBuilder.replicate().build();
        }
        return fs.create(path);
    }

    public boolean isFile(FileSystem fs, Path path) {
        boolean bl;
        try {
            bl = fs.getFileStatus(path).isFile();
        }
        catch (FileNotFoundException fileNotFoundException) {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$appendSparkHadoopConfigs$4(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$appendSparkHadoopConfigs$5(Tuple2 x$11) {
        Tuple2 tuple2 = x$11;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            return key.startsWith("spark.hadoop.");
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$appendSparkHadoopConfigs$6(Configuration hadoopConf$2, Tuple2 x$12) {
        Tuple2 tuple2 = x$12;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            hadoopConf$2.set(key.substring("spark.hadoop.".length()), value, MODULE$.SOURCE_SPARK_HADOOP());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$appendSparkHiveConfigs$4(Tuple2 check$ifrefutable$4) {
        Tuple2 tuple2 = check$ifrefutable$4;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$appendSparkHiveConfigs$5(Tuple2 x$13) {
        Tuple2 tuple2 = x$13;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            return key.startsWith("spark.hive.");
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$appendSparkHiveConfigs$6(Configuration hadoopConf$3, Tuple2 x$14) {
        Tuple2 tuple2 = x$14;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            hadoopConf$3.set(key.substring("spark.".length()), value, MODULE$.SOURCE_SPARK_HIVE());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private SparkHadoopUtil$() {
    }
}

