/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.util;

import java.io.Serializable;
import java.util.Map;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.util.Instrumentation;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.MatrixUDT;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.LabeledPoint$;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.PartitionwiseSampledRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.text.TextFileFormat;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.ArrayImplicits$;
import org.apache.spark.util.random.BernoulliCellSampler;
import org.apache.spark.util.random.RandomSampler;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

public final class MLUtils$
implements Logging {
    public static final MLUtils$ MODULE$ = new MLUtils$();
    private static double EPSILON;
    private static transient Logger org$apache$spark$internal$Logging$$log_;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Dataset<Row> convertVectorColumnsToML(Dataset<?> dataset, String ... cols) {
        return this.convertVectorColumnsToML(dataset, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])cols));
    }

    public Dataset<Row> convertVectorColumnsFromML(Dataset<?> dataset, String ... cols) {
        return this.convertVectorColumnsFromML(dataset, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])cols));
    }

    public Dataset<Row> convertMatrixColumnsToML(Dataset<?> dataset, String ... cols) {
        return this.convertMatrixColumnsToML(dataset, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])cols));
    }

    public Dataset<Row> convertMatrixColumnsFromML(Dataset<?> dataset, String ... cols) {
        return this.convertMatrixColumnsFromML(dataset, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])cols));
    }

    /*
     * WARNING - void declaration
     */
    private double EPSILON$lzycompute() {
        MLUtils$ mLUtils$ = this;
        synchronized (mLUtils$) {
            if (!bitmap$0) {
                void var2_2;
                double eps = 1.0;
                while (1.0 + eps / 2.0 != 1.0) {
                    eps /= 2.0;
                }
                EPSILON = var2_2;
                bitmap$0 = true;
            }
        }
        return EPSILON;
    }

    public double EPSILON() {
        if (!bitmap$0) {
            return this.EPSILON$lzycompute();
        }
        return EPSILON;
    }

    public RDD<LabeledPoint> loadLibSVMFile(SparkContext sc, String path, int numFeatures, int minPartitions) {
        int n;
        RDD<Tuple3<Object, int[], double[]>> parsed = this.parseLibSVMFile(sc, path, minPartitions);
        if (numFeatures > 0) {
            n = numFeatures;
        } else {
            parsed.persist(StorageLevel$.MODULE$.MEMORY_ONLY());
            n = this.computeNumFeatures(parsed);
        }
        int d = n;
        return parsed.map((Function1 & Serializable)x0$1 -> {
            Tuple3 tuple3 = x0$1;
            if (tuple3 != null) {
                double label = BoxesRunTime.unboxToDouble((Object)tuple3._1());
                int[] indices = (int[])tuple3._2();
                double[] values = (double[])tuple3._3();
                return new LabeledPoint(label, Vectors$.MODULE$.sparse(d, indices, values));
            }
            throw new MatchError((Object)tuple3);
        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
    }

    public int computeNumFeatures(RDD<Tuple3<Object, int[], double[]>> rdd) {
        return BoxesRunTime.unboxToInt((Object)rdd.map((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)MLUtils$.$anonfun$computeNumFeatures$1(x0$1)), (ClassTag)ClassTag$.MODULE$.Int()).reduce((Function2)(JFunction2.mcIII.sp & Serializable)(x, y) -> scala.math.package$.MODULE$.max(x, y))) + 1;
    }

    public RDD<Tuple3<Object, int[], double[]>> parseLibSVMFile(SparkContext sc, String path, int minPartitions) {
        return sc.textFile(path, minPartitions).map((Function1 & Serializable)x$1 -> x$1.trim(), ClassTag$.MODULE$.apply(String.class)).filter((Function1 & Serializable)line -> BoxesRunTime.boxToBoolean((boolean)MLUtils$.$anonfun$parseLibSVMFile$2(line))).map((Function1 & Serializable)line -> MODULE$.parseLibSVMRecord((String)line), ClassTag$.MODULE$.apply(Tuple3.class));
    }

    public RDD<Tuple3<Object, int[], double[]>> parseLibSVMFile(SparkSession sparkSession, Seq<String> paths, scala.collection.immutable.Map<String, String> options) {
        SparkSession x$1 = sparkSession;
        Seq<String> x$2 = paths;
        String x$3 = TextFileFormat.class.getName();
        scala.collection.immutable.Map x$4 = (scala.collection.immutable.Map)options.$plus$plus((IterableOnce)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSource$.MODULE$.GLOB_PATHS_KEY()), (Object)"false")})));
        Option x$5 = DataSource$.MODULE$.apply$default$4();
        Seq x$6 = DataSource$.MODULE$.apply$default$5();
        Option x$7 = DataSource$.MODULE$.apply$default$6();
        Option x$8 = DataSource$.MODULE$.apply$default$8();
        Dataset lines = sparkSession.baseRelationToDataFrame(new DataSource(x$1, x$3, x$2, x$5, x$6, x$7, x$4, x$8).resolveRelation(false)).select("value", (Seq)Nil$.MODULE$);
        return lines.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.trim((Column)lines.sparkSession().implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$)).as("line")})).filter(functions$.MODULE$.not(functions$.MODULE$.length((Column)lines.sparkSession().implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"line"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)0)).or(lines.sparkSession().implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"line"}))).$((Seq)Nil$.MODULE$).startsWith("#")))).as(lines.sparkSession().implicits().newStringEncoder()).rdd().map((Function1 & Serializable)line -> MODULE$.parseLibSVMRecord((String)line), ClassTag$.MODULE$.apply(Tuple3.class));
    }

    public Tuple3<Object, int[], double[]> parseLibSVMRecord(String line) {
        String[] items = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(line), ' ');
        double label = StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])items))));
        Tuple2 tuple2 = ArrayOps$.MODULE$.unzip$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.tail$extension(Predef$.MODULE$.refArrayOps((Object[])items))), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$2))))), (Function1 & Serializable)item -> {
            String[] indexAndValue = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(item), ':');
            int index = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(indexAndValue[0])) - 1;
            double value = StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(indexAndValue[1]));
            return new Tuple2.mcID.sp(index, value);
        }, ClassTag$.MODULE$.apply(Tuple2.class))), Predef$.MODULE$.$conforms(), (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Double());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int[] indices = (int[])tuple2._1();
        double[] values = (double[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)indices, (Object)values);
        int[] indices2 = (int[])tuple22._1();
        double[] values2 = (double[])tuple22._2();
        IntRef previous = IntRef.create((int)-1);
        int indicesLength = indices2.length;
        for (int i = 0; i < indicesLength; ++i) {
            int current = indices2[i];
            Predef$.MODULE$.require(current > previous.elem, (Function0 & Serializable)() -> "indices should be one-based and in ascending order; found current=" + current + ", previous=" + previous$1.elem + "; line=\"" + line + "\"");
            previous.elem = current;
        }
        return new Tuple3((Object)BoxesRunTime.boxToDouble((double)label), (Object)indices2, (Object)values2);
    }

    public RDD<LabeledPoint> loadLibSVMFile(SparkContext sc, String path, int numFeatures) {
        return this.loadLibSVMFile(sc, path, numFeatures, sc.defaultMinPartitions());
    }

    public RDD<LabeledPoint> loadLibSVMFile(SparkContext sc, String path) {
        return this.loadLibSVMFile(sc, path, -1);
    }

    public void saveAsLibSVMFile(RDD<LabeledPoint> data, String dir) {
        RDD dataStr = data.map((Function1 & Serializable)x0$1 -> {
            LabeledPoint labeledPoint = x0$1;
            if (labeledPoint != null) {
                double label = labeledPoint.label();
                Vector features = labeledPoint.features();
                StringBuilder sb = new StringBuilder(Double.toString(label));
                features.foreachActive((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVID.sp & Serializable)(x0$2, x1$1) -> {
                    Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(x0$2, x1$1);
                    if (sp2 != null) {
                        int i = sp2._1$mcI$sp();
                        double v = sp2._2$mcD$sp();
                        sb.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)' '));
                        sb.$plus$plus$eq(i + 1 + ":" + v);
                        return;
                    }
                    throw new MatchError((Object)sp2);
                });
                return sb.mkString();
            }
            throw new MatchError((Object)labeledPoint);
        }, ClassTag$.MODULE$.apply(String.class));
        dataStr.saveAsTextFile(dir);
    }

    public RDD<Vector> loadVectors(SparkContext sc, String path, int minPartitions) {
        return sc.textFile(path, minPartitions).map((Function1 & Serializable)s -> Vectors$.MODULE$.parse((String)s), ClassTag$.MODULE$.apply(Vector.class));
    }

    public RDD<Vector> loadVectors(SparkContext sc, String path) {
        return sc.textFile(path, sc.defaultMinPartitions()).map((Function1 & Serializable)s -> Vectors$.MODULE$.parse((String)s), ClassTag$.MODULE$.apply(Vector.class));
    }

    public RDD<LabeledPoint> loadLabeledPoints(SparkContext sc, String path, int minPartitions) {
        return sc.textFile(path, minPartitions).map((Function1 & Serializable)s -> LabeledPoint$.MODULE$.parse((String)s), ClassTag$.MODULE$.apply(LabeledPoint.class));
    }

    public RDD<LabeledPoint> loadLabeledPoints(SparkContext sc, String dir) {
        return this.loadLabeledPoints(sc, dir, sc.defaultMinPartitions());
    }

    public <T> Tuple2<RDD<T>, RDD<T>>[] kFold(RDD<T> rdd, int numFolds, int seed, ClassTag<T> evidence$1) {
        return this.kFold(rdd, numFolds, (long)seed, evidence$1);
    }

    public <T> Tuple2<RDD<T>, RDD<T>>[] kFold(RDD<T> rdd, int numFolds, long seed, ClassTag<T> evidence$2) {
        float numFoldsF = numFolds;
        return (Tuple2[])RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numFolds).map((Function1 & Serializable)fold -> MLUtils$.$anonfun$kFold$1(numFoldsF, rdd, seed, evidence$2, BoxesRunTime.unboxToInt((Object)fold))).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public Tuple2<RDD<Row>, RDD<Row>>[] kFold(Dataset<Row> df, int numFolds, String foldColName) {
        Column foldCol = df.col(foldColName);
        UserDefinedFunction checker = functions$.MODULE$.udf((Function1)(JFunction1.mcZI.sp & Serializable)foldNum -> {
            if (foldNum < 0 || foldNum >= numFolds) {
                throw new SparkException("Fold number must be in range [0, " + numFolds + "), but got " + foldNum + ".");
            }
            return true;
        }, ((TypeTags)package$.MODULE$.universe()).TypeTag().Boolean(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int());
        return (Tuple2[])RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numFolds).map((Function1 & Serializable)fold -> MLUtils$.$anonfun$kFold$3(df, checker, foldCol, foldColName, BoxesRunTime.unboxToInt((Object)fold))).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public Vector appendBias(Vector vector) {
        Vector vector2 = vector;
        if (vector2 instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vector2;
            double[] inputValues = denseVector.values();
            int inputLength = inputValues.length;
            double[] outputValues = (double[])Array$.MODULE$.ofDim(inputLength + 1, (ClassTag)ClassTag$.MODULE$.Double());
            System.arraycopy(inputValues, 0, outputValues, 0, inputLength);
            outputValues[inputLength] = 1.0;
            return Vectors$.MODULE$.dense(outputValues);
        }
        if (vector2 instanceof SparseVector) {
            SparseVector sparseVector = (SparseVector)vector2;
            double[] inputValues = sparseVector.values();
            int[] inputIndices = sparseVector.indices();
            int inputValuesLength = inputValues.length;
            int dim = sparseVector.size();
            double[] outputValues = (double[])Array$.MODULE$.ofDim(inputValuesLength + 1, (ClassTag)ClassTag$.MODULE$.Double());
            int[] outputIndices = (int[])Array$.MODULE$.ofDim(inputValuesLength + 1, (ClassTag)ClassTag$.MODULE$.Int());
            System.arraycopy(inputValues, 0, outputValues, 0, inputValuesLength);
            System.arraycopy(inputIndices, 0, outputIndices, 0, inputValuesLength);
            outputValues[inputValuesLength] = 1.0;
            outputIndices[inputValuesLength] = dim;
            return Vectors$.MODULE$.sparse(dim + 1, outputIndices, outputValues);
        }
        throw new IllegalArgumentException("Do not support vector type " + vector.getClass());
    }

    public Dataset<Row> convertVectorColumnsToML(Dataset<?> dataset, Seq<String> cols) {
        Set colSet;
        StructType schema = dataset.schema();
        Set set = colSet = cols.nonEmpty() ? ((IterableOnceOps)cols.flatMap((Function1 & Serializable)c -> {
            DataType dataType = schema.apply(c).dataType();
            Class clazz = dataType.getClass();
            Class<org.apache.spark.mllib.linalg.VectorUDT> clazz2 = org.apache.spark.mllib.linalg.VectorUDT.class;
            if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
                return new Some(c);
            }
            Class clazz3 = dataType.getClass();
            Class<VectorUDT> clazz4 = VectorUDT.class;
            Predef$.MODULE$.require(!(clazz3 != null ? !clazz3.equals(clazz4) : clazz4 != null), (Function0 & Serializable)() -> "Column " + c + " must be old Vector type to be converted to new type but got " + dataType + ".");
            return None$.MODULE$;
        })).toSet() : Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)MLUtils$.$anonfun$convertVectorColumnsToML$3(x$4)))), (Function1 & Serializable)x$5 -> x$5.name(), ClassTag$.MODULE$.apply(String.class))).toSet();
        if (colSet.isEmpty()) {
            return dataset.toDF();
        }
        this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Vector column conversion has serialization overhead. Please migrate your datasets and workflows to use the spark.ml package.");
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_mllib_util_MLUtils$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_mllib_util_MLUtils$$typecreator1$1() {
            }
        }
        public final class Org_apache_spark_mllib_util_MLUtils$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.mllib.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_mllib_util_MLUtils$$typecreator2$1() {
            }
        }
        UserDefinedFunction convertToML = functions$.MODULE$.udf((Function1 & Serializable)v -> v.asML(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_mllib_util_MLUtils$$typecreator1$1()), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_mllib_util_MLUtils$$typecreator2$1()));
        Column[] exprs = (Column[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()), (Function1 & Serializable)field -> {
            String c = field.name();
            if (colSet.contains((Object)c)) {
                return convertToML.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(c)})).as(c, field.metadata());
            }
            return functions$.MODULE$.col(c);
        }, ClassTag$.MODULE$.apply(Column.class));
        return dataset.select((Seq)ArrayImplicits$.MODULE$.SparkArrayOps((Object)exprs).toImmutableArraySeq());
    }

    public Dataset<Row> convertVectorColumnsFromML(Dataset<?> dataset, Seq<String> cols) {
        Set colSet;
        StructType schema = dataset.schema();
        Set set = colSet = cols.nonEmpty() ? ((IterableOnceOps)cols.flatMap((Function1 & Serializable)c -> {
            DataType dataType = schema.apply(c).dataType();
            Class clazz = dataType.getClass();
            Class<VectorUDT> clazz2 = VectorUDT.class;
            if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
                return new Some(c);
            }
            Class clazz3 = dataType.getClass();
            Class<org.apache.spark.mllib.linalg.VectorUDT> clazz4 = org.apache.spark.mllib.linalg.VectorUDT.class;
            Predef$.MODULE$.require(!(clazz3 != null ? !clazz3.equals(clazz4) : clazz4 != null), (Function0 & Serializable)() -> "Column " + c + " must be new Vector type to be converted to old type but got " + dataType + ".");
            return None$.MODULE$;
        })).toSet() : Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()), (Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)MLUtils$.$anonfun$convertVectorColumnsFromML$3(x$6)))), (Function1 & Serializable)x$7 -> x$7.name(), ClassTag$.MODULE$.apply(String.class))).toSet();
        if (colSet.isEmpty()) {
            return dataset.toDF();
        }
        this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Vector column conversion has serialization overhead. Please migrate your datasets and workflows to use the spark.ml package.");
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_mllib_util_MLUtils$$typecreator1$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.mllib.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_mllib_util_MLUtils$$typecreator1$2() {
            }
        }
        public final class Org_apache_spark_mllib_util_MLUtils$$typecreator2$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_mllib_util_MLUtils$$typecreator2$2() {
            }
        }
        UserDefinedFunction convertFromML = functions$.MODULE$.udf((Function1 & Serializable)v -> Vectors$.MODULE$.fromML((org.apache.spark.ml.linalg.Vector)v), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_mllib_util_MLUtils$$typecreator1$2()), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_mllib_util_MLUtils$$typecreator2$2()));
        Column[] exprs = (Column[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()), (Function1 & Serializable)field -> {
            String c = field.name();
            if (colSet.contains((Object)c)) {
                return convertFromML.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(c)})).as(c, field.metadata());
            }
            return functions$.MODULE$.col(c);
        }, ClassTag$.MODULE$.apply(Column.class));
        return dataset.select((Seq)ArrayImplicits$.MODULE$.SparkArrayOps((Object)exprs).toImmutableArraySeq());
    }

    public Dataset<Row> convertMatrixColumnsToML(Dataset<?> dataset, Seq<String> cols) {
        Set colSet;
        StructType schema = dataset.schema();
        Set set = colSet = cols.nonEmpty() ? ((IterableOnceOps)cols.flatMap((Function1 & Serializable)c -> {
            DataType dataType = schema.apply(c).dataType();
            Class clazz = dataType.getClass();
            Class<MatrixUDT> clazz2 = MatrixUDT.class;
            if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
                return new Some(c);
            }
            Class clazz3 = dataType.getClass();
            Class<org.apache.spark.ml.linalg.MatrixUDT> clazz4 = org.apache.spark.ml.linalg.MatrixUDT.class;
            Predef$.MODULE$.require(!(clazz3 != null ? !clazz3.equals(clazz4) : clazz4 != null), (Function0 & Serializable)() -> "Column " + c + " must be old Matrix type to be converted to new type but got " + dataType + ".");
            return None$.MODULE$;
        })).toSet() : Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()), (Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)MLUtils$.$anonfun$convertMatrixColumnsToML$3(x$8)))), (Function1 & Serializable)x$9 -> x$9.name(), ClassTag$.MODULE$.apply(String.class))).toSet();
        if (colSet.isEmpty()) {
            return dataset.toDF();
        }
        this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Matrix column conversion has serialization overhead. Please migrate your datasets and workflows to use the spark.ml package.");
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_mllib_util_MLUtils$$typecreator1$3
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Matrix").asType().toTypeConstructor();
            }

            public Org_apache_spark_mllib_util_MLUtils$$typecreator1$3() {
            }
        }
        public final class Org_apache_spark_mllib_util_MLUtils$$typecreator2$3
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.mllib.linalg.Matrix").asType().toTypeConstructor();
            }

            public Org_apache_spark_mllib_util_MLUtils$$typecreator2$3() {
            }
        }
        UserDefinedFunction convertToML = functions$.MODULE$.udf((Function1 & Serializable)v -> v.asML(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_mllib_util_MLUtils$$typecreator1$3()), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_mllib_util_MLUtils$$typecreator2$3()));
        Column[] exprs = (Column[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()), (Function1 & Serializable)field -> {
            String c = field.name();
            if (colSet.contains((Object)c)) {
                return convertToML.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(c)})).as(c, field.metadata());
            }
            return functions$.MODULE$.col(c);
        }, ClassTag$.MODULE$.apply(Column.class));
        return dataset.select((Seq)ArrayImplicits$.MODULE$.SparkArrayOps((Object)exprs).toImmutableArraySeq());
    }

    public Dataset<Row> convertMatrixColumnsFromML(Dataset<?> dataset, Seq<String> cols) {
        Set colSet;
        StructType schema = dataset.schema();
        Set set = colSet = cols.nonEmpty() ? ((IterableOnceOps)cols.flatMap((Function1 & Serializable)c -> {
            DataType dataType = schema.apply(c).dataType();
            Class clazz = dataType.getClass();
            Class<org.apache.spark.ml.linalg.MatrixUDT> clazz2 = org.apache.spark.ml.linalg.MatrixUDT.class;
            if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
                return new Some(c);
            }
            Class clazz3 = dataType.getClass();
            Class<MatrixUDT> clazz4 = MatrixUDT.class;
            Predef$.MODULE$.require(!(clazz3 != null ? !clazz3.equals(clazz4) : clazz4 != null), (Function0 & Serializable)() -> "Column " + c + " must be new Matrix type to be converted to old type but got " + dataType + ".");
            return None$.MODULE$;
        })).toSet() : Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()), (Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)MLUtils$.$anonfun$convertMatrixColumnsFromML$3(x$10)))), (Function1 & Serializable)x$11 -> x$11.name(), ClassTag$.MODULE$.apply(String.class))).toSet();
        if (colSet.isEmpty()) {
            return dataset.toDF();
        }
        this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Matrix column conversion has serialization overhead. Please migrate your datasets and workflows to use the spark.ml package.");
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_mllib_util_MLUtils$$typecreator1$4
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.mllib.linalg.Matrix").asType().toTypeConstructor();
            }

            public Org_apache_spark_mllib_util_MLUtils$$typecreator1$4() {
            }
        }
        public final class Org_apache_spark_mllib_util_MLUtils$$typecreator2$4
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Matrix").asType().toTypeConstructor();
            }

            public Org_apache_spark_mllib_util_MLUtils$$typecreator2$4() {
            }
        }
        UserDefinedFunction convertFromML = functions$.MODULE$.udf((Function1 & Serializable)m -> Matrices$.MODULE$.fromML((Matrix)m), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_mllib_util_MLUtils$$typecreator1$4()), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_mllib_util_MLUtils$$typecreator2$4()));
        Column[] exprs = (Column[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()), (Function1 & Serializable)field -> {
            String c = field.name();
            if (colSet.contains((Object)c)) {
                return convertFromML.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(c)})).as(c, field.metadata());
            }
            return functions$.MODULE$.col(c);
        }, ClassTag$.MODULE$.apply(Column.class));
        return dataset.select((Seq)ArrayImplicits$.MODULE$.SparkArrayOps((Object)exprs).toImmutableArraySeq());
    }

    public double fastSquaredDistance(Vector v1, double norm1, Vector v2, double norm2, double precision) {
        double sqDist;
        block1: {
            double sumSquaredNorm;
            block2: {
                block0: {
                    int n = v1.size();
                    Predef$.MODULE$.require(v2.size() == n, (Function0 & Serializable)() -> "Both vectors should have same length, found v1 is " + n + " while v2 is " + v2.size());
                    Predef$.MODULE$.require(norm1 >= 0.0 && norm2 >= 0.0, (Function0 & Serializable)() -> "Both norms should be greater or equal to 0.0, found norm1=" + norm1 + ", norm2=" + norm2);
                    sqDist = 0.0;
                    if (!(v1 instanceof DenseVector) || !(v2 instanceof DenseVector)) break block0;
                    sqDist = Vectors$.MODULE$.sqdist(v1, v2);
                    break block1;
                }
                sumSquaredNorm = norm1 * norm1 + norm2 * norm2;
                double normDiff = norm1 - norm2;
                double precisionBound1 = 2.0 * this.EPSILON() * sumSquaredNorm / (normDiff * normDiff + this.EPSILON());
                if (!(precisionBound1 < precision)) break block2;
                sqDist = sumSquaredNorm - 2.0 * BLAS$.MODULE$.dot(v1, v2);
                break block1;
            }
            double dotValue = BLAS$.MODULE$.dot(v1, v2);
            sqDist = scala.math.package$.MODULE$.max(sumSquaredNorm - 2.0 * dotValue, 0.0);
            double precisionBound2 = this.EPSILON() * (sumSquaredNorm + 2.0 * scala.math.package$.MODULE$.abs(dotValue)) / (sqDist + this.EPSILON());
            if (!(precisionBound2 > precision)) break block1;
            sqDist = Vectors$.MODULE$.sqdist(v1, v2);
        }
        return sqDist;
    }

    public double fastSquaredDistance$default$5() {
        return 1.0E-6;
    }

    public double log1pExp(double x) {
        if (x > 0.0) {
            return x + scala.math.package$.MODULE$.log1p(scala.math.package$.MODULE$.exp(-x));
        }
        return scala.math.package$.MODULE$.log1p(scala.math.package$.MODULE$.exp(x));
    }

    public void optimizerFailed(Instrumentation instr, Class<?> optimizerClass) {
        MessageWithContext msg = this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " failed."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.OPTIMIZER_CLASS_NAME$.MODULE$, (Object)optimizerClass.getName())}));
        instr.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> msg));
        throw new SparkException(msg.message());
    }

    public static final /* synthetic */ int $anonfun$computeNumFeatures$1(Tuple3 x0$1) {
        Tuple3 tuple3 = x0$1;
        if (tuple3 != null) {
            int[] indices = (int[])tuple3._2();
            return BoxesRunTime.unboxToInt((Object)ArrayOps$.MODULE$.lastOption$extension(Predef$.MODULE$.intArrayOps(indices)).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
        }
        throw new MatchError((Object)tuple3);
    }

    public static final /* synthetic */ boolean $anonfun$parseLibSVMFile$2(String line) {
        return !line.isEmpty() && !line.startsWith("#");
    }

    public static final /* synthetic */ Tuple2 $anonfun$kFold$1(float numFoldsF$1, RDD rdd$1, long seed$1, ClassTag evidence$2$1, int fold) {
        BernoulliCellSampler sampler = new BernoulliCellSampler((double)((float)(fold - 1) / numFoldsF$1), (double)((float)fold / numFoldsF$1), false);
        PartitionwiseSampledRDD validation = new PartitionwiseSampledRDD(rdd$1, (RandomSampler)sampler, true, seed$1, evidence$2$1, evidence$2$1);
        PartitionwiseSampledRDD training = new PartitionwiseSampledRDD(rdd$1, (RandomSampler)sampler.cloneComplement(), true, seed$1, evidence$2$1, evidence$2$1);
        return new Tuple2((Object)training, (Object)validation);
    }

    public static final /* synthetic */ Tuple2 $anonfun$kFold$3(Dataset df$1, UserDefinedFunction checker$1, Column foldCol$1, String foldColName$1, int fold) {
        RDD training = df$1.filter(checker$1.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{foldCol$1})).$amp$amp((Object)foldCol$1.$eq$bang$eq((Object)BoxesRunTime.boxToInteger((int)fold)))).drop(foldColName$1).rdd();
        RDD validation = df$1.filter(checker$1.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{foldCol$1})).$amp$amp((Object)foldCol$1.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)fold)))).drop(foldColName$1).rdd();
        if (training.isEmpty()) {
            throw new SparkException("The training data at fold " + fold + " is empty.");
        }
        if (validation.isEmpty()) {
            throw new SparkException("The validation data at fold " + fold + " is empty.");
        }
        return new Tuple2((Object)training, (Object)validation);
    }

    public static final /* synthetic */ boolean $anonfun$convertVectorColumnsToML$3(StructField x$4) {
        Class clazz = x$4.dataType().getClass();
        Class<org.apache.spark.mllib.linalg.VectorUDT> clazz2 = org.apache.spark.mllib.linalg.VectorUDT.class;
        return !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$convertVectorColumnsFromML$3(StructField x$6) {
        Class clazz = x$6.dataType().getClass();
        Class<VectorUDT> clazz2 = VectorUDT.class;
        return !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$convertMatrixColumnsToML$3(StructField x$8) {
        Class clazz = x$8.dataType().getClass();
        Class<MatrixUDT> clazz2 = MatrixUDT.class;
        return !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$convertMatrixColumnsFromML$3(StructField x$10) {
        Class clazz = x$10.dataType().getClass();
        Class<org.apache.spark.ml.linalg.MatrixUDT> clazz2 = org.apache.spark.ml.linalg.MatrixUDT.class;
        return !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null);
    }

    private MLUtils$() {
    }
}

