/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.coursier.cache;

import coursierapi.shaded.coursier.cache.ArchiveCache$;
import coursierapi.shaded.coursier.cache.ArchiveType;
import coursierapi.shaded.coursier.cache.ArtifactError;
import coursierapi.shaded.coursier.cache.Cache;
import coursierapi.shaded.coursier.cache.CacheLocks$;
import coursierapi.shaded.coursier.cache.CacheLogger;
import coursierapi.shaded.coursier.cache.CacheLogger$;
import coursierapi.shaded.coursier.cache.UnArchiver;
import coursierapi.shaded.coursier.core.Authentication;
import coursierapi.shaded.coursier.paths.CachePath;
import coursierapi.shaded.coursier.util.Artifact;
import coursierapi.shaded.coursier.util.Monad$ops$;
import coursierapi.shaded.coursier.util.Sync;
import coursierapi.shaded.scala.$less$colon$less$;
import coursierapi.shaded.scala.Array;
import coursierapi.shaded.scala.Array$;
import coursierapi.shaded.scala.Array$UnapplySeqWrapper$;
import coursierapi.shaded.scala.Function0;
import coursierapi.shaded.scala.Function1;
import coursierapi.shaded.scala.MatchError;
import coursierapi.shaded.scala.None$;
import coursierapi.shaded.scala.Option;
import coursierapi.shaded.scala.Product;
import coursierapi.shaded.scala.Some;
import coursierapi.shaded.scala.collection.Iterator;
import coursierapi.shaded.scala.package$;
import coursierapi.shaded.scala.runtime.BoxesRunTime;
import coursierapi.shaded.scala.runtime.Statics;
import coursierapi.shaded.scala.util.Either;
import coursierapi.shaded.scala.util.Left;
import coursierapi.shaded.scala.util.Right;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;

public final class ArchiveCache<F>
implements Serializable,
Product {
    private final File location;
    private final Cache<F> cache;
    private final UnArchiver unArchiver;
    private final Sync<F> sync;

    @Override
    public Iterator<Object> productIterator() {
        return Product.productIterator$(this);
    }

    public File location() {
        return this.location;
    }

    public Cache<F> cache() {
        return this.cache;
    }

    public UnArchiver unArchiver() {
        return this.unArchiver;
    }

    public Sync<F> sync() {
        return this.sync;
    }

    private Sync<F> S() {
        return this.sync();
    }

    private File localDir(Artifact artifact) {
        return CachePath.localFile(artifact.url(), this.location(), (String)artifact.authentication().map((Function1<Authentication, String> & Serializable)x$1 -> x$1.user()).orNull($less$colon$less$.MODULE$.refl()), true);
    }

    public F getIfExists(Artifact artifact) {
        File dir = this.localDir(artifact);
        ArchiveType archiveType0 = ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$archiveType(artifact.url());
        Object dirTask = Monad$ops$.MODULE$.toAllMonadOps(this.S().delay(() -> dir.exists()), this.sync()).map((Function1<Object, Either> & Serializable)x0$1 -> ArchiveCache.$anonfun$getIfExists$2(dir, BoxesRunTime.unboxToBoolean(x0$1)));
        return archiveType0.singleFile() ? Monad$ops$.MODULE$.toAllMonadOps(dirTask, this.sync()).flatMap((Function1<Either, Object> & Serializable)x0$2 -> {
            Object f;
            Right right;
            Option option;
            Either either = x0$2;
            if (either instanceof Right && (option = (Option)(right = (Right)either).value()) instanceof Some) {
                Some some = (Some)option;
                File dir = (File)some.value();
                f = this.S().delay((Function0<Either> & Serializable)() -> {
                    Right right;
                    Object object;
                    File[] fileArray = dir.listFiles();
                    if (fileArray != null && !Array$UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq(fileArray)) && new Array.UnapplySeqWrapper(Array$UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 1) == 0) {
                        File f = (File)Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                        right = package$.MODULE$.Right().apply(new Some<File>(f));
                    } else {
                        right = package$.MODULE$.Right().apply(new Some<File>(dir));
                    }
                    return right;
                });
            } else {
                f = this.S().point(either);
            }
            return f;
        }) : dirTask;
    }

    public F get(Artifact artifact) {
        File dir = this.localDir(artifact);
        ArchiveType archiveType0 = ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$archiveType(artifact.url());
        Object downloadAndExtract = Monad$ops$.MODULE$.toAllMonadOps(((CacheLogger)this.cache().loggerOpt().getOrElse((Function0<CacheLogger> & Serializable)() -> CacheLogger$.MODULE$.nop())).using().apply(this.cache().file(artifact).run(), this.sync()), this.sync()).flatMap((Function1<Either, Object> & Serializable)x0$1 -> {
            Object object;
            Either either = x0$1;
            if (either instanceof Left) {
                Left left = (Left)either;
                ArtifactError err = (ArtifactError)left.value();
                object = this.S().point(package$.MODULE$.Left().apply(err));
            } else if (either instanceof Right) {
                Right right = (Right)either;
                File f = (File)right.value();
                object = this.extract$1(f, false, dir, archiveType0);
            } else {
                throw new MatchError(either);
            }
            return object;
        });
        Object dirTask = Monad$ops$.MODULE$.toAllMonadOps(this.S().delay(() -> dir.exists()), this.sync()).flatMap((Function1<Object, Object> & Serializable)x0$2 -> ArchiveCache.$anonfun$get$7(this, artifact, dir, downloadAndExtract, archiveType0, BoxesRunTime.unboxToBoolean(x0$2)));
        return archiveType0.singleFile() ? Monad$ops$.MODULE$.toAllMonadOps(dirTask, this.sync()).flatMap((Function1<Either, Object> & Serializable)x0$4 -> {
            Object f;
            Either either = x0$4;
            if (either instanceof Right) {
                Right right = (Right)either;
                File dir = (File)right.value();
                f = this.S().delay((Function0<Either> & Serializable)() -> {
                    Right right;
                    Object object;
                    File[] fileArray = dir.listFiles();
                    if (fileArray != null && !Array$UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq(fileArray)) && new Array.UnapplySeqWrapper(Array$UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 1) == 0) {
                        File f = (File)Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                        right = package$.MODULE$.Right().apply(f);
                    } else {
                        right = package$.MODULE$.Right().apply(dir);
                    }
                    return right;
                });
            } else {
                f = this.S().point(either);
            }
            return f;
        }) : dirTask;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("ArchiveCache(");
        b.append(String.valueOf(this.location()));
        b.append(", ");
        b.append(String.valueOf(this.cache()));
        b.append(", ");
        b.append(String.valueOf(this.unArchiver()));
        b.append(", ");
        b.append(String.valueOf(this.sync()));
        b.append(")");
        return b.toString();
    }

    public boolean canEqual(Object obj) {
        return obj != null && obj instanceof ArchiveCache && true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!this.canEqual(obj)) return false;
        ArchiveCache other = (ArchiveCache)obj;
        if (!true) return false;
        File file = this.location();
        File file2 = other.location();
        if (file == null) {
            if (file2 != null) {
                return false;
            }
        } else if (!((Object)file).equals(file2)) return false;
        Cache<F> cache = this.cache();
        Cache<F> cache2 = other.cache();
        if (cache == null) {
            if (cache2 != null) {
                return false;
            }
        } else if (!cache.equals(cache2)) return false;
        UnArchiver unArchiver = this.unArchiver();
        UnArchiver unArchiver2 = other.unArchiver();
        if (unArchiver == null) {
            if (unArchiver2 != null) {
                return false;
            }
        } else if (!unArchiver.equals(unArchiver2)) return false;
        Sync<F> sync = this.sync();
        Sync<F> sync2 = other.sync();
        if (sync == null) {
            if (sync2 == null) return true;
            return false;
        } else {
            if (!sync.equals(sync2)) return false;
            return true;
        }
    }

    public int hashCode() {
        int code = 17 + Statics.anyHash("ArchiveCache");
        code = 37 * code + Statics.anyHash(this.location());
        code = 37 * code + Statics.anyHash(this.cache());
        code = 37 * code + Statics.anyHash(this.unArchiver());
        code = 37 * code + Statics.anyHash(this.sync());
        return 37 * code;
    }

    @Override
    public String productPrefix() {
        return "ArchiveCache";
    }

    @Override
    public int productArity() {
        return 4;
    }

    @Override
    public Object productElement(int n) {
        Sync<F> sync;
        int n2 = n;
        switch (n2) {
            case 0: {
                sync = this.location();
                break;
            }
            case 1: {
                sync = this.cache();
                break;
            }
            case 2: {
                sync = this.unArchiver();
                break;
            }
            case 3: {
                sync = this.sync();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(n2));
            }
        }
        return sync;
    }

    public static final /* synthetic */ Either $anonfun$getIfExists$2(File dir$1, boolean x0$1) {
        Right right;
        boolean bl = x0$1;
        if (bl) {
            right = package$.MODULE$.Right().apply(new Some<File>(dir$1));
        } else if (!bl) {
            right = package$.MODULE$.Right().apply(None$.MODULE$);
        } else {
            throw new MatchError(BoxesRunTime.boxToBoolean(bl));
        }
        return right;
    }

    private static final void moveToDest$1(File tmp$1, File dir$3) {
        Files.move(tmp$1.toPath(), dir$3.toPath(), StandardCopyOption.ATOMIC_MOVE);
    }

    private final Object extract$1(File f, boolean deleteDest, File dir$3, ArchiveType archiveType0$1) {
        return this.S().delay((Function0<Right> & Serializable)() -> {
            CacheLocks$.MODULE$.withLockOr(this.location(), dir$3, () -> {
                block4: {
                    if (!deleteDest && dir$3.exists()) break block4;
                    File tmp = CachePath.temporaryFile(dir$3);
                    ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$deleteRecursive(tmp);
                    Files.createDirectories(tmp.toPath(), new FileAttribute[0]);
                    this.unArchiver().extract(archiveType0$1, f, tmp, false);
                    FileTime lastModifiedTime = Files.getLastModifiedTime(f.toPath(), new LinkOption[0]);
                    Files.setLastModifiedTime(tmp.toPath(), lastModifiedTime);
                    if (dir$3.exists()) {
                        if (deleteDest) {
                            ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$deleteRecursive(dir$3);
                            ArchiveCache.moveToDest$1(tmp, dir$3);
                        } else {
                            ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$deleteRecursive(tmp);
                        }
                    } else {
                        ArchiveCache.moveToDest$1(tmp, dir$3);
                    }
                }
            }, (Function0<None$> & Serializable)() -> {
                Thread.sleep(50L);
                return None$.MODULE$;
            });
            return package$.MODULE$.Right().apply(dir$3);
        });
    }

    public static final /* synthetic */ Object $anonfun$get$7(ArchiveCache $this, Artifact artifact$1, File dir$3, Object downloadAndExtract$1, ArchiveType archiveType0$1, boolean x0$2) {
        Object object;
        boolean bl = x0$2;
        if (bl) {
            object = artifact$1.changing() ? Monad$ops$.MODULE$.toAllMonadOps(((CacheLogger)$this.cache().loggerOpt().getOrElse((Function0<CacheLogger> & Serializable)() -> CacheLogger$.MODULE$.nop())).using().apply($this.cache().file(artifact$1).run(), $this.sync()), $this.sync()).flatMap((Function1<Either, Object> & Serializable)x0$3 -> {
                Object object;
                Either either = x0$3;
                if (either instanceof Left) {
                    Left left = (Left)either;
                    ArtifactError err = (ArtifactError)left.value();
                    object = $this.S().point(package$.MODULE$.Left().apply(err));
                } else if (either instanceof Right) {
                    Right right = (Right)either;
                    File f = (File)right.value();
                    FileTime archiveLastModifiedTime = Files.getLastModifiedTime(f.toPath(), new LinkOption[0]);
                    FileTime dirLastModifiedTime = Files.getLastModifiedTime(dir$3.toPath(), new LinkOption[0]);
                    FileTime fileTime = archiveLastModifiedTime;
                    FileTime fileTime2 = dirLastModifiedTime;
                    object = !(fileTime != null ? !((Object)fileTime).equals(fileTime2) : fileTime2 != null) ? $this.S().point(package$.MODULE$.Right().apply(dir$3)) : $this.extract$1(f, true, dir$3, archiveType0$1);
                } else {
                    throw new MatchError(either);
                }
                return object;
            }) : $this.S().point(package$.MODULE$.Right().apply(dir$3));
        } else if (!bl) {
            object = downloadAndExtract$1;
        } else {
            throw new MatchError(BoxesRunTime.boxToBoolean(bl));
        }
        return object;
    }

    public ArchiveCache(File location, Cache<F> cache, UnArchiver unArchiver, Sync<F> sync) {
        this.location = location;
        this.cache = cache;
        this.unArchiver = unArchiver;
        this.sync = sync;
        Product.$init$(this);
    }
}

