/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.commonscompress.archivers.zip;

import coursierapi.shaded.commonscompress.archivers.ArchiveEntry;
import coursierapi.shaded.commonscompress.archivers.zip.ExtraFieldParsingBehavior;
import coursierapi.shaded.commonscompress.archivers.zip.ExtraFieldUtils;
import coursierapi.shaded.commonscompress.archivers.zip.GeneralPurposeBit;
import coursierapi.shaded.commonscompress.archivers.zip.UnparseableExtraFieldData;
import coursierapi.shaded.commonscompress.archivers.zip.UnrecognizedExtraField;
import coursierapi.shaded.commonscompress.archivers.zip.X000A_NTFS;
import coursierapi.shaded.commonscompress.archivers.zip.X5455_ExtendedTimestamp;
import coursierapi.shaded.commonscompress.archivers.zip.ZipExtraField;
import coursierapi.shaded.commonscompress.archivers.zip.ZipShort;
import coursierapi.shaded.commonscompress.archivers.zip.ZipUtil;
import coursierapi.shaded.commonscompress.utils.ByteUtils;
import coursierapi.shaded.commonscompress.utils.TimeUtils;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;

public class ZipArchiveEntry
extends ZipEntry
implements ArchiveEntry {
    static final ZipArchiveEntry[] EMPTY_ARRAY = new ZipArchiveEntry[0];
    private int method = -1;
    private long size = -1L;
    private int internalAttributes;
    private int versionRequired;
    private int versionMadeBy;
    private int platform = 0;
    private int rawFlag;
    private long externalAttributes;
    private ZipExtraField[] extraFields;
    private UnparseableExtraFieldData unparseableExtra;
    private String name;
    private byte[] rawName;
    private GeneralPurposeBit gpb = new GeneralPurposeBit();
    private long localHeaderOffset = -1L;
    private long dataOffset = -1L;
    private boolean isStreamContiguous;
    private NameSource nameSource = NameSource.NAME;
    private CommentSource commentSource = CommentSource.COMMENT;
    private long diskNumberStart;
    private boolean lastModifiedDateSet = false;
    private long time = -1L;

    private static boolean canConvertToInfoZipExtendedTimestamp(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime creationTime) {
        return TimeUtils.isUnixTime(lastModifiedTime) && TimeUtils.isUnixTime(lastAccessTime) && TimeUtils.isUnixTime(creationTime);
    }

    protected ZipArchiveEntry() {
        this("");
    }

    public ZipArchiveEntry(String name) {
        super(name);
        this.setName(name);
    }

    public void addAsFirstExtraField(ZipExtraField ze) {
        if (ze instanceof UnparseableExtraFieldData) {
            this.unparseableExtra = (UnparseableExtraFieldData)ze;
        } else {
            if (this.getExtraField(ze.getHeaderId()) != null) {
                this.internalRemoveExtraField(ze.getHeaderId());
            }
            ZipExtraField[] copy = this.extraFields;
            int newLen = this.extraFields != null ? this.extraFields.length + 1 : 1;
            this.extraFields = new ZipExtraField[newLen];
            this.extraFields[0] = ze;
            if (copy != null) {
                System.arraycopy(copy, 0, this.extraFields, 1, this.extraFields.length - 1);
            }
        }
        this.setExtra();
    }

    private void addInfoZipExtendedTimestamp(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime creationTime) {
        X5455_ExtendedTimestamp infoZipTimestamp = new X5455_ExtendedTimestamp();
        if (lastModifiedTime != null) {
            infoZipTimestamp.setModifyFileTime(lastModifiedTime);
        }
        if (lastAccessTime != null) {
            infoZipTimestamp.setAccessFileTime(lastAccessTime);
        }
        if (creationTime != null) {
            infoZipTimestamp.setCreateFileTime(creationTime);
        }
        this.internalAddExtraField(infoZipTimestamp);
    }

    private void addNTFSTimestamp(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime creationTime) {
        X000A_NTFS ntfsTimestamp = new X000A_NTFS();
        if (lastModifiedTime != null) {
            ntfsTimestamp.setModifyFileTime(lastModifiedTime);
        }
        if (lastAccessTime != null) {
            ntfsTimestamp.setAccessFileTime(lastAccessTime);
        }
        if (creationTime != null) {
            ntfsTimestamp.setCreateFileTime(creationTime);
        }
        this.internalAddExtraField(ntfsTimestamp);
    }

    @Override
    public Object clone() {
        ZipArchiveEntry e = (ZipArchiveEntry)super.clone();
        e.setInternalAttributes(this.getInternalAttributes());
        e.setExternalAttributes(this.getExternalAttributes());
        e.setExtraFields(this.getAllExtraFieldsNoCopy());
        return e;
    }

    private ZipExtraField[] copyOf(ZipExtraField[] src, int length) {
        return Arrays.copyOf(src, length);
    }

    public boolean equals(Object obj) {
        String otherName;
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ZipArchiveEntry other = (ZipArchiveEntry)obj;
        String myName = this.getName();
        if (!Objects.equals(myName, otherName = other.getName())) {
            return false;
        }
        String myComment = this.getComment();
        String otherComment = other.getComment();
        if (myComment == null) {
            myComment = "";
        }
        if (otherComment == null) {
            otherComment = "";
        }
        return Objects.equals(this.getLastModifiedTime(), other.getLastModifiedTime()) && Objects.equals(this.getLastAccessTime(), other.getLastAccessTime()) && Objects.equals(this.getCreationTime(), other.getCreationTime()) && myComment.equals(otherComment) && this.getInternalAttributes() == other.getInternalAttributes() && this.getPlatform() == other.getPlatform() && this.getExternalAttributes() == other.getExternalAttributes() && this.getMethod() == other.getMethod() && this.getSize() == other.getSize() && this.getCrc() == other.getCrc() && this.getCompressedSize() == other.getCompressedSize() && Arrays.equals(this.getCentralDirectoryExtra(), other.getCentralDirectoryExtra()) && Arrays.equals(this.getLocalFileDataExtra(), other.getLocalFileDataExtra()) && this.localHeaderOffset == other.localHeaderOffset && this.dataOffset == other.dataOffset && this.gpb.equals(other.gpb);
    }

    private ZipExtraField[] getAllExtraFieldsNoCopy() {
        if (this.extraFields == null) {
            return this.getUnparseableOnly();
        }
        return this.unparseableExtra != null ? this.getMergedFields() : this.extraFields;
    }

    public byte[] getCentralDirectoryExtra() {
        return ExtraFieldUtils.mergeCentralDirectoryData(this.getAllExtraFieldsNoCopy());
    }

    public long getDataOffset() {
        return this.dataOffset;
    }

    public long getDiskNumberStart() {
        return this.diskNumberStart;
    }

    public long getExternalAttributes() {
        return this.externalAttributes;
    }

    public ZipExtraField getExtraField(ZipShort type) {
        if (this.extraFields != null) {
            for (ZipExtraField extraField : this.extraFields) {
                if (!type.equals(extraField.getHeaderId())) continue;
                return extraField;
            }
        }
        return null;
    }

    public GeneralPurposeBit getGeneralPurposeBit() {
        return this.gpb;
    }

    public int getInternalAttributes() {
        return this.internalAttributes;
    }

    public byte[] getLocalFileDataExtra() {
        byte[] extra = this.getExtra();
        return extra != null ? extra : ByteUtils.EMPTY_BYTE_ARRAY;
    }

    protected long getLocalHeaderOffset() {
        return this.localHeaderOffset;
    }

    private ZipExtraField[] getMergedFields() {
        ZipExtraField[] zipExtraFields = this.copyOf(this.extraFields, this.extraFields.length + 1);
        zipExtraFields[this.extraFields.length] = this.unparseableExtra;
        return zipExtraFields;
    }

    @Override
    public int getMethod() {
        return this.method;
    }

    @Override
    public String getName() {
        return this.name == null ? super.getName() : this.name;
    }

    public int getPlatform() {
        return this.platform;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public long getTime() {
        if (this.lastModifiedDateSet) {
            return this.getLastModifiedTime().toMillis();
        }
        return this.time != -1L ? this.time : super.getTime();
    }

    public int getUnixMode() {
        return this.platform != 3 ? 0 : (int)(this.getExternalAttributes() >> 16 & 0xFFFFL);
    }

    private ZipExtraField[] getUnparseableOnly() {
        ZipExtraField[] zipExtraFieldArray;
        if (this.unparseableExtra == null) {
            zipExtraFieldArray = ExtraFieldUtils.EMPTY_ZIP_EXTRA_FIELD_ARRAY;
        } else {
            ZipExtraField[] zipExtraFieldArray2 = new ZipExtraField[1];
            zipExtraFieldArray = zipExtraFieldArray2;
            zipExtraFieldArray2[0] = this.unparseableExtra;
        }
        return zipExtraFieldArray;
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    private void internalAddExtraField(ZipExtraField ze) {
        if (ze instanceof UnparseableExtraFieldData) {
            this.unparseableExtra = (UnparseableExtraFieldData)ze;
        } else if (this.extraFields == null) {
            this.extraFields = new ZipExtraField[]{ze};
        } else {
            if (this.getExtraField(ze.getHeaderId()) != null) {
                this.internalRemoveExtraField(ze.getHeaderId());
            }
            ZipExtraField[] zipExtraFields = this.copyOf(this.extraFields, this.extraFields.length + 1);
            zipExtraFields[zipExtraFields.length - 1] = ze;
            this.extraFields = zipExtraFields;
        }
    }

    private void internalRemoveExtraField(ZipShort type) {
        if (this.extraFields == null) {
            return;
        }
        ArrayList<ZipExtraField> newResult = new ArrayList<ZipExtraField>();
        for (ZipExtraField extraField : this.extraFields) {
            if (type.equals(extraField.getHeaderId())) continue;
            newResult.add(extraField);
        }
        if (this.extraFields.length == newResult.size()) {
            return;
        }
        this.extraFields = newResult.toArray(ExtraFieldUtils.EMPTY_ZIP_EXTRA_FIELD_ARRAY);
    }

    private void internalSetLastModifiedTime(FileTime time) {
        super.setLastModifiedTime(time);
        this.time = time.toMillis();
        this.lastModifiedDateSet = true;
    }

    @Override
    public boolean isDirectory() {
        return this.getName().endsWith("/");
    }

    public boolean isUnixSymlink() {
        return (this.getUnixMode() & 0xF000) == 40960;
    }

    private void mergeExtraFields(ZipExtraField[] f, boolean local) {
        if (this.extraFields == null) {
            this.setExtraFields(f);
        } else {
            for (ZipExtraField element : f) {
                ZipExtraField existing = element instanceof UnparseableExtraFieldData ? this.unparseableExtra : this.getExtraField(element.getHeaderId());
                if (existing == null) {
                    this.internalAddExtraField(element);
                    continue;
                }
                byte[] b = local ? element.getLocalFileDataData() : element.getCentralDirectoryData();
                try {
                    if (local) {
                        existing.parseFromLocalFileData(b, 0, b.length);
                        continue;
                    }
                    existing.parseFromCentralDirectoryData(b, 0, b.length);
                }
                catch (ZipException ex) {
                    UnrecognizedExtraField u = new UnrecognizedExtraField();
                    u.setHeaderId(existing.getHeaderId());
                    if (local) {
                        u.setLocalFileDataData(b);
                        u.setCentralDirectoryData(existing.getCentralDirectoryData());
                    } else {
                        u.setLocalFileDataData(existing.getLocalFileDataData());
                        u.setCentralDirectoryData(b);
                    }
                    this.internalRemoveExtraField(existing.getHeaderId());
                    this.internalAddExtraField(u);
                }
            }
            this.setExtra();
        }
    }

    private boolean requiresExtraTimeFields() {
        if (this.getLastAccessTime() != null || this.getCreationTime() != null) {
            return true;
        }
        return this.lastModifiedDateSet;
    }

    public void setCentralDirectoryExtra(byte[] b) {
        try {
            this.mergeExtraFields(ExtraFieldUtils.parse(b, false, ExtraFieldParsingMode.BEST_EFFORT), false);
        }
        catch (ZipException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public void setCommentSource(CommentSource commentSource) {
        this.commentSource = commentSource;
    }

    @Override
    public ZipEntry setCreationTime(FileTime time) {
        super.setCreationTime(time);
        this.setExtraTimeFields();
        return this;
    }

    protected void setDataOffset(long dataOffset) {
        this.dataOffset = dataOffset;
    }

    public void setDiskNumberStart(long diskNumberStart) {
        this.diskNumberStart = diskNumberStart;
    }

    public void setExternalAttributes(long value) {
        this.externalAttributes = value;
    }

    protected void setExtra() {
        super.setExtra(ExtraFieldUtils.mergeLocalFileDataData(this.getAllExtraFieldsNoCopy()));
        this.updateTimeFieldsFromExtraFields();
    }

    @Override
    public void setExtra(byte[] extra) throws RuntimeException {
        try {
            this.mergeExtraFields(ExtraFieldUtils.parse(extra, true, ExtraFieldParsingMode.BEST_EFFORT), true);
        }
        catch (ZipException e) {
            throw new IllegalArgumentException("Error parsing extra fields for entry: " + this.getName() + " - " + e.getMessage(), e);
        }
    }

    public void setExtraFields(ZipExtraField[] fields) {
        this.unparseableExtra = null;
        ArrayList<ZipExtraField> newFields = new ArrayList<ZipExtraField>();
        if (fields != null) {
            for (ZipExtraField field : fields) {
                if (field instanceof UnparseableExtraFieldData) {
                    this.unparseableExtra = (UnparseableExtraFieldData)field;
                    continue;
                }
                newFields.add(field);
            }
        }
        this.extraFields = newFields.toArray(ExtraFieldUtils.EMPTY_ZIP_EXTRA_FIELD_ARRAY);
        this.setExtra();
    }

    private void setExtraTimeFields() {
        if (this.getExtraField(X5455_ExtendedTimestamp.HEADER_ID) != null) {
            this.internalRemoveExtraField(X5455_ExtendedTimestamp.HEADER_ID);
        }
        if (this.getExtraField(X000A_NTFS.HEADER_ID) != null) {
            this.internalRemoveExtraField(X000A_NTFS.HEADER_ID);
        }
        if (this.requiresExtraTimeFields()) {
            FileTime creationTime;
            FileTime lastAccessTime;
            FileTime lastModifiedTime = this.getLastModifiedTime();
            if (ZipArchiveEntry.canConvertToInfoZipExtendedTimestamp(lastModifiedTime, lastAccessTime = this.getLastAccessTime(), creationTime = this.getCreationTime())) {
                this.addInfoZipExtendedTimestamp(lastModifiedTime, lastAccessTime, creationTime);
            }
            this.addNTFSTimestamp(lastModifiedTime, lastAccessTime, creationTime);
        }
        this.setExtra();
    }

    public void setGeneralPurposeBit(GeneralPurposeBit b) {
        this.gpb = b;
    }

    public void setInternalAttributes(int value) {
        this.internalAttributes = value;
    }

    @Override
    public ZipEntry setLastAccessTime(FileTime time) {
        super.setLastAccessTime(time);
        this.setExtraTimeFields();
        return this;
    }

    @Override
    public ZipEntry setLastModifiedTime(FileTime time) {
        this.internalSetLastModifiedTime(time);
        this.setExtraTimeFields();
        return this;
    }

    protected void setLocalHeaderOffset(long localHeaderOffset) {
        this.localHeaderOffset = localHeaderOffset;
    }

    @Override
    public void setMethod(int method) {
        if (method < 0) {
            throw new IllegalArgumentException("ZIP compression method can not be negative: " + method);
        }
        this.method = method;
    }

    protected void setName(String name) {
        if (name != null && this.getPlatform() == 0 && !name.contains("/")) {
            name = name.replace('\\', '/');
        }
        this.name = name;
    }

    protected void setName(String name, byte[] rawName) {
        this.setName(name);
        this.rawName = rawName;
    }

    public void setNameSource(NameSource nameSource) {
        this.nameSource = nameSource;
    }

    protected void setPlatform(int platform) {
        this.platform = platform;
    }

    public void setRawFlag(int rawFlag) {
        this.rawFlag = rawFlag;
    }

    @Override
    public void setSize(long size) {
        if (size < 0L) {
            throw new IllegalArgumentException("Invalid entry size");
        }
        this.size = size;
    }

    protected void setStreamContiguous(boolean isStreamContiguous) {
        this.isStreamContiguous = isStreamContiguous;
    }

    @Override
    public void setTime(long time) {
        if (ZipUtil.isDosTime(time)) {
            super.setTime(time);
            this.time = time;
            this.lastModifiedDateSet = false;
            this.setExtraTimeFields();
        } else {
            this.setLastModifiedTime(FileTime.fromMillis(time));
        }
    }

    public void setVersionMadeBy(int versionMadeBy) {
        this.versionMadeBy = versionMadeBy;
    }

    public void setVersionRequired(int versionRequired) {
        this.versionRequired = versionRequired;
    }

    private void updateTimeFieldsFromExtraFields() {
        this.updateTimeFromExtendedTimestampField();
        this.updateTimeFromNtfsField();
    }

    private void updateTimeFromExtendedTimestampField() {
        ZipExtraField extraField = this.getExtraField(X5455_ExtendedTimestamp.HEADER_ID);
        if (extraField instanceof X5455_ExtendedTimestamp) {
            FileTime creationTime;
            FileTime accessTime;
            FileTime modifyTime;
            X5455_ExtendedTimestamp extendedTimestamp = (X5455_ExtendedTimestamp)extraField;
            if (extendedTimestamp.isBit0_modifyTimePresent() && (modifyTime = extendedTimestamp.getModifyFileTime()) != null) {
                this.internalSetLastModifiedTime(modifyTime);
            }
            if (extendedTimestamp.isBit1_accessTimePresent() && (accessTime = extendedTimestamp.getAccessFileTime()) != null) {
                super.setLastAccessTime(accessTime);
            }
            if (extendedTimestamp.isBit2_createTimePresent() && (creationTime = extendedTimestamp.getCreateFileTime()) != null) {
                super.setCreationTime(creationTime);
            }
        }
    }

    private void updateTimeFromNtfsField() {
        ZipExtraField extraField = this.getExtraField(X000A_NTFS.HEADER_ID);
        if (extraField instanceof X000A_NTFS) {
            FileTime creationTime;
            FileTime accessTime;
            X000A_NTFS ntfsTimestamp = (X000A_NTFS)extraField;
            FileTime modifyTime = ntfsTimestamp.getModifyFileTime();
            if (modifyTime != null) {
                this.internalSetLastModifiedTime(modifyTime);
            }
            if ((accessTime = ntfsTimestamp.getAccessFileTime()) != null) {
                super.setLastAccessTime(accessTime);
            }
            if ((creationTime = ntfsTimestamp.getCreateFileTime()) != null) {
                super.setCreationTime(creationTime);
            }
        }
    }

    public static final class NameSource
    extends Enum<NameSource> {
        public static final /* enum */ NameSource NAME = new NameSource();
        public static final /* enum */ NameSource NAME_WITH_EFS_FLAG = new NameSource();
        public static final /* enum */ NameSource UNICODE_EXTRA_FIELD = new NameSource();
        private static final /* synthetic */ NameSource[] $VALUES;

        static {
            $VALUES = new NameSource[]{NAME, NAME_WITH_EFS_FLAG, UNICODE_EXTRA_FIELD};
        }
    }

    public static class ExtraFieldParsingMode
    extends Enum<ExtraFieldParsingMode>
    implements ExtraFieldParsingBehavior {
        public static final /* enum */ ExtraFieldParsingMode BEST_EFFORT = new ExtraFieldParsingMode(ExtraFieldUtils.UnparseableExtraField.READ){

            @Override
            public ZipExtraField fill(ZipExtraField field, byte[] data, int off, int len, boolean local) {
                return ExtraFieldParsingMode.fillAndMakeUnrecognizedOnError(field, data, off, len, local);
            }
        };
        public static final /* enum */ ExtraFieldParsingMode STRICT_FOR_KNOW_EXTRA_FIELDS = new ExtraFieldParsingMode(ExtraFieldUtils.UnparseableExtraField.READ);
        public static final /* enum */ ExtraFieldParsingMode ONLY_PARSEABLE_LENIENT = new ExtraFieldParsingMode(ExtraFieldUtils.UnparseableExtraField.SKIP){

            @Override
            public ZipExtraField fill(ZipExtraField field, byte[] data, int off, int len, boolean local) {
                return ExtraFieldParsingMode.fillAndMakeUnrecognizedOnError(field, data, off, len, local);
            }
        };
        public static final /* enum */ ExtraFieldParsingMode ONLY_PARSEABLE_STRICT = new ExtraFieldParsingMode(ExtraFieldUtils.UnparseableExtraField.SKIP);
        public static final /* enum */ ExtraFieldParsingMode DRACONIC = new ExtraFieldParsingMode(ExtraFieldUtils.UnparseableExtraField.THROW);
        private final ExtraFieldUtils.UnparseableExtraField onUnparseableData;
        private static final /* synthetic */ ExtraFieldParsingMode[] $VALUES;

        private static ZipExtraField fillAndMakeUnrecognizedOnError(ZipExtraField field, byte[] data, int off, int len, boolean local) {
            try {
                return ExtraFieldUtils.fillExtraField(field, data, off, len, local);
            }
            catch (ZipException ex) {
                UnrecognizedExtraField u = new UnrecognizedExtraField();
                u.setHeaderId(field.getHeaderId());
                if (local) {
                    u.setLocalFileDataData(Arrays.copyOfRange(data, off, off + len));
                } else {
                    u.setCentralDirectoryData(Arrays.copyOfRange(data, off, off + len));
                }
                return u;
            }
        }

        private ExtraFieldParsingMode(ExtraFieldUtils.UnparseableExtraField onUnparseableData) {
            this.onUnparseableData = onUnparseableData;
        }

        @Override
        public ZipExtraField createExtraField(ZipShort headerId) throws ZipException, InstantiationException, IllegalAccessException {
            return ExtraFieldUtils.createExtraField(headerId);
        }

        @Override
        public ZipExtraField fill(ZipExtraField field, byte[] data, int off, int len, boolean local) throws ZipException {
            return ExtraFieldUtils.fillExtraField(field, data, off, len, local);
        }

        @Override
        public ZipExtraField onUnparseableExtraField(byte[] data, int off, int len, boolean local, int claimedLength) throws ZipException {
            return this.onUnparseableData.onUnparseableExtraField(data, off, len, local, claimedLength);
        }

        static {
            $VALUES = new ExtraFieldParsingMode[]{BEST_EFFORT, STRICT_FOR_KNOW_EXTRA_FIELDS, ONLY_PARSEABLE_LENIENT, ONLY_PARSEABLE_STRICT, DRACONIC};
        }
    }

    public static final class CommentSource
    extends Enum<CommentSource> {
        public static final /* enum */ CommentSource COMMENT = new CommentSource();
        public static final /* enum */ CommentSource UNICODE_EXTRA_FIELD = new CommentSource();
        private static final /* synthetic */ CommentSource[] $VALUES;

        static {
            $VALUES = new CommentSource[]{COMMENT, UNICODE_EXTRA_FIELD};
        }
    }
}

