/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.plans.logical.statsEstimation;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeMap$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat$;
import org.apache.spark.sql.catalyst.plans.logical.Histogram;
import org.apache.spark.sql.catalyst.plans.logical.HistogramBin;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.plans.logical.statsEstimation.EstimationUtils;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.Numeric;
import scala.math.Ordered;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class EstimationUtils$ {
    public static EstimationUtils$ MODULE$;

    static {
        new EstimationUtils$();
    }

    public boolean rowCountsExist(Seq<LogicalPlan> plans2) {
        return plans2.forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)EstimationUtils$.$anonfun$rowCountsExist$1(x$1)));
    }

    public boolean columnStatsExist(Seq<Tuple2<Statistics, Attribute>> statsAndAttr) {
        return statsAndAttr.forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)EstimationUtils$.$anonfun$columnStatsExist$1(x0$1)));
    }

    public boolean columnStatsWithCountsExist(Seq<Tuple2<Statistics, Attribute>> statsAndAttr) {
        return statsAndAttr.forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)EstimationUtils$.$anonfun$columnStatsWithCountsExist$1(x0$1)));
    }

    public ColumnStat nullColumnStat(DataType dataType, BigInt rowCount) {
        return new ColumnStat((Option<BigInt>)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<BigInt>)new Some((Object)rowCount), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)dataType.defaultSize())), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)dataType.defaultSize())), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8());
    }

    public Option<BigInt> updateStat(BigInt oldNumRows, BigInt newNumRows, Option<BigInt> oldStatOpt, Option<BigInt> updatedStatOpt) {
        if (oldStatOpt.isDefined() && updatedStatOpt.isDefined() && ((Ordered)updatedStatOpt.get()).$greater((Object)BigInt$.MODULE$.int2bigInt(1)) && newNumRows.$less((Object)oldNumRows)) {
            return new Some((Object)this.ceil(package$.MODULE$.BigDecimal().apply((BigInt)oldStatOpt.get()).$times(package$.MODULE$.BigDecimal().apply(newNumRows)).$div(package$.MODULE$.BigDecimal().apply(oldNumRows))));
        }
        return updatedStatOpt;
    }

    public BigInt ceil(BigDecimal bigDecimal) {
        return bigDecimal.setScale(0, BigDecimal.RoundingMode$.MODULE$.CEILING()).toBigInt();
    }

    public AttributeMap<ColumnStat> getOutputMap(AttributeMap<ColumnStat> inputMap, Seq<Attribute> output) {
        return AttributeMap$.MODULE$.apply((Seq)output.flatMap((Function1 & Serializable & scala.Serializable)a -> Option$.MODULE$.option2Iterable(inputMap.get((Attribute)a).map((Function1 & Serializable & scala.Serializable)x$3 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(a), x$3))), Seq$.MODULE$.canBuildFrom()));
    }

    public Seq<Tuple2<Attribute, ColumnStat>> getAliasStats(Seq<Expression> expressions, AttributeMap<ColumnStat> attributeStats, BigInt rowCount) {
        return (Seq)expressions.collect((PartialFunction)new scala.Serializable(attributeStats, rowCount){
            public static final long serialVersionUID = 0L;
            private final AttributeMap attributeStats$1;
            private final BigInt rowCount$1;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Expression expression;
                Expression expr;
                boolean bl = false;
                Alias alias = null;
                A1 A1 = x1;
                if (A1 instanceof Alias) {
                    Attribute attribute;
                    bl = true;
                    alias = (Alias)A1;
                    Expression attr = alias.child();
                    if (attr instanceof Attribute && this.attributeStats$1.contains(attribute = (Attribute)attr)) {
                        return (B1)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)alias.toAttribute()), this.attributeStats$1.apply(attribute));
                    }
                }
                if (bl && (expr = alias.child()) != null && (expression = expr).foldable() && expression.deterministic()) {
                    Object value = expression.eval(org.apache.spark.sql.catalyst.expressions.package$.MODULE$.EmptyRow());
                    int size = expression.dataType().defaultSize();
                    ColumnStat columnStat = value == null ? new ColumnStat((Option<BigInt>)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<BigInt>)new Some((Object)this.rowCount$1), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)size)), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)size)), (Option<Histogram>)None$.MODULE$, 2) : new ColumnStat((Option<BigInt>)new Some((Object)BigInt$.MODULE$.int2bigInt(1)), (Option<Object>)new Some(value), (Option<Object>)new Some(value), (Option<BigInt>)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)size)), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)size)), (Option<Histogram>)None$.MODULE$, 2);
                    return (B1)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)alias.toAttribute()), (Object)columnStat);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Expression x1) {
                Expression expression;
                Expression expr;
                boolean bl = false;
                Alias alias = null;
                Expression expression2 = x1;
                if (expression2 instanceof Alias) {
                    Attribute attribute;
                    bl = true;
                    alias = (Alias)expression2;
                    Expression attr = alias.child();
                    if (attr instanceof Attribute && this.attributeStats$1.contains(attribute = (Attribute)attr)) {
                        return true;
                    }
                }
                return bl && (expr = alias.child()) != null && (expression = expr).foldable() && expression.deterministic();
            }
            {
                this.attributeStats$1 = attributeStats$1;
                this.rowCount$1 = rowCount$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public BigInt getSizePerRow(Seq<Attribute> attributes, AttributeMap<ColumnStat> attrStats) {
        return BigInt$.MODULE$.long2bigInt(8L + BoxesRunTime.unboxToLong((Object)((TraversableOnce)attributes.map((Function1 & Serializable & scala.Serializable)attr -> BoxesRunTime.boxToLong((long)EstimationUtils$.$anonfun$getSizePerRow$1(attrStats, attr)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
    }

    public AttributeMap<ColumnStat> getSizePerRow$default$2() {
        return AttributeMap$.MODULE$.apply(Nil$.MODULE$);
    }

    public BigInt getOutputSize(Seq<Attribute> attributes, BigInt outputRowCount, AttributeMap<ColumnStat> attrStats) {
        if (outputRowCount.$greater((Object)BigInt$.MODULE$.int2bigInt(0))) {
            return outputRowCount.$times(this.getSizePerRow(attributes, attrStats));
        }
        return BigInt$.MODULE$.int2bigInt(1);
    }

    public AttributeMap<ColumnStat> getOutputSize$default$3() {
        return AttributeMap$.MODULE$.apply(Nil$.MODULE$);
    }

    public double toDouble(Object value, DataType dataType) {
        DataType dataType2 = dataType;
        if (dataType2 instanceof NumericType ? true : (DateType$.MODULE$.equals(dataType2) ? true : TimestampType$.MODULE$.equals(dataType2))) {
            return new StringOps(Predef$.MODULE$.augmentString(value.toString())).toDouble();
        }
        if (BooleanType$.MODULE$.equals(dataType2)) {
            if (BoxesRunTime.unboxToBoolean((Object)value)) {
                return 1.0;
            }
            return 0.0;
        }
        throw new MatchError((Object)dataType2);
    }

    public Object fromDouble(double d, DataType dataType) {
        DataType dataType2 = dataType;
        if (BooleanType$.MODULE$.equals(dataType2)) {
            return BoxesRunTime.boxToBoolean(((int)d == 1 ? 1 : 0) != 0);
        }
        if (DateType$.MODULE$.equals(dataType2)) {
            return BoxesRunTime.boxToInteger((int)((int)d));
        }
        if (TimestampType$.MODULE$.equals(dataType2)) {
            return BoxesRunTime.boxToLong((long)((long)d));
        }
        if (ByteType$.MODULE$.equals(dataType2)) {
            return BoxesRunTime.boxToByte((byte)((byte)d));
        }
        if (ShortType$.MODULE$.equals(dataType2)) {
            return BoxesRunTime.boxToShort((short)((short)d));
        }
        if (IntegerType$.MODULE$.equals(dataType2)) {
            return BoxesRunTime.boxToInteger((int)((int)d));
        }
        if (LongType$.MODULE$.equals(dataType2)) {
            return BoxesRunTime.boxToLong((long)((long)d));
        }
        if (FloatType$.MODULE$.equals(dataType2)) {
            return BoxesRunTime.boxToFloat((float)((float)d));
        }
        if (DoubleType$.MODULE$.equals(dataType2)) {
            return BoxesRunTime.boxToDouble((double)d);
        }
        if (dataType2 instanceof DecimalType) {
            return Decimal$.MODULE$.apply(d);
        }
        throw new MatchError((Object)dataType2);
    }

    private int findFirstBinForValue(double value, HistogramBin[] bins) {
        int i;
        for (i = 0; i < bins.length && value > bins[i].hi(); ++i) {
        }
        return i;
    }

    private int findLastBinForValue(double value, HistogramBin[] bins) {
        int i;
        for (i = bins.length - 1; i >= 0 && value < bins[i].lo(); --i) {
        }
        return i;
    }

    private double binHoldingRangePossibility(double upperBound, double lowerBound, HistogramBin bin) {
        Predef$.MODULE$.assert(bin.lo() <= lowerBound && lowerBound <= upperBound && upperBound <= bin.hi());
        if (bin.hi() == bin.lo()) {
            return 1.0;
        }
        if (upperBound == lowerBound) {
            return 1.0 / (double)bin.ndv();
        }
        return scala.math.package$.MODULE$.min((upperBound - lowerBound) / (bin.hi() - bin.lo()), 1.0);
    }

    /*
     * Unable to fully structure code
     */
    public double numBinsHoldingRange(double upperBound, boolean upperBoundInclusive, double lowerBound, boolean lowerBoundInclusive, HistogramBin[] bins) {
        v0 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])bins));
        if (!(((HistogramBin)v0.head()).lo() <= lowerBound) || !(lowerBound <= upperBound)) ** GOTO lbl-1000
        v1 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])bins));
        if (upperBound <= ((HistogramBin)v1.last()).hi()) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        Predef$.MODULE$.assert(v2, (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$numBinsHoldingRange$1(), ()Ljava/lang/String;)());
        Predef$.MODULE$.assert(upperBound != lowerBound || upperBoundInclusive != false || lowerBoundInclusive != false, (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$numBinsHoldingRange$2(double double ), ()Ljava/lang/String;)((double)lowerBound, (double)upperBound));
        upperBinIndex = upperBoundInclusive != false ? this.findLastBinForValue(upperBound, bins) : this.findFirstBinForValue(upperBound, bins);
        lowerBinIndex = lowerBoundInclusive != false ? this.findFirstBinForValue(lowerBound, bins) : this.findLastBinForValue(lowerBound, bins);
        Predef$.MODULE$.assert(lowerBinIndex <= upperBinIndex, (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$numBinsHoldingRange$3(), ()Ljava/lang/String;)());
        if (lowerBinIndex == upperBinIndex) {
            return this.binHoldingRangePossibility(upperBound, lowerBound, bins[lowerBinIndex]);
        }
        lowerBin = bins[lowerBinIndex];
        lowerPart = this.binHoldingRangePossibility(lowerBin.hi(), lowerBound, lowerBin);
        higherBin = bins[upperBinIndex];
        higherPart = this.binHoldingRangePossibility(upperBound, higherBin.lo(), higherBin);
        return lowerPart + higherPart + (double)upperBinIndex - (double)lowerBinIndex - (double)true;
    }

    public Seq<EstimationUtils.OverlappedRange> getOverlappedRanges(Histogram leftHistogram, Histogram rightHistogram, double lowerBound, double upperBound) {
        ArrayBuffer overlappedRanges = new ArrayBuffer();
        HistogramBin[] leftBins = (HistogramBin[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])leftHistogram.bins())).filter((Function1 & Serializable & scala.Serializable)b -> BoxesRunTime.boxToBoolean((boolean)EstimationUtils$.$anonfun$getOverlappedRanges$1(upperBound, lowerBound, b)));
        HistogramBin[] rightBins = (HistogramBin[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rightHistogram.bins())).filter((Function1 & Serializable & scala.Serializable)b -> BoxesRunTime.boxToBoolean((boolean)EstimationUtils$.$anonfun$getOverlappedRanges$2(upperBound, lowerBound, b)));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])leftBins)).foreach((Function1 & Serializable & scala.Serializable)lb -> {
            EstimationUtils$.$anonfun$getOverlappedRanges$3(rightBins, leftHistogram, lowerBound, upperBound, rightHistogram, overlappedRanges, lb);
            return BoxedUnit.UNIT;
        });
        return overlappedRanges.toSeq();
    }

    public Tuple2<HistogramBin, Object> trimBin(HistogramBin bin, double height, double lowerBound, double upperBound) {
        Tuple2.mcDD.sp sp2;
        Tuple2.mcDD.sp sp3;
        if (bin.lo() <= lowerBound && bin.hi() >= upperBound) {
            sp3 = new Tuple2.mcDD.sp(lowerBound, upperBound);
        } else if (bin.lo() <= lowerBound && bin.hi() >= lowerBound) {
            sp3 = new Tuple2.mcDD.sp(lowerBound, bin.hi());
        } else if (bin.lo() <= upperBound && bin.hi() >= upperBound) {
            sp3 = new Tuple2.mcDD.sp(bin.lo(), upperBound);
        } else {
            Predef$.MODULE$.assert(bin.lo() >= lowerBound && bin.hi() <= upperBound);
            sp3 = sp2 = new Tuple2.mcDD.sp(bin.lo(), bin.hi());
        }
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        double lo = sp2._1$mcD$sp();
        double hi = sp2._2$mcD$sp();
        Tuple2.mcDD.sp sp4 = new Tuple2.mcDD.sp(lo, hi);
        double lo2 = sp4._1$mcD$sp();
        double hi2 = sp4._2$mcD$sp();
        if (hi2 == lo2) {
            return new Tuple2((Object)new HistogramBin(lo2, hi2, 1L), (Object)BoxesRunTime.boxToDouble((double)(height / (double)bin.ndv())));
        }
        Predef$.MODULE$.assert(bin.hi() != bin.lo());
        double ratio = (hi2 - lo2) / (bin.hi() - bin.lo());
        return new Tuple2((Object)new HistogramBin(lo2, hi2, (long)scala.math.package$.MODULE$.ceil((double)bin.ndv() * ratio)), (Object)BoxesRunTime.boxToDouble((double)(height * ratio)));
    }

    public static final /* synthetic */ boolean $anonfun$rowCountsExist$1(LogicalPlan x$1) {
        return x$1.stats().rowCount().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$columnStatsExist$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Statistics stats = (Statistics)tuple2._1();
            Attribute attr = (Attribute)tuple2._2();
            return stats.attributeStats().contains(attr);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$columnStatsWithCountsExist$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Statistics stats = (Statistics)tuple2._1();
            Attribute attr = (Attribute)tuple2._2();
            return BoxesRunTime.unboxToBoolean((Object)stats.attributeStats().get(attr).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.hasCountStats())).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$getSizePerRow$2(ColumnStat x$4) {
        return x$4.avgLen().isDefined();
    }

    public static final /* synthetic */ long $anonfun$getSizePerRow$1(AttributeMap attrStats$1, Attribute attr) {
        if (BoxesRunTime.unboxToBoolean((Object)attrStats$1.get(attr).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)EstimationUtils$.$anonfun$getSizePerRow$2(x$4))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false))) {
            DataType dataType = attr.dataType();
            if (StringType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.unboxToLong((Object)((ColumnStat)attrStats$1.apply(attr)).avgLen().get()) + 8L + 4L;
            }
            return BoxesRunTime.unboxToLong((Object)((ColumnStat)attrStats$1.apply(attr)).avgLen().get());
        }
        return attr.dataType().defaultSize();
    }

    public static final /* synthetic */ String $anonfun$numBinsHoldingRange$1() {
        return "Given range does not fit in the given histogram.";
    }

    public static final /* synthetic */ String $anonfun$numBinsHoldingRange$2(double lowerBound$1, double upperBound$1) {
        return new StringBuilder(34).append("'").append(lowerBound$1).append(" < value < ").append(upperBound$1).append("' is an invalid range.").toString();
    }

    public static final /* synthetic */ String $anonfun$numBinsHoldingRange$3() {
        return "Invalid histogram data.";
    }

    public static final /* synthetic */ boolean $anonfun$getOverlappedRanges$1(double upperBound$2, double lowerBound$2, HistogramBin b) {
        return b.lo() <= upperBound$2 && b.hi() >= lowerBound$2;
    }

    public static final /* synthetic */ boolean $anonfun$getOverlappedRanges$2(double upperBound$2, double lowerBound$2, HistogramBin b) {
        return b.lo() <= upperBound$2 && b.hi() >= lowerBound$2;
    }

    public static final /* synthetic */ void $anonfun$getOverlappedRanges$3(HistogramBin[] rightBins$1, Histogram leftHistogram$1, double lowerBound$2, double upperBound$2, Histogram rightHistogram$1, ArrayBuffer overlappedRanges$1, HistogramBin lb) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rightBins$1)).foreach((Function1 & Serializable & scala.Serializable)rb -> {
            Tuple2<HistogramBin, Object> tuple2 = MODULE$.trimBin(lb, leftHistogram$1.height(), lowerBound$2, upperBound$2);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            HistogramBin left = (HistogramBin)tuple2._1();
            double leftHeight = tuple2._2$mcD$sp();
            Tuple2 tuple22 = new Tuple2((Object)left, (Object)BoxesRunTime.boxToDouble((double)leftHeight));
            HistogramBin left2 = (HistogramBin)tuple22._1();
            double leftHeight2 = tuple22._2$mcD$sp();
            Tuple2<HistogramBin, Object> tuple23 = MODULE$.trimBin((HistogramBin)rb, rightHistogram$1.height(), lowerBound$2, upperBound$2);
            if (tuple23 == null) {
                throw new MatchError(tuple23);
            }
            HistogramBin right = (HistogramBin)tuple23._1();
            double rightHeight = tuple23._2$mcD$sp();
            Tuple2 tuple24 = new Tuple2((Object)right, (Object)BoxesRunTime.boxToDouble((double)rightHeight));
            HistogramBin right2 = (HistogramBin)tuple24._1();
            double rightHeight2 = tuple24._2$mcD$sp();
            if (left2.lo() <= right2.hi() && left2.hi() >= right2.lo()) {
                EstimationUtils.OverlappedRange overlappedRange;
                if (right2.lo() >= left2.lo() && right2.hi() >= left2.hi()) {
                    if (left2.hi() == right2.lo()) {
                        overlappedRange = new EstimationUtils.OverlappedRange(right2.lo(), right2.lo(), 1.0, 1.0, leftHeight2 / (double)left2.ndv(), rightHeight2 / (double)right2.ndv());
                    } else {
                        double leftRatio = (left2.hi() - right2.lo()) / (left2.hi() - left2.lo());
                        double rightRatio = (left2.hi() - right2.lo()) / (right2.hi() - right2.lo());
                        overlappedRange = new EstimationUtils.OverlappedRange(right2.lo(), left2.hi(), (double)left2.ndv() * leftRatio, (double)right2.ndv() * rightRatio, leftHeight2 * leftRatio, rightHeight2 * rightRatio);
                    }
                } else if (right2.lo() <= left2.lo() && right2.hi() <= left2.hi()) {
                    if (right2.hi() == left2.lo()) {
                        overlappedRange = new EstimationUtils.OverlappedRange(right2.hi(), right2.hi(), 1.0, 1.0, leftHeight2 / (double)left2.ndv(), rightHeight2 / (double)right2.ndv());
                    } else {
                        double leftRatio = (right2.hi() - left2.lo()) / (left2.hi() - left2.lo());
                        double rightRatio = (right2.hi() - left2.lo()) / (right2.hi() - right2.lo());
                        overlappedRange = new EstimationUtils.OverlappedRange(left2.lo(), right2.hi(), (double)left2.ndv() * leftRatio, (double)right2.ndv() * rightRatio, leftHeight2 * leftRatio, rightHeight2 * rightRatio);
                    }
                } else if (right2.lo() >= left2.lo() && right2.hi() <= left2.hi()) {
                    double leftRatio = (right2.hi() - right2.lo()) / (left2.hi() - left2.lo());
                    overlappedRange = new EstimationUtils.OverlappedRange(right2.lo(), right2.hi(), (double)left2.ndv() * leftRatio, right2.ndv(), leftHeight2 * leftRatio, rightHeight2);
                } else {
                    Predef$.MODULE$.assert(right2.lo() <= left2.lo() && right2.hi() >= left2.hi());
                    double rightRatio = (left2.hi() - left2.lo()) / (right2.hi() - right2.lo());
                    overlappedRange = new EstimationUtils.OverlappedRange(left2.lo(), left2.hi(), left2.ndv(), (double)right2.ndv() * rightRatio, leftHeight2, rightHeight2 * rightRatio);
                }
                EstimationUtils.OverlappedRange range = overlappedRange;
                return overlappedRanges$1.$plus$eq((Object)range);
            }
            return BoxedUnit.UNIT;
        });
    }

    private EstimationUtils$() {
        MODULE$ = this;
    }
}

