/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.optimizer;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.SubqueryExpression;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.logical.Except;
import org.apache.spark.sql.catalyst.plans.logical.HintErrorHandler;
import org.apache.spark.sql.catalyst.plans.logical.HintInfo;
import org.apache.spark.sql.catalyst.plans.logical.Intersect;
import org.apache.spark.sql.catalyst.plans.logical.Join;
import org.apache.spark.sql.catalyst.plans.logical.JoinHint;
import org.apache.spark.sql.catalyst.plans.logical.JoinHint$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.ResolvedHint;
import org.apache.spark.sql.catalyst.plans.logical.UnaryNode;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.internal.SQLConf$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;

public final class EliminateResolvedHint$
extends Rule<LogicalPlan> {
    public static EliminateResolvedHint$ MODULE$;
    private final HintErrorHandler org$apache$spark$sql$catalyst$optimizer$EliminateResolvedHint$$hintErrorHandler;

    static {
        new EliminateResolvedHint$();
    }

    public HintErrorHandler org$apache$spark$sql$catalyst$optimizer$EliminateResolvedHint$$hintErrorHandler() {
        return this.org$apache$spark$sql$catalyst$optimizer$EliminateResolvedHint$$hintErrorHandler;
    }

    @Override
    public LogicalPlan apply(LogicalPlan plan2) {
        LogicalPlan joinsWithHints = (LogicalPlan)plan2.transformUp(new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof Join) {
                    Join join = (Join)A1;
                    JoinHint joinHint = join.hint();
                    JoinHint joinHint2 = JoinHint$.MODULE$.NONE();
                    if (!(joinHint != null ? !((Object)joinHint).equals(joinHint2) : joinHint2 != null)) {
                        Tuple2<LogicalPlan, Seq<HintInfo>> tuple2 = EliminateResolvedHint$.MODULE$.extractHintsFromPlan(join.left());
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        LogicalPlan newLeft = (LogicalPlan)tuple2._1();
                        Seq leftHints = (Seq)tuple2._2();
                        Tuple2 tuple22 = new Tuple2((Object)newLeft, (Object)leftHints);
                        LogicalPlan newLeft2 = (LogicalPlan)tuple22._1();
                        Seq leftHints2 = (Seq)tuple22._2();
                        Tuple2<LogicalPlan, Seq<HintInfo>> tuple23 = EliminateResolvedHint$.MODULE$.extractHintsFromPlan(join.right());
                        if (tuple23 == null) {
                            throw new MatchError(tuple23);
                        }
                        LogicalPlan newRight = (LogicalPlan)tuple23._1();
                        Seq rightHints = (Seq)tuple23._2();
                        Tuple2 tuple24 = new Tuple2((Object)newRight, (Object)rightHints);
                        LogicalPlan newRight2 = (LogicalPlan)tuple24._1();
                        Seq rightHints2 = (Seq)tuple24._2();
                        JoinHint newJoinHint = new JoinHint(EliminateResolvedHint$.MODULE$.org$apache$spark$sql$catalyst$optimizer$EliminateResolvedHint$$mergeHints((Seq<HintInfo>)leftHints2), EliminateResolvedHint$.MODULE$.org$apache$spark$sql$catalyst$optimizer$EliminateResolvedHint$$mergeHints((Seq<HintInfo>)rightHints2));
                        LogicalPlan x$1 = newLeft2;
                        LogicalPlan x$2 = newRight2;
                        JoinHint x$3 = newJoinHint;
                        JoinType x$4 = join.copy$default$3();
                        Option<Expression> x$5 = join.copy$default$4();
                        return (B1)join.copy(x$1, x$2, x$4, x$5, x$3);
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                if (logicalPlan instanceof Join) {
                    Join join = (Join)logicalPlan;
                    JoinHint joinHint = join.hint();
                    JoinHint joinHint2 = JoinHint$.MODULE$.NONE();
                    if (!(joinHint != null ? !((Object)joinHint).equals(joinHint2) : joinHint2 != null)) {
                        return true;
                    }
                }
                return false;
            }
        });
        boolean shouldPullHintsIntoSubqueries = BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.PULL_HINTS_INTO_SUBQUERIES()));
        LogicalPlan joinsAndSubqueriesWithHints = shouldPullHintsIntoSubqueries ? this.pullHintsIntoSubqueries(joinsWithHints) : joinsWithHints;
        return (LogicalPlan)joinsAndSubqueriesWithHints.transformUp(new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (A1 instanceof ResolvedHint) {
                    ResolvedHint resolvedHint = (ResolvedHint)A1;
                    EliminateResolvedHint$.MODULE$.org$apache$spark$sql$catalyst$optimizer$EliminateResolvedHint$$hintErrorHandler().joinNotFoundForJoinHint(resolvedHint.hints());
                    return (B1)resolvedHint.child();
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(LogicalPlan x2) {
                LogicalPlan logicalPlan = x2;
                return logicalPlan instanceof ResolvedHint;
            }
        });
    }

    public LogicalPlan pullHintsIntoSubqueries(LogicalPlan plan2) {
        return plan2.transformAllExpressionsWithPruning((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.containsPattern(TreePattern$.MODULE$.PLAN_EXPRESSION())), plan2.transformAllExpressionsWithPruning$default$2(), (PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                SubqueryExpression subqueryExpression;
                A1 A1 = x1;
                if (A1 instanceof SubqueryExpression && (subqueryExpression = (SubqueryExpression)A1).hint().isEmpty()) {
                    Tuple2<LogicalPlan, Seq<HintInfo>> tuple2 = EliminateResolvedHint$.MODULE$.extractHintsFromPlan((LogicalPlan)subqueryExpression.plan());
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    LogicalPlan newPlan = (LogicalPlan)tuple2._1();
                    Seq subqueryHints = (Seq)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)newPlan, (Object)subqueryHints);
                    LogicalPlan newPlan2 = (LogicalPlan)tuple22._1();
                    Seq subqueryHints2 = (Seq)tuple22._2();
                    Option<HintInfo> newHint = EliminateResolvedHint$.MODULE$.org$apache$spark$sql$catalyst$optimizer$EliminateResolvedHint$$mergeHints((Seq<HintInfo>)subqueryHints2);
                    return (B1)subqueryExpression.withNewPlan(newPlan2).withNewHint(newHint);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Expression x1) {
                SubqueryExpression subqueryExpression;
                Expression expression = x1;
                return expression instanceof SubqueryExpression && (subqueryExpression = (SubqueryExpression)expression).hint().isEmpty();
            }
        });
    }

    public Option<HintInfo> org$apache$spark$sql$catalyst$optimizer$EliminateResolvedHint$$mergeHints(Seq<HintInfo> hints) {
        return hints.reduceOption((Function2 & Serializable & scala.Serializable)(h1, h2) -> h1.merge((HintInfo)h2, MODULE$.org$apache$spark$sql$catalyst$optimizer$EliminateResolvedHint$$hintErrorHandler()));
    }

    public Tuple2<LogicalPlan, Seq<HintInfo>> extractHintsFromPlan(LogicalPlan plan2) {
        LogicalPlan logicalPlan = plan2;
        if (logicalPlan instanceof ResolvedHint) {
            ResolvedHint resolvedHint = (ResolvedHint)logicalPlan;
            Tuple2<LogicalPlan, Seq<HintInfo>> tuple2 = this.extractHintsFromPlan(resolvedHint.child());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            LogicalPlan plan3 = (LogicalPlan)tuple2._1();
            Seq hints = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)plan3, (Object)hints);
            LogicalPlan plan4 = (LogicalPlan)tuple22._1();
            Seq hints2 = (Seq)tuple22._2();
            HintInfo hintInfo = resolvedHint.hints();
            return new Tuple2((Object)plan4, hints2.$plus$colon((Object)hintInfo, Seq$.MODULE$.canBuildFrom()));
        }
        if (logicalPlan instanceof UnaryNode) {
            UnaryNode unaryNode = (UnaryNode)((Object)logicalPlan);
            Tuple2<LogicalPlan, Seq<HintInfo>> tuple2 = this.extractHintsFromPlan((LogicalPlan)unaryNode.child());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            LogicalPlan plan5 = (LogicalPlan)tuple2._1();
            Seq hints = (Seq)tuple2._2();
            Tuple2 tuple23 = new Tuple2((Object)plan5, (Object)hints);
            LogicalPlan plan6 = (LogicalPlan)tuple23._1();
            Seq hints3 = (Seq)tuple23._2();
            return new Tuple2(((TreeNode)((Object)unaryNode)).withNewChildren((Seq)new .colon.colon((Object)plan6, (List)Nil$.MODULE$)), (Object)hints3);
        }
        if (logicalPlan instanceof Intersect) {
            Intersect intersect = (Intersect)logicalPlan;
            Tuple2<LogicalPlan, Seq<HintInfo>> tuple2 = this.extractHintsFromPlan(intersect.left());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            LogicalPlan plan7 = (LogicalPlan)tuple2._1();
            Seq hints = (Seq)tuple2._2();
            Tuple2 tuple24 = new Tuple2((Object)plan7, (Object)hints);
            LogicalPlan plan8 = (LogicalPlan)tuple24._1();
            Seq hints4 = (Seq)tuple24._2();
            return new Tuple2((Object)intersect.copy(plan8, intersect.copy$default$2(), intersect.copy$default$3()), (Object)hints4);
        }
        if (logicalPlan instanceof Except) {
            Except except = (Except)logicalPlan;
            Tuple2<LogicalPlan, Seq<HintInfo>> tuple2 = this.extractHintsFromPlan(except.left());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            LogicalPlan plan9 = (LogicalPlan)tuple2._1();
            Seq hints = (Seq)tuple2._2();
            Tuple2 tuple25 = new Tuple2((Object)plan9, (Object)hints);
            LogicalPlan plan10 = (LogicalPlan)tuple25._1();
            Seq hints5 = (Seq)tuple25._2();
            return new Tuple2((Object)except.copy(plan10, except.copy$default$2(), except.copy$default$3()), (Object)hints5);
        }
        if (logicalPlan != null) {
            LogicalPlan logicalPlan2 = logicalPlan;
            return new Tuple2((Object)logicalPlan2, (Object)Nil$.MODULE$);
        }
        throw new MatchError((Object)logicalPlan);
    }

    private EliminateResolvedHint$() {
        MODULE$ = this;
        this.org$apache$spark$sql$catalyst$optimizer$EliminateResolvedHint$$hintErrorHandler = this.conf().hintErrorHandler();
    }
}

