/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.codegen;

import java.io.Serializable;
import java.util.regex.Matcher;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeAndComment;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeFormatter;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.matching.Regex;

public final class CodeFormatter$ {
    public static CodeFormatter$ MODULE$;
    private final Regex commentHolder;
    private final Regex commentRegexp;
    private final Regex extraNewLinesRegexp;

    static {
        new CodeFormatter$();
    }

    public Regex commentHolder() {
        return this.commentHolder;
    }

    public Regex commentRegexp() {
        return this.commentRegexp;
    }

    public Regex extraNewLinesRegexp() {
        return this.extraNewLinesRegexp;
    }

    public String format(CodeAndComment code, int maxLines) {
        CodeFormatter formatter;
        block0: {
            formatter = new CodeFormatter();
            String[] lines = code.body().split("\n");
            boolean needToTruncate = maxLines >= 0 && lines.length > maxLines;
            String[] filteredLines = needToTruncate ? (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])lines)).take(maxLines) : lines;
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredLines)).foreach((Function1 & Serializable & scala.Serializable)line -> {
                CodeFormatter$.$anonfun$format$1(code, formatter, line);
                return BoxedUnit.UNIT;
            });
            if (!needToTruncate) break block0;
            formatter.org$apache$spark$sql$catalyst$expressions$codegen$CodeFormatter$$addLine(new StringBuilder(39).append("[truncated to ").append(maxLines).append(" lines (total lines is ").append(lines.length).append(")]").toString());
        }
        return formatter.org$apache$spark$sql$catalyst$expressions$codegen$CodeFormatter$$result();
    }

    public int format$default$2() {
        return -1;
    }

    public String stripExtraNewLines(String input) {
        scala.collection.mutable.StringBuilder code = new scala.collection.mutable.StringBuilder();
        ObjectRef lastLine = ObjectRef.create((Object)"dummy");
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(input)).split('\n'))).foreach((Function1 & Serializable & scala.Serializable)l -> {
            CodeFormatter$.$anonfun$stripExtraNewLines$1(lastLine, code, l);
            return BoxedUnit.UNIT;
        });
        return code.result();
    }

    public CodeAndComment stripOverlappingComments(CodeAndComment codeAndComment) {
        scala.collection.mutable.StringBuilder code = new scala.collection.mutable.StringBuilder();
        Map<String, String> map = codeAndComment.comment();
        ObjectRef lastLine = ObjectRef.create((Object)"dummy");
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(codeAndComment.body())).split('\n'))).foreach((Function1 & Serializable & scala.Serializable)l -> {
            CodeFormatter$.$anonfun$stripOverlappingComments$1(lastLine, code, map, l);
            return BoxedUnit.UNIT;
        });
        return new CodeAndComment(code.result().trim(), map);
    }

    public String stripExtraNewLinesAndComments(String input) {
        return this.extraNewLinesRegexp().replaceAllIn((CharSequence)this.commentRegexp().replaceAllIn((CharSequence)input, ""), "\n");
    }

    public static final /* synthetic */ void $anonfun$format$1(CodeAndComment code$1, CodeFormatter formatter$1, String line2) {
        String commentReplaced = MODULE$.commentHolder().replaceAllIn((CharSequence)line2.trim(), (Function1 & Serializable & scala.Serializable)m -> (String)code$1.comment().get((Object)m.group(1)).map((Function1 & Serializable & scala.Serializable)x$1 -> Matcher.quoteReplacement(x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> m.group(0)));
        String[] comments = commentReplaced.split("\n");
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])comments)).foreach((Function1 & Serializable & scala.Serializable)line -> {
            formatter$1.org$apache$spark$sql$catalyst$expressions$codegen$CodeFormatter$$addLine(line);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$stripExtraNewLines$1(ObjectRef lastLine$1, scala.collection.mutable.StringBuilder code$2, String l) {
        v0 = line = l.trim();
        var5_4 = "";
        if (v0 != null ? v0.equals(var5_4) == false : var5_4 != null) ** GOTO lbl-1000
        v1 = (String)lastLine$1.elem;
        var6_5 = "";
        if (!(v1 == null ? var6_5 != null : v1.equals(var6_5) == false) || ((String)lastLine$1.elem).endsWith("{") || ((String)lastLine$1.elem).endsWith("*/")) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = skip = false;
        }
        if (!skip) {
            code$2.append(line);
            v3 = code$2.append("\n");
        } else {
            v3 = BoxedUnit.UNIT;
        }
        lastLine$1.elem = line;
    }

    private static final Option getComment$1(String line, Map map$1) {
        if (line.startsWith("/*") && line.endsWith("*/")) {
            return map$1.get((Object)line.substring(2, line.length() - 2));
        }
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$stripOverlappingComments$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String lastComment = (String)tuple2._1();
            String currentComment = (String)tuple2._2();
            return lastComment.substring(3).contains(currentComment.substring(3));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$stripOverlappingComments$1(ObjectRef lastLine$2, scala.collection.mutable.StringBuilder code$3, Map map$1, String l) {
        String line = l.trim();
        boolean skip = ((IterableLike)Option$.MODULE$.option2Iterable(CodeFormatter$.getComment$1((String)lastLine$2.elem, map$1)).zip((GenIterable)Option$.MODULE$.option2Iterable(CodeFormatter$.getComment$1(line, map$1)), Iterable$.MODULE$.canBuildFrom())).exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)CodeFormatter$.$anonfun$stripOverlappingComments$2(x0$1)));
        Object object = !skip ? code$3.append(line).append("\n") : BoxedUnit.UNIT;
        lastLine$2.elem = line;
    }

    private CodeFormatter$() {
        MODULE$ = this;
        this.commentHolder = new StringOps(Predef$.MODULE$.augmentString("\\/\\*(.+?)\\*\\/")).r();
        this.commentRegexp = new StringOps(Predef$.MODULE$.augmentString("([ |\\t]*?\\/\\*[\\s|\\S]*?\\*\\/[ |\\t]*?)|([ |\\t]*?\\/\\/[\\s\\S]*?\\n)")).r();
        this.extraNewLinesRegexp = new StringOps(Predef$.MODULE$.augmentString("\\n\\s*\\n")).r();
    }
}

