/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.csv;

import com.univocity.parsers.csv.CsvParser;
import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.csv.CSVExprUtils$;
import org.apache.spark.sql.catalyst.csv.CSVHeaderChecker$;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005ma\u0001\u0002\n\u0014\u0001\u0001B\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\ti\u0001\u0011\t\u0011)A\u0005k!A\u0011\b\u0001B\u0001B\u0003%!\b\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003G\u0011\u0015I\u0005\u0001\"\u0001K\u0011\u001d\u0001\u0006A1A\u0005\nECaA\u0015\u0001!\u0002\u00131\u0005bB*\u0001\u0005\u0004%I!\u0015\u0005\u0007)\u0002\u0001\u000b\u0011\u0002$\t\u000bU\u0003A\u0011\u0002,\t\u000bU\u0003A\u0011A0\t\rU\u0003A\u0011A\nc\u0011\u0019)\u0006\u0001\"\u0001\u0014a\u001e9QpEA\u0001\u0012\u0003qha\u0002\n\u0014\u0003\u0003E\ta \u0005\u0007\u0013>!\t!!\u0001\t\u0013\u0005\rq\"%A\u0005\u0002\u0005\u0015!\u0001E\"T-\"+\u0017\rZ3s\u0007\",7m[3s\u0015\t!R#A\u0002dgZT!AF\f\u0002\u0011\r\fG/\u00197zgRT!\u0001G\r\u0002\u0007M\fHN\u0003\u0002\u001b7\u0005)1\u000f]1sW*\u0011A$H\u0001\u0007CB\f7\r[3\u000b\u0003y\t1a\u001c:h\u0007\u0001\u00192\u0001A\u0011(!\t\u0011S%D\u0001$\u0015\u0005!\u0013!B:dC2\f\u0017B\u0001\u0014$\u0005\u0019\te.\u001f*fMB\u0011\u0001fK\u0007\u0002S)\u0011!&G\u0001\tS:$XM\u001d8bY&\u0011A&\u000b\u0002\b\u0019><w-\u001b8h\u0003\u0019\u00198\r[3nCB\u0011qFM\u0007\u0002a)\u0011\u0011gF\u0001\u0006if\u0004Xm]\u0005\u0003gA\u0012!b\u0015;sk\u000e$H+\u001f9f\u0003\u001dy\u0007\u000f^5p]N\u0004\"AN\u001c\u000e\u0003MI!\u0001O\n\u0003\u0015\r\u001bfk\u00149uS>t7/\u0001\u0004t_V\u00148-\u001a\t\u0003w\ts!\u0001\u0010!\u0011\u0005u\u001aS\"\u0001 \u000b\u0005}z\u0012A\u0002\u001fs_>$h(\u0003\u0002BG\u00051\u0001K]3eK\u001aL!a\u0011#\u0003\rM#(/\u001b8h\u0015\t\t5%A\u0007jgN#\u0018M\u001d;PM\u001aKG.\u001a\t\u0003E\u001dK!\u0001S\u0012\u0003\u000f\t{w\u000e\\3b]\u00061A(\u001b8jiz\"Ra\u0013'N\u001d>\u0003\"A\u000e\u0001\t\u000b5*\u0001\u0019\u0001\u0018\t\u000bQ*\u0001\u0019A\u001b\t\u000be*\u0001\u0019\u0001\u001e\t\u000f\u0015+\u0001\u0013!a\u0001\r\u0006i1-Y:f'\u0016t7/\u001b;jm\u0016,\u0012AR\u0001\u000fG\u0006\u001cXmU3og&$\u0018N^3!\u00035)gNZ8sG\u0016\u001c6\r[3nC\u0006qQM\u001c4pe\u000e,7k\u00195f[\u0006\u0004\u0013AF2iK\u000e\\\u0007*Z1eKJ\u001cu\u000e\\;n]:\u000bW.Z:\u0015\u0005]S\u0006C\u0001\u0012Y\u0013\tI6E\u0001\u0003V]&$\b\"B.\u000b\u0001\u0004a\u0016aC2pYVlgNT1nKN\u00042AI/;\u0013\tq6EA\u0003BeJ\f\u0017\u0010\u0006\u0002XA\")\u0011m\u0003a\u0001u\u0005!A.\u001b8f)\t96\rC\u0003e\u0019\u0001\u0007Q-A\u0005u_.,g.\u001b>feB\u0011aM\\\u0007\u0002O*\u0011A\u0003\u001b\u0006\u0003S*\fq\u0001]1sg\u0016\u00148O\u0003\u0002lY\u0006IQO\\5w_\u000eLG/\u001f\u0006\u0002[\u0006\u00191m\\7\n\u0005=<'!C\"tmB\u000b'o]3s)\r9\u0016\u000f \u0005\u0006e6\u0001\ra]\u0001\u0006Y&tWm\u001d\t\u0004ifTdBA;x\u001d\tid/C\u0001%\u0013\tA8%A\u0004qC\u000e\\\u0017mZ3\n\u0005i\\(\u0001C%uKJ\fGo\u001c:\u000b\u0005a\u001c\u0003\"\u00023\u000e\u0001\u0004)\u0017\u0001E\"T-\"+\u0017\rZ3s\u0007\",7m[3s!\t1tb\u0005\u0002\u0010CQ\ta0A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003\u000fQ3ARA\u0005W\t\tY\u0001\u0005\u0003\u0002\u000e\u0005]QBAA\b\u0015\u0011\t\t\"a\u0005\u0002\u0013Ut7\r[3dW\u0016$'bAA\u000bG\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005e\u0011q\u0002\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class CSVHeaderChecker
implements Logging {
    private final StructType schema;
    private final CSVOptions options;
    private final String source;
    private final boolean isStartOfFile;
    private final boolean caseSensitive;
    private final boolean enforceSchema;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static boolean $lessinit$greater$default$4() {
        return CSVHeaderChecker$.MODULE$.$lessinit$greater$default$4();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private boolean caseSensitive() {
        return this.caseSensitive;
    }

    private boolean enforceSchema() {
        return this.enforceSchema;
    }

    private void checkHeaderColumnNames(String[] columnNames) {
        if (columnNames != null) {
            IndexedSeq fieldNames = ((TraversableOnce)this.schema.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Seq$.MODULE$.canBuildFrom())).toIndexedSeq();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])columnNames)).size(), fieldNames.length());
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            int headerLen = sp2._1$mcI$sp();
            int schemaSize = sp2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(headerLen, schemaSize);
            int headerLen2 = sp3._1$mcI$sp();
            int schemaSize2 = sp3._2$mcI$sp();
            None$ errorMessage = None$.MODULE$;
            if (headerLen2 == schemaSize2) {
                for (int i = 0; errorMessage.isEmpty() && i < headerLen2; ++i) {
                    Tuple2 tuple2 = new Tuple2(fieldNames.apply(i), (Object)columnNames[i]);
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String nameInSchema = (String)tuple2._1();
                    String nameInHeader = (String)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)nameInSchema, (Object)nameInHeader);
                    String nameInSchema2 = (String)tuple22._1();
                    String nameInHeader2 = (String)tuple22._2();
                    if (!this.caseSensitive()) {
                        nameInSchema2 = nameInSchema2.toLowerCase();
                        nameInHeader2 = nameInHeader2.toLowerCase();
                    }
                    String string = nameInHeader2;
                    String string2 = nameInSchema2;
                    if (!(string == null ? string2 != null : !string.equals(string2))) continue;
                    errorMessage = new Some((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(163).append("|CSV header does not conform to the schema.\n                  | Header: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])columnNames)).mkString(", ")).append("\n                  | Schema: ").append(fieldNames.mkString(", ")).append("\n                  |Expected: ").append(fieldNames.apply(i)).append(" but found: ").append(columnNames[i]).append("\n                  |").append(this.source).toString())).stripMargin());
                }
            } else {
                errorMessage = new Some((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(142).append("|Number of column in CSV header is not equal to number of fields in the schema:\n              | Header length: ").append(headerLen2).append(", schema size: ").append(schemaSize2).append("\n              |").append(this.source).toString())).stripMargin());
            }
            errorMessage.foreach((Function1 & Serializable & scala.Serializable)msg -> {
                CSVHeaderChecker.$anonfun$checkHeaderColumnNames$2(this, msg);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public void checkHeaderColumnNames(String line) {
        if (this.options.headerFlag()) {
            CsvParser parser = new CsvParser(this.options.asParserSettings());
            this.checkHeaderColumnNames(parser.parseLine(line));
            return;
        }
    }

    public void checkHeaderColumnNames(CsvParser tokenizer) {
        Predef$.MODULE$.assert(this.options.multiLine(), (Function0 & Serializable & scala.Serializable)() -> "This method should be executed with multiLine.");
        if (this.options.headerFlag()) {
            String[] firstRecord = tokenizer.parseNext();
            this.checkHeaderColumnNames(firstRecord);
            return;
        }
    }

    public void checkHeaderColumnNames(Iterator<String> lines, CsvParser tokenizer) {
        Predef$.MODULE$.assert(!this.options.multiLine(), (Function0 & Serializable & scala.Serializable)() -> "This method should not be executed with multiline.");
        if (this.options.headerFlag() && this.isStartOfFile) {
            CSVExprUtils$.MODULE$.extractHeader(lines, this.options).foreach((Function1 & Serializable & scala.Serializable)header -> {
                this.checkHeaderColumnNames(tokenizer.parseLine(header));
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$checkHeaderColumnNames$2(CSVHeaderChecker $this, String msg) {
        if ($this.enforceSchema()) {
            $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg);
            return;
        }
        throw new IllegalArgumentException(msg);
    }

    public CSVHeaderChecker(StructType schema, CSVOptions options, String source, boolean isStartOfFile) {
        this.schema = schema;
        this.options = options;
        this.source = source;
        this.isStartOfFile = isStartOfFile;
        Logging.$init$((Logging)this);
        this.caseSensitive = SQLConf$.MODULE$.get().caseSensitiveAnalysis();
        this.enforceSchema = options.enforceSchema();
    }
}

