/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.CastSupport;
import org.apache.spark.sql.catalyst.analysis.ResolvedInlineTable;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedInlineTable;
import org.apache.spark.sql.catalyst.analysis.package$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.EvalHelper;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.optimizer.EvalInlineTables$;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.catalyst.trees.AlwaysProcess$;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ResolveInlineTables$
extends Rule<LogicalPlan>
implements CastSupport,
AliasHelper,
EvalHelper {
    public static ResolveInlineTables$ MODULE$;

    static {
        new ResolveInlineTables$();
    }

    @Override
    public Expression prepareForEval(Expression e) {
        return EvalHelper.prepareForEval$(this, e);
    }

    @Override
    public AttributeMap<Alias> getAliasMap(Project plan2) {
        return AliasHelper.getAliasMap$((AliasHelper)this, plan2);
    }

    @Override
    public AttributeMap<Alias> getAliasMap(Aggregate plan2) {
        return AliasHelper.getAliasMap$((AliasHelper)this, plan2);
    }

    @Override
    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    @Override
    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$(this, expr, aliasMap);
    }

    @Override
    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$(this, expr, aliasMap);
    }

    @Override
    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$(this, e);
    }

    @Override
    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$(this, e);
    }

    @Override
    public Cast cast(Expression child, DataType dataType) {
        return CastSupport.cast$(this, child, dataType);
    }

    @Override
    public LogicalPlan apply(LogicalPlan plan2) {
        return plan2.resolveOperatorsWithPruning(AlwaysProcess$.MODULE$.fn(), this.ruleId(), (PartialFunction<LogicalPlan, LogicalPlan>)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                UnresolvedInlineTable unresolvedInlineTable;
                A1 A1 = x1;
                if (A1 instanceof UnresolvedInlineTable && (unresolvedInlineTable = (UnresolvedInlineTable)A1).expressionsResolved()) {
                    ResolveInlineTables$.MODULE$.validateInputDimension(unresolvedInlineTable);
                    ResolveInlineTables$.MODULE$.validateInputEvaluable(unresolvedInlineTable);
                    ResolvedInlineTable resolvedTable = ResolveInlineTables$.MODULE$.findCommonTypesAndCast(unresolvedInlineTable);
                    return (B1)ResolveInlineTables$.MODULE$.earlyEvalIfPossible(resolvedTable);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                UnresolvedInlineTable unresolvedInlineTable;
                LogicalPlan logicalPlan = x1;
                return logicalPlan instanceof UnresolvedInlineTable && (unresolvedInlineTable = (UnresolvedInlineTable)logicalPlan).expressionsResolved();
            }
        });
    }

    public void validateInputDimension(UnresolvedInlineTable table) {
        if (table.rows().nonEmpty()) {
            int numCols = table.names().size();
            ((IterableLike)table.rows().zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                ResolveInlineTables$.$anonfun$validateInputDimension$1(numCols, table, x0$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public void validateInputEvaluable(UnresolvedInlineTable table) {
        table.rows().foreach((Function1 & Serializable & scala.Serializable)row -> {
            row.foreach((Function1 & Serializable & scala.Serializable)e -> {
                ResolveInlineTables$.$anonfun$validateInputEvaluable$2(e);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
    }

    public ResolvedInlineTable findCommonTypesAndCast(UnresolvedInlineTable table) {
        Seq fields = (Seq)((TraversableLike)((IterableLike)table.rows().transpose((Function1)Predef$.MODULE$.$conforms())).zip(table.names(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Seq column = (Seq)tuple2._1();
                String name = (String)tuple2._2();
                Seq inputTypes = (Seq)column.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.dataType(), Seq$.MODULE$.canBuildFrom());
                DataType tpe = (DataType)TypeCoercion$.MODULE$.findWiderTypeWithoutStringPromotion((Seq<DataType>)inputTypes).getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.AnalysisErrorAt(table).failAnalysis("INVALID_INLINE_TABLE.INCOMPATIBLE_TYPES_IN_INLINE_TABLE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colName"), (Object)TypeUtils$.MODULE$.toSQLId(name))})))));
                return new StructField(name, tpe, column.exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.nullable())), StructField$.MODULE$.apply$default$4());
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
        Seq<AttributeReference> attributes = DataTypeUtils$.MODULE$.toAttributes(StructType$.MODULE$.apply(fields));
        Predef$.MODULE$.assert(fields.size() == table.names().size());
        Seq castedRows = (Seq)table.rows().map((Function1 & Serializable & scala.Serializable)row -> (Seq)((TraversableLike)row.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                Expression e = (Expression)tuple2._1();
                int ci = tuple2._2$mcI$sp();
                DataType targetType = ((StructField)fields.apply(ci)).dataType();
                Expression castedExpr = DataTypeUtils$.MODULE$.sameType(e.dataType(), targetType) ? e : MODULE$.cast(e, targetType);
                return castedExpr;
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        return new ResolvedInlineTable((Seq<Seq<Expression>>)castedRows, attributes);
    }

    public LogicalPlan earlyEvalIfPossible(ResolvedInlineTable table) {
        boolean earlyEvalPossible = ((IterableLike)table.rows().flatten((Function1)Predef$.MODULE$.$conforms())).forall((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ResolveInlineTables$.$anonfun$earlyEvalIfPossible$1(x$3)));
        if (earlyEvalPossible) {
            return EvalInlineTables$.MODULE$.apply(table);
        }
        return table;
    }

    public static final /* synthetic */ void $anonfun$validateInputDimension$1(int numCols$1, UnresolvedInlineTable table$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Seq row = (Seq)tuple2._1();
            int rowIndex = tuple2._2$mcI$sp();
            if (row.size() != numCols$1) {
                throw package$.MODULE$.AnalysisErrorAt(table$1).failAnalysis("INVALID_INLINE_TABLE.NUM_COLUMNS_MISMATCH", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expectedNumCols"), (Object)Integer.toString(numCols$1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"actualNumCols"), (Object)Integer.toString(row.size())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rowIndex"), (Object)Integer.toString(rowIndex))}))));
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$validateInputEvaluable$2(Expression e) {
        if (!e.resolved() && !e.containsPattern(TreePattern$.MODULE$.CURRENT_LIKE()) || !MODULE$.trimAliases(MODULE$.prepareForEval(e)).foldable()) {
            throw package$.MODULE$.AnalysisErrorAt(e).failAnalysis("INVALID_INLINE_TABLE.CANNOT_EVALUATE_EXPRESSION_IN_INLINE_TABLE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expr"), (Object)TypeUtils$.MODULE$.toSQLExpr(e))}))));
        }
    }

    public static final /* synthetic */ boolean $anonfun$earlyEvalIfPossible$1(Expression x$3) {
        return !x$3.containsPattern(TreePattern$.MODULE$.CURRENT_LIKE());
    }

    private ResolveInlineTables$() {
        MODULE$ = this;
        CastSupport.$init$(this);
        AliasHelper.$init$(this);
        EvalHelper.$init$(this);
    }
}

