/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.util.Map;
import org.apache.spark.sql.catalyst.WalkedTypePath;
import org.apache.spark.sql.catalyst.WalkedTypePath$;
import org.apache.spark.sql.catalyst.analysis.GetColumnByOrdinal;
import org.apache.spark.sql.catalyst.analysis.UnresolvedExtractValue;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoder;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders;
import org.apache.spark.sql.catalyst.encoders.EncoderUtils$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GetStructField;
import org.apache.spark.sql.catalyst.expressions.GetStructField$;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.IsNull;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.MapKeys;
import org.apache.spark.sql.catalyst.expressions.MapValues;
import org.apache.spark.sql.catalyst.expressions.UpCast;
import org.apache.spark.sql.catalyst.expressions.objects.AssertNotNull;
import org.apache.spark.sql.catalyst.expressions.objects.CreateExternalRow;
import org.apache.spark.sql.catalyst.expressions.objects.InitializeJavaBean;
import org.apache.spark.sql.catalyst.expressions.objects.Invoke;
import org.apache.spark.sql.catalyst.expressions.objects.Invoke$;
import org.apache.spark.sql.catalyst.expressions.objects.NewInstance;
import org.apache.spark.sql.catalyst.expressions.objects.NewInstance$;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke$;
import org.apache.spark.sql.catalyst.expressions.objects.UnresolvedCatalystToExternalMap;
import org.apache.spark.sql.catalyst.expressions.objects.UnresolvedMapObjects;
import org.apache.spark.sql.catalyst.expressions.objects.UnresolvedMapObjects$;
import org.apache.spark.sql.catalyst.expressions.objects.WrapOption;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ObjectType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.UserDefinedType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.math.BigInt;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;

public final class DeserializerBuildHelper$ {
    public static DeserializerBuildHelper$ MODULE$;

    static {
        new DeserializerBuildHelper$();
    }

    public Expression addToPath(Expression path, String part, DataType dataType, WalkedTypePath walkedTypePath) {
        UnresolvedExtractValue newPath = new UnresolvedExtractValue(path, Literal$.MODULE$.apply(part));
        return this.upCastToExpectedType(newPath, dataType, walkedTypePath);
    }

    public Expression addToPathOrdinal(Expression path, int ordinal, DataType dataType, WalkedTypePath walkedTypePath) {
        GetStructField newPath = new GetStructField(path, ordinal, GetStructField$.MODULE$.apply$default$3());
        return this.upCastToExpectedType(newPath, dataType, walkedTypePath);
    }

    public Expression deserializerForWithNullSafetyAndUpcast(Expression expr, DataType dataType, boolean nullable, WalkedTypePath walkedTypePath, Function1<Expression, Expression> funcForCreatingDeserializer) {
        Expression casted = this.upCastToExpectedType(expr, dataType, walkedTypePath);
        return this.expressionWithNullSafety((Expression)funcForCreatingDeserializer.apply((Object)casted), nullable, walkedTypePath);
    }

    public Expression expressionWithNullSafety(Expression expr, boolean nullable, WalkedTypePath walkedTypePath) {
        if (nullable) {
            return expr;
        }
        return new AssertNotNull(expr, (Seq<String>)walkedTypePath.getPaths());
    }

    public Expression createDeserializerForTypesSupportValueOf(Expression path, Class<?> clazz) {
        Class<?> x$1 = clazz;
        ObjectType x$2 = new ObjectType(clazz);
        String x$3 = "valueOf";
        Expression expression = path;
        List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
        boolean x$5 = false;
        Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
        boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
        boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
        return new StaticInvoke(x$1, (DataType)x$2, x$3, (Seq<Expression>)x$4, x$6, x$7, x$5, x$8);
    }

    public Expression createDeserializerForString(Expression path, boolean returnNullable) {
        Expression x$1 = path;
        String x$2 = "toString";
        ObjectType x$3 = new ObjectType(String.class);
        boolean x$4 = returnNullable;
        Seq<Expression> x$5 = Invoke$.MODULE$.apply$default$4();
        Seq<AbstractDataType> x$6 = Invoke$.MODULE$.apply$default$5();
        boolean x$7 = Invoke$.MODULE$.apply$default$6();
        boolean x$8 = Invoke$.MODULE$.apply$default$8();
        return new Invoke(x$1, x$2, (DataType)x$3, x$5, x$6, x$7, x$4, x$8);
    }

    public Expression createDeserializerForSqlDate(Expression path) {
        Class<?> x$1 = DateTimeUtils$.MODULE$.getClass();
        ObjectType x$2 = new ObjectType(Date.class);
        String x$3 = "toJavaDate";
        Expression expression = path;
        List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
        boolean x$5 = false;
        Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
        boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
        boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
        return new StaticInvoke(x$1, (DataType)x$2, x$3, (Seq<Expression>)x$4, x$6, x$7, x$5, x$8);
    }

    public Expression createDeserializerForLocalDate(Expression path) {
        Class<?> x$1 = DateTimeUtils$.MODULE$.getClass();
        ObjectType x$2 = new ObjectType(LocalDate.class);
        String x$3 = "daysToLocalDate";
        Expression expression = path;
        List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
        boolean x$5 = false;
        Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
        boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
        boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
        return new StaticInvoke(x$1, (DataType)x$2, x$3, (Seq<Expression>)x$4, x$6, x$7, x$5, x$8);
    }

    public Expression createDeserializerForInstant(Expression path) {
        Class<?> x$1 = DateTimeUtils$.MODULE$.getClass();
        ObjectType x$2 = new ObjectType(Instant.class);
        String x$3 = "microsToInstant";
        Expression expression = path;
        List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
        boolean x$5 = false;
        Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
        boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
        boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
        return new StaticInvoke(x$1, (DataType)x$2, x$3, (Seq<Expression>)x$4, x$6, x$7, x$5, x$8);
    }

    public Expression createDeserializerForSqlTimestamp(Expression path) {
        Class<?> x$1 = DateTimeUtils$.MODULE$.getClass();
        ObjectType x$2 = new ObjectType(Timestamp.class);
        String x$3 = "toJavaTimestamp";
        Expression expression = path;
        List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
        boolean x$5 = false;
        Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
        boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
        boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
        return new StaticInvoke(x$1, (DataType)x$2, x$3, (Seq<Expression>)x$4, x$6, x$7, x$5, x$8);
    }

    public Expression createDeserializerForLocalDateTime(Expression path) {
        Class<?> x$1 = DateTimeUtils$.MODULE$.getClass();
        ObjectType x$2 = new ObjectType(LocalDateTime.class);
        String x$3 = "microsToLocalDateTime";
        Expression expression = path;
        List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
        boolean x$5 = false;
        Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
        boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
        boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
        return new StaticInvoke(x$1, (DataType)x$2, x$3, (Seq<Expression>)x$4, x$6, x$7, x$5, x$8);
    }

    public Expression createDeserializerForJavaBigDecimal(Expression path, boolean returnNullable) {
        Expression x$1 = path;
        String x$2 = "toJavaBigDecimal";
        ObjectType x$3 = new ObjectType(BigDecimal.class);
        boolean x$4 = returnNullable;
        Seq<Expression> x$5 = Invoke$.MODULE$.apply$default$4();
        Seq<AbstractDataType> x$6 = Invoke$.MODULE$.apply$default$5();
        boolean x$7 = Invoke$.MODULE$.apply$default$6();
        boolean x$8 = Invoke$.MODULE$.apply$default$8();
        return new Invoke(x$1, x$2, (DataType)x$3, x$5, x$6, x$7, x$4, x$8);
    }

    public Expression createDeserializerForScalaBigDecimal(Expression path, boolean returnNullable) {
        Expression x$1 = path;
        String x$2 = "toBigDecimal";
        ObjectType x$3 = new ObjectType(scala.math.BigDecimal.class);
        boolean x$4 = returnNullable;
        Seq<Expression> x$5 = Invoke$.MODULE$.apply$default$4();
        Seq<AbstractDataType> x$6 = Invoke$.MODULE$.apply$default$5();
        boolean x$7 = Invoke$.MODULE$.apply$default$6();
        boolean x$8 = Invoke$.MODULE$.apply$default$8();
        return new Invoke(x$1, x$2, (DataType)x$3, x$5, x$6, x$7, x$4, x$8);
    }

    public Expression createDeserializerForJavaBigInteger(Expression path, boolean returnNullable) {
        Expression x$1 = path;
        String x$2 = "toJavaBigInteger";
        ObjectType x$3 = new ObjectType(BigInteger.class);
        boolean x$4 = returnNullable;
        Seq<Expression> x$5 = Invoke$.MODULE$.apply$default$4();
        Seq<AbstractDataType> x$6 = Invoke$.MODULE$.apply$default$5();
        boolean x$7 = Invoke$.MODULE$.apply$default$6();
        boolean x$8 = Invoke$.MODULE$.apply$default$8();
        return new Invoke(x$1, x$2, (DataType)x$3, x$5, x$6, x$7, x$4, x$8);
    }

    public Expression createDeserializerForScalaBigInt(Expression path) {
        Expression x$1 = path;
        String x$2 = "toScalaBigInt";
        ObjectType x$3 = new ObjectType(BigInt.class);
        boolean x$4 = false;
        Seq<Expression> x$5 = Invoke$.MODULE$.apply$default$4();
        Seq<AbstractDataType> x$6 = Invoke$.MODULE$.apply$default$5();
        boolean x$7 = Invoke$.MODULE$.apply$default$6();
        boolean x$8 = Invoke$.MODULE$.apply$default$8();
        return new Invoke(x$1, x$2, (DataType)x$3, x$5, x$6, x$7, x$4, x$8);
    }

    public Expression createDeserializerForDuration(Expression path) {
        Class<?> x$1 = IntervalUtils$.MODULE$.getClass();
        ObjectType x$2 = new ObjectType(Duration.class);
        String x$3 = "microsToDuration";
        Expression expression = path;
        List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
        boolean x$5 = false;
        Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
        boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
        boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
        return new StaticInvoke(x$1, (DataType)x$2, x$3, (Seq<Expression>)x$4, x$6, x$7, x$5, x$8);
    }

    public Expression createDeserializerForPeriod(Expression path) {
        Class<?> x$1 = IntervalUtils$.MODULE$.getClass();
        ObjectType x$2 = new ObjectType(Period.class);
        String x$3 = "monthsToPeriod";
        Expression expression = path;
        List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
        boolean x$5 = false;
        Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
        boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
        boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
        return new StaticInvoke(x$1, (DataType)x$2, x$3, (Seq<Expression>)x$4, x$6, x$7, x$5, x$8);
    }

    public Expression upCastToExpectedType(Expression expr, DataType expected, WalkedTypePath walkedTypePath) {
        DataType dataType = expected;
        if (dataType instanceof StructType) {
            return expr;
        }
        if (dataType instanceof ArrayType) {
            return expr;
        }
        if (dataType instanceof MapType) {
            return expr;
        }
        if (dataType instanceof DecimalType) {
            return new UpCast(expr, (AbstractDataType)DecimalType$.MODULE$, (Seq<String>)walkedTypePath.getPaths());
        }
        return new UpCast(expr, (AbstractDataType)expected, (Seq<String>)walkedTypePath.getPaths());
    }

    public <T> Expression createDeserializer(AgnosticEncoder<T> enc) {
        WalkedTypePath walkedTypePath = new WalkedTypePath(WalkedTypePath$.MODULE$.apply$default$1()).recordRoot(enc.clsTag().runtimeClass().getName());
        GetColumnByOrdinal input = new GetColumnByOrdinal(0, enc.dataType());
        AgnosticEncoder<T> agnosticEncoder = enc;
        if (agnosticEncoder instanceof AgnosticEncoders.RowEncoder) {
            AgnosticEncoders.RowEncoder rowEncoder = (AgnosticEncoders.RowEncoder)agnosticEncoder;
            Seq fields = rowEncoder.fields();
            Seq children2 = (Seq)((TraversableLike)fields.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    AgnosticEncoders.EncoderField f = (AgnosticEncoders.EncoderField)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    return MODULE$.createDeserializer(f.enc(), new GetStructField(input, i, GetStructField$.MODULE$.apply$default$3()), walkedTypePath);
                }
                throw new MatchError((Object)tuple2);
            }, Seq$.MODULE$.canBuildFrom());
            return new CreateExternalRow((Seq<Expression>)children2, enc.schema());
        }
        Expression deserializer = this.createDeserializer(enc, this.upCastToExpectedType(input, enc.dataType(), walkedTypePath), walkedTypePath);
        return this.expressionWithNullSafety(deserializer, enc.nullable(), walkedTypePath);
    }

    private Expression createDeserializer(AgnosticEncoder<?> enc, Expression path, WalkedTypePath walkedTypePath) {
        boolean bl = false;
        AgnosticEncoders.MapEncoder mapEncoder = null;
        AgnosticEncoder<?> agnosticEncoder = enc;
        if (EncoderUtils$.MODULE$.isNativeEncoder(enc)) {
            return path;
        }
        if (agnosticEncoder instanceof AgnosticEncoders.BoxedLeafEncoder) {
            return this.createDeserializerForTypesSupportValueOf(path, enc.clsTag().runtimeClass());
        }
        if (agnosticEncoder instanceof AgnosticEncoders.JavaEnumEncoder) {
            AgnosticEncoders.JavaEnumEncoder javaEnumEncoder = (AgnosticEncoders.JavaEnumEncoder)agnosticEncoder;
            ClassTag tag = javaEnumEncoder.clsTag();
            Expression toString = this.createDeserializerForString(path, false);
            return this.createDeserializerForTypesSupportValueOf(toString, tag.runtimeClass());
        }
        if (agnosticEncoder instanceof AgnosticEncoders.ScalaEnumEncoder) {
            AgnosticEncoders.ScalaEnumEncoder scalaEnumEncoder = (AgnosticEncoders.ScalaEnumEncoder)agnosticEncoder;
            Class parent = scalaEnumEncoder.parent();
            ClassTag tag = scalaEnumEncoder.clsTag();
            Class x$1 = parent;
            ObjectType x$2 = new ObjectType(tag.runtimeClass());
            String x$3 = "withName";
            Expression expression = this.createDeserializerForString(path, false);
            List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
            boolean x$5 = false;
            Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
            boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
            boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
            return new StaticInvoke(x$1, (DataType)x$2, x$3, (Seq<Expression>)x$4, x$6, x$7, x$5, x$8);
        }
        if (AgnosticEncoders.StringEncoder$.MODULE$.equals(agnosticEncoder)) {
            return this.createDeserializerForString(path, false);
        }
        if (agnosticEncoder instanceof AgnosticEncoders.ScalaDecimalEncoder) {
            return this.createDeserializerForScalaBigDecimal(path, false);
        }
        if (agnosticEncoder instanceof AgnosticEncoders.JavaDecimalEncoder) {
            return this.createDeserializerForJavaBigDecimal(path, false);
        }
        if (AgnosticEncoders.ScalaBigIntEncoder$.MODULE$.equals(agnosticEncoder)) {
            return this.createDeserializerForScalaBigInt(path);
        }
        if (AgnosticEncoders.JavaBigIntEncoder$.MODULE$.equals(agnosticEncoder)) {
            return this.createDeserializerForJavaBigInteger(path, false);
        }
        if (AgnosticEncoders.DayTimeIntervalEncoder$.MODULE$.equals(agnosticEncoder)) {
            return this.createDeserializerForDuration(path);
        }
        if (AgnosticEncoders.YearMonthIntervalEncoder$.MODULE$.equals(agnosticEncoder)) {
            return this.createDeserializerForPeriod(path);
        }
        if (agnosticEncoder instanceof AgnosticEncoders.DateEncoder) {
            return this.createDeserializerForSqlDate(path);
        }
        if (agnosticEncoder instanceof AgnosticEncoders.LocalDateEncoder) {
            return this.createDeserializerForLocalDate(path);
        }
        if (agnosticEncoder instanceof AgnosticEncoders.TimestampEncoder) {
            return this.createDeserializerForSqlTimestamp(path);
        }
        if (agnosticEncoder instanceof AgnosticEncoders.InstantEncoder) {
            return this.createDeserializerForInstant(path);
        }
        if (AgnosticEncoders.LocalDateTimeEncoder$.MODULE$.equals(agnosticEncoder)) {
            return this.createDeserializerForLocalDateTime(path);
        }
        if (agnosticEncoder instanceof AgnosticEncoders.UDTEncoder) {
            AgnosticEncoders.UDTEncoder uDTEncoder = (AgnosticEncoders.UDTEncoder)agnosticEncoder;
            UserDefinedType udt = uDTEncoder.udt();
            Class udtClass = uDTEncoder.udtClass();
            NewInstance obj = NewInstance$.MODULE$.apply(udtClass, (Seq<Expression>)Nil$.MODULE$, (DataType)new ObjectType(udtClass), NewInstance$.MODULE$.apply$default$4());
            Expression expression = path;
            return new Invoke(obj, "deserialize", (DataType)new ObjectType(udt.userClass()), (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)expression), Invoke$.MODULE$.apply$default$5(), Invoke$.MODULE$.apply$default$6(), Invoke$.MODULE$.apply$default$7(), Invoke$.MODULE$.apply$default$8());
        }
        if (agnosticEncoder instanceof AgnosticEncoders.OptionEncoder) {
            AgnosticEncoders.OptionEncoder optionEncoder = (AgnosticEncoders.OptionEncoder)agnosticEncoder;
            AgnosticEncoder valueEnc = optionEncoder.elementEncoder();
            WalkedTypePath newTypePath = walkedTypePath.recordOption(valueEnc.clsTag().runtimeClass().getName());
            Expression deserializer = this.createDeserializer(valueEnc, path, newTypePath);
            return new WrapOption(deserializer, EncoderUtils$.MODULE$.externalDataTypeFor(valueEnc));
        }
        if (agnosticEncoder instanceof AgnosticEncoders.ArrayEncoder) {
            AgnosticEncoders.ArrayEncoder arrayEncoder = (AgnosticEncoders.ArrayEncoder)agnosticEncoder;
            AgnosticEncoder elementEnc = arrayEncoder.element();
            boolean containsNull = arrayEncoder.containsNull();
            if (elementEnc != null) {
                AgnosticEncoder agnosticEncoder2 = elementEnc;
                Expression x$9 = this.deserializeArray(path, (AgnosticEncoder<?>)agnosticEncoder2, containsNull, (Option<Class<?>>)None$.MODULE$, walkedTypePath);
                String x$10 = this.toArrayMethodName(agnosticEncoder2);
                ObjectType x$11 = new ObjectType(enc.clsTag().runtimeClass());
                boolean x$12 = false;
                Seq<Expression> x$132 = Invoke$.MODULE$.apply$default$4();
                Seq<AbstractDataType> x$142 = Invoke$.MODULE$.apply$default$5();
                boolean x$15 = Invoke$.MODULE$.apply$default$6();
                boolean x$162 = Invoke$.MODULE$.apply$default$8();
                return new Invoke(x$9, x$10, (DataType)x$11, x$132, x$142, x$15, x$12, x$162);
            }
        }
        if (agnosticEncoder instanceof AgnosticEncoders.IterableEncoder) {
            AgnosticEncoders.IterableEncoder iterableEncoder = (AgnosticEncoders.IterableEncoder)agnosticEncoder;
            ClassTag clsTag = iterableEncoder.clsTag();
            AgnosticEncoder elementEnc = iterableEncoder.element();
            boolean containsNull = iterableEncoder.containsNull();
            return this.deserializeArray(path, elementEnc, containsNull, Option$.MODULE$.apply((Object)clsTag.runtimeClass()), walkedTypePath);
        }
        if (agnosticEncoder instanceof AgnosticEncoders.MapEncoder) {
            bl = true;
            mapEncoder = (AgnosticEncoders.MapEncoder)agnosticEncoder;
            ClassTag tag = mapEncoder.clsTag();
            AgnosticEncoder keyEncoder = mapEncoder.keyEncoder();
            AgnosticEncoder valueEncoder = mapEncoder.valueEncoder();
            if (Map.class.isAssignableFrom(tag.runtimeClass())) {
                WalkedTypePath newTypePath = walkedTypePath.recordMap(keyEncoder.clsTag().runtimeClass().getName(), valueEncoder.clsTag().runtimeClass().getName());
                Invoke keyData = new Invoke(new UnresolvedMapObjects((Function1<Expression, Expression>)(Function1 & Serializable & scala.Serializable)p -> MODULE$.createDeserializer((AgnosticEncoder<?>)keyEncoder, (Expression)p, newTypePath), new MapKeys(path), UnresolvedMapObjects$.MODULE$.apply$default$3()), "array", (DataType)new ObjectType(Object[].class), Invoke$.MODULE$.apply$default$4(), Invoke$.MODULE$.apply$default$5(), Invoke$.MODULE$.apply$default$6(), Invoke$.MODULE$.apply$default$7(), Invoke$.MODULE$.apply$default$8());
                Invoke valueData = new Invoke(new UnresolvedMapObjects((Function1<Expression, Expression>)(Function1 & Serializable & scala.Serializable)p -> MODULE$.createDeserializer((AgnosticEncoder<?>)valueEncoder, (Expression)p, newTypePath), new MapValues(path), UnresolvedMapObjects$.MODULE$.apply$default$3()), "array", (DataType)new ObjectType(Object[].class), Invoke$.MODULE$.apply$default$4(), Invoke$.MODULE$.apply$default$5(), Invoke$.MODULE$.apply$default$6(), Invoke$.MODULE$.apply$default$7(), Invoke$.MODULE$.apply$default$8());
                Class<?> x$17 = ArrayBasedMapData$.MODULE$.getClass();
                ObjectType x$18 = new ObjectType(Map.class);
                String x$19 = "toJavaMap";
                Invoke invoke = keyData;
                Invoke invoke2 = valueData;
                List x$20 = Nil$.MODULE$.$colon$colon((Object)invoke2).$colon$colon((Object)invoke);
                boolean x$21 = false;
                Seq<AbstractDataType> x$22 = StaticInvoke$.MODULE$.apply$default$5();
                boolean x$23 = StaticInvoke$.MODULE$.apply$default$6();
                boolean x$24 = StaticInvoke$.MODULE$.apply$default$8();
                return new StaticInvoke(x$17, (DataType)x$18, x$19, (Seq<Expression>)x$20, x$22, x$23, x$21, x$24);
            }
        }
        if (bl) {
            ClassTag tag = mapEncoder.clsTag();
            AgnosticEncoder keyEncoder = mapEncoder.keyEncoder();
            AgnosticEncoder valueEncoder = mapEncoder.valueEncoder();
            WalkedTypePath newTypePath = walkedTypePath.recordMap(keyEncoder.clsTag().runtimeClass().getName(), valueEncoder.clsTag().runtimeClass().getName());
            return new UnresolvedCatalystToExternalMap(path, (Function1<Expression, Expression>)(Function1 & Serializable & scala.Serializable)x$13 -> MODULE$.createDeserializer((AgnosticEncoder<?>)keyEncoder, (Expression)x$13, newTypePath), (Function1<Expression, Expression>)(Function1 & Serializable & scala.Serializable)x$14 -> MODULE$.createDeserializer((AgnosticEncoder<?>)valueEncoder, (Expression)x$14, newTypePath), tag.runtimeClass());
        }
        if (agnosticEncoder instanceof AgnosticEncoders.ProductEncoder) {
            AgnosticEncoders.ProductEncoder productEncoder = (AgnosticEncoders.ProductEncoder)agnosticEncoder;
            ClassTag tag = productEncoder.clsTag();
            Seq fields = productEncoder.fields();
            Option outerPointerGetter = productEncoder.outerPointerGetter();
            Class cls = tag.runtimeClass();
            ObjectType dt = new ObjectType(cls);
            boolean isTuple = cls.getName().startsWith("scala.Tuple");
            Seq arguments = (Seq)((TraversableLike)fields.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    AgnosticEncoders.EncoderField field = (AgnosticEncoders.EncoderField)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    WalkedTypePath newTypePath = walkedTypePath.recordField(field.enc().clsTag().runtimeClass().getName(), field.name());
                    Expression getter = isTuple ? MODULE$.addToPathOrdinal(path, i, field.enc().dataType(), newTypePath) : MODULE$.addToPath(path, field.name(), field.enc().dataType(), newTypePath);
                    return MODULE$.expressionWithNullSafety(MODULE$.createDeserializer(field.enc(), getter, newTypePath), field.enc().nullable(), newTypePath);
                }
                throw new MatchError((Object)tuple2);
            }, Seq$.MODULE$.canBuildFrom());
            return new If(new IsNull(path), Literal$.MODULE$.create(null, (DataType)dt), new NewInstance(cls, (Seq<Expression>)arguments, (Seq<AbstractDataType>)Nil$.MODULE$, false, (DataType)dt, (Option<Function0<Object>>)outerPointerGetter));
        }
        if (agnosticEncoder instanceof AgnosticEncoders.RowEncoder) {
            AgnosticEncoders.RowEncoder rowEncoder = (AgnosticEncoders.RowEncoder)agnosticEncoder;
            Seq fields = rowEncoder.fields();
            Seq convertedFields = (Seq)((TraversableLike)fields.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    AgnosticEncoders.EncoderField f = (AgnosticEncoders.EncoderField)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    WalkedTypePath newTypePath = walkedTypePath.recordField(f.enc().clsTag().runtimeClass().getName(), f.name());
                    Literal literal = Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)i));
                    return new If(new Invoke(path, "isNullAt", (DataType)BooleanType$.MODULE$, (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)literal), Invoke$.MODULE$.apply$default$5(), Invoke$.MODULE$.apply$default$6(), Invoke$.MODULE$.apply$default$7(), Invoke$.MODULE$.apply$default$8()), Literal$.MODULE$.create(null, EncoderUtils$.MODULE$.externalDataTypeFor(f.enc())), MODULE$.createDeserializer(f.enc(), new GetStructField(path, i, GetStructField$.MODULE$.apply$default$3()), newTypePath));
                }
                throw new MatchError((Object)tuple2);
            }, Seq$.MODULE$.canBuildFrom());
            return new If(new IsNull(path), Literal$.MODULE$.create(null, EncoderUtils$.MODULE$.externalDataTypeFor(enc)), new CreateExternalRow((Seq<Expression>)convertedFields, enc.schema()));
        }
        if (agnosticEncoder instanceof AgnosticEncoders.JavaBeanEncoder) {
            AgnosticEncoders.JavaBeanEncoder javaBeanEncoder = (AgnosticEncoders.JavaBeanEncoder)agnosticEncoder;
            ClassTag tag = javaBeanEncoder.clsTag();
            Seq fields = javaBeanEncoder.fields();
            Seq setters = (Seq)((TraversableLike)fields.filter((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)DeserializerBuildHelper$.$anonfun$createDeserializer$8(x$16)))).map((Function1 & Serializable & scala.Serializable)f -> {
                WalkedTypePath newTypePath = walkedTypePath.recordField(f.enc().clsTag().runtimeClass().getName(), f.name());
                Expression setter = MODULE$.expressionWithNullSafety(MODULE$.createDeserializer(f.enc(), MODULE$.addToPath(path, f.name(), f.enc().dataType(), newTypePath), newTypePath), f.nullable(), newTypePath);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(f.writeMethod().get()), (Object)setter);
            }, Seq$.MODULE$.canBuildFrom());
            Class cls = tag.runtimeClass();
            NewInstance newInstance = NewInstance$.MODULE$.apply(cls, (Seq<Expression>)Nil$.MODULE$, (DataType)new ObjectType(cls), false);
            InitializeJavaBean result = new InitializeJavaBean(newInstance, (scala.collection.immutable.Map<String, Expression>)setters.toMap(Predef$.MODULE$.$conforms()));
            return new If(new IsNull(path), Literal$.MODULE$.create(null, (DataType)new ObjectType(cls)), result);
        }
        throw new MatchError(agnosticEncoder);
    }

    private Expression deserializeArray(Expression path, AgnosticEncoder<?> elementEnc, boolean containsNull, Option<Class<?>> cls, WalkedTypePath walkedTypePath) {
        WalkedTypePath newTypePath = walkedTypePath.recordArray(elementEnc.clsTag().runtimeClass().getName());
        Function1 & Serializable & scala.Serializable mapFunction = (Function1 & Serializable & scala.Serializable)element -> MODULE$.deserializerForWithNullSafetyAndUpcast((Expression)element, elementEnc.dataType(), containsNull, newTypePath, (Function1<Expression, Expression>)(Function1 & Serializable & scala.Serializable)x$17 -> MODULE$.createDeserializer(elementEnc, (Expression)x$17, newTypePath));
        return new UnresolvedMapObjects((Function1<Expression, Expression>)mapFunction, path, cls);
    }

    private String toArrayMethodName(AgnosticEncoder<?> enc) {
        AgnosticEncoder<?> agnosticEncoder = enc;
        if (AgnosticEncoders.PrimitiveBooleanEncoder$.MODULE$.equals(agnosticEncoder)) {
            return "toBooleanArray";
        }
        if (AgnosticEncoders.PrimitiveByteEncoder$.MODULE$.equals(agnosticEncoder)) {
            return "toByteArray";
        }
        if (AgnosticEncoders.PrimitiveShortEncoder$.MODULE$.equals(agnosticEncoder)) {
            return "toShortArray";
        }
        if (AgnosticEncoders.PrimitiveIntEncoder$.MODULE$.equals(agnosticEncoder)) {
            return "toIntArray";
        }
        if (AgnosticEncoders.PrimitiveLongEncoder$.MODULE$.equals(agnosticEncoder)) {
            return "toLongArray";
        }
        if (AgnosticEncoders.PrimitiveFloatEncoder$.MODULE$.equals(agnosticEncoder)) {
            return "toFloatArray";
        }
        if (AgnosticEncoders.PrimitiveDoubleEncoder$.MODULE$.equals(agnosticEncoder)) {
            return "toDoubleArray";
        }
        return "array";
    }

    public static final /* synthetic */ boolean $anonfun$createDeserializer$8(AgnosticEncoders.EncoderField x$16) {
        return x$16.writeMethod().isDefined();
    }

    private DeserializerBuildHelper$() {
        MODULE$ = this;
    }
}

