/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.req;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.req.BaseReqSketch;
import org.apache.datasketches.req.FloatBuffer;
import org.apache.datasketches.req.ReqAuxiliary;
import org.apache.datasketches.req.ReqCompactor;
import org.apache.datasketches.req.ReqDebug;
import org.apache.datasketches.req.ReqIterator;
import org.apache.datasketches.req.ReqSerDe;
import org.apache.datasketches.req.ReqSketchBuilder;

public class ReqSketch
extends BaseReqSketch {
    private static final String LS = System.getProperty("line.separator");
    static final byte INIT_NUMBER_OF_SECTIONS = 3;
    static final byte MIN_K = 4;
    static final byte NOM_CAP_MULT = 2;
    private static final double relRseFactor = Math.sqrt(0.017066666666666667);
    private static final double fixRseFactor = 0.084;
    private final int k;
    private final boolean hra;
    private boolean ltEq = false;
    private long totalN;
    private float minValue = Float.NaN;
    private float maxValue = Float.NaN;
    private int retItems = 0;
    private int maxNomSize = 0;
    private ReqAuxiliary aux = null;
    private List<ReqCompactor> compactors = new ArrayList<ReqCompactor>();
    private ReqDebug reqDebug = null;
    private final CompactorReturn cReturn = new CompactorReturn();

    ReqSketch(int k, boolean highRankAccuracy, ReqDebug reqDebug) {
        ReqSketch.checkK(k);
        this.k = k;
        this.hra = highRankAccuracy;
        this.retItems = 0;
        this.maxNomSize = 0;
        this.totalN = 0L;
        this.reqDebug = reqDebug;
        this.grow();
    }

    ReqSketch(ReqSketch other) {
        this.k = other.k;
        this.hra = other.hra;
        this.totalN = other.totalN;
        this.retItems = other.retItems;
        this.maxNomSize = other.maxNomSize;
        this.minValue = other.minValue;
        this.maxValue = other.maxValue;
        this.ltEq = other.ltEq;
        this.reqDebug = other.reqDebug;
        for (int i = 0; i < other.getNumLevels(); ++i) {
            this.compactors.add(new ReqCompactor(other.compactors.get(i)));
        }
        this.aux = null;
    }

    ReqSketch(int k, boolean hra, long totalN, float minValue, float maxValue, List<ReqCompactor> compactors) {
        ReqSketch.checkK(k);
        this.k = k;
        this.hra = hra;
        this.totalN = totalN;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.compactors = compactors;
    }

    public static ReqSketch heapify(Memory mem) {
        return ReqSerDe.heapify(mem);
    }

    public static final ReqSketchBuilder builder() {
        return new ReqSketchBuilder();
    }

    private void compress() {
        if (this.reqDebug != null) {
            this.reqDebug.emitStartCompress();
        }
        for (int h = 0; h < this.compactors.size(); ++h) {
            int compNomCap;
            ReqCompactor c = this.compactors.get(h);
            int compRetItems = c.getBuffer().getCount();
            if (compRetItems < (compNomCap = c.getNomCapacity())) continue;
            if (h + 1 >= this.getNumLevels()) {
                if (this.reqDebug != null) {
                    this.reqDebug.emitMustAddCompactor();
                }
                this.grow();
            }
            FloatBuffer promoted = c.compact(this.cReturn);
            this.compactors.get(h + 1).getBuffer().mergeSortIn(promoted);
            this.retItems += this.cReturn.deltaRetItems;
            this.maxNomSize += this.cReturn.deltaNomSize;
        }
        this.aux = null;
        if (this.reqDebug != null) {
            this.reqDebug.emitCompressDone();
        }
    }

    ReqAuxiliary getAux() {
        return this.aux;
    }

    @Override
    public double[] getCDF(float[] splitPoints) {
        if (this.isEmpty()) {
            return null;
        }
        int numBkts = splitPoints.length + 1;
        double[] outArr = new double[numBkts];
        long[] buckets = this.getPMForCDF(splitPoints);
        for (int j = 0; j < numBkts; ++j) {
            outArr[j] = (double)buckets[j] / (double)this.getN();
        }
        return outArr;
    }

    List<ReqCompactor> getCompactors() {
        return this.compactors;
    }

    private long getCount(float value) {
        if (this.isEmpty()) {
            return 0L;
        }
        int numComp = this.compactors.size();
        long cumNnr = 0L;
        for (int i = 0; i < numComp; ++i) {
            ReqCompactor c = this.compactors.get(i);
            long wt = 1L << c.getLgWeight();
            FloatBuffer buf = c.getBuffer();
            cumNnr += (long)buf.getCountWithCriterion(value, this.ltEq) * wt;
        }
        return cumNnr;
    }

    private long[] getCounts(float[] values) {
        int numValues = values.length;
        int numComp = this.compactors.size();
        long[] cumNnrArr = new long[numValues];
        if (this.isEmpty()) {
            return cumNnrArr;
        }
        for (int i = 0; i < numComp; ++i) {
            ReqCompactor c = this.compactors.get(i);
            long wt = 1L << c.getLgWeight();
            FloatBuffer buf = c.getBuffer();
            for (int j = 0; j < numValues; ++j) {
                int n = j;
                cumNnrArr[n] = cumNnrArr[n] + (long)buf.getCountWithCriterion(values[j], this.ltEq) * wt;
            }
        }
        return cumNnrArr;
    }

    boolean getLtEq() {
        return this.ltEq;
    }

    @Override
    public boolean getHighRankAccuracy() {
        return this.hra;
    }

    int getK() {
        return this.k;
    }

    int getMaxNomSize() {
        return this.maxNomSize;
    }

    @Override
    public float getMaxValue() {
        return this.maxValue;
    }

    @Override
    public float getMinValue() {
        return this.minValue;
    }

    @Override
    public long getN() {
        return this.totalN;
    }

    int getNumLevels() {
        return this.compactors.size();
    }

    @Override
    public double[] getPMF(float[] splitPoints) {
        if (this.isEmpty()) {
            return null;
        }
        int numBkts = splitPoints.length + 1;
        double[] outArr = new double[numBkts];
        long[] buckets = this.getPMForCDF(splitPoints);
        outArr[0] = (double)buckets[0] / (double)this.getN();
        for (int j = 1; j < numBkts; ++j) {
            outArr[j] = (double)(buckets[j] - buckets[j - 1]) / (double)this.getN();
        }
        return outArr;
    }

    private long[] getPMForCDF(float[] splits) {
        ReqSketch.validateSplits(splits);
        int numSplits = splits.length;
        long[] splitCounts = this.getCounts(splits);
        int numBkts = numSplits + 1;
        long[] bkts = Arrays.copyOf(splitCounts, numBkts);
        bkts[numBkts - 1] = this.getN();
        return bkts;
    }

    @Override
    public float getQuantile(double normRank) {
        if (this.isEmpty()) {
            return Float.NaN;
        }
        if (normRank < 0.0 || normRank > 1.0) {
            throw new SketchesArgumentException("Normalized rank must be in the range [0.0, 1.0]: " + normRank);
        }
        if (this.aux == null) {
            this.aux = new ReqAuxiliary(this);
        }
        return this.aux.getQuantile(normRank, this.ltEq);
    }

    @Override
    public float[] getQuantiles(double[] normRanks) {
        if (this.isEmpty()) {
            return null;
        }
        int len = normRanks.length;
        float[] qArr = new float[len];
        for (int i = 0; i < len; ++i) {
            qArr[i] = this.getQuantile(normRanks[i]);
        }
        return qArr;
    }

    @Override
    public double getRank(float value) {
        if (this.isEmpty()) {
            return Double.NaN;
        }
        long nnCount = this.getCount(value);
        return (double)nnCount / (double)this.totalN;
    }

    @Override
    public double[] getRanks(float[] values) {
        if (this.isEmpty()) {
            return null;
        }
        long[] cumNnrArr = this.getCounts(values);
        int numValues = values.length;
        double[] rArr = new double[numValues];
        for (int i = 0; i < numValues; ++i) {
            rArr[i] = (double)cumNnrArr[i] / (double)this.totalN;
        }
        return rArr;
    }

    private static double getRankLB(int k, int levels, double rank, int numStdDev, boolean hra, long totalN) {
        if (ReqSketch.exactRank(k, levels, rank, hra, totalN)) {
            return rank;
        }
        double relative = relRseFactor / (double)k * (hra ? 1.0 - rank : rank);
        double fixed = 0.084 / (double)k;
        double lbRel = rank - (double)numStdDev * relative;
        double lbFix = rank - (double)numStdDev * fixed;
        return Math.max(lbRel, lbFix);
    }

    @Override
    public double getRankLowerBound(double rank, int numStdDev) {
        return ReqSketch.getRankLB(this.k, this.getNumLevels(), rank, numStdDev, this.hra, this.getN());
    }

    private static double getRankUB(int k, int levels, double rank, int numStdDev, boolean hra, long totalN) {
        if (ReqSketch.exactRank(k, levels, rank, hra, totalN)) {
            return rank;
        }
        double relative = relRseFactor / (double)k * (hra ? 1.0 - rank : rank);
        double fixed = 0.084 / (double)k;
        double ubRel = rank + (double)numStdDev * relative;
        double ubFix = rank + (double)numStdDev * fixed;
        return Math.min(ubRel, ubFix);
    }

    private static boolean exactRank(int k, int levels, double rank, boolean hra, long totalN) {
        int baseCap = k * 3;
        if (levels == 1 || totalN <= (long)baseCap) {
            return true;
        }
        double exactRankThresh = (double)baseCap / (double)totalN;
        return hra && rank >= 1.0 - exactRankThresh || !hra && rank <= exactRankThresh;
    }

    @Override
    public double getRankUpperBound(double rank, int numStdDev) {
        return ReqSketch.getRankUB(this.k, this.getNumLevels(), rank, numStdDev, this.hra, this.getN());
    }

    @Override
    public int getRetainedItems() {
        return this.retItems;
    }

    @Override
    public double getRSE(int k, double rank, boolean hra, long totalN) {
        return ReqSketch.getRankUB(k, 2, rank, 1, hra, totalN);
    }

    @Override
    public int getSerializationBytes() {
        ReqSerDe.SerDeFormat serDeFormat = ReqSerDe.getSerFormat(this);
        return ReqSerDe.getSerBytes(this, serDeFormat);
    }

    private void grow() {
        byte lgWeight = (byte)this.getNumLevels();
        if (lgWeight == 0 && this.reqDebug != null) {
            this.reqDebug.emitStart(this);
        }
        this.compactors.add(new ReqCompactor(lgWeight, this.hra, this.k, this.reqDebug));
        this.maxNomSize = this.computeMaxNomSize();
        if (this.reqDebug != null) {
            this.reqDebug.emitNewCompactor(lgWeight);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.totalN == 0L;
    }

    @Override
    public boolean isEstimationMode() {
        return this.getNumLevels() > 1;
    }

    @Override
    public boolean isLessThanOrEqual() {
        return this.ltEq;
    }

    @Override
    public ReqIterator iterator() {
        return new ReqIterator(this);
    }

    @Override
    public ReqSketch merge(ReqSketch other) {
        if (other == null || other.isEmpty()) {
            return this;
        }
        if (other.hra != this.hra) {
            throw new SketchesArgumentException("Both sketches must have the same HighRankAccuracy setting.");
        }
        this.totalN += other.totalN;
        if (Float.isNaN(this.minValue) || other.minValue < this.minValue) {
            this.minValue = other.minValue;
        }
        if (Float.isNaN(this.maxValue) || other.maxValue > this.maxValue) {
            this.maxValue = other.maxValue;
        }
        while (this.getNumLevels() < other.getNumLevels()) {
            this.grow();
        }
        for (int i = 0; i < other.getNumLevels(); ++i) {
            this.compactors.get(i).merge(other.compactors.get(i));
        }
        this.maxNomSize = this.computeMaxNomSize();
        this.retItems = this.computeTotalRetainedItems();
        if (this.retItems >= this.maxNomSize) {
            this.compress();
        }
        assert (this.retItems < this.maxNomSize);
        this.aux = null;
        return this;
    }

    @Override
    public ReqSketch reset() {
        this.totalN = 0L;
        this.retItems = 0;
        this.maxNomSize = 0;
        this.minValue = Float.NaN;
        this.maxValue = Float.NaN;
        this.aux = null;
        this.compactors = new ArrayList<ReqCompactor>();
        this.grow();
        return this;
    }

    @Override
    public ReqSketch setLessThanOrEqual(boolean ltEq) {
        this.ltEq = ltEq;
        return this;
    }

    @Override
    public byte[] toByteArray() {
        return ReqSerDe.toByteArray(this);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("**********Relative Error Quantiles Sketch Summary**********").append(LS);
        sb.append("  K               : " + this.k).append(LS);
        sb.append("  N               : " + this.totalN).append(LS);
        sb.append("  Retained Items  : " + this.retItems).append(LS);
        sb.append("  Min Value       : " + this.minValue).append(LS);
        sb.append("  Max Value       : " + this.maxValue).append(LS);
        sb.append("  Estimation Mode : " + this.isEstimationMode()).append(LS);
        sb.append("  LtEQ            : " + this.ltEq).append(LS);
        sb.append("  High Rank Acc   : " + this.hra).append(LS);
        sb.append("  Levels          : " + this.compactors.size()).append(LS);
        sb.append("************************End Summary************************").append(LS);
        return sb.toString();
    }

    @Override
    public void update(float item) {
        if (Float.isNaN(item)) {
            return;
        }
        if (this.isEmpty()) {
            this.minValue = item;
            this.maxValue = item;
        } else {
            if (item < this.minValue) {
                this.minValue = item;
            }
            if (item > this.maxValue) {
                this.maxValue = item;
            }
        }
        FloatBuffer buf = this.compactors.get(0).getBuffer();
        buf.append(item);
        ++this.retItems;
        ++this.totalN;
        if (this.retItems >= this.maxNomSize) {
            buf.sort();
            this.compress();
        }
        this.aux = null;
    }

    int computeMaxNomSize() {
        int cap = 0;
        for (ReqCompactor c : this.compactors) {
            cap += c.getNomCapacity();
        }
        return cap;
    }

    void setMaxNomSize(int maxNomSize) {
        this.maxNomSize = maxNomSize;
    }

    int computeTotalRetainedItems() {
        int count = 0;
        for (ReqCompactor c : this.compactors) {
            count += c.getBuffer().getCount();
        }
        return count;
    }

    void setRetainedItems(int retItems) {
        this.retItems = retItems;
    }

    static void validateSplits(float[] splits) {
        int len = splits.length;
        for (int i = 0; i < len; ++i) {
            float v = splits[i];
            if (!Float.isFinite(v)) {
                throw new SketchesArgumentException("Values must be finite");
            }
            if (i >= len - 1 || !(v >= splits[i + 1])) continue;
            throw new SketchesArgumentException("Values must be unique and monotonically increasing");
        }
    }

    @Override
    public String viewCompactorDetail(String fmt, boolean allData) {
        StringBuilder sb = new StringBuilder();
        sb.append("*********Relative Error Quantiles Compactor Detail*********").append(LS);
        sb.append("Compactor Detail: Ret Items: ").append(this.getRetainedItems()).append("  N: ").append(this.getN());
        sb.append(LS);
        for (int i = 0; i < this.getNumLevels(); ++i) {
            ReqCompactor c = this.compactors.get(i);
            sb.append(c.toListPrefix()).append(LS);
            if (!allData) continue;
            sb.append(c.getBuffer().toHorizList(fmt, 20)).append(LS);
        }
        sb.append("************************End Detail*************************").append(LS);
        return sb.toString();
    }

    static void checkK(int k) {
        if ((k & 1) > 0 || k < 4 || k > 1024) {
            throw new SketchesArgumentException("<i>K</i> must be even and in the range [4, 1024], inclusive: " + k);
        }
    }

    static class CompactorReturn {
        int deltaRetItems;
        int deltaNomSize;

        CompactorReturn() {
        }
    }
}

