/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.util.Objects;
import org.apache.datasketches.kll.KllDoublesSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllMemoryValidate;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.Memory;

final class KllHeapDoublesSketch
extends KllDoublesSketch {
    private final int k_;
    private final int m_;
    private long n_;
    private int minK_;
    private boolean isLevelZeroSorted_;
    private double minDoubleValue_;
    private double maxDoubleValue_;
    private double[] doubleItems_;

    KllHeapDoublesSketch(int k, int m) {
        super(null, null);
        KllHelper.checkM(m);
        KllHelper.checkK(k, m);
        this.k_ = k;
        this.m_ = m;
        this.n_ = 0L;
        this.minK_ = k;
        this.isLevelZeroSorted_ = false;
        this.levelsArr = new int[]{k, k};
        this.minDoubleValue_ = Double.NaN;
        this.maxDoubleValue_ = Double.NaN;
        this.doubleItems_ = new double[k];
    }

    private KllHeapDoublesSketch(Memory srcMem, KllMemoryValidate memVal) {
        super(null, null);
        this.k_ = memVal.k;
        this.m_ = memVal.m;
        this.n_ = memVal.n;
        this.minK_ = memVal.minK;
        this.levelsArr = memVal.levelsArr;
        this.isLevelZeroSorted_ = memVal.level0Sorted;
        boolean updatableMemFormat = memVal.updatableMemFormat;
        if (memVal.empty && !updatableMemFormat) {
            this.minDoubleValue_ = Double.NaN;
            this.maxDoubleValue_ = Double.NaN;
            this.doubleItems_ = new double[this.k_];
        } else if (memVal.singleItem && !updatableMemFormat) {
            double value;
            this.minDoubleValue_ = this.maxDoubleValue_ = (value = srcMem.getDouble(8L));
            this.doubleItems_ = new double[this.k_];
            this.doubleItems_[this.k_ - 1] = value;
        } else {
            int offsetBytes = 20;
            this.minDoubleValue_ = srcMem.getDouble((long)(offsetBytes += updatableMemFormat ? this.levelsArr.length * 4 : (this.levelsArr.length - 1) * 4));
            this.maxDoubleValue_ = srcMem.getDouble((long)(offsetBytes += 8));
            offsetBytes += 8;
            int capacityItems = this.levelsArr[this.getNumLevels()];
            int retainedItems = capacityItems - this.levelsArr[0];
            this.doubleItems_ = new double[capacityItems];
            int shift = this.levelsArr[0];
            if (updatableMemFormat) {
                srcMem.getDoubleArray((long)(offsetBytes += shift * 8), this.doubleItems_, shift, retainedItems);
            } else {
                srcMem.getDoubleArray((long)offsetBytes, this.doubleItems_, shift, retainedItems);
            }
        }
    }

    static KllHeapDoublesSketch heapifyImpl(Memory srcMem) {
        Objects.requireNonNull(srcMem, "Parameter 'srcMem' must not be null");
        KllMemoryValidate memVal = new KllMemoryValidate(srcMem);
        if (!memVal.doublesSketch) {
            KllSketch.Error.kllSketchThrow(KllSketch.Error.SRC_MUST_BE_DOUBLE);
        }
        return new KllHeapDoublesSketch(srcMem, memVal);
    }

    @Override
    public int getK() {
        return this.k_;
    }

    @Override
    public long getN() {
        return this.n_;
    }

    @Override
    double[] getDoubleItemsArray() {
        return this.doubleItems_;
    }

    @Override
    double getDoubleSingleItem() {
        if (this.n_ != 1L) {
            KllSketch.Error.kllSketchThrow(KllSketch.Error.NOT_SINGLE_ITEM);
            return Double.NaN;
        }
        return this.doubleItems_[this.k_ - 1];
    }

    @Override
    float getFloatSingleItem() {
        KllSketch.Error.kllSketchThrow(KllSketch.Error.MUST_NOT_CALL);
        return Float.NaN;
    }

    @Override
    int getM() {
        return this.m_;
    }

    @Override
    double getMaxDoubleValue() {
        return this.maxDoubleValue_;
    }

    @Override
    double getMinDoubleValue() {
        return this.minDoubleValue_;
    }

    @Override
    int getMinK() {
        return this.minK_;
    }

    @Override
    void incN() {
        ++this.n_;
    }

    @Override
    void incNumLevels() {
    }

    @Override
    boolean isLevelZeroSorted() {
        return this.isLevelZeroSorted_;
    }

    @Override
    void setDoubleItemsArray(double[] doubleItems) {
        this.doubleItems_ = doubleItems;
    }

    @Override
    void setDoubleItemsArrayAt(int index, double value) {
        this.doubleItems_[index] = value;
    }

    @Override
    void setLevelZeroSorted(boolean sorted) {
        this.isLevelZeroSorted_ = sorted;
    }

    @Override
    void setMaxDoubleValue(double value) {
        this.maxDoubleValue_ = value;
    }

    @Override
    void setMinDoubleValue(double value) {
        this.minDoubleValue_ = value;
    }

    @Override
    void setMinK(int minK) {
        this.minK_ = minK;
    }

    @Override
    void setN(long n) {
        this.n_ = n;
    }

    @Override
    void setNumLevels(int numLevels) {
    }
}

