/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming.ui;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.sql.streaming.StreamingQueryListener;
import org.apache.spark.sql.streaming.ui.StreamingQueryData;
import org.apache.spark.sql.streaming.ui.StreamingQueryData$;
import org.apache.spark.sql.streaming.ui.StreamingQueryProgressWrapper;
import org.apache.spark.sql.streaming.ui.StreamingQueryProgressWrapper$;
import org.apache.spark.sql.streaming.ui.UIUtils$;
import org.apache.spark.status.ElementTrackingStore;
import org.apache.spark.status.KVUtils$;
import org.apache.spark.util.kvstore.KVStoreView;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b!B\t\u0013\u0001Yq\u0002\u0002C\u0012\u0001\u0005\u000b\u0007I\u0011A\u0013\t\u0011)\u0002!\u0011!Q\u0001\n\u0019B\u0001b\u000b\u0001\u0003\u0006\u0004%\t\u0001\f\u0005\tg\u0001\u0011\t\u0011)A\u0005[!)A\u0007\u0001C\u0001k!9!\b\u0001b\u0001\n\u0013Y\u0004B\u0002\"\u0001A\u0003%A\bC\u0004D\u0001\t\u0007I\u0011B\u001e\t\r\u0011\u0003\u0001\u0015!\u0003=\u0011\u001d)\u0005A1A\u0005\n\u0019Ca\u0001\u001b\u0001!\u0002\u00139\u0005\"B5\u0001\t\u0013Q\u0007\"B:\u0001\t\u0003\"\b\"\u0002@\u0001\t\u0003z\bbBA\u0005\u0001\u0011\u0005\u00131\u0002\u0005\b\u0003+\u0001A\u0011IA\f\u0005q\u0019FO]3b[&tw-U;fef\u001cF/\u0019;vg2K7\u000f^3oKJT!a\u0005\u000b\u0002\u0005UL'BA\u000b\u0017\u0003%\u0019HO]3b[&twM\u0003\u0002\u00181\u0005\u00191/\u001d7\u000b\u0005eQ\u0012!B:qCJ\\'BA\u000e\u001d\u0003\u0019\t\u0007/Y2iK*\tQ$A\u0002pe\u001e\u001c\"\u0001A\u0010\u0011\u0005\u0001\nS\"\u0001\u000b\n\u0005\t\"\"AF*ue\u0016\fW.\u001b8h#V,'/\u001f'jgR,g.\u001a:\u0002\t\r|gNZ\u0002\u0001+\u00051\u0003CA\u0014)\u001b\u0005A\u0012BA\u0015\u0019\u0005%\u0019\u0006/\u0019:l\u0007>tg-A\u0003d_:4\u0007%A\u0003ti>\u0014X-F\u0001.!\tq\u0013'D\u00010\u0015\t\u0001\u0004$\u0001\u0004ti\u0006$Xo]\u0005\u0003e=\u0012A#\u00127f[\u0016tG\u000f\u0016:bG.LgnZ*u_J,\u0017AB:u_J,\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0004maJ\u0004CA\u001c\u0001\u001b\u0005\u0011\u0002\"B\u0012\u0006\u0001\u00041\u0003\"B\u0016\u0006\u0001\u0004i\u0013AG:ue\u0016\fW.\u001b8h!J|wM]3tgJ+G/\u001a8uS>tW#\u0001\u001f\u0011\u0005u\u0002U\"\u0001 \u000b\u0003}\nQa]2bY\u0006L!!\u0011 \u0003\u0007%sG/A\u000etiJ,\u0017-\\5oOB\u0013xn\u001a:fgN\u0014V\r^3oi&|g\u000eI\u0001\u001dS:\f7\r^5wKF+XM]=Ti\u0006$Xo\u001d*fi\u0016tG/[8o\u0003uIg.Y2uSZ,\u0017+^3ssN#\u0018\r^;t%\u0016$XM\u001c;j_:\u0004\u0013aD9vKJLHk\u001c)s_\u001e\u0014Xm]:\u0016\u0003\u001d\u0003B\u0001S(R+6\t\u0011J\u0003\u0002K\u0017\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u00051k\u0015\u0001B;uS2T\u0011AT\u0001\u0005U\u00064\u0018-\u0003\u0002Q\u0013\n\t2i\u001c8dkJ\u0014XM\u001c;ICNDW*\u00199\u0011\u0005I\u001bV\"A&\n\u0005Q[%\u0001B+V\u0013\u0012\u00032AV.^\u001b\u00059&B\u0001-Z\u0003\u001diW\u000f^1cY\u0016T!A\u0017 \u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002]/\n)\u0011+^3vKB\u0011a,\u001a\b\u0003?\u000e\u0004\"\u0001\u0019 \u000e\u0003\u0005T!A\u0019\u0013\u0002\rq\u0012xn\u001c;?\u0013\t!g(\u0001\u0004Qe\u0016$WMZ\u0005\u0003M\u001e\u0014aa\u0015;sS:<'B\u00013?\u0003A\tX/\u001a:z)>\u0004&o\\4sKN\u001c\b%\u0001\fdY\u0016\fg.\u001e9J]\u0006\u001cG/\u001b<f#V,'/[3t)\tYg\u000e\u0005\u0002>Y&\u0011QN\u0010\u0002\u0005+:LG\u000fC\u0003p\u0019\u0001\u0007\u0001/A\u0003d_VtG\u000f\u0005\u0002>c&\u0011!O\u0010\u0002\u0005\u0019>tw-\u0001\bp]F+XM]=Ti\u0006\u0014H/\u001a3\u0015\u0005-,\b\"\u0002<\u000e\u0001\u00049\u0018!B3wK:$\bC\u0001=|\u001d\t\u0001\u00130\u0003\u0002{)\u000512\u000b\u001e:fC6LgnZ)vKJLH*[:uK:,'/\u0003\u0002}{\n\t\u0012+^3ssN#\u0018M\u001d;fI\u00163XM\u001c;\u000b\u0005i$\u0012aD8o#V,'/\u001f)s_\u001e\u0014Xm]:\u0015\u0007-\f\t\u0001\u0003\u0004w\u001d\u0001\u0007\u00111\u0001\t\u0004q\u0006\u0015\u0011bAA\u0004{\n\u0011\u0012+^3ssB\u0013xn\u001a:fgN,e/\u001a8u\u0003-yg.U;fefLE\r\\3\u0015\u0007-\fi\u0001\u0003\u0004w\u001f\u0001\u0007\u0011q\u0002\t\u0004q\u0006E\u0011bAA\n{\nq\u0011+^3ss&#G.Z#wK:$\u0018!E8o#V,'/\u001f+fe6Lg.\u0019;fIR\u00191.!\u0007\t\rY\u0004\u0002\u0019AA\u000e!\rA\u0018QD\u0005\u0004\u0003?i(\u0001F)vKJLH+\u001a:nS:\fG/\u001a3Fm\u0016tG\u000f")
public class StreamingQueryStatusListener
extends StreamingQueryListener {
    private final SparkConf conf;
    private final ElementTrackingStore store;
    private final int streamingProgressRetention;
    private final int inactiveQueryStatusRetention;
    private final ConcurrentHashMap<UUID, Queue<String>> queryToProgress;

    public SparkConf conf() {
        return this.conf;
    }

    public ElementTrackingStore store() {
        return this.store;
    }

    private int streamingProgressRetention() {
        return this.streamingProgressRetention;
    }

    private int inactiveQueryStatusRetention() {
        return this.inactiveQueryStatusRetention;
    }

    private ConcurrentHashMap<UUID, Queue<String>> queryToProgress() {
        return this.queryToProgress;
    }

    private void cleanupInactiveQueries(long count) {
        KVStoreView view = this.store().view(StreamingQueryData.class).index("active").first((Object)BoxesRunTime.boxToBoolean((boolean)false)).last((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Seq inactiveQueries = KVUtils$.MODULE$.viewToSeq(view);
        int numInactiveQueries = inactiveQueries.size();
        if (numInactiveQueries <= this.inactiveQueryStatusRetention()) {
            return;
        }
        Seq toDelete = (Seq)((IterableLike)inactiveQueries.sortBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)StreamingQueryStatusListener.$anonfun$cleanupInactiveQueries$1(x$1)), (Ordering)Ordering.Long$.MODULE$)).take(numInactiveQueries - this.inactiveQueryStatusRetention());
        Seq runIds = (Seq)toDelete.map((Function1 & Serializable & scala.Serializable)e -> {
            this.store().delete(e.getClass(), (Object)e.runId());
            return e.runId();
        }, Seq$.MODULE$.canBuildFrom());
        this.store().removeAllByIndexValues(StreamingQueryProgressWrapper.class, "runId", (Iterable)runIds);
    }

    @Override
    public void onQueryStarted(StreamingQueryListener.QueryStartedEvent event) {
        long startTimestamp = UIUtils$.MODULE$.parseProgressTimestamp(event.timestamp());
        this.store().write((Object)new StreamingQueryData(event.name(), event.id(), event.runId().toString(), true, (Option<String>)None$.MODULE$, startTimestamp, StreamingQueryData$.MODULE$.$lessinit$greater$default$7()), true);
    }

    @Override
    public void onQueryProgress(StreamingQueryListener.QueryProgressEvent event) {
        UUID runId = event.progress().runId();
        long batchId = event.progress().batchId();
        String timestamp = event.progress().timestamp();
        Queue<String> queue = !this.queryToProgress().containsKey(runId) ? this.queryToProgress().put(runId, (Queue<String>)Queue$.MODULE$.empty()) : BoxedUnit.UNIT;
        Queue<String> progressIds = this.queryToProgress().get(runId);
        progressIds.enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{StreamingQueryProgressWrapper$.MODULE$.getUniqueId(runId, batchId, timestamp)}));
        this.store().write((Object)new StreamingQueryProgressWrapper(event.progress()));
        while (progressIds.length() > this.streamingProgressRetention()) {
            String uniqueId = (String)progressIds.dequeue();
            this.store().delete(StreamingQueryProgressWrapper.class, (Object)uniqueId);
        }
    }

    @Override
    public void onQueryIdle(StreamingQueryListener.QueryIdleEvent event) {
    }

    @Override
    public void onQueryTerminated(StreamingQueryListener.QueryTerminatedEvent event) {
        StreamingQueryData querySummary = (StreamingQueryData)this.store().read(StreamingQueryData.class, (Object)event.runId().toString());
        long curTime = System.currentTimeMillis();
        this.store().write((Object)new StreamingQueryData(querySummary.name(), querySummary.id(), querySummary.runId(), false, event.exception(), querySummary.startTimestamp(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)curTime))), true);
        this.queryToProgress().remove(event.runId());
    }

    public static final /* synthetic */ long $anonfun$cleanupInactiveQueries$1(StreamingQueryData x$1) {
        return BoxesRunTime.unboxToLong((Object)x$1.endTimestamp().get());
    }

    public StreamingQueryStatusListener(SparkConf conf, ElementTrackingStore store) {
        this.conf = conf;
        this.store = store;
        this.streamingProgressRetention = BoxesRunTime.unboxToInt((Object)conf.get(StaticSQLConf$.MODULE$.STREAMING_UI_RETAINED_PROGRESS_UPDATES()));
        this.inactiveQueryStatusRetention = BoxesRunTime.unboxToInt((Object)conf.get(StaticSQLConf$.MODULE$.STREAMING_UI_RETAINED_QUERIES()));
        store.addTrigger(StreamingQueryData.class, (long)this.inactiveQueryStatusRetention(), (Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)count -> this.cleanupInactiveQueries(count));
        this.queryToProgress = new ConcurrentHashMap();
    }
}

