/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.io.CompressionCodec$;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager$;
import org.apache.spark.sql.execution.streaming.state.RocksDBCheckpointMetadata;
import org.apache.spark.sql.execution.streaming.state.RocksDBCheckpointMetadata$;
import org.apache.spark.sql.execution.streaming.state.RocksDBFileManager$;
import org.apache.spark.sql.execution.streaming.state.RocksDBFileManagerMetrics;
import org.apache.spark.sql.execution.streaming.state.RocksDBFileManagerMetrics$;
import org.apache.spark.sql.execution.streaming.state.RocksDBFileMappings;
import org.apache.spark.sql.execution.streaming.state.RocksDBImmutableFile;
import org.apache.spark.sql.execution.streaming.state.RocksDBImmutableFile$;
import org.apache.spark.sql.execution.streaming.state.StateStoreChangelogReader;
import org.apache.spark.sql.execution.streaming.state.StateStoreChangelogWriter;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\t\u0005h\u0001B\u001d;\u0001%C\u0001B\u0016\u0001\u0003\u0002\u0003\u0006Ia\u0016\u0005\tE\u0002\u0011\t\u0011)A\u0005G\"A1\u000e\u0001B\u0001B\u0003%A\u000e\u0003\u0005u\u0001\t\u0005\t\u0015!\u0003X\u0011!)\bA!A!\u0002\u00139\u0006\"\u0002<\u0001\t\u00039\b\"C@\u0001\u0011\u000b\u0007I\u0011BA\u0001\u0011%\tY\u0001\u0001b\u0001\n\u0013\ti\u0001\u0003\u0005\u0002\u001a\u0001\u0001\u000b\u0011BA\b\u0011%\tY\u0002\u0001b\u0001\n\u0013\ti\u0002\u0003\u0005\u0002&\u0001\u0001\u000b\u0011BA\u0010\u0011%\tI\u0004\u0001b\u0001\n\u0013\tY\u0004\u0003\u0005\u0002B\u0001\u0001\u000b\u0011BA\u001f\u0011)\t\u0019\u0005\u0001EC\u0002\u0013%\u0011Q\t\u0005\b\u0003\u001f\u0002A\u0011BA)\u0011%\ti\u0006\u0001a\u0001\n\u0013\ty\u0006C\u0005\u0002h\u0001\u0001\r\u0011\"\u0003\u0002j!A\u0011Q\u000f\u0001!B\u0013\t\t\u0007C\u0004\u0002\u0000\u0001!\t!!!\t\u000f\u0005\r\u0005\u0001\"\u0001\u0002\u0006\"9\u0011q\u0011\u0001\u0005\u0002\u0005%\u0005bBAN\u0001\u0011\u0005\u0011Q\u0014\u0005\n\u0003O\u0003\u0001\u0019!C\u0005\u0003SC\u0011\"!-\u0001\u0001\u0004%I!a-\t\u0011\u0005]\u0006\u0001)Q\u0005\u0003WC\u0011\"a/\u0001\u0001\u0004%I!!+\t\u0013\u0005u\u0006\u00011A\u0005\n\u0005}\u0006\u0002CAb\u0001\u0001\u0006K!a+\t\u000f\u0005\u001d\u0007\u0001\"\u0001\u0002*\"9\u0011\u0011\u001a\u0001\u0005\u0002\u0005%\u0006bBAf\u0001\u0011\u0005\u0011Q\u001a\u0005\b\u0003;\u0004A\u0011AAp\u0011\u001d\ti\u000f\u0001C\u0001\u0003_Dq!a=\u0001\t\u0003\t)\u0010C\u0004\u0002x\u0002!\t!!?\t\u000f\tu\u0001\u0001\"\u0003\u0003 !9!1\u0006\u0001\u0005\u0002\t5\u0002b\u0002B\u001d\u0001\u0011%!1\b\u0005\b\u0005\u001f\u0002A\u0011\u0002B)\u0011\u001d\u0011I\u0006\u0001C\u0005\u00057BqAa\u0018\u0001\t\u0013\u0011\t\u0007C\u0004\u0003f\u0001!IAa\u001a\t\u000f\t]\u0004\u0001\"\u0003\u0003z!9!1\u0011\u0001\u0005\n\t\u0015\u0005b\u0002BF\u0001\u0011%!Q\u0012\u0005\b\u0005#\u0003A\u0011\u0002BJ\u0011\u001d\u00119\n\u0001C\u0005\u00053CqAa(\u0001\t#\u0012\t\u000bC\u0004\u0003$\u0002!IA!*\t\u000f\t-\u0006\u0001\"\u0003\u0003.\"9!1\u0017\u0001\u0005\n\tUv!\u0003B`u\u0005\u0005\t\u0012\u0001Ba\r!I$(!A\t\u0002\t\r\u0007B\u0002<6\t\u0003\u0011)\rC\u0005\u0003HV\n\n\u0011\"\u0001\u0003J\"I!q\\\u001b\u0012\u0002\u0013\u0005!\u0011\u001a\u0002\u0013%>\u001c7n\u001d#C\r&dW-T1oC\u001e,'O\u0003\u0002<y\u0005)1\u000f^1uK*\u0011QHP\u0001\ngR\u0014X-Y7j]\u001eT!a\u0010!\u0002\u0013\u0015DXmY;uS>t'BA!C\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0007\u0012\u000bQa\u001d9be.T!!\u0012$\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0015aA8sO\u000e\u00011c\u0001\u0001K!B\u00111JT\u0007\u0002\u0019*\tQ*A\u0003tG\u0006d\u0017-\u0003\u0002P\u0019\n1\u0011I\\=SK\u001a\u0004\"!\u0015+\u000e\u0003IS!a\u0015\"\u0002\u0011%tG/\u001a:oC2L!!\u0016*\u0003\u000f1{wmZ5oO\u0006QAMZ:S_>$H)\u001b:\u0011\u0005a{fBA-^!\tQF*D\u0001\\\u0015\ta\u0006*\u0001\u0004=e>|GOP\u0005\u0003=2\u000ba\u0001\u0015:fI\u00164\u0017B\u00011b\u0005\u0019\u0019FO]5oO*\u0011a\fT\u0001\rY>\u001c\u0017\r\u001c+f[B$\u0015N\u001d\t\u0003I&l\u0011!\u001a\u0006\u0003M\u001e\f!![8\u000b\u0003!\fAA[1wC&\u0011!.\u001a\u0002\u0005\r&dW-\u0001\u0006iC\u0012|w\u000e]\"p]\u001a\u0004\"!\u001c:\u000e\u00039T!a\u001c9\u0002\t\r|gN\u001a\u0006\u0003c\u0012\u000ba\u0001[1e_>\u0004\u0018BA:o\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u0006I1m\u001c3fG:\u000bW.Z\u0001\nY><w-\u001b8h\u0013\u0012\fa\u0001P5oSRtDC\u0002={wrlh\u0010\u0005\u0002z\u00015\t!\bC\u0003W\r\u0001\u0007q\u000bC\u0003c\r\u0001\u00071\rC\u0003l\r\u0001\u0007A\u000eC\u0004u\rA\u0005\t\u0019A,\t\u000fU4\u0001\u0013!a\u0001/\u0006\u0011a-\\\u000b\u0003\u0003\u0007\u0001B!!\u0002\u0002\b5\tA(C\u0002\u0002\nq\u0012Qc\u00115fG.\u0004x.\u001b8u\r&dW-T1oC\u001e,'/\u0001\u0002ggV\u0011\u0011q\u0002\t\u0005\u0003#\t)\"\u0004\u0002\u0002\u0014)\u0019\u00111\u00029\n\t\u0005]\u00111\u0003\u0002\u000b\r&dWmU=ti\u0016l\u0017a\u00014tA\u0005aqN\u001c7z5&\u0004h)\u001b7fgV\u0011\u0011q\u0004\n\u0007\u0003C\t9#a\r\u0007\r\u0005\r2\u0002AA\u0010\u00051a$/\u001a4j]\u0016lWM\u001c;?\u00035yg\u000e\\=[SB4\u0015\u000e\\3tAA!\u0011\u0011FA\u0018\u001b\t\tYCC\u0002\u0002.\u001d\fA\u0001\\1oO&!\u0011\u0011GA\u0016\u0005\u0019y%M[3diB!\u0011\u0011CA\u001b\u0013\u0011\t9$a\u0005\u0003\u0015A\u000bG\u000f\u001b$jYR,'/\u0001\np]2L8\t[1oO\u0016dwn\u001a$jY\u0016\u001cXCAA\u001f%\u0019\ty$a\n\u00024\u00191\u00111E\u0007\u0001\u0003{\t1c\u001c8ms\u000eC\u0017M\\4fY><g)\u001b7fg\u0002\n\u0011b\u001d9be.\u001cuN\u001c4\u0016\u0005\u0005\u001d\u0003\u0003BA%\u0003\u0017j\u0011AQ\u0005\u0004\u0003\u001b\u0012%!C*qCJ\\7i\u001c8g\u0003\u0015\u0019w\u000eZ3d+\t\t\u0019\u0006\u0005\u0003\u0002V\u0005eSBAA,\u0015\t1')\u0003\u0003\u0002\\\u0005]#\u0001E\"p[B\u0014Xm]:j_:\u001cu\u000eZ3d\u000311\u0017\u000e\\3NCB\u0004\u0018N\\4t+\t\t\t\u0007E\u0002z\u0003GJ1!!\u001a;\u0005M\u0011vnY6t\t\n3\u0015\u000e\\3NCB\u0004\u0018N\\4t\u0003A1\u0017\u000e\\3NCB\u0004\u0018N\\4t?\u0012*\u0017\u000f\u0006\u0003\u0002l\u0005E\u0004cA&\u0002n%\u0019\u0011q\u000e'\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003g\n\u0012\u0011!a\u0001\u0003C\n1\u0001\u001f\u00132\u000351\u0017\u000e\\3NCB\u0004\u0018N\\4tA!\u001a!#!\u001f\u0011\u0007-\u000bY(C\u0002\u0002~1\u0013\u0001B^8mCRLG.Z\u0001\u0010G>\u0004\u0018PR5mK6\u000b\u0007\u000f]5oOR\u0011\u00111N\u0001\u0018G\u0006\u0004H/\u001e:f\r&dW-T1q%\u00164WM]3oG\u0016$\"!!\u0019\u0002%\u001d,Go\u00115b]\u001e,Gj\\4Xe&$XM\u001d\u000b\u0005\u0003\u0017\u000b\t\nE\u0002z\u0003\u001bK1!a$;\u0005e\u0019F/\u0019;f'R|'/Z\"iC:<W\r\\8h/JLG/\u001a:\t\u000f\u0005MU\u00031\u0001\u0002\u0016\u00069a/\u001a:tS>t\u0007cA&\u0002\u0018&\u0019\u0011\u0011\u0014'\u0003\t1{gnZ\u0001\u0013O\u0016$8\t[1oO\u0016dwn\u001a*fC\u0012,'\u000f\u0006\u0003\u0002 \u0006\u0015\u0006cA=\u0002\"&\u0019\u00111\u0015\u001e\u00033M#\u0018\r^3Ti>\u0014Xm\u00115b]\u001e,Gn\\4SK\u0006$WM\u001d\u0005\b\u0003'3\u0002\u0019AAK\u0003Uaw.\u00193DQ\u0016\u001c7\u000e]8j]RlU\r\u001e:jGN,\"!a+\u0011\u0007e\fi+C\u0002\u00020j\u0012\u0011DU8dWN$%IR5mK6\u000bg.Y4fe6+GO]5dg\u0006IBn\\1e\u0007\",7m\u001b9pS:$X*\u001a;sS\u000e\u001cx\fJ3r)\u0011\tY'!.\t\u0013\u0005M\u0004$!AA\u0002\u0005-\u0016A\u00067pC\u0012\u001c\u0005.Z2la>Lg\u000e^'fiJL7m\u001d\u0011)\u0007e\tI(A\u000btCZ,7\t[3dWB|\u0017N\u001c;NKR\u0014\u0018nY:\u00023M\fg/Z\"iK\u000e\\\u0007o\\5oi6+GO]5dg~#S-\u001d\u000b\u0005\u0003W\n\t\rC\u0005\u0002tm\t\t\u00111\u0001\u0002,\u000612/\u0019<f\u0007\",7m\u001b9pS:$X*\u001a;sS\u000e\u001c\b\u0005K\u0002\u001d\u0003s\n1\u0004\\1uKN$Hj\\1e\u0007\",7m\u001b9pS:$X*\u001a;sS\u000e\u001c\u0018a\u00077bi\u0016\u001cHoU1wK\u000eCWmY6q_&tG/T3ue&\u001c7/A\ntCZ,7\t[3dWB|\u0017N\u001c;U_\u001237\u000f\u0006\u0006\u0002l\u0005=\u00171[Ak\u00033Da!!5 \u0001\u0004\u0019\u0017!D2iK\u000e\\\u0007o\\5oi\u0012K'\u000fC\u0004\u0002\u0014~\u0001\r!!&\t\u000f\u0005]w\u00041\u0001\u0002\u0016\u00069a.^7LKf\u001c\bbBAn?\u0001\u0007\u0011\u0011M\u0001\u0015G\u0006\u0004H/\u001e:fI\u001aKG.Z'baBLgnZ:\u0002+1|\u0017\rZ\"iK\u000e\\\u0007o\\5oi\u001a\u0013x.\u001c#ggR1\u0011\u0011]At\u0003S\u00042!_Ar\u0013\r\t)O\u000f\u0002\u001a%>\u001c7n\u001d#C\u0007\",7m\u001b9pS:$X*\u001a;bI\u0006$\u0018\rC\u0004\u0002\u0014\u0002\u0002\r!!&\t\r\u0005-\b\u00051\u0001d\u0003!awnY1m\t&\u0014\u0018\u0001G4fi2\u000bG/Z:u':\f\u0007o\u001d5piZ+'o]5p]R!\u0011QSAy\u0011\u001d\t\u0019*\ta\u0001\u0003+\u000b\u0001cZ3u\u0019\u0006$Xm\u001d;WKJ\u001c\u0018n\u001c8\u0015\u0005\u0005U\u0015a\u00044j]\u0012|%\u000f\u001d5b]\u001aKG.Z:\u0015\r\u0005m(Q\u0002B\t!\u0015\tiPa\u0002X\u001d\u0011\tyPa\u0001\u000f\u0007i\u0013\t!C\u0001N\u0013\r\u0011)\u0001T\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011IAa\u0003\u0003\u0007M+\u0017OC\u0002\u0003\u00061CqAa\u0004$\u0001\u0004\tY0\u0001\u0007ue\u0006\u001c7.\u001a3GS2,7\u000fC\u0004\u0003\u0014\r\u0002\rA!\u0006\u0002\u0011\u0005dGNR5mKN\u0004b!!@\u0003\b\t]\u0001\u0003BA\t\u00053IAAa\u0007\u0002\u0014\tQa)\u001b7f'R\fG/^:\u0002)\u0011,G.\u001a;f\u0007\"\fgnZ3m_\u001e4\u0015\u000e\\3t)\u0011\tYG!\t\t\u000f\t\rB\u00051\u0001\u0003&\u0005\u0001b/\u001a:tS>t7\u000fV8EK2,G/\u001a\t\u0006\u0017\n\u001d\u0012QS\u0005\u0004\u0005Sa%!B!se\u0006L\u0018!\u00053fY\u0016$Xm\u00147e-\u0016\u00148/[8ogR!\u00111\u000eB\u0018\u0011\u001d\u0011\t$\na\u0001\u0005g\t1C\\;n-\u0016\u00148/[8ogR{'+\u001a;bS:\u00042a\u0013B\u001b\u0013\r\u00119\u0004\u0014\u0002\u0004\u0013:$\u0018aF:bm\u0016LU.\\;uC\ndWMR5mKN$v\u000e\u00124t)!\u0011iD!\u0012\u0003H\t5\u0003CBA\u007f\u0005\u000f\u0011y\u0004E\u0002z\u0005\u0003J1Aa\u0011;\u0005Q\u0011vnY6t\t\nKU.\\;uC\ndWMR5mK\"9\u00111\u0013\u0014A\u0002\u0005U\u0005b\u0002B%M\u0001\u0007!1J\u0001\u000bY>\u001c\u0017\r\u001c$jY\u0016\u001c\b#BA\u007f\u0005\u000f\u0019\u0007bBAnM\u0001\u0007\u0011\u0011M\u0001\u001aY>\fG-S7nkR\f'\r\\3GS2,7O\u0012:p[\u001237\u000f\u0006\u0004\u0002l\tM#q\u000b\u0005\b\u0005+:\u0003\u0019\u0001B\u001f\u00039IW.\\;uC\ndWMR5mKNDa!a;(\u0001\u0004\u0019\u0017A\u000b:f[>4X\rT8dC2d\u0017\u0010R3mKR,GmU*U\r&dWm\u001d$s_6$em]'baBLgn\u001a\u000b\u0005\u0003W\u0012i\u0006C\u0004\u0003J!\u0002\rAa\u0013\u0002?\u001d,G/S7nkR\f'\r\\3GS2,7O\u0012:p[Z+'o]5p]jK\u0007\u000f\u0006\u0003\u0003>\t\r\u0004bBAJS\u0001\u0007\u0011QS\u0001\ru&\u0004Hk\u001c#gg\u001aKG.\u001a\u000b\u0007\u0003W\u0012IG!\u001c\t\u000f\t-$\u00061\u0001\u0003L\u0005)a-\u001b7fg\"9!q\u000e\u0016A\u0002\tE\u0014A\u00033ggjK\u0007OR5mKB!\u0011\u0011\u0003B:\u0013\u0011\u0011)(a\u0005\u0003\tA\u000bG\u000f[\u0001\u000eY><g)\u001b7fg&sG)\u001b:\u0015\r\u0005-$1\u0010B@\u0011\u0019\u0011ih\u000ba\u0001G\u0006\u0019A-\u001b:\t\r\t\u00055\u00061\u0001X\u0003\ri7oZ\u0001\u000f]\u0016<HIR*GS2,g*Y7f)\r9&q\u0011\u0005\u0007\u0005\u0013c\u0003\u0019A,\u0002\u001b1|7-\u00197GS2,g*Y7f\u0003=!gm\u001d\"bi\u000eD',\u001b9GS2,G\u0003\u0002B9\u0005\u001fCq!a%.\u0001\u0004\t)*\u0001\teMN\u001c\u0005.\u00198hK2|wMR5mKR!!\u0011\u000fBK\u0011\u001d\t\u0019J\fa\u0001\u0003+\u000b\u0011\u0003\\8dC2lU\r^1eCR\fg)\u001b7f)\r\u0019'1\u0014\u0005\u0007\u0005;{\u0003\u0019A2\u0002\u0013A\f'/\u001a8u\t&\u0014\u0018a\u00027pO:\u000bW.Z\u000b\u0002/\u0006YAMZ:GS2,\u0007+\u0019;i)\u0011\u0011\tHa*\t\r\t%\u0016\u00071\u0001X\u0003!1\u0017\u000e\\3OC6,\u0017!\u00047pG\u0006dg)\u001b7f!\u0006$\b\u000eF\u0003d\u0005_\u0013\t\f\u0003\u0004\u0002lJ\u0002\ra\u0019\u0005\u0007\u0005S\u0013\u0004\u0019A,\u0002!1L7\u000f\u001e*pG.\u001cHI\u0011$jY\u0016\u001cH\u0003\u0002B\\\u0005{\u0003ra\u0013B]\u0005\u0017\u0012Y%C\u0002\u0003<2\u0013a\u0001V;qY\u0016\u0014\u0004BBAvg\u0001\u00071-\u0001\nS_\u000e\\7\u000f\u0012\"GS2,W*\u00198bO\u0016\u0014\bCA=6'\t)$\n\u0006\u0002\u0003B\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ*\"Aa3+\u0007]\u0013im\u000b\u0002\u0003PB!!\u0011\u001bBn\u001b\t\u0011\u0019N\u0003\u0003\u0003V\n]\u0017!C;oG\",7m[3e\u0015\r\u0011I\u000eT\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002Bo\u0005'\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%k\u0001")
public class RocksDBFileManager
implements Logging {
    private CheckpointFileManager fm;
    private SparkConf sparkConf;
    private final String dfsRootDir;
    private final File localTempDir;
    private Configuration hadoopConf;
    private final String codecName;
    private final String loggingId;
    private final FileSystem fs;
    private final PathFilter onlyZipFiles;
    private final PathFilter onlyChangelogFiles;
    private volatile RocksDBFileMappings fileMappings;
    private volatile RocksDBFileManagerMetrics loadCheckpointMetrics;
    private volatile RocksDBFileManagerMetrics saveCheckpointMetrics;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static String $lessinit$greater$default$5() {
        return RocksDBFileManager$.MODULE$.$lessinit$greater$default$5();
    }

    public static String $lessinit$greater$default$4() {
        return RocksDBFileManager$.MODULE$.$lessinit$greater$default$4();
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private CheckpointFileManager fm$lzycompute() {
        RocksDBFileManager rocksDBFileManager = this;
        synchronized (rocksDBFileManager) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.fm = CheckpointFileManager$.MODULE$.create(new Path(this.dfsRootDir), this.hadoopConf);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        this.hadoopConf = null;
        return this.fm;
    }

    private CheckpointFileManager fm() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.fm$lzycompute();
        }
        return this.fm;
    }

    private FileSystem fs() {
        return this.fs;
    }

    private PathFilter onlyZipFiles() {
        return this.onlyZipFiles;
    }

    private PathFilter onlyChangelogFiles() {
        return this.onlyChangelogFiles;
    }

    private SparkConf sparkConf$lzycompute() {
        RocksDBFileManager rocksDBFileManager = this;
        synchronized (rocksDBFileManager) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.sparkConf = (SparkConf)Option$.MODULE$.apply((Object)SparkEnv$.MODULE$.get()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.conf()).getOrElse((Function0 & Serializable & scala.Serializable)() -> new SparkConf());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.sparkConf;
    }

    private SparkConf sparkConf() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.sparkConf$lzycompute();
        }
        return this.sparkConf;
    }

    private CompressionCodec codec() {
        return CompressionCodec$.MODULE$.createCodec(this.sparkConf(), this.codecName);
    }

    private RocksDBFileMappings fileMappings() {
        return this.fileMappings;
    }

    private void fileMappings_$eq(RocksDBFileMappings x$1) {
        this.fileMappings = x$1;
    }

    public void copyFileMapping() {
        ConcurrentHashMap<Object, Seq<RocksDBImmutableFile>> newVersionToRocksDBFiles = new ConcurrentHashMap<Object, Seq<RocksDBImmutableFile>>();
        ConcurrentHashMap<String, RocksDBImmutableFile> newLocalFilesToDfsFiles = new ConcurrentHashMap<String, RocksDBImmutableFile>();
        newVersionToRocksDBFiles.putAll(this.fileMappings().versionToRocksDBFiles());
        newLocalFilesToDfsFiles.putAll(this.fileMappings().localFilesToDfsFiles());
        this.fileMappings_$eq(new RocksDBFileMappings(newVersionToRocksDBFiles, newLocalFilesToDfsFiles));
    }

    public RocksDBFileMappings captureFileMapReference() {
        return this.fileMappings();
    }

    public StateStoreChangelogWriter getChangeLogWriter(long version) {
        Path rootDir = new Path(this.dfsRootDir);
        Path changelogFile = this.dfsChangelogFile(version);
        if (!this.fm().exists(rootDir)) {
            this.fm().mkdirs(rootDir);
        }
        StateStoreChangelogWriter changelogWriter = new StateStoreChangelogWriter(this.fm(), changelogFile, this.codec());
        return changelogWriter;
    }

    public StateStoreChangelogReader getChangelogReader(long version) {
        Path changelogFile = this.dfsChangelogFile(version);
        return new StateStoreChangelogReader(this.fm(), changelogFile, this.codec());
    }

    private RocksDBFileManagerMetrics loadCheckpointMetrics() {
        return this.loadCheckpointMetrics;
    }

    private void loadCheckpointMetrics_$eq(RocksDBFileManagerMetrics x$1) {
        this.loadCheckpointMetrics = x$1;
    }

    private RocksDBFileManagerMetrics saveCheckpointMetrics() {
        return this.saveCheckpointMetrics;
    }

    private void saveCheckpointMetrics_$eq(RocksDBFileManagerMetrics x$1) {
        this.saveCheckpointMetrics = x$1;
    }

    public RocksDBFileManagerMetrics latestLoadCheckpointMetrics() {
        return this.loadCheckpointMetrics();
    }

    public RocksDBFileManagerMetrics latestSaveCheckpointMetrics() {
        return this.saveCheckpointMetrics();
    }

    public void saveCheckpointToDfs(File checkpointDir, long version, long numKeys, RocksDBFileMappings capturedFileMappings) {
        this.logFilesInDir(checkpointDir, new StringBuilder(36).append("Saving checkpoint files for version ").append(version).toString());
        Tuple2<Seq<File>, Seq<File>> tuple2 = this.listRocksDBFiles(checkpointDir);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq localImmutableFiles = (Seq)tuple2._1();
        Seq localOtherFiles = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)localImmutableFiles, (Object)localOtherFiles);
        Seq localImmutableFiles2 = (Seq)tuple22._1();
        Seq localOtherFiles2 = (Seq)tuple22._2();
        Seq<RocksDBImmutableFile> rocksDBFiles = this.saveImmutableFilesToDfs(version, (Seq<File>)localImmutableFiles2, capturedFileMappings);
        RocksDBCheckpointMetadata metadata = RocksDBCheckpointMetadata$.MODULE$.apply(rocksDBFiles, numKeys);
        File metadataFile = this.localMetadataFile(checkpointDir);
        metadata.writeToFile(metadataFile);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Written metadata for version ").append(version).append(":\n").append(metadata.prettyJson()).toString());
        if (version <= 1L && numKeys <= 0L) {
            Path path = new Path(this.dfsRootDir);
            if (!this.fm().exists(path)) {
                this.fm().mkdirs(path);
            }
        }
        this.zipToDfsFile((Seq<File>)((Seq)localOtherFiles2.$colon$plus((Object)metadataFile, Seq$.MODULE$.canBuildFrom())), this.dfsBatchZipFile(version));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Saved checkpoint file for version ").append(version).toString());
    }

    public RocksDBCheckpointMetadata loadCheckpointFromDfs(long version, File localDir) {
        RocksDBCheckpointMetadata rocksDBCheckpointMetadata;
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Loading checkpoint files for version ").append(version).toString());
        this.fileMappings().versionToRocksDBFiles().keySet().removeIf(x$3 -> RocksDBFileManager.$anonfun$loadCheckpointFromDfs$2(version, BoxesRunTime.unboxToLong((Object)x$3)));
        if (version == 0L) {
            if (localDir.exists()) {
                Utils$.MODULE$.deleteRecursively(localDir);
            }
            this.fileMappings().localFilesToDfsFiles().clear();
            localDir.mkdirs();
            rocksDBCheckpointMetadata = RocksDBCheckpointMetadata$.MODULE$.apply((Seq<RocksDBImmutableFile>)((Seq)Nil$.MODULE$), 0L);
        } else {
            ((IterableLike)this.listRocksDBFiles(localDir)._2()).foreach((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.delete()));
            Utils$.MODULE$.unzipFilesFromFile(this.fs(), this.dfsBatchZipFile(version), localDir);
            File metadataFile = this.localMetadataFile(localDir);
            RocksDBCheckpointMetadata metadata = RocksDBCheckpointMetadata$.MODULE$.readFromFile(metadataFile);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Read metadata for version ").append(version).append(":\n").append(metadata.prettyJson()).toString());
            this.loadImmutableFilesFromDfs(metadata.immutableFiles(), localDir);
            this.fileMappings().versionToRocksDBFiles().put(BoxesRunTime.boxToLong((long)version), metadata.immutableFiles());
            metadataFile.delete();
            rocksDBCheckpointMetadata = metadata;
        }
        RocksDBCheckpointMetadata metadata = rocksDBCheckpointMetadata;
        this.logFilesInDir(localDir, new StringBuilder(36).append("Loaded checkpoint files for version ").append(version).toString());
        return metadata;
    }

    public long getLatestSnapshotVersion(long version) {
        Path path = new Path(this.dfsRootDir);
        if (this.fm().exists(path)) {
            if (this.fm().exists(this.dfsBatchZipFile(version))) {
                return version;
            }
            return BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fm().list(path, this.onlyZipFiles()))).map((Function1 & Serializable & scala.Serializable)x$5 -> new StringOps(Predef$.MODULE$.augmentString(x$5.getPath().getName())).stripSuffix(".zip"), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)RocksDBFileManager.$anonfun$getLatestSnapshotVersion$2(x$6)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$7 -> x$7 <= version))).foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2)(JFunction2.mcJJJ.sp & Serializable & scala.Serializable)(x, y) -> package$.MODULE$.max(x, y)));
        }
        return 0L;
    }

    public long getLatestVersion() {
        Path path = new Path(this.dfsRootDir);
        if (this.fm().exists(path)) {
            Path[] files = (Path[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fm().list(path))).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.getPath(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class)));
            long[] changelogFileVersions = (long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)RocksDBFileManager.$anonfun$getLatestVersion$2(this, x$9))))).map((Function1 & Serializable & scala.Serializable)x$10 -> new StringOps(Predef$.MODULE$.augmentString(x$10.getName())).stripSuffix(".changelog"), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)RocksDBFileManager.$anonfun$getLatestVersion$4(x$11)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
            long[] snapshotFileVersions = (long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).filter((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)RocksDBFileManager.$anonfun$getLatestVersion$5(this, x$12))))).map((Function1 & Serializable & scala.Serializable)x$13 -> new StringOps(Predef$.MODULE$.augmentString(x$13.getName())).stripSuffix(".zip"), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToLong((long)RocksDBFileManager.$anonfun$getLatestVersion$7(x$14)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
            long[] versions = (long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(changelogFileVersions)).$plus$plus((GenTraversableOnce)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(snapshotFileVersions)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
            return BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(versions)).foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2)(JFunction2.mcJJJ.sp & Serializable & scala.Serializable)(x, y) -> package$.MODULE$.max(x, y)));
        }
        return 0L;
    }

    public Seq<String> findOrphanFiles(Seq<String> trackedFiles, Seq<FileStatus> allFiles) {
        Map fileModificationTimes = ((TraversableOnce)allFiles.map((Function1 & Serializable & scala.Serializable)file -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)file.getPath().getName()), (Object)BoxesRunTime.boxToLong((long)file.getModificationTime())), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        if (trackedFiles.nonEmpty() && allFiles.size() > trackedFiles.size()) {
            long oldestTrackedFileModificationTime = BoxesRunTime.unboxToLong((Object)((TraversableOnce)trackedFiles.flatMap((Function1 & Serializable & scala.Serializable)x$15 -> Option$.MODULE$.option2Iterable(fileModificationTimes.get(x$15)), Seq$.MODULE$.canBuildFrom())).min((Ordering)Ordering.Long$.MODULE$));
            Seq orphanFiles = ((MapLike)fileModificationTimes.filter((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)RocksDBFileManager.$anonfun$findOrphanFiles$3(oldestTrackedFileModificationTime, x$16)))).keys().toSeq();
            if (orphanFiles.nonEmpty()) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(79).append("Found ").append(orphanFiles.size()).append(" orphan files: ").append(((TraversableOnce)orphanFiles.take(20)).mkString(", ")).append("... (display at most 20 filenames) that should be deleted.").toString());
            }
            return orphanFiles;
        }
        return (Seq)Nil$.MODULE$;
    }

    private void deleteChangelogFiles(long[] versionsToDelete) {
        new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(versionsToDelete)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)version -> {
            try {
                this.fm().delete(this.dfsChangelogFile(version));
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Deleted changelog file ").append(version).toString());
            }
            catch (Exception e) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Error deleting changelog file for version ").append(version).toString(), e);
            }
        });
    }

    public void deleteOldVersions(int numVersionsToRetain) {
        Path path = new Path(this.dfsRootDir);
        Path[] allFiles = (Path[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fm().list(path))).map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.getPath(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class)));
        Path[] snapshotFiles = (Path[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allFiles)).filter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)RocksDBFileManager.$anonfun$deleteOldVersions$2(this, file)));
        Path[] changelogFiles = (Path[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allFiles)).filter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)RocksDBFileManager.$anonfun$deleteOldVersions$3(this, file)));
        long[] sortedSnapshotVersions = (long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])snapshotFiles)).map((Function1 & Serializable & scala.Serializable)x$18 -> new StringOps(Predef$.MODULE$.augmentString(x$18.getName())).stripSuffix(".zip"), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).map((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToLong((long)RocksDBFileManager.$anonfun$deleteOldVersions$5(x$19)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).sorted((Ordering)Ordering.Long$.MODULE$);
        if (new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(sortedSnapshotVersions)).isEmpty()) {
            return;
        }
        long maxSnapshotVersionPresent = BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(sortedSnapshotVersions)).last());
        long minVersionToRetain = BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(sortedSnapshotVersions)).filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$20 -> x$20 <= maxSnapshotVersionPresent - (long)numVersionsToRetain + 1L))).foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2)(JFunction2.mcJJJ.sp & Serializable & scala.Serializable)(x, y) -> package$.MODULE$.max(x, y)));
        long[] snapshotVersionsToDelete = (long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(sortedSnapshotVersions)).filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$21 -> x$21 < minVersionToRetain);
        if (new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(snapshotVersionsToDelete)).isEmpty()) {
            return;
        }
        HashMap fileToMaxUsedVersion = new HashMap();
        new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(sortedSnapshotVersions)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)version -> {
            Seq files = (Seq)Option$.MODULE$.apply(this.fileMappings().versionToRocksDBFiles().get(BoxesRunTime.boxToLong((long)version))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                Seq<RocksDBImmutableFile> newResolvedFiles = this.getImmutableFilesFromVersionZip(version);
                this.fileMappings().versionToRocksDBFiles().put(BoxesRunTime.boxToLong((long)version), newResolvedFiles);
                return newResolvedFiles;
            });
            files.foreach((Function1 & Serializable & scala.Serializable)f -> {
                fileToMaxUsedVersion.update((Object)f.dfsFileName(), (Object)BoxesRunTime.boxToLong((long)package$.MODULE$.max(version, BoxesRunTime.unboxToLong((Object)fileToMaxUsedVersion.getOrElse((Object)f.dfsFileName(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> version$5)))));
                return BoxedUnit.UNIT;
            });
        });
        HashMap filesToDelete = (HashMap)fileToMaxUsedVersion.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)RocksDBFileManager.$anonfun$deleteOldVersions$13(snapshotVersionsToDelete, x0$1)));
        Path sstDir = new Path(this.dfsRootDir, RocksDBImmutableFile$.MODULE$.SST_FILES_DFS_SUBDIR());
        Path logDir = new Path(this.dfsRootDir, RocksDBImmutableFile$.MODULE$.LOG_FILES_DFS_SUBDIR());
        Seq allSstFiles = this.fm().exists(sstDir) ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fm().list(sstDir))).toSeq() : (Seq)Nil$.MODULE$;
        Seq allLogFiles = this.fm().exists(logDir) ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fm().list(logDir))).toSeq() : (Seq)Nil$.MODULE$;
        filesToDelete.$plus$plus$eq((TraversableOnce)this.findOrphanFiles((Seq<String>)fileToMaxUsedVersion.keys().toSeq(), (Seq<FileStatus>)((Seq)allSstFiles.$plus$plus((GenTraversableOnce)allLogFiles, Seq$.MODULE$.canBuildFrom()))).map((Function1 & Serializable & scala.Serializable)x$22 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$22), (Object)BoxesRunTime.boxToLong((long)-1L)), Seq$.MODULE$.canBuildFrom()));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Deleting ").append(filesToDelete.size()).append(" files not used in versions >= ").append(minVersionToRetain).toString());
        IntRef failedToDelete = IntRef.create((int)0);
        filesToDelete.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            RocksDBFileManager.$anonfun$deleteOldVersions$16(this, failedToDelete, x0$2);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(snapshotVersionsToDelete)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)version -> {
            Path versionFile = this.dfsBatchZipFile(version);
            try {
                this.fm().delete(versionFile);
                this.fileMappings().versionToRocksDBFiles().remove(BoxesRunTime.boxToLong((long)version));
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Deleted version ").append(version).toString());
            }
            catch (Exception e) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Error deleting version file ").append(versionFile).append(" for version ").append(version).toString(), e);
            }
        });
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Deleted ").append(filesToDelete.size() - failedToDelete$1.elem).append(" files (failed to delete").append(failedToDelete$1.elem).append(" files) not used in versions >= ").append(minVersionToRetain).toString());
        long[] changelogVersionsToDelete = (long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])changelogFiles)).map((Function1 & Serializable & scala.Serializable)x$23 -> new StringOps(Predef$.MODULE$.augmentString(x$23.getName())).stripSuffix(".changelog"), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).map((Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToLong((long)RocksDBFileManager.$anonfun$deleteOldVersions$26(x$24)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$25 -> x$25 < minVersionToRetain);
        this.deleteChangelogFiles(changelogVersionsToDelete);
    }

    private Seq<RocksDBImmutableFile> saveImmutableFilesToDfs(long version, Seq<File> localFiles, RocksDBFileMappings capturedFileMappings) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Saving RocksDB files to DFS for ").append(version).toString());
        LongRef bytesCopied = LongRef.create((long)0L);
        LongRef filesCopied = LongRef.create((long)0L);
        LongRef filesReused = LongRef.create((long)0L);
        Seq immutableFiles = (Seq)localFiles.map((Function1 & Serializable & scala.Serializable)localFile -> {
            Option existingDfsFile = ((MapLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(capturedFileMappings.localFilesToDfsFiles()).asScala()).get((Object)localFile.getName());
            if (existingDfsFile.isDefined() && ((RocksDBImmutableFile)existingDfsFile.get()).sizeBytes() == localFile.length()) {
                RocksDBImmutableFile dfsFile = (RocksDBImmutableFile)existingDfsFile.get();
                ++filesReused$1.elem;
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("reusing file ").append(dfsFile).append(" for ").append(localFile).toString());
                return RocksDBImmutableFile$.MODULE$.apply(localFile.getName(), dfsFile.dfsFileName(), dfsFile.sizeBytes());
            }
            String localFileName = localFile.getName();
            String dfsFileName = this.newDFSFileName(localFileName);
            Path dfsFile = this.dfsFilePath(dfsFileName);
            this.fs().copyFromLocalFile(new Path(localFile.getAbsoluteFile().toURI()), dfsFile);
            long localFileSize = localFile.length();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Copied ").append(localFile).append(" to ").append(dfsFile).append(" - ").append(localFileSize).append(" bytes").toString());
            ++filesCopied$1.elem;
            bytesCopied$1.elem += localFileSize;
            RocksDBImmutableFile immutableDfsFile = RocksDBImmutableFile$.MODULE$.apply(localFile.getName(), dfsFileName, localFileSize);
            capturedFileMappings.localFilesToDfsFiles().put(localFileName, immutableDfsFile);
            return immutableDfsFile;
        }, Seq$.MODULE$.canBuildFrom());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(85).append("Copied ").append(filesCopied$1.elem).append(" files (").append(bytesCopied$1.elem).append(" bytes) from local to").append(" DFS for version ").append(version).append(". ").append(filesReused$1.elem).append(" files reused without copying.").toString());
        capturedFileMappings.versionToRocksDBFiles().put(BoxesRunTime.boxToLong((long)version), (Seq<RocksDBImmutableFile>)immutableFiles);
        this.removeLocallyDeletedSSTFilesFromDfsMapping(localFiles);
        long x$1 = bytesCopied.elem;
        long x$2 = filesCopied.elem;
        long x$3 = filesReused.elem;
        Option<Object> x$4 = RocksDBFileManagerMetrics$.MODULE$.apply$default$4();
        this.saveCheckpointMetrics_$eq(new RocksDBFileManagerMetrics(x$2, x$1, x$3, x$4));
        return immutableFiles;
    }

    private void loadImmutableFilesFromDfs(Seq<RocksDBImmutableFile> immutableFiles, File localDir) {
        Map requiredFileNameToFileDetails = ((TraversableOnce)immutableFiles.map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.localFileName()), f), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Seq localImmutableFiles = (Seq)this.listRocksDBFiles(localDir)._1();
        this.removeLocallyDeletedSSTFilesFromDfsMapping((Seq<File>)localImmutableFiles);
        localImmutableFiles.foreach((Function1 & Serializable & scala.Serializable)existingFile -> {
            RocksDBFileManager.$anonfun$loadImmutableFilesFromDfs$2(this, requiredFileNameToFileDetails, existingFile);
            return BoxedUnit.UNIT;
        });
        LongRef filesCopied = LongRef.create((long)0L);
        LongRef bytesCopied = LongRef.create((long)0L);
        LongRef filesReused = LongRef.create((long)0L);
        immutableFiles.foreach((Function1 & Serializable & scala.Serializable)file -> {
            RocksDBFileManager.$anonfun$loadImmutableFilesFromDfs$6(this, localDir, filesCopied, bytesCopied, filesReused, file);
            return BoxedUnit.UNIT;
        });
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Copied ").append(filesCopied$2.elem).append(" files (").append(bytesCopied$2.elem).append(" bytes) from DFS to local with ").append(filesReused$2.elem).append(" files reused.").toString());
        long x$1 = bytesCopied.elem;
        long x$2 = filesCopied.elem;
        long x$3 = filesReused.elem;
        Option<Object> x$4 = RocksDBFileManagerMetrics$.MODULE$.apply$default$4();
        this.loadCheckpointMetrics_$eq(new RocksDBFileManagerMetrics(x$2, x$1, x$3, x$4));
    }

    private void removeLocallyDeletedSSTFilesFromDfsMapping(Seq<File> localFiles) {
        Set currentLocalFiles = ((TraversableOnce)localFiles.map((Function1 & Serializable & scala.Serializable)x$26 -> x$26.getName(), Seq$.MODULE$.canBuildFrom())).toSet();
        Iterable mappingsToClean = (Iterable)((MapLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.fileMappings().localFilesToDfsFiles()).asScala()).keys().filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)currentLocalFiles.contains((Object)elem)));
        mappingsToClean.foreach((Function1 & Serializable & scala.Serializable)f -> {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("cleaning ").append((String)f).append(" from the localFilesToDfsFiles map").toString());
            return this.fileMappings().localFilesToDfsFiles().remove(f);
        });
    }

    private Seq<RocksDBImmutableFile> getImmutableFilesFromVersionZip(long version) {
        Utils$.MODULE$.deleteRecursively(this.localTempDir);
        this.localTempDir.mkdirs();
        Utils$.MODULE$.unzipFilesFromFile(this.fs(), this.dfsBatchZipFile(version), this.localTempDir);
        File metadataFile = this.localMetadataFile(this.localTempDir);
        RocksDBCheckpointMetadata metadata = RocksDBCheckpointMetadata$.MODULE$.readFromFile(metadataFile);
        return metadata.immutableFiles();
    }

    private void zipToDfsFile(Seq<File> files, Path dfsZipFile) {
        LazyRef filesStr$lzy = new LazyRef();
        ObjectRef in = ObjectRef.create(null);
        CheckpointFileManager.CancellableFSDataOutputStream out = this.fm().createAtomic(dfsZipFile, true);
        LongRef totalBytes = LongRef.create((long)0L);
        ZipOutputStream zout = new ZipOutputStream((OutputStream)((Object)out));
        try {
            try {
                files.foreach((Function1 & Serializable & scala.Serializable)file -> {
                    RocksDBFileManager.$anonfun$zipToDfsFile$1(zout, in, totalBytes, file);
                    return BoxedUnit.UNIT;
                });
                zout.close();
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Zipped ").append(totalBytes$1.elem).append(" bytes (before compression) to ").append(RocksDBFileManager.filesStr$1(filesStr$lzy, dfsZipFile, files)).toString());
                RocksDBFileManagerMetrics qual$1 = this.saveCheckpointMetrics();
                Some x$1 = new Some((Object)BoxesRunTime.boxToLong((long)totalBytes.elem));
                long x$2 = qual$1.copy$default$1();
                long x$3 = qual$1.copy$default$2();
                long x$4 = qual$1.copy$default$3();
                this.saveCheckpointMetrics_$eq(qual$1.copy(x$2, x$3, x$4, (Option<Object>)x$1));
            }
            catch (Exception e) {
                out.cancel();
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Error zipping to ").append(RocksDBFileManager.filesStr$1(filesStr$lzy, dfsZipFile, files)).toString(), e);
                throw e;
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)((InputStream)in.elem));
            IOUtils.closeQuietly((OutputStream)zout);
        }
    }

    private void logFilesInDir(File dir, String msg) {
        LazyRef files$lzy = new LazyRef();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(11).append(msg).append(" - ").append(RocksDBFileManager.files$2(files$lzy, dir).length).append(" files\n\t").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])RocksDBFileManager.files$2(files$lzy, dir))).mkString("\n\t")).toString());
    }

    private String newDFSFileName(String localFileName) {
        String baseName = FilenameUtils.getBaseName((String)localFileName);
        String extension = FilenameUtils.getExtension((String)localFileName);
        return new StringBuilder(2).append(baseName).append("-").append(UUID.randomUUID()).append(".").append(extension).toString();
    }

    private Path dfsBatchZipFile(long version) {
        return new Path(new StringBuilder(5).append(this.dfsRootDir).append("/").append(version).append(".zip").toString());
    }

    private Path dfsChangelogFile(long version) {
        return new Path(new StringBuilder(11).append(this.dfsRootDir).append("/").append(version).append(".changelog").toString());
    }

    private File localMetadataFile(File parentDir) {
        return new File(parentDir, "metadata");
    }

    public String logName() {
        return new StringBuilder(1).append(Logging.logName$((Logging)this)).append(" ").append(this.loggingId).toString();
    }

    private Path dfsFilePath(String fileName) {
        if (RocksDBImmutableFile$.MODULE$.isSstFile(fileName)) {
            return new Path(new Path(this.dfsRootDir, RocksDBImmutableFile$.MODULE$.SST_FILES_DFS_SUBDIR()), fileName);
        }
        if (RocksDBImmutableFile$.MODULE$.isLogFile(fileName)) {
            return new Path(new Path(this.dfsRootDir, RocksDBImmutableFile$.MODULE$.LOG_FILES_DFS_SUBDIR()), fileName);
        }
        return new Path(this.dfsRootDir, fileName);
    }

    private File localFilePath(File localDir, String fileName) {
        if (RocksDBImmutableFile$.MODULE$.isLogFile(fileName)) {
            return new File(new File(localDir, RocksDBImmutableFile$.MODULE$.LOG_FILES_LOCAL_SUBDIR()), fileName);
        }
        return new File(localDir, fileName);
    }

    private Tuple2<Seq<File>, Seq<File>> listRocksDBFiles(File localDir) {
        File[] topLevelFiles = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])localDir.listFiles())).filter((Function1 & Serializable & scala.Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)RocksDBFileManager.$anonfun$listRocksDBFiles$1(x$27)));
        File[] archivedLogFiles = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Option$.MODULE$.apply((Object)new File(localDir, RocksDBImmutableFile$.MODULE$.LOG_FILES_LOCAL_SUBDIR()).listFiles()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (File[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(File.class))))).filter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)RocksDBImmutableFile$.MODULE$.isLogFile(file.getName())));
        Tuple2 tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])topLevelFiles)).partition((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)RocksDBImmutableFile$.MODULE$.isSstFile(f.getName())));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File[] topLevelSstFiles = (File[])tuple2._1();
        File[] topLevelOtherFiles = (File[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)topLevelSstFiles, (Object)topLevelOtherFiles);
        File[] topLevelSstFiles2 = (File[])tuple22._1();
        File[] topLevelOtherFiles2 = (File[])tuple22._2();
        return new Tuple2(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])topLevelSstFiles2)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])archivedLogFiles)), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit())), (Object)Predef$.MODULE$.wrapRefArray((Object[])topLevelOtherFiles2));
    }

    public static final /* synthetic */ boolean $anonfun$loadCheckpointFromDfs$2(long version$2, long x$3) {
        return x$3 >= version$2;
    }

    public static final /* synthetic */ long $anonfun$getLatestSnapshotVersion$2(String x$6) {
        return new StringOps(Predef$.MODULE$.augmentString(x$6)).toLong();
    }

    public static final /* synthetic */ boolean $anonfun$getLatestVersion$2(RocksDBFileManager $this, Path x$9) {
        return $this.onlyChangelogFiles().accept(x$9);
    }

    public static final /* synthetic */ long $anonfun$getLatestVersion$4(String x$11) {
        return new StringOps(Predef$.MODULE$.augmentString(x$11)).toLong();
    }

    public static final /* synthetic */ boolean $anonfun$getLatestVersion$5(RocksDBFileManager $this, Path x$12) {
        return $this.onlyZipFiles().accept(x$12);
    }

    public static final /* synthetic */ long $anonfun$getLatestVersion$7(String x$14) {
        return new StringOps(Predef$.MODULE$.augmentString(x$14)).toLong();
    }

    public static final /* synthetic */ boolean $anonfun$findOrphanFiles$3(long oldestTrackedFileModificationTime$1, Tuple2 x$16) {
        return x$16._2$mcJ$sp() < oldestTrackedFileModificationTime$1;
    }

    public static final /* synthetic */ boolean $anonfun$deleteOldVersions$2(RocksDBFileManager $this, Path file) {
        return $this.onlyZipFiles().accept(file);
    }

    public static final /* synthetic */ boolean $anonfun$deleteOldVersions$3(RocksDBFileManager $this, Path file) {
        return $this.onlyChangelogFiles().accept(file);
    }

    public static final /* synthetic */ long $anonfun$deleteOldVersions$5(String x$19) {
        return new StringOps(Predef$.MODULE$.augmentString(x$19)).toLong();
    }

    public static final /* synthetic */ boolean $anonfun$deleteOldVersions$13(long[] snapshotVersionsToDelete$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            long v = tuple2._2$mcJ$sp();
            return new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(snapshotVersionsToDelete$1)).contains((Object)BoxesRunTime.boxToLong((long)v));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$deleteOldVersions$16(RocksDBFileManager $this, IntRef failedToDelete$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            BoxedUnit boxedUnit;
            String dfsFileName = (String)tuple2._1();
            long maxUsedVersion = tuple2._2$mcJ$sp();
            try {
                Path dfsFile = $this.dfsFilePath(dfsFileName);
                $this.fm().delete(dfsFile);
                if (maxUsedVersion == -1L) {
                    $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Deleted orphan file ").append(dfsFileName).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Deleted file ").append(dfsFileName).append(" that was last used in version ").append(maxUsedVersion).toString());
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            catch (Exception e) {
                ++failedToDelete$1.elem;
                if (maxUsedVersion == -1L) {
                    $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Error deleting orphan file ").append(dfsFileName).toString(), e);
                    boxedUnit = BoxedUnit.UNIT;
                }
                $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Error deleting file ").append(dfsFileName).append(", last used in version ").append(maxUsedVersion).toString(), e);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ long $anonfun$deleteOldVersions$26(String x$24) {
        return new StringOps(Predef$.MODULE$.augmentString(x$24)).toLong();
    }

    public static final /* synthetic */ void $anonfun$loadImmutableFilesFromDfs$2(RocksDBFileManager $this, Map requiredFileNameToFileDetails$1, File existingFile) {
        boolean isSameFile;
        boolean bl;
        long existingFileSize = existingFile.length();
        Option requiredFile = requiredFileNameToFileDetails$1.get((Object)existingFile.getName());
        Option prevDfsFile = ((MapLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter($this.fileMappings().localFilesToDfsFiles()).asScala()).get((Object)existingFile.getName());
        if (requiredFile.isDefined() && prevDfsFile.isDefined()) {
            String string = ((RocksDBImmutableFile)requiredFile.get()).dfsFileName();
            String string2 = ((RocksDBImmutableFile)prevDfsFile.get()).dfsFileName();
            bl = !(string != null ? !string.equals(string2) : string2 != null) && existingFile.length() == ((RocksDBImmutableFile)requiredFile.get()).sizeBytes();
        } else {
            bl = isSameFile = false;
        }
        if (!isSameFile) {
            existingFile.delete();
            $this.fileMappings().localFilesToDfsFiles().remove(existingFile.getName());
            $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Deleted local file ").append(existingFile).append(" with size ").append(existingFileSize).append(" mapped").append(" to previous dfsFile ").append(prevDfsFile.getOrElse((Function0 & Serializable & scala.Serializable)() -> "null")).toString());
            return;
        }
        $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("reusing ").append(prevDfsFile).append(" present at ").append(existingFile).append(" for ").append(requiredFile).toString());
    }

    public static final /* synthetic */ void $anonfun$loadImmutableFilesFromDfs$6(RocksDBFileManager $this, File localDir$1, LongRef filesCopied$2, LongRef bytesCopied$2, LongRef filesReused$2, RocksDBImmutableFile file) {
        String localFileName = file.localFileName();
        File localFile = $this.localFilePath(localDir$1, localFileName);
        if (!localFile.exists()) {
            Path dfsFile = $this.dfsFilePath(file.dfsFileName());
            $this.fs().copyToLocalFile(dfsFile, new Path(localFile.getAbsoluteFile().toURI()));
            long localFileSize = localFile.length();
            long expectedSize = file.sizeBytes();
            if (localFileSize != expectedSize) {
                throw new IllegalStateException(new StringBuilder(43).append("Copied ").append(dfsFile).append(" to ").append(localFile).append(",").append(" expected ").append(expectedSize).append(" bytes, found ").append(localFileSize).append(" bytes ").toString());
            }
            ++filesCopied$2.elem;
            bytesCopied$2.elem += localFileSize;
            $this.fileMappings().localFilesToDfsFiles().put(localFileName, file);
            $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Copied ").append(dfsFile).append(" to ").append(localFile).append(" - ").append(localFileSize).append(" bytes").toString());
            return;
        }
        ++filesReused$2.elem;
    }

    private static final /* synthetic */ String filesStr$lzycompute$1(LazyRef filesStr$lzy$1, Path dfsZipFile$1, Seq files$1) {
        String string;
        LazyRef lazyRef = filesStr$lzy$1;
        synchronized (lazyRef) {
            string = filesStr$lzy$1.initialized() ? (String)filesStr$lzy$1.value() : (String)filesStr$lzy$1.initialize((Object)new StringBuilder(2).append(dfsZipFile$1).append("\n\t").append(files$1.mkString("\n\t")).toString());
        }
        return string;
    }

    private static final String filesStr$1(LazyRef filesStr$lzy$1, Path dfsZipFile$1, Seq files$1) {
        if (filesStr$lzy$1.initialized()) {
            return (String)filesStr$lzy$1.value();
        }
        return RocksDBFileManager.filesStr$lzycompute$1(filesStr$lzy$1, dfsZipFile$1, files$1);
    }

    public static final /* synthetic */ void $anonfun$zipToDfsFile$1(ZipOutputStream zout$1, ObjectRef in$1, LongRef totalBytes$1, File file) {
        zout$1.putNextEntry(new ZipEntry(file.getName()));
        in$1.elem = new FileInputStream(file);
        int bytes = IOUtils.copy((InputStream)((InputStream)in$1.elem), (OutputStream)zout$1);
        ((InputStream)in$1.elem).close();
        zout$1.closeEntry();
        totalBytes$1.elem += (long)bytes;
    }

    private static final /* synthetic */ String[] files$lzycompute$1(LazyRef files$lzy$1, File dir$1) {
        String[] stringArray;
        LazyRef lazyRef = files$lzy$1;
        synchronized (lazyRef) {
            stringArray = files$lzy$1.initialized() ? (String[])files$lzy$1.value() : (String[])files$lzy$1.initialize(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Option$.MODULE$.apply((Object)Utils$.MODULE$.recursiveList(dir$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (File[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class))))).map((Function1 & Serializable & scala.Serializable)f -> new StringBuilder(9).append(f.getAbsolutePath()).append(" - ").append(f.length()).append(" bytes").toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        }
        return stringArray;
    }

    private static final String[] files$2(LazyRef files$lzy$1, File dir$1) {
        if (files$lzy$1.initialized()) {
            return (String[])files$lzy$1.value();
        }
        return RocksDBFileManager.files$lzycompute$1(files$lzy$1, dir$1);
    }

    public static final /* synthetic */ boolean $anonfun$listRocksDBFiles$1(File x$27) {
        return !x$27.isDirectory();
    }

    public RocksDBFileManager(String dfsRootDir, File localTempDir, Configuration hadoopConf, String codecName, String loggingId) {
        this.dfsRootDir = dfsRootDir;
        this.localTempDir = localTempDir;
        this.hadoopConf = hadoopConf;
        this.codecName = codecName;
        this.loggingId = loggingId;
        Logging.$init$((Logging)this);
        this.fs = new Path(dfsRootDir).getFileSystem(hadoopConf);
        this.onlyZipFiles = new PathFilter(null){

            public boolean accept(Path path) {
                return path.toString().endsWith(".zip");
            }
        };
        this.onlyChangelogFiles = new PathFilter(null){

            public boolean accept(Path path) {
                return path.toString().endsWith(".changelog");
            }
        };
        this.fileMappings = new RocksDBFileMappings(new ConcurrentHashMap<Object, Seq<RocksDBImmutableFile>>(), new ConcurrentHashMap<String, RocksDBImmutableFile>());
        this.loadCheckpointMetrics = RocksDBFileManagerMetrics$.MODULE$.EMPTY_METRICS();
        this.saveCheckpointMetrics = RocksDBFileManagerMetrics$.MODULE$.EMPTY_METRICS();
    }
}

