/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar.compression;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.types.PhysicalDataType;
import org.apache.spark.sql.catalyst.types.PhysicalLongType$;
import org.apache.spark.sql.execution.columnar.ByteBufferHelper$;
import org.apache.spark.sql.execution.columnar.ColumnType;
import org.apache.spark.sql.execution.columnar.LONG$;
import org.apache.spark.sql.execution.columnar.NativeColumnType;
import org.apache.spark.sql.execution.columnar.compression.LongDelta$;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t\u0015qA\u0002\u0015*\u0011\u0003[sG\u0002\u0004:S!\u00055F\u000f\u0005\u0006\u0015\u0006!\t\u0001\u0014\u0005\u0006\u001b\u0006!\tE\u0014\u0005\u0006%\u0006!\te\u0015\u0005\u0006q\u0006!\t%\u001f\u0005\b\u0003\u000b\tA\u0011IA\u0004\r\u0015i\u0018\u0001AA\u0014\u0011\u0019Qu\u0001\"\u0001\u00022!A\u0011qG\u0004A\u0002\u0013Ea\nC\u0005\u0002:\u001d\u0001\r\u0011\"\u0005\u0002<!9\u0011qI\u0004!B\u0013y\u0005\u0002CA%\u000f\u0001\u0007I\u0011\u0003(\t\u0013\u0005-s\u00011A\u0005\u0012\u00055\u0003bBA)\u000f\u0001\u0006Ka\u0014\u0005\u0007\u0003':A\u0011\t(\t\r\u0005Us\u0001\"\u0011O\u0011-\t9f\u0002a\u0001\u0002\u0004%I!!\u0017\t\u0017\u0005\u0005t\u00011AA\u0002\u0013%\u00111\r\u0005\f\u0003O:\u0001\u0019!A!B\u0013\tY\u0006C\u0004\u0002j\u001d!\t%a\u001b\t\u000f\u0005ut\u0001\"\u0011\u0002\u0000\u0019)q+\u0001\u0001\u0002\n\"A\u0011N\u0006B\u0001B\u0003%!\u000eC\u0005t-\t\u0005\t\u0015!\u0003\u0002\u000e\"1!J\u0006C\u0001\u0003\u001fC1\"a&\u0017\u0001\u0004\u0005\r\u0011\"\u0003\u0002Z!Y\u0011\u0011\u0014\fA\u0002\u0003\u0007I\u0011BAN\u0011-\tyJ\u0006a\u0001\u0002\u0003\u0006K!a\u0017\t\u000f\u0005\u0005f\u0003\"\u0011\u0002$\"9\u0011Q\u0015\f\u0005B\u0005\u001d\u0006bBAW-\u0011\u0005\u0013q\u0016\u0005\n\u0003\u000b\f\u0011\u0011!C!\u0003\u000fD\u0001\"!6\u0002\u0003\u0003%\tA\u0014\u0005\n\u0003/\f\u0011\u0011!C\u0001\u00033D\u0011\"!8\u0002\u0003\u0003%\t%a8\t\u0013\u00055\u0018!!A\u0005\u0002\u0005=\b\"CAz\u0003\u0005\u0005I\u0011IA{\u0011%\t90AA\u0001\n\u0003\nI\u0010C\u0005\u0002|\u0006\t\t\u0011\"\u0003\u0002~\u0006IAj\u001c8h\t\u0016dG/\u0019\u0006\u0003U-\n1bY8naJ,7o]5p]*\u0011A&L\u0001\tG>dW/\u001c8be*\u0011afL\u0001\nKb,7-\u001e;j_:T!\u0001M\u0019\u0002\u0007M\fHN\u0003\u00023g\u0005)1\u000f]1sW*\u0011A'N\u0001\u0007CB\f7\r[3\u000b\u0003Y\n1a\u001c:h!\tA\u0014!D\u0001*\u0005%auN\\4EK2$\u0018mE\u0003\u0002w\u0005#u\t\u0005\u0002=\u007f5\tQHC\u0001?\u0003\u0015\u00198-\u00197b\u0013\t\u0001UH\u0001\u0004B]f\u0014VM\u001a\t\u0003q\tK!aQ\u0015\u0003#\r{W\u000e\u001d:fgNLwN\\*dQ\u0016lW\r\u0005\u0002=\u000b&\u0011a)\u0010\u0002\b!J|G-^2u!\ta\u0004*\u0003\u0002J{\ta1+\u001a:jC2L'0\u00192mK\u00061A(\u001b8jiz\u001a\u0001\u0001F\u00018\u0003\u0019!\u0018\u0010]3JIV\tq\n\u0005\u0002=!&\u0011\u0011+\u0010\u0002\u0004\u0013:$\u0018a\u00023fG>$WM]\u000b\u0003)j#2!\u00165s!\rAd\u000bW\u0005\u0003/&\u0012q\u0001R3d_\u0012,'\u000f\u0005\u0002Z52\u0001A!B.\u0005\u0005\u0004a&!\u0001+\u0012\u0005u\u0003\u0007C\u0001\u001f_\u0013\tyVHA\u0004O_RD\u0017N\\4\u0011\u0005\u00054W\"\u00012\u000b\u0005\r$\u0017!\u0002;za\u0016\u001c(BA30\u0003!\u0019\u0017\r^1msN$\u0018BA4c\u0005A\u0001\u0006._:jG\u0006dG)\u0019;b)f\u0004X\rC\u0003j\t\u0001\u0007!.\u0001\u0004ck\u001a4WM\u001d\t\u0003WBl\u0011\u0001\u001c\u0006\u0003[:\f1A\\5p\u0015\u0005y\u0017\u0001\u00026bm\u0006L!!\u001d7\u0003\u0015\tKH/\u001a\"vM\u001a,'\u000fC\u0003t\t\u0001\u0007A/\u0001\u0006d_2,XN\u001c+za\u0016\u00042!\u001e<Y\u001b\u0005Y\u0013BA<,\u0005Aq\u0015\r^5wK\u000e{G.^7o)f\u0004X-A\u0004f]\u000e|G-\u001a:\u0016\u0005i|HcA>\u0002\u0002A\u0019\u0001\b @\n\u0005uL#aB#oG>$WM\u001d\t\u00033~$QaW\u0003C\u0002qCaa]\u0003A\u0002\u0005\r\u0001cA;w}\u0006A1/\u001e9q_J$8\u000f\u0006\u0003\u0002\n\u0005=\u0001c\u0001\u001f\u0002\f%\u0019\u0011QB\u001f\u0003\u000f\t{w\u000e\\3b]\"11O\u0002a\u0001\u0003#\u0001D!a\u0005\u0002\u001cA)Q/!\u0006\u0002\u001a%\u0019\u0011qC\u0016\u0003\u0015\r{G.^7o)f\u0004X\rE\u0002Z\u00037!A\"!\b\u0002\u0010\u0005\u0005\t\u0011!B\u0001\u0003?\u00111a\u0018\u00137#\ri\u0016\u0011\u0005\t\u0004y\u0005\r\u0012bAA\u0013{\t\u0019\u0011I\\=\u0014\t\u001dY\u0014\u0011\u0006\t\u0005qq\fYCD\u0002b\u0003[I1!a\fc\u0003A\u0001\u0006._:jG\u0006dGj\u001c8h)f\u0004X\r\u0006\u0002\u00024A\u0019\u0011QG\u0004\u000e\u0003\u0005\tqbX2p[B\u0014Xm]:fINK'0Z\u0001\u0014?\u000e|W\u000e\u001d:fgN,GmU5{K~#S-\u001d\u000b\u0005\u0003{\t\u0019\u0005E\u0002=\u0003\u007fI1!!\u0011>\u0005\u0011)f.\u001b;\t\u0011\u0005\u0015#\"!AA\u0002=\u000b1\u0001\u001f\u00132\u0003Ay6m\\7qe\u0016\u001c8/\u001a3TSj,\u0007%A\t`k:\u001cw.\u001c9sKN\u001cX\rZ*ju\u0016\fQcX;oG>l\u0007O]3tg\u0016$7+\u001b>f?\u0012*\u0017\u000f\u0006\u0003\u0002>\u0005=\u0003\u0002CA#\u001b\u0005\u0005\t\u0019A(\u0002%}+hnY8naJ,7o]3e'&TX\rI\u0001\u000fG>l\u0007O]3tg\u0016$7+\u001b>f\u0003A)hnY8naJ,7o]3e'&TX-A\u0005qe\u00164h+\u00197vKV\u0011\u00111\f\t\u0004y\u0005u\u0013bAA0{\t!Aj\u001c8h\u00035\u0001(/\u001a<WC2,Xm\u0018\u0013fcR!\u0011QHA3\u0011%\t)EEA\u0001\u0002\u0004\tY&\u0001\u0006qe\u00164h+\u00197vK\u0002\n!dZ1uQ\u0016\u00148i\\7qe\u0016\u001c8/\u001b2jY&$\u0018p\u0015;biN$b!!\u0010\u0002n\u0005e\u0004bBA8)\u0001\u0007\u0011\u0011O\u0001\u0004e><\b\u0003BA:\u0003kj\u0011\u0001Z\u0005\u0004\u0003o\"'aC%oi\u0016\u0014h.\u00197S_^Da!a\u001f\u0015\u0001\u0004y\u0015aB8sI&t\u0017\r\\\u0001\tG>l\u0007O]3tgR)!.!!\u0002\u0006\"1\u00111Q\u000bA\u0002)\fAA\u001a:p[\"1\u0011qQ\u000bA\u0002)\f!\u0001^8\u0014\tYY\u00141\u0012\t\u0005qY\u000bY\u0003\u0005\u0003vm\u0006-BCBAI\u0003'\u000b)\nE\u0002\u00026YAQ![\rA\u0002)Daa]\rA\u0002\u00055\u0015\u0001\u00029sKZ\f\u0001\u0002\u001d:fm~#S-\u001d\u000b\u0005\u0003{\ti\nC\u0005\u0002Fm\t\t\u00111\u0001\u0002\\\u0005)\u0001O]3wA\u00059\u0001.Y:OKb$XCAA\u0005\u0003\u0011qW\r\u001f;\u0015\r\u0005u\u0012\u0011VAV\u0011\u001d\tyG\ba\u0001\u0003cBa!a\u001f\u001f\u0001\u0004y\u0015A\u00033fG>l\u0007O]3tgR1\u0011QHAY\u0003\u0003Dq!a- \u0001\u0004\t),\u0001\u0007d_2,XN\u001c,fGR|'\u000f\u0005\u0003\u00028\u0006uVBAA]\u0015\r\tY,L\u0001\u000bm\u0016\u001cGo\u001c:ju\u0016$\u0017\u0002BA`\u0003s\u0013Ac\u0016:ji\u0006\u0014G.Z\"pYVlgNV3di>\u0014\bBBAb?\u0001\u0007q*\u0001\u0005dCB\f7-\u001b;z\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011\u0011\u001a\t\u0005\u0003\u0017\f\t.\u0004\u0002\u0002N*\u0019\u0011q\u001a8\u0002\t1\fgnZ\u0005\u0005\u0003'\fiM\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\t#a7\t\u0011\u0005\u0015#%!AA\u0002=\u000bq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003C\u0004b!a9\u0002j\u0006\u0005RBAAs\u0015\r\t9/P\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAv\u0003K\u0014\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011\u0011BAy\u0011%\t)\u0005JA\u0001\u0002\u0004\t\t#\u0001\u0005iCND7i\u001c3f)\u0005y\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005%\u0017a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a@\u0011\t\u0005-'\u0011A\u0005\u0005\u0005\u0007\tiM\u0001\u0004PE*,7\r\u001e")
public final class LongDelta {
    public static String toString() {
        return LongDelta$.MODULE$.toString();
    }

    public static int hashCode() {
        return LongDelta$.MODULE$.hashCode();
    }

    public static boolean canEqual(Object object) {
        return LongDelta$.MODULE$.canEqual(object);
    }

    public static Iterator<Object> productIterator() {
        return LongDelta$.MODULE$.productIterator();
    }

    public static Object productElement(int n) {
        return LongDelta$.MODULE$.productElement(n);
    }

    public static int productArity() {
        return LongDelta$.MODULE$.productArity();
    }

    public static String productPrefix() {
        return LongDelta$.MODULE$.productPrefix();
    }

    public static boolean supports(ColumnType<?> columnType) {
        return LongDelta$.MODULE$.supports(columnType);
    }

    public static <T extends PhysicalDataType> org.apache.spark.sql.execution.columnar.compression.Encoder<T> encoder(NativeColumnType<T> nativeColumnType) {
        return LongDelta$.MODULE$.encoder(nativeColumnType);
    }

    public static <T extends PhysicalDataType> org.apache.spark.sql.execution.columnar.compression.Decoder<T> decoder(ByteBuffer byteBuffer, NativeColumnType<T> nativeColumnType) {
        return LongDelta$.MODULE$.decoder(byteBuffer, nativeColumnType);
    }

    public static int typeId() {
        return LongDelta$.MODULE$.typeId();
    }

    public static class Decoder
    implements org.apache.spark.sql.execution.columnar.compression.Decoder<PhysicalLongType$> {
        private final ByteBuffer buffer;
        private long prev;

        private long prev() {
            return this.prev;
        }

        private void prev_$eq(long x$1) {
            this.prev = x$1;
        }

        @Override
        public boolean hasNext() {
            return this.buffer.hasRemaining();
        }

        @Override
        public void next(InternalRow row, int ordinal) {
            byte delta = this.buffer.get();
            this.prev_$eq(delta > -128 ? this.prev() + (long)delta : ByteBufferHelper$.MODULE$.getLong(this.buffer));
            row.setLong(ordinal, this.prev());
        }

        @Override
        public void decompress(WritableColumnVector columnVector, int capacity) {
            long prevLocal = 0L;
            ByteBuffer nullsBuffer = this.buffer.duplicate().order(ByteOrder.nativeOrder());
            nullsBuffer.rewind();
            int nullCount = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
            int nextNullIndex = nullCount > 0 ? ByteBufferHelper$.MODULE$.getInt(nullsBuffer) : -1;
            int seenNulls = 0;
            for (int pos = 0; pos < capacity; ++pos) {
                if (pos != nextNullIndex) {
                    byte delta = this.buffer.get();
                    prevLocal = delta > -128 ? prevLocal + (long)delta : ByteBufferHelper$.MODULE$.getLong(this.buffer);
                    columnVector.putLong(pos, prevLocal);
                    continue;
                }
                if (++seenNulls < nullCount) {
                    nextNullIndex = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
                }
                columnVector.putNull(pos);
            }
        }

        public Decoder(ByteBuffer buffer, NativeColumnType<PhysicalLongType$> columnType) {
            this.buffer = buffer;
        }
    }

    public static class Encoder
    implements org.apache.spark.sql.execution.columnar.compression.Encoder<PhysicalLongType$> {
        private int _compressedSize;
        private int _uncompressedSize;
        private long prevValue;

        @Override
        public double compressionRatio() {
            return org.apache.spark.sql.execution.columnar.compression.Encoder.compressionRatio$(this);
        }

        public int _compressedSize() {
            return this._compressedSize;
        }

        public void _compressedSize_$eq(int x$1) {
            this._compressedSize = x$1;
        }

        public int _uncompressedSize() {
            return this._uncompressedSize;
        }

        public void _uncompressedSize_$eq(int x$1) {
            this._uncompressedSize = x$1;
        }

        @Override
        public int compressedSize() {
            return this._compressedSize();
        }

        @Override
        public int uncompressedSize() {
            return this._uncompressedSize();
        }

        private long prevValue() {
            return this.prevValue;
        }

        private void prevValue_$eq(long x$1) {
            this.prevValue = x$1;
        }

        @Override
        public void gatherCompressibilityStats(InternalRow row, int ordinal) {
            long value = row.getLong(ordinal);
            long delta = value - this.prevValue();
            this._compressedSize_$eq(this._compressedSize() + 1);
            if (this._uncompressedSize() == 0 || delta <= (long)-128 || delta > (long)127) {
                this._compressedSize_$eq(this._compressedSize() + LONG$.MODULE$.defaultSize());
            }
            this._uncompressedSize_$eq(this._uncompressedSize() + LONG$.MODULE$.defaultSize());
            this.prevValue_$eq(value);
        }

        @Override
        public ByteBuffer compress(ByteBuffer from, ByteBuffer to) {
            to.putInt(LongDelta$.MODULE$.typeId());
            if (from.hasRemaining()) {
                long prev = from.getLong();
                to.put((byte)-128);
                to.putLong(prev);
                while (from.hasRemaining()) {
                    ByteBuffer byteBuffer;
                    long current = from.getLong();
                    long delta = current - prev;
                    prev = current;
                    if ((long)-128 < delta && delta <= (long)127) {
                        byteBuffer = to.put((byte)delta);
                        continue;
                    }
                    to.put((byte)-128);
                    byteBuffer = to.putLong(current);
                }
            }
            return (ByteBuffer)to.rewind();
        }

        public Encoder() {
            org.apache.spark.sql.execution.columnar.compression.Encoder.$init$(this);
            this._compressedSize = 0;
            this._uncompressedSize = 0;
        }
    }
}

