/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar.compression;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.types.PhysicalDataType;
import org.apache.spark.sql.catalyst.types.PhysicalIntegerType$;
import org.apache.spark.sql.execution.columnar.ByteBufferHelper$;
import org.apache.spark.sql.execution.columnar.ColumnType;
import org.apache.spark.sql.execution.columnar.INT$;
import org.apache.spark.sql.execution.columnar.NativeColumnType;
import org.apache.spark.sql.execution.columnar.compression.IntDelta$;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005uxA\u0002\u0015*\u0011\u0003[sG\u0002\u0004:S!\u00055F\u000f\u0005\u0006\u0015\u0006!\t\u0001\u0014\u0005\u0006\u001b\u0006!\tE\u0014\u0005\u0006%\u0006!\te\u0015\u0005\u0006q\u0006!\t%\u001f\u0005\b\u0003\u000b\tA\u0011IA\u0004\r\u0015i\u0018\u0001AA\u0014\u0011\u0019Qu\u0001\"\u0001\u00022!A\u0011qG\u0004A\u0002\u0013Ea\nC\u0005\u0002:\u001d\u0001\r\u0011\"\u0005\u0002<!9\u0011qI\u0004!B\u0013y\u0005\u0002CA%\u000f\u0001\u0007I\u0011\u0003(\t\u0013\u0005-s\u00011A\u0005\u0012\u00055\u0003bBA)\u000f\u0001\u0006Ka\u0014\u0005\u0007\u0003':A\u0011\t(\t\r\u0005Us\u0001\"\u0011O\u0011)\t9f\u0002a\u0001\u0002\u0004%IA\u0014\u0005\f\u00033:\u0001\u0019!a\u0001\n\u0013\tY\u0006\u0003\u0006\u0002`\u001d\u0001\r\u0011!Q!\n=Cq!!\u0019\b\t\u0003\n\u0019\u0007C\u0004\u0002v\u001d!\t%a\u001e\u0007\u000b]\u000b\u0001!!!\t\u0011%4\"\u0011!Q\u0001\n)D\u0011b\u001d\f\u0003\u0002\u0003\u0006I!!\"\t\r)3B\u0011AAD\u0011)\tyI\u0006a\u0001\u0002\u0004%IA\u0014\u0005\f\u0003#3\u0002\u0019!a\u0001\n\u0013\t\u0019\n\u0003\u0006\u0002\u0018Z\u0001\r\u0011!Q!\n=Cq!!'\u0017\t\u0003\nY\nC\u0004\u0002\u001eZ!\t%a(\t\u000f\u0005\u0015f\u0003\"\u0011\u0002(\"I\u0011QX\u0001\u0002\u0002\u0013\u0005\u0013q\u0018\u0005\t\u0003\u001b\f\u0011\u0011!C\u0001\u001d\"I\u0011qZ\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u001b\u0005\n\u0003+\f\u0011\u0011!C!\u0003/D\u0011\"!:\u0002\u0003\u0003%\t!a:\t\u0013\u0005-\u0018!!A\u0005B\u00055\b\"CAx\u0003\u0005\u0005I\u0011IAy\u0011%\t\u00190AA\u0001\n\u0013\t)0\u0001\u0005J]R$U\r\u001c;b\u0015\tQ3&A\u0006d_6\u0004(/Z:tS>t'B\u0001\u0017.\u0003!\u0019w\u000e\\;n]\u0006\u0014(B\u0001\u00180\u0003%)\u00070Z2vi&|gN\u0003\u00021c\u0005\u00191/\u001d7\u000b\u0005I\u001a\u0014!B:qCJ\\'B\u0001\u001b6\u0003\u0019\t\u0007/Y2iK*\ta'A\u0002pe\u001e\u0004\"\u0001O\u0001\u000e\u0003%\u0012\u0001\"\u00138u\t\u0016dG/Y\n\u0006\u0003m\nEi\u0012\t\u0003y}j\u0011!\u0010\u0006\u0002}\u0005)1oY1mC&\u0011\u0001)\u0010\u0002\u0007\u0003:L(+\u001a4\u0011\u0005a\u0012\u0015BA\"*\u0005E\u0019u.\u001c9sKN\u001c\u0018n\u001c8TG\",W.\u001a\t\u0003y\u0015K!AR\u001f\u0003\u000fA\u0013x\u000eZ;diB\u0011A\bS\u0005\u0003\u0013v\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fa\u0001P5oSRt4\u0001\u0001\u000b\u0002o\u00051A/\u001f9f\u0013\u0012,\u0012a\u0014\t\u0003yAK!!U\u001f\u0003\u0007%sG/A\u0004eK\u000e|G-\u001a:\u0016\u0005QSFcA+ieB\u0019\u0001H\u0016-\n\u0005]K#a\u0002#fG>$WM\u001d\t\u00033jc\u0001\u0001B\u0003\\\t\t\u0007ALA\u0001U#\ti\u0006\r\u0005\u0002==&\u0011q,\u0010\u0002\b\u001d>$\b.\u001b8h!\t\tg-D\u0001c\u0015\t\u0019G-A\u0003usB,7O\u0003\u0002f_\u0005A1-\u0019;bYf\u001cH/\u0003\u0002hE\n\u0001\u0002\u000b[=tS\u000e\fG\u000eR1uCRK\b/\u001a\u0005\u0006S\u0012\u0001\rA[\u0001\u0007EV4g-\u001a:\u0011\u0005-\u0004X\"\u00017\u000b\u00055t\u0017a\u00018j_*\tq.\u0001\u0003kCZ\f\u0017BA9m\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\u0006g\u0012\u0001\r\u0001^\u0001\u000bG>dW/\u001c8UsB,\u0007cA;w16\t1&\u0003\u0002xW\t\u0001b*\u0019;jm\u0016\u001cu\u000e\\;n]RK\b/Z\u0001\bK:\u001cw\u000eZ3s+\tQx\u0010F\u0002|\u0003\u0003\u00012\u0001\u000f?\u007f\u0013\ti\u0018FA\u0004F]\u000e|G-\u001a:\u0011\u0005e{H!B.\u0006\u0005\u0004a\u0006BB:\u0006\u0001\u0004\t\u0019\u0001E\u0002vmz\f\u0001b];qa>\u0014Ho\u001d\u000b\u0005\u0003\u0013\ty\u0001E\u0002=\u0003\u0017I1!!\u0004>\u0005\u001d\u0011un\u001c7fC:Daa\u001d\u0004A\u0002\u0005E\u0001\u0007BA\n\u00037\u0001R!^A\u000b\u00033I1!a\u0006,\u0005)\u0019u\u000e\\;n]RK\b/\u001a\t\u00043\u0006mA\u0001DA\u000f\u0003\u001f\t\t\u0011!A\u0003\u0002\u0005}!aA0%kE\u0019Q,!\t\u0011\u0007q\n\u0019#C\u0002\u0002&u\u00121!\u00118z'\u001191(!\u000b\u0011\tab\u00181\u0006\b\u0004C\u00065\u0012bAA\u0018E\u0006\u0019\u0002\u000b[=tS\u000e\fG.\u00138uK\u001e,'\u000fV=qKR\u0011\u00111\u0007\t\u0004\u0003k9Q\"A\u0001\u0002\u001f}\u001bw.\u001c9sKN\u001cX\rZ*ju\u0016\f1cX2p[B\u0014Xm]:fINK'0Z0%KF$B!!\u0010\u0002DA\u0019A(a\u0010\n\u0007\u0005\u0005SH\u0001\u0003V]&$\b\u0002CA#\u0015\u0005\u0005\t\u0019A(\u0002\u0007a$\u0013'\u0001\t`G>l\u0007O]3tg\u0016$7+\u001b>fA\u0005\tr,\u001e8d_6\u0004(/Z:tK\u0012\u001c\u0016N_3\u0002+}+hnY8naJ,7o]3e'&TXm\u0018\u0013fcR!\u0011QHA(\u0011!\t)%DA\u0001\u0002\u0004y\u0015AE0v]\u000e|W\u000e\u001d:fgN,GmU5{K\u0002\nabY8naJ,7o]3e'&TX-\u0001\tv]\u000e|W\u000e\u001d:fgN,GmU5{K\u0006I\u0001O]3w-\u0006dW/Z\u0001\u000eaJ,gOV1mk\u0016|F%Z9\u0015\t\u0005u\u0012Q\f\u0005\t\u0003\u000b\u0012\u0012\u0011!a\u0001\u001f\u0006Q\u0001O]3w-\u0006dW/\u001a\u0011\u00025\u001d\fG\u000f[3s\u0007>l\u0007O]3tg&\u0014\u0017\u000e\\5usN#\u0018\r^:\u0015\r\u0005u\u0012QMA9\u0011\u001d\t9\u0007\u0006a\u0001\u0003S\n1A]8x!\u0011\tY'!\u001c\u000e\u0003\u0011L1!a\u001ce\u0005-Ie\u000e^3s]\u0006d'k\\<\t\r\u0005MD\u00031\u0001P\u0003\u001dy'\u000fZ5oC2\f\u0001bY8naJ,7o\u001d\u000b\u0006U\u0006e\u0014Q\u0010\u0005\u0007\u0003w*\u0002\u0019\u00016\u0002\t\u0019\u0014x.\u001c\u0005\u0007\u0003\u007f*\u0002\u0019\u00016\u0002\u0005Q|7\u0003\u0002\f<\u0003\u0007\u0003B\u0001\u000f,\u0002,A!QO^A\u0016)\u0019\tI)a#\u0002\u000eB\u0019\u0011Q\u0007\f\t\u000b%L\u0002\u0019\u00016\t\rML\u0002\u0019AAC\u0003\u0011\u0001(/\u001a<\u0002\u0011A\u0014XM^0%KF$B!!\u0010\u0002\u0016\"A\u0011QI\u000e\u0002\u0002\u0003\u0007q*A\u0003qe\u00164\b%A\u0004iCNtU\r\u001f;\u0016\u0005\u0005%\u0011\u0001\u00028fqR$b!!\u0010\u0002\"\u0006\r\u0006bBA4=\u0001\u0007\u0011\u0011\u000e\u0005\u0007\u0003gr\u0002\u0019A(\u0002\u0015\u0011,7m\\7qe\u0016\u001c8\u000f\u0006\u0004\u0002>\u0005%\u0016\u0011\u0018\u0005\b\u0003W{\u0002\u0019AAW\u00031\u0019w\u000e\\;n]Z+7\r^8s!\u0011\ty+!.\u000e\u0005\u0005E&bAAZ[\u0005Qa/Z2u_JL'0\u001a3\n\t\u0005]\u0016\u0011\u0017\u0002\u0015/JLG/\u00192mK\u000e{G.^7o-\u0016\u001cGo\u001c:\t\r\u0005mv\u00041\u0001P\u0003!\u0019\u0017\r]1dSRL\u0018!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002BB!\u00111YAe\u001b\t\t)MC\u0002\u0002H:\fA\u0001\\1oO&!\u00111ZAc\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u0011\u0003'D\u0001\"!\u0012#\u0003\u0003\u0005\raT\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011\u0011\u001c\t\u0007\u00037\f\t/!\t\u000e\u0005\u0005u'bAAp{\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\r\u0018Q\u001c\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\n\u0005%\b\"CA#I\u0005\u0005\t\u0019AA\u0011\u0003!A\u0017m\u001d5D_\u0012,G#A(\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!1\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003o\u0004B!a1\u0002z&!\u00111`Ac\u0005\u0019y%M[3di\u0002")
public final class IntDelta {
    public static String toString() {
        return IntDelta$.MODULE$.toString();
    }

    public static int hashCode() {
        return IntDelta$.MODULE$.hashCode();
    }

    public static boolean canEqual(Object object) {
        return IntDelta$.MODULE$.canEqual(object);
    }

    public static Iterator<Object> productIterator() {
        return IntDelta$.MODULE$.productIterator();
    }

    public static Object productElement(int n) {
        return IntDelta$.MODULE$.productElement(n);
    }

    public static int productArity() {
        return IntDelta$.MODULE$.productArity();
    }

    public static String productPrefix() {
        return IntDelta$.MODULE$.productPrefix();
    }

    public static boolean supports(ColumnType<?> columnType) {
        return IntDelta$.MODULE$.supports(columnType);
    }

    public static <T extends PhysicalDataType> org.apache.spark.sql.execution.columnar.compression.Encoder<T> encoder(NativeColumnType<T> nativeColumnType) {
        return IntDelta$.MODULE$.encoder(nativeColumnType);
    }

    public static <T extends PhysicalDataType> org.apache.spark.sql.execution.columnar.compression.Decoder<T> decoder(ByteBuffer byteBuffer, NativeColumnType<T> nativeColumnType) {
        return IntDelta$.MODULE$.decoder(byteBuffer, nativeColumnType);
    }

    public static int typeId() {
        return IntDelta$.MODULE$.typeId();
    }

    public static class Decoder
    implements org.apache.spark.sql.execution.columnar.compression.Decoder<PhysicalIntegerType$> {
        private final ByteBuffer buffer;
        private int prev;

        private int prev() {
            return this.prev;
        }

        private void prev_$eq(int x$1) {
            this.prev = x$1;
        }

        @Override
        public boolean hasNext() {
            return this.buffer.hasRemaining();
        }

        @Override
        public void next(InternalRow row, int ordinal) {
            byte delta = this.buffer.get();
            this.prev_$eq(delta > -128 ? this.prev() + delta : ByteBufferHelper$.MODULE$.getInt(this.buffer));
            row.setInt(ordinal, this.prev());
        }

        @Override
        public void decompress(WritableColumnVector columnVector, int capacity) {
            int prevLocal = 0;
            ByteBuffer nullsBuffer = this.buffer.duplicate().order(ByteOrder.nativeOrder());
            nullsBuffer.rewind();
            int nullCount = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
            int nextNullIndex = nullCount > 0 ? ByteBufferHelper$.MODULE$.getInt(nullsBuffer) : -1;
            int seenNulls = 0;
            for (int pos = 0; pos < capacity; ++pos) {
                if (pos != nextNullIndex) {
                    byte delta = this.buffer.get();
                    prevLocal = delta > -128 ? prevLocal + delta : ByteBufferHelper$.MODULE$.getInt(this.buffer);
                    columnVector.putInt(pos, prevLocal);
                    continue;
                }
                if (++seenNulls < nullCount) {
                    nextNullIndex = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
                }
                columnVector.putNull(pos);
            }
        }

        public Decoder(ByteBuffer buffer, NativeColumnType<PhysicalIntegerType$> columnType) {
            this.buffer = buffer;
        }
    }

    public static class Encoder
    implements org.apache.spark.sql.execution.columnar.compression.Encoder<PhysicalIntegerType$> {
        private int _compressedSize;
        private int _uncompressedSize;
        private int prevValue;

        @Override
        public double compressionRatio() {
            return org.apache.spark.sql.execution.columnar.compression.Encoder.compressionRatio$(this);
        }

        public int _compressedSize() {
            return this._compressedSize;
        }

        public void _compressedSize_$eq(int x$1) {
            this._compressedSize = x$1;
        }

        public int _uncompressedSize() {
            return this._uncompressedSize;
        }

        public void _uncompressedSize_$eq(int x$1) {
            this._uncompressedSize = x$1;
        }

        @Override
        public int compressedSize() {
            return this._compressedSize();
        }

        @Override
        public int uncompressedSize() {
            return this._uncompressedSize();
        }

        private int prevValue() {
            return this.prevValue;
        }

        private void prevValue_$eq(int x$1) {
            this.prevValue = x$1;
        }

        @Override
        public void gatherCompressibilityStats(InternalRow row, int ordinal) {
            int value = row.getInt(ordinal);
            int delta = value - this.prevValue();
            this._compressedSize_$eq(this._compressedSize() + 1);
            if (this._uncompressedSize() == 0 || delta <= -128 || delta > 127) {
                this._compressedSize_$eq(this._compressedSize() + INT$.MODULE$.defaultSize());
            }
            this._uncompressedSize_$eq(this._uncompressedSize() + INT$.MODULE$.defaultSize());
            this.prevValue_$eq(value);
        }

        @Override
        public ByteBuffer compress(ByteBuffer from, ByteBuffer to) {
            to.putInt(IntDelta$.MODULE$.typeId());
            if (from.hasRemaining()) {
                int prev = from.getInt();
                to.put((byte)-128);
                to.putInt(prev);
                while (from.hasRemaining()) {
                    ByteBuffer byteBuffer;
                    int current = from.getInt();
                    int delta = current - prev;
                    prev = current;
                    if (-128 < delta && delta <= 127) {
                        byteBuffer = to.put((byte)delta);
                        continue;
                    }
                    to.put((byte)-128);
                    byteBuffer = to.putInt(current);
                }
            }
            return (ByteBuffer)to.rewind();
        }

        public Encoder() {
            org.apache.spark.sql.execution.columnar.compression.Encoder.$init$(this);
            this._compressedSize = 0;
            this._uncompressedSize = 0;
        }
    }
}

