/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchable;
import io.fabric8.kubernetes.client.dsl.Nameable;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.function.UnaryOperator;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.ExecutorExited;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodState;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsLifecycleManager$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshot;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.FinalPodState;
import org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend;
import org.apache.spark.scheduler.cluster.k8s.PodDeleted;
import org.apache.spark.scheduler.cluster.k8s.PodFailed;
import org.apache.spark.scheduler.cluster.k8s.PodSucceeded;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.sparkproject.guava.cache.Cache;
import org.sparkproject.guava.cache.CacheBuilder;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.generic.Subtractable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\u0015a!\u0002\u0012$\u0001%z\u0003\u0002\u0003\u001f\u0001\u0005\u000b\u0007I\u0011\u0001 \t\u0011\r\u0003!\u0011!Q\u0001\n}B\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\t#\u0002\u0011\t\u0011)A\u0005%\")a\u000b\u0001C\u0001/\"AA\f\u0001EC\u0002\u0013%Q\f\u0003\u0005b\u0001!\u0015\r\u0011\"\u0003c\u0011!1\u0007\u0001#b\u0001\n\u00139\u0007bB>\u0001\u0001\u0004%IA\u0019\u0005\by\u0002\u0001\r\u0011\"\u0003~\u0011\u001d\t9\u0001\u0001Q!\n\rD\u0011\"!\u0003\u0001\u0005\u0004%I!a\u0003\t\u0011\u0005u\u0001\u0001)A\u0005\u0003\u001bA\u0011\"a\b\u0001\u0005\u0004%I!!\t\t\u0011\u0005e\u0002\u0001)A\u0005\u0003GA\u0011\"a\u000f\u0001\u0005\u0004%I!!\t\t\u0011\u0005u\u0002\u0001)A\u0005\u0003GAq!a\u0010\u0001\t\u0003\t\t\u0005C\u0004\u0002N\u0001!I!a\u0014\t\u000f\u0005=\u0004\u0001\"\u0003\u0002r!9\u0011q\u0011\u0001\u0005\n\u0005%\u0005bBAQ\u0001\u0011%\u00111\u0015\u0005\b\u0003W\u0003A\u0011BAW\u0011\u001d\tY\f\u0001C\u0005\u0003{Cq!!4\u0001\t\u0013\ty\rC\u0004\u0002T\u0002!I!!6\b\u000f\u0005m7\u0005#\u0003\u0002^\u001a1!e\tE\u0005\u0003?DaA\u0016\u000f\u0005\u0002\u0005\u0005\b\"CAr9\t\u0007I\u0011AAs\u0011!\t9\u000f\bQ\u0001\n\u0005\u001d\u0007bBAu9\u0011\u0005\u00111\u001e\u0005\b\u0003cdB\u0011AAz\u0005q)\u00050Z2vi>\u0014\bk\u001c3t\u0019&4WmY=dY\u0016l\u0015M\\1hKJT!\u0001J\u0013\u0002\u0007-D4O\u0003\u0002'O\u000591\r\\;ti\u0016\u0014(B\u0001\u0015*\u0003%\u00198\r[3ek2,'O\u0003\u0002+W\u0005)1\u000f]1sW*\u0011A&L\u0001\u0007CB\f7\r[3\u000b\u00039\n1a\u001c:h'\r\u0001\u0001G\u000e\t\u0003cQj\u0011A\r\u0006\u0002g\u0005)1oY1mC&\u0011QG\r\u0002\u0007\u0003:L(+\u001a4\u0011\u0005]RT\"\u0001\u001d\u000b\u0005eJ\u0013\u0001C5oi\u0016\u0014h.\u00197\n\u0005mB$a\u0002'pO\u001eLgnZ\u0001\u0005G>tgm\u0001\u0001\u0016\u0003}\u0002\"\u0001Q!\u000e\u0003%J!AQ\u0015\u0003\u0013M\u0003\u0018M]6D_:4\u0017!B2p]\u001a\u0004\u0013\u0001E6vE\u0016\u0014h.\u001a;fg\u000ec\u0017.\u001a8u!\t1u*D\u0001H\u0015\tA\u0015*\u0001\u0004dY&,g\u000e\u001e\u0006\u0003\u0015.\u000b!b[;cKJtW\r^3t\u0015\taU*A\u0004gC\n\u0014\u0018n\u0019\u001d\u000b\u00039\u000b!![8\n\u0005A;%\u0001E&vE\u0016\u0014h.\u001a;fg\u000ec\u0017.\u001a8u\u00039\u0019h.\u00199tQ>$8o\u0015;pe\u0016\u0004\"a\u0015+\u000e\u0003\rJ!!V\u0012\u00035\u0015CXmY;u_J\u0004v\u000eZ:T]\u0006\u00048\u000f[8ugN#xN]3\u0002\rqJg.\u001b;?)\u0011A\u0016LW.\u0011\u0005M\u0003\u0001\"\u0002\u001f\u0006\u0001\u0004y\u0004\"\u0002#\u0006\u0001\u0004)\u0005\"B)\u0006\u0001\u0004\u0011\u0016!F:i_VdG\rR3mKR,W\t_3dkR|'o]\u000b\u0002=B\u0011\u0011gX\u0005\u0003AJ\u0012qAQ8pY\u0016\fg.A\u000bnSN\u001c\u0018N\\4Q_\u0012$U\r^3di\u0012+G\u000e^1\u0016\u0003\r\u0004\"!\r3\n\u0005\u0015\u0014$\u0001\u0002'p]\u001e\fQC]3n_Z,G-\u0012=fGV$xN]:DC\u000eDW-F\u0001i!\u0011I'\u000f\u001e;\u000e\u0003)T!a\u001b7\u0002\u000b\r\f7\r[3\u000b\u00055t\u0017AB2p[6|gN\u0003\u0002pa\u00061qm\\8hY\u0016T\u0011!]\u0001\u0004G>l\u0017BA:k\u0005\u0015\u0019\u0015m\u00195f!\t)(0D\u0001w\u0015\t9\b0\u0001\u0003mC:<'\"A=\u0002\t)\fg/Y\u0005\u0003KZ\f!\u0003\\1ti\u001a+H\u000e\\*oCB\u001c\bn\u001c;Ug\u00061B.Y:u\rVdGn\u00158baNDw\u000e\u001e+t?\u0012*\u0017\u000fF\u0002\u007f\u0003\u0007\u0001\"!M@\n\u0007\u0005\u0005!G\u0001\u0003V]&$\b\u0002CA\u0003\u0015\u0005\u0005\t\u0019A2\u0002\u0007a$\u0013'A\nmCN$h)\u001e7m':\f\u0007o\u001d5piR\u001b\b%A\bj]\u0006\u001cG/\u001b<bi\u0016$\u0007k\u001c3t+\t\ti\u0001E\u0003\u0002\u0010\u0005e1-\u0004\u0002\u0002\u0012)!\u00111CA\u000b\u0003\u001diW\u000f^1cY\u0016T1!a\u00063\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u00037\t\tBA\u0004ICND7+\u001a;\u0002!%t\u0017m\u0019;jm\u0006$X\r\u001a)pIN\u0004\u0013!\u00038b[\u0016\u001c\b/Y2f+\t\t\u0019\u0003\u0005\u0003\u0002&\u0005Mb\u0002BA\u0014\u0003_\u00012!!\u000b3\u001b\t\tYCC\u0002\u0002.u\na\u0001\u0010:p_Rt\u0014bAA\u0019e\u00051\u0001K]3eK\u001aLA!!\u000e\u00028\t11\u000b\u001e:j]\u001eT1!!\r3\u0003)q\u0017-\\3ta\u0006\u001cW\rI\u0001\u0013gB\f'o[\"p]R\f\u0017N\\3s\u001d\u0006lW-A\nta\u0006\u00148nQ8oi\u0006Lg.\u001a:OC6,\u0007%A\u0003ti\u0006\u0014H\u000fF\u0002\u007f\u0003\u0007Bq!!\u0012\u0013\u0001\u0004\t9%\u0001\ttG\",G-\u001e7fe\n\u000b7m[3oIB\u00191+!\u0013\n\u0007\u0005-3EA\u0011Lk\n,'O\\3uKN\u001cE.^:uKJ\u001c6\r[3ek2,'OQ1dW\u0016tG-\u0001\bp]:+wo\u00158baNDw\u000e^:\u0015\u000by\f\t&a\u0015\t\u000f\u0005\u00153\u00031\u0001\u0002H!9\u0011QK\nA\u0002\u0005]\u0013!C:oCB\u001c\bn\u001c;t!\u0019\tI&a\u0019\u0002j9!\u00111LA0\u001d\u0011\tI#!\u0018\n\u0003MJ1!!\u00193\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u001a\u0002h\t\u00191+Z9\u000b\u0007\u0005\u0005$\u0007E\u0002T\u0003WJ1!!\u001c$\u0005Q)\u00050Z2vi>\u0014\bk\u001c3t':\f\u0007o\u001d5pi\u00061rN\u001c$j]\u0006dgj\u001c8EK2,G/\u001a3Ti\u0006$X\rF\u0005_\u0003g\ni(!!\u0002\u0004\"9\u0011Q\u000f\u000bA\u0002\u0005]\u0014\u0001\u00039pIN#\u0018\r^3\u0011\u0007M\u000bI(C\u0002\u0002|\r\u0012QBR5oC2\u0004v\u000eZ*uCR,\u0007BBA@)\u0001\u00071-\u0001\u0004fq\u0016\u001c\u0017\n\u001a\u0005\b\u0003\u000b\"\u0002\u0019AA$\u0011\u0019\t)\t\u0006a\u0001=\u0006iA-\u001a7fi\u00164%o\\7LqM\fQC]3n_Z,W\t_3dkR|'O\u0012:p[.C4\u000fF\u0003\u007f\u0003\u0017\u000bi\t\u0003\u0004\u0002\u0000U\u0001\ra\u0019\u0005\b\u0003\u001f+\u0002\u0019AAI\u0003))\b\u000fZ1uK\u0012\u0004v\u000e\u001a\t\u0005\u0003'\u000bi*\u0004\u0002\u0002\u0016*!\u0011qSAM\u0003\u0015iw\u000eZ3m\u0015\r\tY*S\u0001\u0004CBL\u0017\u0002BAP\u0003+\u00131\u0001U8e\u0003]\u0011X-\\8wK\u0016CXmY;u_J4%o\\7Ta\u0006\u00148\u000eF\u0004_\u0003K\u000b9+!+\t\u000f\u0005\u0015c\u00031\u0001\u0002H!9\u0011Q\u000f\fA\u0002\u0005]\u0004BBA@-\u0001\u00071-\u0001\bgS:$W\t_5u%\u0016\f7o\u001c8\u0015\r\u0005=\u0016qWA]!\u0011\t\t,a-\u000e\u0003\u001dJ1!!.(\u00059)\u00050Z2vi>\u0014X\t_5uK\u0012Dq!!\u001e\u0018\u0001\u0004\t9\b\u0003\u0004\u0002\u0000]\u0001\raY\u0001\u0012KbLGOU3bg>tW*Z:tC\u001e,G\u0003CA\u0012\u0003\u007f\u000b\t-a1\t\u000f\u0005U\u0004\u00041\u0001\u0002x!1\u0011q\u0010\rA\u0002\rDq!!2\u0019\u0001\u0004\t9-\u0001\u0005fq&$8i\u001c3f!\r\t\u0014\u0011Z\u0005\u0004\u0003\u0017\u0014$aA%oi\u0006aa-\u001b8e\u000bbLGoQ8eKR!\u0011qYAi\u0011\u001d\t)(\u0007a\u0001\u0003o\nQ\"[:Q_\u0012Le.Y2uSZ,Gc\u00010\u0002X\"9\u0011\u0011\u001c\u000eA\u0002\u0005E\u0015a\u00019pI\u0006aR\t_3dkR|'\u000fU8eg2Kg-Z2zG2,W*\u00198bO\u0016\u0014\bCA*\u001d'\ta\u0002\u0007\u0006\u0002\u0002^\u0006\tRKT&O\u001f^su,\u0012-J)~\u001bu\nR#\u0016\u0005\u0005\u001d\u0017AE+O\u0017:{uKT0F1&#vlQ(E\u000b\u0002\n\u0001\u0003Z3tGJL'-Z#ySR\u001cu\u000eZ3\u0015\t\u0005\r\u0012Q\u001e\u0005\b\u0003_\u0004\u0003\u0019AAd\u0003\u0011\u0019w\u000eZ3\u0002-\u0015DXmY;u_JLe.Y2uSZ\fG/[8o\r:,\"!!>\u0011\r\u0005](\u0011AAI\u001b\t\tIP\u0003\u0003\u0002|\u0006u\u0018\u0001\u00034v]\u000e$\u0018n\u001c8\u000b\u0007\u0005}\b0\u0001\u0003vi&d\u0017\u0002\u0002B\u0002\u0003s\u0014Q\"\u00168bef|\u0005/\u001a:bi>\u0014\b")
public class ExecutorPodsLifecycleManager
implements Logging {
    private boolean shouldDeleteExecutors;
    private long missingPodDetectDelta;
    private Cache<Long, Long> removedExecutorsCache;
    private final SparkConf conf;
    private final KubernetesClient kubernetesClient;
    private final ExecutorPodsSnapshotsStore snapshotsStore;
    private long lastFullSnapshotTs;
    private final HashSet<Object> inactivatedPods;
    private final String namespace;
    private final String sparkContainerName;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static UnaryOperator<Pod> executorInactivationFn() {
        return ExecutorPodsLifecycleManager$.MODULE$.executorInactivationFn();
    }

    public static String describeExitCode(int n) {
        return ExecutorPodsLifecycleManager$.MODULE$.describeExitCode(n);
    }

    public static int UNKNOWN_EXIT_CODE() {
        return ExecutorPodsLifecycleManager$.MODULE$.UNKNOWN_EXIT_CODE();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SparkConf conf() {
        return this.conf;
    }

    private boolean shouldDeleteExecutors$lzycompute() {
        ExecutorPodsLifecycleManager executorPodsLifecycleManager = this;
        synchronized (executorPodsLifecycleManager) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.shouldDeleteExecutors = BoxesRunTime.unboxToBoolean((Object)this.conf().get(Config$.MODULE$.KUBERNETES_DELETE_EXECUTORS()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.shouldDeleteExecutors;
    }

    private boolean shouldDeleteExecutors() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.shouldDeleteExecutors$lzycompute();
        }
        return this.shouldDeleteExecutors;
    }

    private long missingPodDetectDelta$lzycompute() {
        ExecutorPodsLifecycleManager executorPodsLifecycleManager = this;
        synchronized (executorPodsLifecycleManager) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.missingPodDetectDelta = BoxesRunTime.unboxToLong((Object)this.conf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_MISSING_POD_DETECT_DELTA()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.missingPodDetectDelta;
    }

    private long missingPodDetectDelta() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.missingPodDetectDelta$lzycompute();
        }
        return this.missingPodDetectDelta;
    }

    private Cache<Long, Long> removedExecutorsCache$lzycompute() {
        ExecutorPodsLifecycleManager executorPodsLifecycleManager = this;
        synchronized (executorPodsLifecycleManager) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.removedExecutorsCache = CacheBuilder.newBuilder().expireAfterWrite(3L, TimeUnit.MINUTES).build();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.removedExecutorsCache;
    }

    private Cache<Long, Long> removedExecutorsCache() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.removedExecutorsCache$lzycompute();
        }
        return this.removedExecutorsCache;
    }

    private long lastFullSnapshotTs() {
        return this.lastFullSnapshotTs;
    }

    private void lastFullSnapshotTs_$eq(long x$1) {
        this.lastFullSnapshotTs = x$1;
    }

    private HashSet<Object> inactivatedPods() {
        return this.inactivatedPods;
    }

    private String namespace() {
        return this.namespace;
    }

    private String sparkContainerName() {
        return this.sparkContainerName;
    }

    public void start(KubernetesClusterSchedulerBackend schedulerBackend) {
        long eventProcessingInterval = BoxesRunTime.unboxToLong((Object)this.conf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_EVENT_PROCESSING_INTERVAL()));
        this.snapshotsStore.addSubscriber(eventProcessingInterval, (Function1<Seq<ExecutorPodsSnapshot>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$1 -> {
            this.onNewSnapshots(schedulerBackend, (Seq<ExecutorPodsSnapshot>)x$1);
            return BoxedUnit.UNIT;
        });
    }

    private void onNewSnapshots(KubernetesClusterSchedulerBackend schedulerBackend, Seq<ExecutorPodsSnapshot> snapshots) {
        HashSet execIdsRemovedInThisRound = HashSet$.MODULE$.empty();
        snapshots.foreach((Function1 & Serializable & scala.Serializable)snapshot -> {
            ExecutorPodsLifecycleManager.$anonfun$onNewSnapshots$1(this, schedulerBackend, execIdsRemovedInThisRound, snapshot);
            return BoxedUnit.UNIT;
        });
        if (this.inactivatedPods().nonEmpty() && snapshots.nonEmpty()) {
            this.inactivatedPods().retain((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$2 -> ((ExecutorPodsSnapshot)snapshots.last()).executorPods().contains((Object)BoxesRunTime.boxToLong((long)x$2)));
        }
        if (snapshots.nonEmpty() && this.lastFullSnapshotTs() != ((ExecutorPodsSnapshot)snapshots.last()).fullSnapshotTs()) {
            this.lastFullSnapshotTs_$eq(((ExecutorPodsSnapshot)snapshots.last()).fullSnapshotTs());
            Map lostExecutorsWithRegistrationTs = (Map)((Subtractable)schedulerBackend.getExecutorsWithRegistrationTs().map((Function1 & Serializable & scala.Serializable)t -> new Tuple2.mcJJ.sp(new StringOps(Predef$.MODULE$.augmentString((String)t._1())).toLong(), t._2$mcJ$sp()), Map$.MODULE$.canBuildFrom())).$minus$minus((GenTraversableOnce)((ExecutorPodsSnapshot)snapshots.last()).executorPods().keySet()).$minus$minus((GenTraversableOnce)execIdsRemovedInThisRound);
            lostExecutorsWithRegistrationTs.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                ExecutorPodsLifecycleManager.$anonfun$onNewSnapshots$9(this, schedulerBackend, x0$2);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private boolean onFinalNonDeletedState(FinalPodState podState, long execId, KubernetesClusterSchedulerBackend schedulerBackend, boolean deleteFromK8s) {
        boolean deleted;
        block0: {
            deleted = this.removeExecutorFromSpark(schedulerBackend, podState, execId);
            if (!deleteFromK8s) break block0;
            this.removeExecutorFromK8s(execId, podState.pod());
        }
        return deleted;
    }

    private void removeExecutorFromK8s(long execId, Pod updatedPod) {
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (this.shouldDeleteExecutors()) {
                ((Deletable)((Nameable)$this.kubernetesClient.pods().inNamespace(this.namespace())).withName(updatedPod.getMetadata().getName())).delete();
                return;
            }
            if (!this.inactivatedPods().contains((Object)BoxesRunTime.boxToLong((long)execId)) && !this.isPodInactive(updatedPod)) {
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Marking executor ").append(updatedPod.getMetadata().getName()).append(" as inactive since ").append("deletion is disabled.").toString());
                ((EditReplacePatchable)((Nameable)$this.kubernetesClient.pods().inNamespace(this.namespace())).withName(updatedPod.getMetadata().getName())).edit(ExecutorPodsLifecycleManager$.MODULE$.executorInactivationFn());
                this.inactivatedPods().$plus$eq((Object)BoxesRunTime.boxToLong((long)execId));
                return;
            }
        });
    }

    private boolean removeExecutorFromSpark(KubernetesClusterSchedulerBackend schedulerBackend, FinalPodState podState, long execId) {
        if (this.removedExecutorsCache().getIfPresent((Object)BoxesRunTime.boxToLong((long)execId)) == null) {
            this.removedExecutorsCache().put((Object)Predef$.MODULE$.long2Long(execId), (Object)Predef$.MODULE$.long2Long(execId));
            ExecutorExited exitReason = this.findExitReason(podState, execId);
            schedulerBackend.doRemoveExecutor(Long.toString(execId), (ExecutorLossReason)exitReason);
            return true;
        }
        return false;
    }

    private ExecutorExited findExitReason(FinalPodState podState, long execId) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        int exitCode = this.findExitCode(podState);
        FinalPodState finalPodState = podState;
        if (finalPodState instanceof PodDeleted) {
            tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new StringBuilder(61).append("The executor with id ").append(execId).append(" was deleted by a user or the framework.").toString());
        } else {
            String msg = this.exitReasonMessage(podState, execId, exitCode);
            tuple22 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)msg);
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        boolean exitCausedByApp = tuple2._1$mcZ$sp();
        String exitMessage = (String)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)exitCausedByApp), (Object)exitMessage);
        boolean exitCausedByApp2 = tuple23._1$mcZ$sp();
        String exitMessage2 = (String)tuple23._2();
        return new ExecutorExited(exitCode, exitCausedByApp2, exitMessage2);
    }

    private String exitReasonMessage(FinalPodState podState, long execId, int exitCode) {
        Pod pod = podState.pod();
        Option reason = Option$.MODULE$.apply((Object)pod.getStatus().getReason());
        Option message = Option$.MODULE$.apply((Object)pod.getStatus().getMessage());
        String explained = ExecutorPodsLifecycleManager$.MODULE$.describeExitCode(exitCode);
        String exitMsg = new StringBuilder(45).append("The executor with id ").append(execId).append(" exited with exit code ").append(explained).append(".").toString();
        Option reasonStr = reason.map((Function1 & Serializable & scala.Serializable)r -> new StringBuilder(41).append("The API gave the following brief reason: ").append((String)r).toString());
        Option msgStr = message.map((Function1 & Serializable & scala.Serializable)m -> new StringBuilder(36).append("The API gave the following message: ").append((String)m).toString());
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(116).append("\n       |").append(exitMsg).append("\n       |").append(reasonStr.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("\n       |").append(msgStr.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("\n       |\n       |The API gave the following container statuses:\n       |\n       |").append(KubernetesUtils$.MODULE$.containersDescription(pod, KubernetesUtils$.MODULE$.containersDescription$default$2())).append("\n      ").toString())).stripMargin();
    }

    private int findExitCode(FinalPodState podState) {
        return BoxesRunTime.unboxToInt((Object)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(podState.pod().getStatus().getContainerStatuses()).asScala()).find((Function1 & Serializable & scala.Serializable)containerStatus -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsLifecycleManager.$anonfun$findExitCode$1(this, containerStatus))).map((Function1 & Serializable & scala.Serializable)terminatedContainer -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(terminatedContainer.getState().getTerminated().getExitCode()))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> ExecutorPodsLifecycleManager$.MODULE$.UNKNOWN_EXIT_CODE()));
    }

    private boolean isPodInactive(Pod pod) {
        Object v = pod.getMetadata().getLabels().get(Constants$.MODULE$.SPARK_EXECUTOR_INACTIVE_LABEL());
        String string = "true";
        return !(v != null ? !v.equals(string) : string != null);
    }

    public static final /* synthetic */ void $anonfun$onNewSnapshots$1(ExecutorPodsLifecycleManager $this, KubernetesClusterSchedulerBackend schedulerBackend$2, HashSet execIdsRemovedInThisRound$1, ExecutorPodsSnapshot snapshot) {
        snapshot.executorPods().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                long execId = tuple2._1$mcJ$sp();
                ExecutorPodState state = (ExecutorPodState)tuple2._2();
                ExecutorPodState executorPodState = state;
                if ($this.isPodInactive(executorPodState.pod())) {
                    return $this.inactivatedPods().$minus$eq((Object)BoxesRunTime.boxToLong((long)execId));
                }
                if (executorPodState instanceof PodDeleted) {
                    PodDeleted podDeleted = (PodDeleted)executorPodState;
                    if ($this.removeExecutorFromSpark(schedulerBackend$2, podDeleted, execId)) {
                        execIdsRemovedInThisRound$1.$plus$eq((Object)BoxesRunTime.boxToLong((long)execId));
                        $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Snapshot reported deleted executor with id ").append(execId).append(",").append(" pod name ").append(state.pod().getMetadata().getName()).toString());
                    }
                    return $this.inactivatedPods().$minus$eq((Object)BoxesRunTime.boxToLong((long)execId));
                }
                if (executorPodState instanceof PodFailed) {
                    boolean deleteFromK8s;
                    PodFailed podFailed = (PodFailed)executorPodState;
                    boolean bl = deleteFromK8s = !execIdsRemovedInThisRound$1.contains((Object)BoxesRunTime.boxToLong((long)execId));
                    if ($this.onFinalNonDeletedState(podFailed, execId, schedulerBackend$2, deleteFromK8s)) {
                        execIdsRemovedInThisRound$1.$plus$eq((Object)BoxesRunTime.boxToLong((long)execId));
                        $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Snapshot reported failed executor with id ").append(execId).append(",").append(" pod name ").append(state.pod().getMetadata().getName()).toString());
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                if (executorPodState instanceof PodSucceeded) {
                    boolean deleteFromK8s;
                    PodSucceeded podSucceeded = (PodSucceeded)executorPodState;
                    boolean bl = deleteFromK8s = !execIdsRemovedInThisRound$1.contains((Object)BoxesRunTime.boxToLong((long)execId));
                    if ($this.onFinalNonDeletedState(podSucceeded, execId, schedulerBackend$2, deleteFromK8s)) {
                        execIdsRemovedInThisRound$1.$plus$eq((Object)BoxesRunTime.boxToLong((long)execId));
                        if (schedulerBackend$2.isExecutorActive(Long.toString(execId))) {
                            $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(114).append("Snapshot reported succeeded executor with id ").append(execId).append(", ").append("even though the application has not requested for it to be removed.").toString());
                            return BoxedUnit.UNIT;
                        }
                        $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Snapshot reported succeeded executor with id ").append(execId).append(",").append(" pod name ").append(state.pod().getMetadata().getName()).append(".").toString());
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public static final /* synthetic */ void $anonfun$onNewSnapshots$9(ExecutorPodsLifecycleManager $this, KubernetesClusterSchedulerBackend schedulerBackend$2, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            long lostExecId = tuple2._1$mcJ$sp();
            long lostExecRegistrationTs = tuple2._2$mcJ$sp();
            if ($this.removedExecutorsCache().getIfPresent((Object)BoxesRunTime.boxToLong((long)lostExecId)) == null && $this.lastFullSnapshotTs() - lostExecRegistrationTs > $this.missingPodDetectDelta()) {
                String exitReasonMessage = new StringBuilder(276).append("The executor with ID ").append(lostExecId).append(" (registered at ").append(lostExecRegistrationTs).append(" ms) was not found in the cluster at the polling time ").append("(").append($this.lastFullSnapshotTs()).append(" ms) which is after the accepted detect delta time ").append("(").append($this.missingPodDetectDelta()).append(" ms) configured by ").append("`").append(Config$.MODULE$.KUBERNETES_EXECUTOR_MISSING_POD_DETECT_DELTA().key()).append("`. ").append("The executor may have been deleted but the driver missed the deletion event. ").append("Marking this executor as failed.").toString();
                $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> exitReasonMessage);
                ExecutorExited exitReason = new ExecutorExited(ExecutorPodsLifecycleManager$.MODULE$.UNKNOWN_EXIT_CODE(), false, exitReasonMessage);
                schedulerBackend$2.doRemoveExecutor(Long.toString(lostExecId), (ExecutorLossReason)exitReason);
                return;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$findExitCode$1(ExecutorPodsLifecycleManager $this, ContainerStatus containerStatus) {
        String string = containerStatus.getName();
        String string2 = $this.sparkContainerName();
        return !(string != null ? !string.equals(string2) : string2 != null) && containerStatus.getState().getTerminated() != null;
    }

    public ExecutorPodsLifecycleManager(SparkConf conf, KubernetesClient kubernetesClient, ExecutorPodsSnapshotsStore snapshotsStore) {
        this.conf = conf;
        this.kubernetesClient = kubernetesClient;
        this.snapshotsStore = snapshotsStore;
        Logging.$init$((Logging)this);
        this.lastFullSnapshotTs = 0L;
        this.inactivatedPods = HashSet$.MODULE$.empty();
        this.namespace = (String)conf.get(Config$.MODULE$.KUBERNETES_NAMESPACE());
        this.sparkContainerName = (String)((Option)conf.get(Config$.MODULE$.KUBERNETES_EXECUTOR_PODTEMPLATE_CONTAINER_NAME())).getOrElse((Function0 & Serializable & scala.Serializable)() -> Constants$.MODULE$.DEFAULT_EXECUTOR_CONTAINER_NAME());
    }
}

